/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.HsmLocation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class OsmLocationExtractor
implements HsmLocation {
    private final URI _uri;

    public OsmLocationExtractor(URI location) throws IllegalArgumentException {
        this._uri = location;
    }

    public OsmLocationExtractor(Map<Integer, String> levels) throws IllegalArgumentException {
        String storageInfo = levels.get(1);
        if (storageInfo == null) {
            throw new IllegalArgumentException("OSM uses level 1 only");
        }
        this._uri = OsmLocationExtractor.parseLevel(storageInfo);
    }

    @Override
    public URI location() {
        return this._uri;
    }

    public static URI parseLevel(String storageInfo) throws IllegalArgumentException {
        boolean isLegacy = false;
        String[] st = storageInfo.split("[ \t]");
        if (st.length < 3) {
            throw new IllegalArgumentException("Invalid content of Level 1 (3/4 fields expected):" + storageInfo);
        }
        if (st.length > 4) {
            isLegacy = true;
        }
        StringBuilder sb = new StringBuilder("osm://");
        String store = st[0];
        String group = st[1];
        String bfid = st[2];
        String instance = st.length > 3 && !isLegacy ? st[3] : "osm";
        sb.append(instance).append("/?");
        sb.append("store=").append(store).append("&");
        sb.append("group=").append(group).append("&");
        sb.append("bfid=").append(bfid);
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("failed to generate URI from level: " + storageInfo);
        }
    }

    @Override
    public Map<Integer, String> toLevels() {
        HashMap<Integer, String> levelData = new HashMap<Integer, String>(1);
        Map<String, String> parsed = OsmLocationExtractor.parseURI(this._uri);
        StringBuilder asLevel = new StringBuilder();
        asLevel.append(parsed.get("store")).append(" ").append(parsed.get("group")).append(" ").append(parsed.get("bfid")).append(" ").append(this._uri.getAuthority());
        levelData.put(1, asLevel.toString());
        return levelData;
    }

    private static Map<String, String> parseURI(URI location) throws IllegalArgumentException {
        HashMap<String, String> values = new HashMap<String, String>();
        String query = location.getQuery();
        if (query == null) {
            throw new IllegalArgumentException("Invalid URI format: " + location);
        }
        String[] storageInfo = query.split("&");
        if (storageInfo.length != 3) {
            throw new IllegalArgumentException("Invalid URI format: " + location);
        }
        for (String s : storageInfo) {
            String[] ss = s.split("=");
            if (ss.length != 2) {
                throw new IllegalArgumentException("Invalid URI format: " + location);
            }
            values.put(ss[0], ss[1]);
        }
        return values;
    }
}

