/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.MessageTimerEvent;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.UOID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class MessageEventTimer {
    private TreeMap _scheduledEvents = new TreeMap();
    private HashMap _hash = new HashMap();
    private final Object _lock = new Object();
    private MessageEntry _currentTimeout = null;
    private CellNucleus _nucleus = null;
    private Thread _loopThread = null;
    public static final int MESSAGE_ARRIVED = 0;
    public static final int TIMEOUT_EXPIRED = 1;
    public static final int EXCEPTION_ARRIVED = 2;
    public static final int TIMER = 3;

    public MessageEventTimer(CellNucleus nucleus) {
        this._nucleus = nucleus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(CellMessage message) {
        Object object = this._lock;
        synchronized (object) {
            this.scheduleEvent(null, message, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(CellMessage message, long timeout, MessageTimerEvent event) {
        Object object = this._lock;
        synchronized (object) {
            try {
                this._nucleus.sendMessage(message);
                this.scheduleEvent(event, message, 1, timeout);
            }
            catch (Exception ee) {
                System.err.println("Exception in sending : " + ee);
                this.scheduleEvent(event, new CellMessage(null, (Object)ee), 0);
            }
        }
    }

    public void addTimer(Object privateKey, Object eventObject, MessageTimerEvent eventClass, long timeout) {
        EventEntry entry = new EventEntry(eventClass, eventObject, 3);
        if (privateKey != null) {
            this.add(privateKey, timeout + System.currentTimeMillis(), entry);
        } else {
            this.add(timeout + System.currentTimeMillis(), entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reschedule(long timeOffset) throws IllegalMonitorStateException {
        if (Thread.currentThread() != this._loopThread) {
            throw new IllegalMonitorStateException("Not called in callback (loopThread)");
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._currentTimeout == null) {
                throw new IllegalMonitorStateException("Nothing to reschedule");
            }
            this._currentTimeout.setTimerKey(timeOffset);
            System.out.println("Rescheduling : " + this._currentTimeout.getUOID());
            this.add(this._currentTimeout.getUOID(), new Long(timeOffset + System.currentTimeMillis()), this._currentTimeout);
        }
    }

    public void interrupt() {
        this._loopThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop() throws InterruptedException {
        while (!Thread.interrupted()) {
            EventEntry entry = null;
            CellMessage[] array = null;
            this._loopThread = Thread.currentThread();
            Object object = this._lock;
            synchronized (object) {
                if (this._scheduledEvents.size() == 0) {
                    this._lock.wait();
                } else {
                    Long timerValue = (Long)this._scheduledEvents.firstKey();
                    long timer = timerValue;
                    long now = System.currentTimeMillis();
                    Object x = this._scheduledEvents.get(timerValue);
                    if (timer == 0L || timer - now <= 0L) {
                        if (x instanceof ArrayList) {
                            ArrayList a = (ArrayList)x;
                            ArrayList<CellMessage> tmp = new ArrayList<CellMessage>();
                            entry = (EventEntry)a.remove(0);
                            if (entry instanceof MessageEntry) {
                                MessageEntry messageEntry = (MessageEntry)entry;
                                CellMessage message = messageEntry.getCellMessage();
                                tmp.add(message);
                                Iterator it = a.iterator();
                                while (it.hasNext()) {
                                    MessageEntry mscan;
                                    CellMessage cm;
                                    EventEntry scan = (EventEntry)it.next();
                                    if (!(scan instanceof MessageEntry) || !(cm = (mscan = (MessageEntry)scan).getCellMessage()).getLastUOID().equals((Object)message.getLastUOID())) continue;
                                    tmp.add(cm);
                                    it.remove();
                                }
                                array = new CellMessage[tmp.size()];
                                tmp.toArray(array);
                            }
                            if (a.size() == 0) {
                                this._scheduledEvents.remove(timerValue);
                            }
                        } else {
                            this._scheduledEvents.remove(timerValue);
                            entry = (EventEntry)x;
                            if (entry instanceof MessageEntry) {
                                array = new CellMessage[]{((MessageEntry)entry).getCellMessage()};
                            }
                        }
                    } else {
                        this._lock.wait(timer - now);
                    }
                }
                if (entry == null) {
                    continue;
                }
                this._currentTimeout = null;
                if (entry instanceof MessageEntry) {
                    this.handleMessageEntries((MessageEntry)entry, array);
                } else {
                    this._hash.remove(entry._privateKey);
                    entry._eventClass.event(this, entry._eventObject, entry._eventType);
                }
            }
        }
    }

    private void handleMessageEntries(MessageEntry entry, CellMessage[] array) {
        if (entry.getUOID() == null) {
            this._currentTimeout = (MessageEntry)this.remove(entry.getCellMessage().getLastUOID());
            if (this._currentTimeout != null) {
                this._currentTimeout._eventClass.event(this, array, entry._eventType);
            } else if (entry._eventClass != null) {
                entry._eventClass.event(this, array, entry._eventType);
            } else {
                System.err.println("WARNING : MessageEventTimer lost event 1 -> UOID : " + entry.getCellMessage().getLastUOID());
            }
        } else {
            this._hash.remove(entry.getUOID());
            entry._eventClass.event(this, array, entry._eventType);
        }
    }

    public String toString() {
        return "" + this._hash.size() + "/" + this._scheduledEvents.size();
    }

    public boolean removeTimer(Object privateKey) {
        return this.remove(privateKey) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventEntry remove(Object privateKey) {
        Object object = this._lock;
        synchronized (object) {
            EventEntry entry = (EventEntry)this._hash.remove(privateKey);
            if (entry == null) {
                return null;
            }
            Long key = entry.getTimerKey();
            Object y = this._scheduledEvents.get(key);
            if (y instanceof ArrayList) {
                ArrayList alist = (ArrayList)y;
                alist.remove(entry);
                if (alist.size() == 0) {
                    this._scheduledEvents.remove(key);
                }
            } else {
                this._scheduledEvents.remove(key);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Object privateKey, Long key, EventEntry entry) {
        Object object = this._lock;
        synchronized (object) {
            entry.setPrivateKey(privateKey);
            this._hash.put(privateKey, entry);
            this.add(key, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Long key, EventEntry entry) {
        Object object = this._lock;
        synchronized (object) {
            entry.setTimerKey(key);
            Object x = this._scheduledEvents.get(key);
            if (x == null) {
                this._scheduledEvents.put(key, entry);
            } else if (x instanceof ArrayList) {
                ((ArrayList)x).add(entry);
            } else {
                this._scheduledEvents.remove(key);
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(x);
                list.add(entry);
                this._scheduledEvents.put(key, list);
            }
            this._lock.notifyAll();
        }
    }

    private void scheduleEvent(MessageTimerEvent eventClass, CellMessage cellMessage, int eventType, long timeout) {
        MessageEntry entry = new MessageEntry(eventClass, cellMessage, eventType);
        this.add(cellMessage.getUOID(), timeout + System.currentTimeMillis(), entry);
    }

    private void scheduleEvent(MessageTimerEvent eventClass, CellMessage cellMessage, int eventType) {
        MessageEntry entry = new MessageEntry(eventClass, cellMessage, eventType);
        this.add(0L, entry);
        System.out.println("Event added ... type = " + eventType + " UOID=" + cellMessage.getUOID() + "/" + cellMessage.getLastUOID());
    }

    private static class EventEntry {
        protected final MessageTimerEvent _eventClass;
        protected final Object _eventObject;
        protected final int _eventType;
        protected Object _privateKey = null;
        protected Long _timerKey = null;

        private EventEntry(MessageTimerEvent eventClass, Object eventObject, int eventType) {
            this._eventClass = eventClass;
            this._eventObject = eventObject;
            this._eventType = eventType;
        }

        public MessageTimerEvent getEventClass() {
            return this._eventClass;
        }

        public Object getEventObject() {
            return this._eventObject;
        }

        public int getEventType() {
            return this._eventType;
        }

        public void setTimerKey(Long timerKey) {
            this._timerKey = timerKey;
        }

        public Long getTimerKey() {
            return this._timerKey;
        }

        public void setPrivateKey(Object key) {
            this._privateKey = key;
        }

        public Object getPrivateKey() {
            return this._privateKey;
        }

        public boolean equals(Object in) {
            return in == this;
        }

        public int hashCode() {
            return this._eventType;
        }
    }

    private class MessageEntry
    extends EventEntry {
        private MessageEntry(MessageTimerEvent eventClass, CellMessage cellMessage, int eventType) {
            super(eventClass, cellMessage, eventType);
        }

        public void setUOID(UOID uoid) {
            this.setPrivateKey(uoid);
        }

        public UOID getUOID() {
            return (UOID)this.getPrivateKey();
        }

        public CellMessage getCellMessage() {
            return (CellMessage)this.getEventObject();
        }
    }
}

