/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.EnstoreLocationExtractor;
import diskCacheV111.util.HpssLocationExtractor;
import diskCacheV111.util.HsmLocation;
import diskCacheV111.util.OsmLocationExtractor;
import java.net.URI;

public class HsmLocationExtractorFactory {
    private HsmLocationExtractorFactory() {
    }

    public static HsmLocation extractorOf(URI location) throws IllegalArgumentException {
        URI validatedUri = HsmLocationExtractorFactory.validate(location);
        HsmLocation extractor = null;
        String hsmType = validatedUri.getScheme();
        if ("osm".equals(hsmType)) {
            extractor = new OsmLocationExtractor(validatedUri);
        } else if ("enstore".equals(hsmType)) {
            extractor = new EnstoreLocationExtractor(validatedUri);
        } else if ("hpss".equals(hsmType)) {
            extractor = new HpssLocationExtractor(validatedUri);
        } else {
            throw new IllegalArgumentException("hsmType " + hsmType + " not supported. FIXME: make it dynamic");
        }
        return extractor;
    }

    public static URI validate(URI location) throws IllegalArgumentException {
        if (location.getScheme() == null) {
            throw new IllegalArgumentException("hsm type not defined in " + location);
        }
        if (location.getAuthority() == null) {
            throw new IllegalArgumentException("hsm instance id not defined in " + location);
        }
        if (location.getPath() == null || location.getPath().isEmpty()) {
            throw new IllegalArgumentException("hsm-specific opaque data not defined in " + location);
        }
        return location;
    }
}

