/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.Adler32;
import diskCacheV111.util.ChecksumFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GenericIdChecksumFactory
extends ChecksumFactory {
    private static final Logger _log = LoggerFactory.getLogger(GenericIdChecksumFactory.class);
    private static final long BYTES_IN_MEBIBYTE = 0x100000L;
    private static final long MILLISECONDS_IN_SECOND = 1000L;
    private ChecksumType _type;

    public GenericIdChecksumFactory(ChecksumType type) throws NoSuchAlgorithmException {
        this._type = type;
        if (this._type != ChecksumType.MD5_TYPE && this._type != ChecksumType.ADLER32) {
            MessageDigest.getInstance(this._type.getName());
        }
    }

    @Override
    public ChecksumType getType() {
        return this._type;
    }

    @Override
    public MessageDigest create() {
        try {
            if (this._type == ChecksumType.ADLER32) {
                return new Adler32();
            }
            return MessageDigest.getInstance(this._type.getName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("This is a bug in ChecksumFactory", e);
        }
    }

    @Override
    public Checksum create(byte[] digest) {
        return new Checksum(this._type, digest);
    }

    @Override
    public Checksum create(String digest) {
        return new Checksum(this._type, digest);
    }

    @Override
    public Checksum find(Set<Checksum> checksums) {
        for (Checksum checksum : checksums) {
            if (checksum.getType() != this._type) continue;
            return checksum;
        }
        return null;
    }

    @Override
    public Checksum computeChecksum(File file) throws IOException, InterruptedException {
        return this.computeChecksum(file, Double.POSITIVE_INFINITY);
    }

    private long throughputAdjustment(double throughputLimit, long numBytes, long elapsedTime) {
        assert (throughputLimit > 0.0 && numBytes >= 0L && elapsedTime >= 0L);
        long desiredDuration = (long)Math.ceil(1000.0 * ((double)numBytes / throughputLimit));
        long adjust = desiredDuration - elapsedTime;
        return Math.max(0L, adjust);
    }

    private String throughputAsString(long numBytes, long millis) {
        return Double.toString((double)numBytes / 1048576.0 / ((double)(millis == 0L ? 1L : millis) / 1000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Checksum computeChecksum(File file, double throughputLimit) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        MessageDigest digest = this.create();
        byte[] buffer = new byte[65536];
        long sum = 0L;
        FileInputStream in = new FileInputStream(file);
        try {
            int rc;
            while ((rc = in.read(buffer, 0, buffer.length)) > 0) {
                sum += (long)rc;
                digest.update(buffer, 0, rc);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                long adjust = this.throughputAdjustment(throughputLimit, sum, System.currentTimeMillis() - start);
                if (adjust <= 0L) continue;
                Thread.sleep(adjust);
            }
        }
        finally {
            in.close();
        }
        Checksum checksum = this.create(digest.digest());
        _log.debug("Computed checksum for {}, length {}, checksum {} in {} ms{}", new Object[]{file, sum, checksum, System.currentTimeMillis() - start, sum == 0L ? "" : ", throughput " + this.throughputAsString(sum, System.currentTimeMillis() - start) + " MiB/s" + (Double.isInfinite(throughputLimit) ? "" : " (limit " + throughputLimit / 1048576.0 + " MiB/s)")});
        return checksum;
    }
}

