/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.ThreadManager;
import dmg.cells.nucleus.CDC;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class FutureTimedTask
extends FutureTask
implements ThreadManager.TimedFuture {
    private Callable callable;
    private Runnable runnable;
    private Future timer;
    private long createtime;
    private CDC cdc;

    public FutureTimedTask(Callable callable, long createtime) {
        super(callable);
        this.callable = callable;
        this.createtime = createtime;
        this.cdc = new CDC();
    }

    public FutureTimedTask(Runnable runnable, Object result, long createtime) {
        super(runnable, result);
        this.runnable = runnable;
        this.createtime = createtime;
        this.cdc = new CDC();
    }

    public Callable getCallable() {
        return this.callable;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    @Override
    public void setTimer(Future timer) {
        this.timer = timer;
    }

    public Future getTimer() {
        return this.timer;
    }

    @Override
    public void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel(true);
        }
    }

    @Override
    public long getCreateTime() {
        return this.createtime;
    }

    @Override
    public void abbreviateTask(boolean abbreviate) {
        if (this.callable instanceof ThreadManager.Skippable) {
            ((ThreadManager.Skippable)((Object)this.callable)).setSkipProcessing(abbreviate);
        }
        if (this.runnable instanceof ThreadManager.Skippable) {
            ((ThreadManager.Skippable)((Object)this.runnable)).setSkipProcessing(abbreviate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.cdc.restore();
        try {
            super.run();
        }
        finally {
            CDC.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean runAndReset() {
        this.cdc.restore();
        try {
            boolean bl = super.runAndReset();
            return bl;
        }
        finally {
            CDC.clear();
        }
    }
}

