/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class FsPath {
    private final List<String> _list;

    public List<String> getPathItemsList() {
        return new ArrayList<String>(this._list);
    }

    public FsPath(String path) {
        this();
        this.add(path);
    }

    public FsPath() {
        this._list = new ArrayList<String>();
    }

    public FsPath(FsPath path) {
        this(path._list);
    }

    public FsPath(FsPath path, String child) {
        this(path._list);
        this.addSingleItem(child);
    }

    public FsPath(List<String> list) {
        this._list = new ArrayList<String>(list);
    }

    public FsPath(FsPath ... paths) {
        int length = 0;
        for (FsPath path : paths) {
            length += path._list.size();
        }
        this._list = new ArrayList<String>(length);
        for (FsPath path : paths) {
            this._list.addAll(path._list);
        }
    }

    public String toString() {
        return FsPath.toString(this._list);
    }

    public static String toString(List<String> pathItemsList) {
        if (pathItemsList.isEmpty()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (String pathItem : pathItemsList) {
            sb.append("/").append(pathItem);
        }
        return sb.toString();
    }

    public void add(String path) {
        if (path == null || path.length() == 0) {
            return;
        }
        if (path.startsWith("/")) {
            this._list.clear();
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            this.addSingleItem(st.nextToken());
        }
    }

    private void addSingleItem(String item) {
        if (item.equals(".")) {
            return;
        }
        if (item.equals("..")) {
            if (this._list.size() > 0) {
                this._list.remove(this._list.size() - 1);
            }
            return;
        }
        this._list.add(item);
    }

    public boolean isEmpty() {
        return this._list.isEmpty();
    }

    public void pop() {
        if (!this._list.isEmpty()) {
            this._list.remove(this._list.size() - 1);
        }
    }

    public int hashCode() {
        return ((Object)this._list).hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof FsPath && ((Object)this._list).equals(((FsPath)o)._list);
    }

    public String getName() {
        if (this._list.isEmpty()) {
            return "";
        }
        return this._list.get(this._list.size() - 1);
    }

    public FsPath getParent() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Root does not have a parent");
        }
        return new FsPath(this._list.subList(0, this._list.size() - 1));
    }

    public boolean startsWith(FsPath prefix) {
        if (prefix._list.size() > this._list.size()) {
            return false;
        }
        for (int i = 0; i < prefix._list.size(); ++i) {
            if (prefix._list.get(i).equals(this._list.get(i))) continue;
            return false;
        }
        return true;
    }

    public FsPath relativize(FsPath path) {
        if (!path.startsWith(this)) {
            throw new IllegalArgumentException(this.toString() + " is not a prefix of " + path);
        }
        return new FsPath(path._list.subList(this._list.size(), path._list.size()));
    }

    public static String getParent(String path) {
        FsPath p = new FsPath(path);
        return p.getParent().toString();
    }

    public static void main(String[] args) {
        FsPath path = new FsPath("/pnfs/desy.de");
        System.out.println(path.toString());
        path.add("zeus/users/patrick");
        System.out.println(path.toString());
        path.add("../trude");
        System.out.println(path.toString());
        path.add("/");
        System.out.println(path.toString());
        path.add("pnfs/cern.ch");
        System.out.println(path.toString());
        path.add("./../././");
        System.out.println(path.toString());
    }
}

