/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.RunSystem;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalTask
implements Callable<Integer> {
    private static final Logger _log = LoggerFactory.getLogger(ExternalTask.class);
    private final long _timeout;
    private final String _command;

    public ExternalTask(long timeout, String command) {
        this._timeout = timeout;
        this._command = command;
    }

    @Override
    public Integer call() {
        try {
            RunSystem run = new RunSystem(this._command, 1, this._timeout);
            run.go();
            String error = run.getErrorString().trim();
            if (error.length() > 0) {
                _log.info(String.format("Command '%s' returned %d, and emitted the following on stderr: %s", this._command, run.getExitValue(), error));
            } else if (run.getExitValue() != 0) {
                _log.info(String.format("Command '%s' returned %d", this._command, run.getExitValue()));
            }
            return run.getExitValue();
        }
        catch (InterruptedException e) {
            _log.error("Thread was waiting for external process '" + this._command + "' but was interrupted.");
            return 1;
        }
        catch (IOException e) {
            _log.error("Encountered a problem running '" + this._command + "': " + e.getMessage());
            return 1;
        }
    }
}

