/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

public class Ecrc2Adler32 {
    private static int BASE = 65521;

    public static long convert(long ecrc, long filesize) {
        int size = (int)(filesize % (long)BASE);
        int s1 = (int)(ecrc & 0xFFFFL);
        int s2 = (int)(ecrc >> 16 & 0xFFFFL);
        s1 = (s1 + 1) % BASE;
        s2 = (size + s2) % BASE;
        return (long)((s2 << 16) + s1) & 0xFFFFFFFFL;
    }

    public static void main(String[] args) {
        String usage = "usage: Ecrc2Adler32 <file ecrc decimal> <filesize>";
        if (args.length != 2) {
            System.out.println(usage);
            System.exit(1);
        }
        long ecrc = Long.parseLong(args[0]);
        long filesize = Long.parseLong(args[1]);
        long adler32 = Ecrc2Adler32.convert(ecrc, filesize);
        System.out.println("adler32 is " + adler32 + " hex value " + Long.toHexString(adler32));
    }
}

