/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.GenericIdChecksumFactory;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;

public abstract class ChecksumFactory {
    public abstract ChecksumType getType();

    public abstract MessageDigest create();

    public abstract Checksum create(byte[] var1);

    public abstract Checksum create(String var1);

    public abstract Checksum find(Set<Checksum> var1);

    public abstract Checksum computeChecksum(File var1) throws IOException, InterruptedException;

    public abstract Checksum computeChecksum(File var1, double var2) throws IOException, InterruptedException;

    public static ChecksumFactory getFactory(ChecksumType type) throws NoSuchAlgorithmException {
        return new GenericIdChecksumFactory(type);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Getting MD4 first time");
        ChecksumFactory.getFactory(ChecksumType.MD4_TYPE);
        System.out.println("Getting MD4 second time");
        ChecksumFactory.getFactory(ChecksumType.MD5_TYPE);
    }
}

