/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.srm.dcache;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import com.google.common.net.InetAddresses;
import diskCacheV111.poolManager.CostModule;
import diskCacheV111.poolManager.PoolMonitorV5;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.services.space.Space;
import diskCacheV111.services.space.SpaceState;
import diskCacheV111.services.space.message.ExtendLifetime;
import diskCacheV111.services.space.message.GetFileSpaceTokensMessage;
import diskCacheV111.services.space.message.GetSpaceMetaData;
import diskCacheV111.services.space.message.GetSpaceTokens;
import diskCacheV111.srm.StorageElementInfo;
import diskCacheV111.srm.dcache.DCacheAuthorization;
import diskCacheV111.srm.dcache.DcacheFileMetaData;
import diskCacheV111.srm.dcache.PinCompanion;
import diskCacheV111.srm.dcache.PutCompanion;
import diskCacheV111.srm.dcache.RemoveFileCompanion;
import diskCacheV111.srm.dcache.SrmMarkSpaceAsBeingUsedCompanion;
import diskCacheV111.srm.dcache.SrmReleaseSpaceCompanion;
import diskCacheV111.srm.dcache.SrmReserveSpaceCompanion;
import diskCacheV111.srm.dcache.SrmUnmarkSpaceAsBeingUsedCompanion;
import diskCacheV111.srm.dcache.UnpinCompanion;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileExistsCacheException;
import diskCacheV111.util.FileLocality;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.NotDirCacheException;
import diskCacheV111.util.NotInTrashCacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.util.ThreadManager;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.util.Version;
import diskCacheV111.vehicles.CopyManagerMessage;
import diskCacheV111.vehicles.IpProtocolInfo;
import diskCacheV111.vehicles.PoolManagerGetPoolMonitor;
import diskCacheV111.vehicles.RemoteHttpDataTransferProtocolInfo;
import diskCacheV111.vehicles.transferManager.CancelTransferMessage;
import diskCacheV111.vehicles.transferManager.RemoteGsiftpDelegateUserCredentialsMessage;
import diskCacheV111.vehicles.transferManager.RemoteGsiftpTransferProtocolInfo;
import diskCacheV111.vehicles.transferManager.RemoteTransferManagerMessage;
import diskCacheV111.vehicles.transferManager.TransferCompleteMessage;
import diskCacheV111.vehicles.transferManager.TransferFailedMessage;
import diskCacheV111.vehicles.transferManager.TransferManagerMessage;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.Domain;
import dmg.cells.services.login.LoginBrokerInfo;
import dmg.util.Args;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.Subject;
import org.apache.axis.types.UnsignedLong;
import org.dcache.acl.enums.AccessMask;
import org.dcache.acl.enums.AccessType;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.auth.persistence.AuthRecordPersistenceManager;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellStub;
import org.dcache.namespace.ACLPermissionHandler;
import org.dcache.namespace.ChainedPermissionHandler;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.namespace.PermissionHandler;
import org.dcache.namespace.PosixPermissionHandler;
import org.dcache.pinmanager.PinManagerExtendPinMessage;
import org.dcache.services.login.RemoteLoginStrategy;
import org.dcache.srm.AbstractStorageElement;
import org.dcache.srm.AdvisoryDeleteCallbacks;
import org.dcache.srm.CopyCallbacks;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.PinCallbacks;
import org.dcache.srm.PrepareToPutCallbacks;
import org.dcache.srm.PrepareToPutInSpaceCallbacks;
import org.dcache.srm.RemoveFileCallbacks;
import org.dcache.srm.SRM;
import org.dcache.srm.SRMAuthorization;
import org.dcache.srm.SRMAuthorizationException;
import org.dcache.srm.SRMDuplicationException;
import org.dcache.srm.SRMException;
import org.dcache.srm.SRMInternalErrorException;
import org.dcache.srm.SRMInvalidPathException;
import org.dcache.srm.SRMInvalidRequestException;
import org.dcache.srm.SRMUser;
import org.dcache.srm.SrmCancelUseOfSpaceCallbacks;
import org.dcache.srm.SrmReleaseSpaceCallbacks;
import org.dcache.srm.SrmReserveSpaceCallbacks;
import org.dcache.srm.SrmUseSpaceCallbacks;
import org.dcache.srm.UnpinCallbacks;
import org.dcache.srm.request.RequestCredential;
import org.dcache.srm.scheduler.Job;
import org.dcache.srm.security.SslGsiSocketFactory;
import org.dcache.srm.util.Configuration;
import org.dcache.srm.util.Permissions;
import org.dcache.srm.util.Tools;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TMetaDataSpace;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.srm.v2_2.TReturnStatus;
import org.dcache.srm.v2_2.TStatusCode;
import org.dcache.util.LoginBrokerHandler;
import org.dcache.util.list.DirectoryEntry;
import org.dcache.util.list.DirectoryListPrinter;
import org.dcache.util.list.DirectoryListSource;
import org.dcache.vehicles.FileAttributes;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public final class Storage
extends AbstractCellComponent
implements AbstractStorageElement,
Runnable,
CellCommandListener,
CellMessageReceiver {
    private static final Logger _log = LoggerFactory.getLogger(Storage.class);
    private static final String INFINITY = "infinity";
    private static boolean kludgeDomainMainWasRun = false;
    private static final String[] SRM_PUT_NOT_SUPPORTED_PROTOCOLS = new String[]{"http"};
    private static final String[] SRM_GET_NOT_SUPPORTED_PROTOCOLS = new String[0];
    private static final String[] SRM_PREFERED_PROTOCOLS = new String[]{"gsiftp", "gsidcap"};
    private static final String SFN_STRING = "SFN=";
    private static final long TRANSIENT_FAILURE_DELAY = TimeUnit.MILLISECONDS.toMillis(10L);
    private CellStub _pnfsStub;
    private CellStub _poolManagerStub;
    private CellStub _poolStub;
    private CellStub _spaceManagerStub;
    private CellStub _copyManagerStub;
    private CellStub _transferManagerStub;
    private CellStub _pinManagerStub;
    private CellStub _loginBrokerStub;
    private PnfsHandler _pnfs;
    private final PermissionHandler permissionHandler = new ChainedPermissionHandler(new ACLPermissionHandler(), new PosixPermissionHandler());
    private PoolMonitorV5 _poolMonitor;
    private SRM srm;
    private Configuration config;
    private Thread storageInfoUpdateThread;
    private boolean ignoreClientProtocolOrder;
    private boolean customGetHostByAddr;
    private FsPath _xrootdRootPath;
    private FsPath _httpRootPath;
    private LoginBrokerHandler _loginBrokerHandler;
    private DirectoryListSource _listSource;
    private boolean _isOnlinePinningEnabled = true;
    public static final String hh_set_switch_to_async_mode_delay_get = "<milliseconds>";
    public static final String fh_set_switch_to_async_mode_delay_get = "Sets the time after which get requests are processed asynchronously.\nUse 'infinity' to always use synchronous replies and use 0 to\nalways use asynchronous replies.";
    public static final String hh_set_switch_to_async_mode_delay_put = "<milliseconds>";
    public static final String fh_set_switch_to_async_mode_delay_put = "Sets the time after which put requests are processed asynchronously.\nUse 'infinity' to always use synchronous replies and use 0 to\nalways use asynchronous replies.";
    public static final String hh_set_switch_to_async_mode_delay_ls = "<milliseconds>";
    public static final String fh_set_switch_to_async_mode_delay_ls = "Sets the time after which ls requests are processed asynchronously.\nUse 'infinity' to always use synchronous replies and use 0 to\nalways use asynchronous replies.";
    public static final String hh_set_switch_to_async_mode_delay_bring_online = "<milliseconds>";
    public static final String fh_set_switch_to_async_mode_delay_bring_online = "Sets the time after which bring online requests are processed\nasynchronously. Use 'infinity' to always use synchronous replies\nand use 0 to always use asynchronous replies.";
    private static final ImmutableMap<String, String> OPTION_TO_PARAMETER_SET = new ImmutableMap.Builder().put((Object)"get", (Object)"get").put((Object)"put", (Object)"put").put((Object)"ls", (Object)"ls").put((Object)"bringonline", (Object)"bringonline").put((Object)"reserve", (Object)"reserve").build();
    public static final String fh_db_history_log = " Syntax: db history log [on|off] # show status or enable db history log ";
    public static final String hh_db_history_log = "[-get] [-put] [-bringonline] [-ls] [-copy] [-reserve] [on|off] # show status or enable db history log ";
    public static final String fh_cancel = " Syntax: cancel <id> ";
    public static final String hh_cancel = " <id> ";
    public static final String fh_cancelall = " Syntax: cancel [-get] [-put] [-copy] [-bring] [-reserve] <pattern> ";
    public static final String hh_cancelall = " [-get] [-put] [-copy] [-bring] [-reserve] <pattern> ";
    public static final String fh_ls = " Syntax: ls [-get] [-put] [-copy] [-bring] [-reserve] [-ls] [-l] [<id>] #will list all requests";
    public static final String hh_ls = " [-get] [-put] [-copy] [-bring] [-reserve] [-ls] [-l] [<id>]";
    public static final String fh_ls_queues = " Syntax: ls queues [-get] [-put] [-copy] [-bring] [-ls] [-l]  #will list schedule queues";
    public static final String hh_ls_queues = " [-get] [-put] [-copy] [-bring] [-ls] [-l] ";
    public static final String fh_ls_completed = " Syntax: ls completed [-get] [-put] [-copy] [-l] [max_count] #will list completed (done, failed or canceled) requests, if max_count is not specified, it is set to 50";
    public static final String hh_ls_completed = " [-get] [-put] [-copy] [-l] [max_count]";
    public static final String fh_set_job_priority = " Syntax: set priority <requestId> <priority>will set priority for the requestid";
    public static final String hh_set_job_priority = " <requestId> <priority>";
    public static final String fh_set_max_ready_put = " Syntax: set max ready put <count> #will set a maximum number of put requests in the ready state";
    public static final String hh_set_max_ready_put = " <count>";
    public static final String fh_set_max_ready_get = " Syntax: set max ready get <count> #will set a maximum number of get requests in the ready state";
    public static final String hh_set_max_ready_get = " <count>";
    public static final String fh_set_max_ready_bring_online = " Syntax: set max ready bring online <count> #will set a maximum number of bring online requests in the ready state";
    public static final String hh_set_max_ready_bring_online = " <count>";
    public static final String fh_set_max_read_ls_ = " Syntax: set max read ls <count>\n #will set a maximum number of ls requests in the ready state\n #\"set max read ls\" is an alias for \"set max ready ls\" preserved for compatibility ";
    public static final String hh_set_max_read_ls = " <count>";
    public static final String fh_set_max_ready_ls = " Syntax: set max ready ls <count>\n #will set a maximum number of ls requests in the ready state";
    public static final String hh_set_max_ready_ls = " <count>";
    public static final String fh_dir_creators_ls = " Syntax: dir creators ls [-l]  #will list all put companion waiting for the dir creation ";
    public static final String hh_dir_creators_ls = " [-l] ";
    public static final String fh_cancel_dir_creation = " Syntax:cancel dir creation <path>  #will fail companion waiting for the dir creation on <path> ";
    public static final String hh_cancel_dir_creation = " <path>";
    public static final String hh_print_srm_counters = "# prints the counters for all srm operations";
    private final Map<String, LoginBrokerInfo[]> latestLoginBrokerInfos = new HashMap<String, LoginBrokerInfo[]>();
    private final Map<String, Long> latestLoginBrokerInfosTimes = new HashMap<String, Long>();
    private long LOGINBROKERINFO_VALIDITYSPAN = 30000L;
    private static final int MAX_LOGIN_BROKER_RETRIES = 5;
    private final Random rand = new Random();
    int numDoorInRanSelection = 3;
    private static final long doorToHostnameCacheTTL = 600000L;
    private Map<String, HostnameCacheRecord> doorToHostnameMap = new HashMap<String, HostnameCacheRecord>();
    private static final Comparator<LoginBrokerInfo> LOAD_ORDER = new Comparator<LoginBrokerInfo>(){

        @Override
        public int compare(LoginBrokerInfo info1, LoginBrokerInfo info2) {
            return (int)Math.signum(info1.getLoad() - info2.getLoad());
        }
    };
    private static final int IPv4_SIZE = 4;
    private static final int IPv6_SIZE = 16;
    private final Map<Long, String> idToUserMap = new HashMap<Long, String>();
    private final Map<Long, GSSCredential> idToCredentialMap = new HashMap<Long, GSSCredential>();
    private static AtomicLong nextMessageID = new AtomicLong(20000L);
    private final Map<Long, TransferInfo> callerIdToHandler = new ConcurrentHashMap<Long, TransferInfo>();
    private volatile StorageElementInfo storageElementInfo = new StorageElementInfo();

    public static SRM getSRMInstance(final String[] dCacheParams, long timeout) throws InterruptedException, TimeoutException {
        _log.info("Here are the params/args to go to dCache: " + Arrays.toString(dCacheParams));
        _log.debug("entering Storage.getSRMInstance");
        SRM srmInstance = SRM.getSRM();
        if (srmInstance != null) {
            _log.debug("in Storage.getSRMInstance(), about to return existing srmInstance");
            return srmInstance;
        }
        if (!kludgeDomainMainWasRun) {
            _log.debug("in Storage.getSRMInstance(),  srmInstance is null, about to call Domain.main()");
            new Thread(){

                @Override
                public void run() {
                    Domain.main((String[])dCacheParams);
                }
            }.start();
            _log.debug("in Storage.getSRMInstance(), started thread that will call  Domain.main()");
        } else {
            _log.debug("in Storage.getSRMInstance(), Domain.main has already been run.");
        }
        srmInstance = SRM.getInstance((long)timeout);
        _log.debug("about to return the instance of srm");
        return srmInstance;
    }

    @Required
    public void setLoginBrokerStub(CellStub loginBrokerStub) {
        this._loginBrokerStub = loginBrokerStub;
    }

    @Required
    public void setPnfsStub(CellStub pnfsStub) {
        this._pnfsStub = pnfsStub;
    }

    @Required
    public void setSpaceManagerStub(CellStub spaceManagerStub) {
        this._spaceManagerStub = spaceManagerStub;
    }

    @Required
    public void setPoolStub(CellStub poolStub) {
        this._poolStub = poolStub;
    }

    @Required
    public void setPoolManagerStub(CellStub poolManagerStub) {
        this._poolManagerStub = poolManagerStub;
    }

    @Required
    public void setTransferManagerStub(CellStub transferManagerStub) {
        this._transferManagerStub = transferManagerStub;
    }

    @Required
    public void setCopyManagerStub(CellStub copyManagerStub) {
        this._copyManagerStub = copyManagerStub;
    }

    @Required
    public void setPinManagerStub(CellStub pinManagerStub) {
        this._pinManagerStub = pinManagerStub;
    }

    @Required
    public void setPnfsHandler(PnfsHandler pnfs) {
        this._pnfs = pnfs;
    }

    @Required
    public void setHttpRootPath(String path) {
        this._httpRootPath = new FsPath(path);
    }

    @Required
    public void setXrootdRootPath(String path) {
        this._xrootdRootPath = new FsPath(path);
    }

    @Required
    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public void setPinOnlineFiles(boolean value) {
        this._isOnlinePinningEnabled = value;
    }

    public void setLoginBrokerUpdatePeriod(long period) {
        this.LOGINBROKERINFO_VALIDITYSPAN = period;
    }

    public void setNumberOfDoorsInRandomSelection(int value) {
        this.numDoorInRanSelection = value;
    }

    public void setUseCustomGetHostByAddress(boolean value) {
        this.customGetHostByAddr = value;
    }

    public void setIgnoreClientProtocolOrder(boolean ignore) {
        this.ignoreClientProtocolOrder = ignore;
    }

    public void start() throws Exception {
        _log.info("Starting SRM");
        if (this.config.getJdbcPass() == null && this.config.getJdbcPwdfile() == null) {
            String error = "database parameters are not specified; use options -jdbcUrl, -jdbcDriver, -dbUser and -dbPass/-pgPass";
            _log.error(error);
            throw new Exception(error);
        }
        if (this.config.isGsissl()) {
            this.config.setWebservice_protocol("https");
            RemoteLoginStrategy loginStrategy = new RemoteLoginStrategy(new CellStub(this.getCellEndpoint(), new CellPath("gPlazma"), 30000L));
            DCacheAuthorization authorization = new DCacheAuthorization(loginStrategy, (AuthRecordPersistenceManager)this.config.getSrmUserPersistenceManager());
            authorization.setCacheLifetime(this.config.getAuthzCacheLifetime());
            this.config.setAuthorization((SRMAuthorization)authorization);
        } else {
            this.config.setWebservice_protocol("http");
        }
        while (this._poolMonitor == null) {
            try {
                this._poolMonitor = this._poolManagerStub.sendAndWait(new PoolManagerGetPoolMonitor()).getPoolMonitor();
            }
            catch (CacheException e) {
                _log.error(e.toString());
                Thread.sleep(TRANSIENT_FAILURE_DELAY);
            }
        }
        this.storageInfoUpdateThread = new Thread(this);
        this.storageInfoUpdateThread.start();
        this.srm = SRM.getSRM((Configuration)this.config, (String)this.getCellName());
    }

    public void stop() {
        this.srm.stop();
    }

    @Required
    public void setDirectoryListSource(DirectoryListSource source) {
        this._listSource = source;
    }

    public static long parseTime(String s) {
        return s.equals(INFINITY) ? Long.MAX_VALUE : Long.parseLong(s);
    }

    @Required
    public void setLoginBrokerHandler(LoginBrokerHandler handler) throws UnknownHostException {
        handler.setAddresses(Arrays.asList(InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())));
        handler.setLoad(new LoginBrokerHandler.LoadProvider(){

            @Override
            public double getLoad() {
                return Storage.this.srm == null ? 0.0 : Storage.this.srm.getLoad();
            }
        });
        this._loginBrokerHandler = handler;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        StorageElementInfo info = this.getStorageElementInfo();
        if (info != null) {
            pw.println(info);
        }
        pw.println(this.config);
        try {
            StringBuilder sb = new StringBuilder();
            this.srm.printGetSchedulerInfo(sb);
            this.srm.printPutSchedulerInfo(sb);
            this.srm.printCopySchedulerInfo(sb);
            this.srm.printBringOnlineSchedulerInfo(sb);
            this.srm.printLsSchedulerInfo(sb);
            pw.println(sb);
        }
        catch (SQLException e) {
            _log.error(e.toString());
        }
    }

    @Override
    public CellInfo getCellInfo(CellInfo info) {
        info.setCellVersion(new CellVersion(Version.getVersion(), "$Revision: 17056 $"));
        return info;
    }

    public String ac_set_switch_to_async_mode_delay_get_$_1(Args args) {
        this.config.setGetSwitchToAsynchronousModeDelay(Storage.parseTime(args.argv(0)));
        return "";
    }

    public String ac_set_switch_to_async_mode_delay_put_$_1(Args args) {
        this.config.setPutSwitchToAsynchronousModeDelay(Storage.parseTime(args.argv(0)));
        return "";
    }

    public String ac_set_switch_to_async_mode_delay_ls_$_1(Args args) {
        this.config.setLsSwitchToAsynchronousModeDelay(Storage.parseTime(args.argv(0)));
        return "";
    }

    public String ac_set_switch_to_async_mode_delay_bring_online_$_1(Args args) {
        this.config.setBringOnlineSwitchToAsynchronousModeDelay(Storage.parseTime(args.argv(0)));
        return "";
    }

    public String ac_db_history_log_$_0_1(Args args) {
        ImmutableCollection sets = new ArrayList();
        for (Map.Entry e : OPTION_TO_PARAMETER_SET.entrySet()) {
            if (!args.hasOption((String)e.getKey())) continue;
            sets.add(e.getValue());
        }
        if (sets.isEmpty()) {
            sets = OPTION_TO_PARAMETER_SET.values();
        }
        if (args.argc() > 0) {
            String arg = args.argv(0);
            if (!arg.equals("on") && !arg.equals("off")) {
                return "syntax error";
            }
            for (String set : sets) {
                this.config.getDatabaseParameters(set).setRequestHistoryDatabaseEnabled(arg.equals("on"));
            }
        }
        StringBuilder s = new StringBuilder();
        for (String set : sets) {
            Configuration.DatabaseParameters parameters = this.config.getDatabaseParameters(set);
            s.append("db history logging for ").append(set).append(" is ").append(parameters.isRequestHistoryDatabaseEnabled() ? "enabled" : "disabled").append("\n");
        }
        return s.toString();
    }

    public String ac_cancel_$_1(Args args) {
        try {
            Long id = Long.valueOf(args.argv(0));
            StringBuilder sb = new StringBuilder();
            this.srm.cancelRequest(sb, id);
            return sb.toString();
        }
        catch (SRMInvalidRequestException ire) {
            return "Invalid request: " + ire.getMessage();
        }
        catch (NumberFormatException e) {
            return e.toString();
        }
        catch (SQLException e) {
            _log.warn(e.toString());
            return e.toString();
        }
    }

    public String ac_cancelall_$_1(Args args) {
        try {
            boolean get = args.hasOption("get");
            boolean put = args.hasOption("put");
            boolean copy = args.hasOption("copy");
            boolean bring = args.hasOption("bring");
            boolean reserve = args.hasOption("reserve");
            boolean ls = args.hasOption("ls");
            if (!(get || put || copy || bring || reserve || ls)) {
                get = true;
                put = true;
                copy = true;
                bring = true;
                reserve = true;
                ls = true;
            }
            String pattern = args.argv(0);
            StringBuilder sb = new StringBuilder();
            if (get) {
                _log.debug("calling srm.cancelAllGetRequest(\"" + pattern + "\")");
                this.srm.cancelAllGetRequest(sb, pattern);
            }
            if (bring) {
                _log.debug("calling srm.cancelAllBringOnlineRequest(\"" + pattern + "\")");
                this.srm.cancelAllBringOnlineRequest(sb, pattern);
            }
            if (put) {
                _log.debug("calling srm.cancelAllPutRequest(\"" + pattern + "\")");
                this.srm.cancelAllPutRequest(sb, pattern);
            }
            if (copy) {
                _log.debug("calling srm.cancelAllCopyRequest(\"" + pattern + "\")");
                this.srm.cancelAllCopyRequest(sb, pattern);
            }
            if (reserve) {
                _log.debug("calling srm.cancelAllReserveSpaceRequest(\"" + pattern + "\")");
                this.srm.cancelAllReserveSpaceRequest(sb, pattern);
            }
            if (ls) {
                _log.debug("calling srm.cancelAllLsRequests(\"" + pattern + "\")");
                this.srm.cancelAllLsRequests(sb, pattern);
            }
            return sb.toString();
        }
        catch (RuntimeException e) {
            _log.error("Failure in cancelall", (Throwable)e);
            return e.toString();
        }
        catch (Exception e) {
            _log.warn("Failure in cancelall: " + e.getMessage());
            return e.toString();
        }
    }

    public String ac_ls_$_0_1(Args args) {
        try {
            boolean get = args.hasOption("get");
            boolean put = args.hasOption("put");
            boolean copy = args.hasOption("copy");
            boolean bring = args.hasOption("bring");
            boolean reserve = args.hasOption("reserve");
            boolean ls = args.hasOption("ls");
            boolean longformat = args.hasOption("l");
            StringBuilder sb = new StringBuilder();
            if (args.argc() == 1) {
                try {
                    Long reqId = Long.valueOf(args.argv(0));
                    this.srm.listRequest(sb, reqId, longformat);
                }
                catch (NumberFormatException nfe) {
                    return "id must be an integer, you gave id=" + args.argv(0);
                }
            } else {
                if (!(get || put || copy || bring || reserve || ls)) {
                    get = true;
                    put = true;
                    copy = true;
                    bring = true;
                    reserve = true;
                    ls = true;
                }
                if (get) {
                    sb.append("Get Requests:\n");
                    this.srm.listGetRequests(sb);
                }
                if (put) {
                    sb.append("Put Requests:\n");
                    this.srm.listPutRequests(sb);
                }
                if (copy) {
                    sb.append("Copy Requests:\n");
                    this.srm.listCopyRequests(sb);
                }
                if (copy) {
                    sb.append("Bring Online Requests:\n");
                    this.srm.listBringOnlineRequests(sb);
                }
                if (reserve) {
                    sb.append("Reserve Space Requests:\n");
                    this.srm.listReserveSpaceRequests(sb);
                }
                if (ls) {
                    sb.append("Ls Requests:\n");
                    this.srm.listLsRequests(sb);
                }
            }
            return sb.toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return t.toString();
        }
    }

    public String ac_ls_queues_$_0(Args args) {
        try {
            boolean get = args.hasOption("get");
            boolean put = args.hasOption("put");
            boolean ls = args.hasOption("ls");
            boolean copy = args.hasOption("copy");
            boolean bring = args.hasOption("bring");
            StringBuilder sb = new StringBuilder();
            if (!(get || put || copy || bring || ls)) {
                get = true;
                put = true;
                copy = true;
                bring = true;
                ls = true;
            }
            if (get) {
                sb.append("Get Request Scheduler:\n");
                this.srm.printGetSchedulerThreadQueue(sb);
                this.srm.printGetSchedulerPriorityThreadQueue(sb);
                this.srm.printCopySchedulerReadyThreadQueue(sb);
                sb.append('\n');
            }
            if (put) {
                sb.append("Put Request Scheduler:\n");
                this.srm.printPutSchedulerThreadQueue(sb);
                this.srm.printPutSchedulerPriorityThreadQueue(sb);
                this.srm.printPutSchedulerReadyThreadQueue(sb);
                sb.append('\n');
            }
            if (copy) {
                sb.append("Copy Request Scheduler:\n");
                this.srm.printCopySchedulerThreadQueue(sb);
                this.srm.printCopySchedulerPriorityThreadQueue(sb);
                this.srm.printCopySchedulerReadyThreadQueue(sb);
                sb.append('\n');
            }
            if (bring) {
                sb.append("Bring Online Request Scheduler:\n");
                this.srm.printBringOnlineSchedulerThreadQueue(sb);
                this.srm.printBringOnlineSchedulerPriorityThreadQueue(sb);
                this.srm.printBringOnlineSchedulerReadyThreadQueue(sb);
                sb.append('\n');
            }
            if (ls) {
                sb.append("Ls Request Scheduler:\n");
                this.srm.printLsSchedulerThreadQueue(sb);
                this.srm.printLsSchedulerPriorityThreadQueue(sb);
                this.srm.printLsSchedulerReadyThreadQueue(sb);
                sb.append('\n');
            }
            return sb.toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return t.toString();
        }
    }

    public String ac_ls_completed_$_0_1(Args args) throws Exception {
        boolean get = args.hasOption("get");
        boolean put = args.hasOption("put");
        boolean copy = args.hasOption("copy");
        int max_count = 50;
        if (args.argc() == 1) {
            max_count = Integer.parseInt(args.argv(0));
        }
        if (!(get || put || copy)) {
            get = true;
            put = true;
            copy = true;
        }
        StringBuilder sb = new StringBuilder();
        if (get) {
            sb.append("Get Requests:\n");
            this.srm.listLatestCompletedGetRequests(sb, max_count);
            sb.append('\n');
        }
        if (put) {
            sb.append("Put Requests:\n");
            this.srm.listLatestCompletedPutRequests(sb, max_count);
            sb.append('\n');
        }
        if (copy) {
            sb.append("Copy Requests:\n");
            this.srm.listLatestCompletedCopyRequests(sb, max_count);
            sb.append('\n');
        }
        return sb.toString();
    }

    public String ac_set_job_priority_$_2(Args args) {
        int priority;
        long requestId;
        String s1 = args.argv(0);
        String s2 = args.argv(1);
        try {
            requestId = Integer.parseInt(s1);
        }
        catch (NumberFormatException e) {
            return "Failed to parse request id: " + s1;
        }
        try {
            priority = Integer.parseInt(s2);
        }
        catch (Exception e) {
            return "Failed to parse priority: " + s2;
        }
        try {
            Job job = Job.getJob((Long)requestId, Job.class);
            job.setPriority(priority);
            job.setPriority(priority);
            StringBuilder sb = new StringBuilder();
            this.srm.listRequest(sb, Long.valueOf(requestId), true);
            return sb.toString();
        }
        catch (RuntimeException e) {
            _log.error("Failure in set job priority", (Throwable)e);
            return e.toString();
        }
        catch (SRMInvalidRequestException e) {
            return e.getMessage() + "\n";
        }
        catch (Exception e) {
            _log.warn("Failure in set job priority: " + e.getMessage());
            return e.toString();
        }
    }

    public String ac_set_max_ready_put_$_1(Args args) throws Exception {
        if (args.argc() != 1) {
            throw new IllegalArgumentException("count is not specified");
        }
        int value = Integer.parseInt(args.argv(0));
        this.config.setPutMaxReadyJobs(value);
        this.srm.getPutRequestScheduler().setMaxReadyJobs(value);
        _log.info("put-req-max-ready-requests=" + value);
        return "put-req-max-ready-requests=" + value;
    }

    public String ac_set_max_ready_get_$_1(Args args) throws Exception {
        if (args.argc() != 1) {
            throw new IllegalArgumentException("count is not specified");
        }
        int value = Integer.parseInt(args.argv(0));
        this.config.setGetMaxReadyJobs(value);
        this.srm.getGetRequestScheduler().setMaxReadyJobs(value);
        _log.info("get-req-max-ready-requests=" + value);
        return "get-req-max-ready-requests=" + value;
    }

    public String ac_set_max_ready_bring_online_$_1(Args args) throws Exception {
        if (args.argc() != 1) {
            throw new IllegalArgumentException("count is not specified");
        }
        int value = Integer.parseInt(args.argv(0));
        this.config.setBringOnlineMaxReadyJobs(value);
        this.srm.getBringOnlineRequestScheduler().setMaxReadyJobs(value);
        _log.info("bring-online-req-max-ready-requests=" + value);
        return "bring-online-req-max-ready-requests=" + value;
    }

    public String ac_set_read_ls_$_1(Args args) throws Exception {
        return this.ac_set_max_ready_ls_$_1(args);
    }

    public String ac_set_max_ready_ls_$_1(Args args) throws Exception {
        if (args.argc() != 1) {
            throw new IllegalArgumentException("count is not specified");
        }
        int value = Integer.parseInt(args.argv(0));
        this.config.setLsMaxReadyJobs(value);
        this.srm.getLsRequestScheduler().setMaxReadyJobs(value);
        _log.info("ls-request-max-ready-requests=" + value);
        return "ls-request-max-ready-requests=" + value;
    }

    public String ac_dir_creators_ls_$_0(Args args) {
        try {
            boolean longformat = args.hasOption("l");
            StringBuilder sb = new StringBuilder();
            PutCompanion.listDirectoriesWaitingForCreation(sb, longformat);
            return sb.toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return t.toString();
        }
    }

    public String ac_cancel_dir_creation_$_1(Args args) {
        try {
            String pnfsPath = args.argv(0);
            StringBuilder sb = new StringBuilder();
            PutCompanion.failCreatorsForPath(pnfsPath, sb);
            return sb.toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return t.toString();
        }
    }

    public String ac_print_srm_counters_$_0(Args args) {
        return this.srm.getSrmServerV1Counters().toString() + '\n' + this.srm.getSrmServerV2Counters().toString() + '\n' + this.srm.getAbstractStorageElementCounters().toString() + '\n' + this.srm.getSrmServerV1Gauges().toString() + '\n' + this.srm.getSrmServerV2Gauges().toString() + '\n' + this.srm.getAbstractStorageElementGauges().toString();
    }

    public void messageArrived(final TransferManagerMessage msg) {
        ThreadManager.execute(new Runnable(){

            @Override
            public void run() {
                Storage.this.handleTransferManagerMessage(msg);
            }
        });
    }

    public void pinFile(SRMUser user, URI surl, String clientHost, long pinLifetime, long requestId, PinCallbacks callbacks) {
        try {
            PinCompanion.pinFile(((AuthorizationRecord)user).toSubject(), this.getPath(surl), clientHost, callbacks, pinLifetime, requestId, this._isOnlinePinningEnabled, this._poolMonitor, this._pnfsStub, this._poolManagerStub, this._pinManagerStub);
        }
        catch (SRMInvalidPathException e) {
            callbacks.FileNotFound(e.getMessage());
        }
    }

    public void unPinFile(SRMUser user, String fileId, UnpinCallbacks callbacks, String pinId) {
        if (PinCompanion.isFakePinId(pinId)) {
            return;
        }
        UnpinCompanion.unpinFile(((AuthorizationRecord)user).toSubject(), new PnfsId(fileId), Long.parseLong(pinId), callbacks, this._pinManagerStub);
    }

    public void unPinFileBySrmRequestId(SRMUser user, String fileId, UnpinCallbacks callbacks, long srmRequestId) {
        UnpinCompanion.unpinFileBySrmRequestId(((AuthorizationRecord)user).toSubject(), new PnfsId(fileId), srmRequestId, callbacks, this._pinManagerStub);
    }

    public void unPinFile(SRMUser user, String fileId, UnpinCallbacks callbacks) {
        UnpinCompanion.unpinFile(((AuthorizationRecord)user).toSubject(), new PnfsId(fileId), callbacks, this._pinManagerStub);
    }

    public String selectGetProtocol(String[] protocols) throws SRMException {
        return this.selectProtocolFor(protocols, SRM_GET_NOT_SUPPORTED_PROTOCOLS);
    }

    public String selectPutProtocol(String[] protocols) throws SRMException {
        return this.selectProtocolFor(protocols, SRM_PUT_NOT_SUPPORTED_PROTOCOLS);
    }

    private String selectProtocolFor(String[] protocols, String[] excludes) throws SRMException {
        int i;
        Set<String> available_protocols = this.listAvailableProtocols();
        available_protocols.retainAll(Arrays.asList(protocols));
        available_protocols.removeAll(Arrays.asList(excludes));
        if (available_protocols.isEmpty()) {
            _log.error("can not find sutable protocol");
            throw new SRMException("can not find sutable put protocol");
        }
        if (this.ignoreClientProtocolOrder) {
            for (i = 0; i < SRM_PREFERED_PROTOCOLS.length; ++i) {
                if (!available_protocols.contains(SRM_PREFERED_PROTOCOLS[i])) continue;
                return SRM_PREFERED_PROTOCOLS[i];
            }
        }
        for (i = 0; i < protocols.length; ++i) {
            if (!available_protocols.contains(protocols[i])) continue;
            return protocols[i];
        }
        throw new SRMException("can not find sutable put protocol");
    }

    public String[] supportedGetProtocols() throws SRMException {
        Set<String> protocols = this.listAvailableProtocols();
        return protocols.toArray(new String[0]);
    }

    public String[] supportedPutProtocols() throws SRMException {
        Set<String> protocols = this.listAvailableProtocols();
        if (protocols.contains("http")) {
            protocols.remove("http");
        }
        return protocols.toArray(new String[0]);
    }

    public String selectGetHost(String protocol, String fileId) throws SRMException {
        return this.selectHost(protocol);
    }

    public String selectPutHost(String protocol) throws SRMException {
        return this.selectHost(protocol);
    }

    public URI getGetTurl(SRMUser user, URI surl, String[] protocols) throws SRMException {
        FsPath path = this.getPath(surl);
        String protocol = this.selectGetProtocol(protocols);
        return this.getTurl(path, protocol, user);
    }

    public URI getGetTurl(SRMUser user, URI surl, URI previous_turl) throws SRMException {
        FsPath actualFilePath = this.getPath(surl);
        String host = previous_turl.getHost();
        int port = previous_turl.getPort();
        return this.getTurl(actualFilePath, previous_turl.getScheme(), host, port, user);
    }

    public URI getPutTurl(SRMUser user, URI surl, String[] protocols) throws SRMException {
        FsPath path = this.getPath(surl);
        String protocol = this.selectPutProtocol(protocols);
        return this.getTurl(path, protocol, user);
    }

    public URI getPutTurl(SRMUser user, URI surl, URI previous_turl) throws SRMException {
        FsPath path = this.getPath(surl);
        String host = previous_turl.getHost();
        int port = previous_turl.getPort();
        return this.getTurl(path, previous_turl.getScheme(), host, port, user);
    }

    private URI getTurl(FsPath path, String protocol, SRMUser user) throws SRMException {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        String hostPort = this.selectHost(protocol);
        int index = hostPort.indexOf(58);
        if (index > -1) {
            String host = hostPort.substring(0, index);
            int port = Integer.parseInt(hostPort.substring(index + 1));
            return this.getTurl(path, protocol, host, port, user);
        }
        return this.getTurl(path, protocol, hostPort, 0, user);
    }

    private static boolean isHostAndPortNeeded(String protocol) {
        return !protocol.equalsIgnoreCase("file");
    }

    private URI getTurl(FsPath path, String protocol, String host, int port, SRMUser user) throws SRMException {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        if (host == null) {
            throw new IllegalArgumentException("host is null");
        }
        String transfer_path = this.getTurlPath(path, protocol, user);
        if (transfer_path == null) {
            throw new SRMException("cannot get transfer path");
        }
        try {
            if (port == 0) {
                port = -1;
            }
            URI turl = Storage.isHostAndPortNeeded(protocol) ? new URI(protocol, null, host, port, transfer_path, null, null) : new URI(protocol, null, transfer_path, null);
            _log.debug("getTurl() returns turl={}", (Object)turl);
            return turl;
        }
        catch (URISyntaxException e) {
            throw new SRMInternalErrorException(e.getMessage());
        }
    }

    private boolean verifyUserPathIsRootSubpath(FsPath absolutePath, SRMUser user) {
        AuthorizationRecord duser;
        if (absolutePath == null) {
            return false;
        }
        String user_root = null;
        if (user != null && (user_root = (duser = (AuthorizationRecord)user).getRoot()) != null) {
            user_root = new FsPath(user_root).toString();
        }
        if (user_root != null) {
            String path = absolutePath.toString();
            _log.debug("getTurl() user root is " + user_root);
            if (!path.startsWith(user_root)) {
                String error = "verifyUserPathIsInTheRoot error:user's path " + absolutePath + " is not subpath of the user's root" + user_root;
                _log.warn(error);
                return false;
            }
        }
        return true;
    }

    private String stripRootPath(FsPath root, FsPath path) throws SRMAuthorizationException {
        if (!path.startsWith(root)) {
            throw new SRMAuthorizationException(String.format("Access denied for path [%s]", path));
        }
        List<String> l = path.getPathItemsList();
        return FsPath.toString(l.subList(root.getPathItemsList().size(), l.size()));
    }

    private String getTurlPath(FsPath path, String protocol, SRMUser user) throws SRMException {
        AuthorizationRecord duser;
        String root;
        FsPath userRoot = new FsPath();
        if (user != null && (root = (duser = (AuthorizationRecord)user).getRoot()) != null) {
            userRoot = new FsPath(root);
        }
        if (!this.verifyUserPathIsRootSubpath(path, user)) {
            throw new SRMAuthorizationException(String.format("Access denied: Path [%s] is outside user's root [%s]", path, userRoot));
        }
        String transferPath = protocol.equals("gsiftp") ? this.stripRootPath(userRoot, path) : (protocol.equals("http") || protocol.equals("https") ? this.stripRootPath(this._httpRootPath, path) : (protocol.equals("root") ? this.stripRootPath(this._xrootdRootPath, path) : path.toString()));
        _log.debug("getTurlPath(path=" + path + ",protocol=" + protocol + ",user=" + user + ") = " + transferPath);
        return transferPath;
    }

    public LoginBrokerInfo[] getLoginBrokerInfos() throws SRMException {
        return this.getLoginBrokerInfos(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginBrokerInfo[] getLoginBrokerInfos(String protocol) throws SRMException {
        String error;
        String key = protocol == null ? "null" : protocol;
        Map<String, Long> map = this.latestLoginBrokerInfosTimes;
        synchronized (map) {
            LoginBrokerInfo[] infos;
            long age;
            Long timestamp = this.latestLoginBrokerInfosTimes.get(key);
            if (timestamp != null && (age = System.currentTimeMillis() - timestamp) < this.LOGINBROKERINFO_VALIDITYSPAN && (infos = this.latestLoginBrokerInfos.get(key)) != null) {
                return infos;
            }
        }
        String brokerMessage = "ls -binary";
        if (protocol != null) {
            brokerMessage = brokerMessage + " -protocol=" + protocol;
        }
        try {
            int retry = 0;
            do {
                _log.debug("getLoginBrokerInfos sending \"" + brokerMessage + "\"  to LoginBroker");
                try {
                    LoginBrokerInfo[] infos = this._loginBrokerStub.sendAndWait((Serializable)((Object)brokerMessage), LoginBrokerInfo[].class);
                    Map<String, Long> map2 = this.latestLoginBrokerInfosTimes;
                    synchronized (map2) {
                        this.latestLoginBrokerInfosTimes.put(key, System.currentTimeMillis());
                        this.latestLoginBrokerInfos.put(key, infos);
                    }
                    return infos;
                }
                catch (TimeoutCacheException e) {
                    error = "LoginBroker is unavailable";
                }
                catch (CacheException e) {
                    error = e.getMessage();
                }
                Thread.sleep(5000L);
            } while (++retry < 5);
        }
        catch (InterruptedException e) {
            throw new SRMException("Request was interrupted", (Throwable)e);
        }
        throw new SRMException(error);
    }

    public Set<String> listAvailableProtocols() throws SRMException {
        HashSet<String> protocols = new HashSet<String>();
        for (LoginBrokerInfo info : this.getLoginBrokerInfos()) {
            protocols.add(info.getProtocolFamily());
        }
        return protocols;
    }

    public boolean isLocalTransferUrl(URI url) throws SRMException {
        String protocol = url.getScheme();
        String host = url.getHost();
        int port = url.getPort();
        for (LoginBrokerInfo info : this.getLoginBrokerInfos(protocol)) {
            if (!info.getHost().equals(host) || info.getPort() != port) continue;
            return true;
        }
        return false;
    }

    public String selectHost(String protocol) throws SRMException {
        _log.debug("selectHost(" + protocol + ")");
        boolean tryFile = false;
        LoginBrokerInfo[] loginBrokerInfos = this.getLoginBrokerInfos(protocol);
        return this.selectHost(loginBrokerInfos);
    }

    private String lbiToDoor(LoginBrokerInfo lbi) throws SRMException {
        String resolvedHost;
        String thehost = lbi.getHost();
        HostnameCacheRecord resolvedHostRecord = this.doorToHostnameMap.get(thehost);
        if (resolvedHostRecord == null || resolvedHostRecord.expired()) {
            try {
                InetAddress address = InetAddress.getByName(thehost);
                resolvedHost = address.getHostName();
                if (this.customGetHostByAddr && InetAddresses.isInetAddress((String)resolvedHost)) {
                    resolvedHost = Storage.getHostByAddr(address.getAddress());
                }
            }
            catch (IOException e) {
                throw new SRMException("selectHost " + e, (Throwable)e);
            }
            this.doorToHostnameMap.put(thehost, new HostnameCacheRecord(resolvedHost));
        } else {
            resolvedHost = resolvedHostRecord.getHostname();
        }
        return resolvedHost + ":" + lbi.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String selectHost(LoginBrokerInfo[] loginBrokerInfos) throws SRMException {
        int selected_indx;
        Arrays.sort(loginBrokerInfos, LOAD_ORDER);
        int len = loginBrokerInfos.length;
        if (len <= 0) {
            return null;
        }
        Random random = this.rand;
        synchronized (random) {
            selected_indx = this.rand.nextInt(Math.min(len, this.numDoorInRanSelection));
        }
        String doorHostPort = this.lbiToDoor(loginBrokerInfos[selected_indx]);
        _log.debug("selectHost returns " + doorHostPort);
        return doorHostPort;
    }

    private static Map<String, List<String>> resolve(String name, String[] attrIds) throws NamingException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        InitialDirContext ctx = new InitialDirContext();
        Attributes attrs = ctx.getAttributes(name, attrIds);
        if (attrs == null) {
            return null;
        }
        NamingEnumeration<? extends Attribute> ae = attrs.getAll();
        while (ae != null && ae.hasMoreElements()) {
            Attribute attr = ae.next();
            String attrID = attr.getID();
            ArrayList<String> l = new ArrayList<String>();
            NamingEnumeration<?> e = attr.getAll();
            while (e.hasMoreElements()) {
                String literalip = (String)e.nextElement();
                l.add(literalip);
            }
            map.put(attrID, l);
        }
        return map;
    }

    private static String getHostByAddr(byte[] addr) throws UnknownHostException {
        try {
            int i;
            StringBuilder literalip = new StringBuilder();
            if (addr.length == 4) {
                for (i = addr.length - 1; i >= 0; --i) {
                    literalip.append(addr[i] & 0xFF).append(".");
                }
                literalip.append("IN-ADDR.ARPA.");
            } else if (addr.length == 16) {
                for (i = addr.length - 1; i >= 0; --i) {
                    literalip.append(addr[i] & 0xF).append(".").append(addr[i] & 0xF0).append(".");
                }
                literalip.append("IP6.INT.");
            }
            String[] ids = new String[]{"PTR"};
            Map<String, List<String>> map = Storage.resolve("dns:///" + literalip, ids);
            String host = "";
            for (List<String> hosts : map.values()) {
                host = hosts.get(0);
            }
            return host;
        }
        catch (NamingException e) {
            throw new UnknownHostException(e.getMessage());
        }
    }

    public void prepareToPut(SRMUser user, URI surl, PrepareToPutCallbacks callbacks, boolean overwrite) {
        try {
            FsPath actualPnfsPath = this.getPath(surl);
            PutCompanion.PrepareToPutFile((AuthorizationRecord)user, this.permissionHandler, actualPnfsPath.toString(), callbacks, this._pnfsStub, this.config.isRecursiveDirectoryCreation(), overwrite);
        }
        catch (SRMInvalidPathException e) {
            callbacks.InvalidPathError(e.getMessage());
        }
    }

    public void setFileMetaData(SRMUser user, FileMetaData fmd) throws SRMException {
        AuthorizationRecord duser = (AuthorizationRecord)user;
        PnfsHandler handler = new PnfsHandler(this._pnfs, duser.toSubject());
        try {
            if (!(fmd instanceof DcacheFileMetaData)) {
                throw new SRMException("Storage.setFileMetaData: metadata in not dCacheMetaData");
            }
            DcacheFileMetaData dfmd = (DcacheFileMetaData)fmd;
            FileAttributes updatedAttributes = new FileAttributes();
            updatedAttributes.setMode(dfmd.permMode);
            handler.setFileAttributes(dfmd.getPnfsId(), updatedAttributes);
            FileAttributes attributes = dfmd.getFileAttributes();
            attributes.setMode(dfmd.permMode);
        }
        catch (TimeoutCacheException e) {
            throw new SRMInternalErrorException("PnfsManager is unavailable: " + e.getMessage(), (Throwable)e);
        }
        catch (NotInTrashCacheException e) {
            throw new SRMInvalidPathException("No such file or directory", (Throwable)e);
        }
        catch (FileNotFoundCacheException e) {
            throw new SRMInvalidPathException("No such file or directory", (Throwable)e);
        }
        catch (PermissionDeniedCacheException e) {
            throw new SRMAuthorizationException("Permission denied");
        }
        catch (CacheException e) {
            throw new SRMException("SetFileMetaData failed for " + fmd.SURL + "; return code=" + e.getRc() + " reason=" + e.getMessage());
        }
    }

    public FileMetaData getFileMetaData(SRMUser user, URI surl, boolean read) throws SRMException {
        _log.debug("getFileMetaData(" + surl + ")");
        FsPath path = this.getPath(surl);
        AuthorizationRecord duser = (AuthorizationRecord)user;
        PnfsHandler handler = new PnfsHandler(this._pnfs, duser.toSubject());
        try {
            EnumSet<FileAttribute> requestedAttributes = EnumSet.of(FileAttribute.TYPE, FileAttribute.LOCATIONS);
            requestedAttributes.addAll(DcacheFileMetaData.getKnownAttributes());
            requestedAttributes.addAll(PoolMonitorV5.getRequiredAttributesForFileLocality());
            EnumSet<AccessMask> accessMask = read ? EnumSet.of(AccessMask.READ_DATA) : EnumSet.noneOf(AccessMask.class);
            FileAttributes attributes = handler.getFileAttributes(path.toString(), requestedAttributes, accessMask);
            DcacheFileMetaData fmd = new DcacheFileMetaData(attributes);
            if (attributes.getFileType() != FileType.DIR) {
                FileLocality locality = this._poolMonitor.getFileLocality(attributes, this.config.getSrmHost());
                fmd.locality = locality.toTFileLocality();
                switch (locality) {
                    case ONLINE: 
                    case ONLINE_AND_NEARLINE: {
                        fmd.isCached = true;
                    }
                }
            }
            try {
                GetFileSpaceTokensMessage msg = new GetFileSpaceTokensMessage(attributes.getPnfsId());
                msg = this._spaceManagerStub.sendAndWait(msg);
                if (msg.getSpaceTokens() != null) {
                    fmd.spaceTokens = new long[msg.getSpaceTokens().length];
                    System.arraycopy(msg.getSpaceTokens(), 0, fmd.spaceTokens, 0, msg.getSpaceTokens().length);
                }
            }
            catch (TimeoutCacheException e) {
                _log.info(e.getMessage());
            }
            return fmd;
        }
        catch (TimeoutCacheException e) {
            throw new SRMInternalErrorException(e.getMessage(), (Throwable)e);
        }
        catch (PermissionDeniedCacheException e) {
            throw new SRMAuthorizationException(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundCacheException e) {
            throw new SRMInvalidPathException(e.getMessage(), (Throwable)e);
        }
        catch (CacheException e) {
            throw new SRMException("Could not get storage info by path: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new SRMInternalErrorException("Operation interrupted", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserById(long id) {
        _log.debug("getDcacheUserById(" + id + ")");
        Map<Long, String> map = this.idToUserMap;
        synchronized (map) {
            return this.idToUserMap.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GSSCredential getCredentialById(long id) {
        _log.debug("getDcacheUserById(" + id + ")");
        Map<Long, String> map = this.idToUserMap;
        synchronized (map) {
            return this.idToCredentialMap.get(id);
        }
    }

    private static synchronized long getNextMessageID() {
        return nextMessageID.getAndIncrement();
    }

    public void localCopy(SRMUser user, URI fromSurl, URI toSurl) throws SRMException {
        FsPath actualFromFilePath = this.getPath(fromSurl);
        FsPath actualToFilePath = this.getPath(toSurl);
        long id = Storage.getNextMessageID();
        _log.debug("localCopy for user " + user + "from actualFromFilePath to actualToFilePath");
        AuthorizationRecord duser = (AuthorizationRecord)user;
        try {
            CopyManagerMessage copyRequest = new CopyManagerMessage(actualFromFilePath.toString(), actualToFilePath.toString(), id, this.config.getBuffer_size(), this.config.getTcp_buffer_size());
            copyRequest.setSubject(((AuthorizationRecord)user).toSubject());
            this._copyManagerStub.sendAndWait(copyRequest);
        }
        catch (TimeoutCacheException e) {
            _log.error("CopyManager is unavailable");
            throw new SRMInternalErrorException("CopyManager is unavailable: " + e.getMessage(), (Throwable)e);
        }
        catch (CacheException e) {
            String msg = " local copy failed with code =" + e.getRc() + " details: " + e.getMessage();
            _log.warn(msg);
            throw new SRMException(msg, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new SRMException("Request to CopyManager was interrupted", (Throwable)e);
        }
    }

    public void prepareToPutInReservedSpace(SRMUser user, String path, long size, long spaceReservationToken, PrepareToPutInSpaceCallbacks callbacks) {
        throw new UnsupportedOperationException("NotImplementedException");
    }

    public void advisoryDelete(SRMUser user, URI surl, final AdvisoryDeleteCallbacks callback) {
        _log.debug("Storage.advisoryDelete");
        if (!this.config.isAdvisoryDelete()) {
            if (callback != null) {
                callback.AdvisoryDeleteSuccesseded();
            }
            return;
        }
        RemoveFileCallbacks removeFileCallback = new RemoveFileCallbacks(){

            public void RemoveFileSucceeded() {
                callback.AdvisoryDeleteSuccesseded();
            }

            public void RemoveFileFailed(String reason) {
                callback.AdvisoryDeleteFailed(reason);
            }

            public void FileNotFound(String error) {
                callback.AdvisoryDeleteFailed(error);
            }

            public void Exception(Exception e) {
                callback.Exception(e);
            }

            public void Timeout() {
                callback.Timeout();
            }

            public void PermissionDenied() {
                callback.AdvisoryDeleteFailed("Permission denied");
            }
        };
        try {
            RemoveFileCompanion.removeFile((AuthorizationRecord)user, this.getPath(surl).toString(), removeFileCallback, this._pnfsStub, this.getCellEndpoint());
        }
        catch (SRMInvalidPathException e) {
            callback.AdvisoryDeleteFailed(e.getMessage());
        }
    }

    public void removeFile(SRMUser user, URI surl, RemoveFileCallbacks callbacks) {
        _log.debug("Storage.removeFile");
        try {
            RemoveFileCompanion.removeFile((AuthorizationRecord)user, this.getPath(surl).toString(), callbacks, this._pnfsStub, this.getCellEndpoint());
        }
        catch (SRMInvalidPathException e) {
            callbacks.FileNotFound(e.getMessage());
        }
    }

    public void removeDirectory(SRMUser user, List<URI> surls) throws SRMException {
        _log.debug("Storage.removeDirectory");
        for (URI surl : surls) {
            FsPath path = this.getPath(surl);
            try {
                this._pnfs.deletePnfsEntry(path.toString());
            }
            catch (TimeoutCacheException e) {
                _log.error("Failed to delete " + path + " due to timeout");
                throw new SRMInternalErrorException("Internal name space timeout while deleting " + surl);
            }
            catch (FileNotFoundCacheException e) {
                throw new SRMException("File does not exist: " + surl);
            }
            catch (NotInTrashCacheException e) {
                throw new SRMException("File does not exist: " + surl);
            }
            catch (CacheException e) {
                _log.error("Failed to delete " + path + ": " + e.getMessage());
                throw new SRMException("Failed to delete " + surl + ": " + e.getMessage());
            }
        }
    }

    public void createDirectory(SRMUser user, URI surl) throws SRMException {
        _log.debug("Storage.createDirectory");
        Subject subject = ((AuthorizationRecord)user).toSubject();
        PnfsHandler handler = new PnfsHandler(this._pnfs, subject);
        try {
            handler.createPnfsDirectory(this.getPath(surl).toString());
        }
        catch (TimeoutCacheException e) {
            throw new SRMInternalErrorException("Internal name space timeout", (Throwable)e);
        }
        catch (NotDirCacheException e) {
            throw new SRMInvalidPathException("Parent path is not a directory", (Throwable)e);
        }
        catch (NotInTrashCacheException e) {
            throw new SRMInvalidPathException("Parent path does not exist", (Throwable)e);
        }
        catch (FileNotFoundCacheException e) {
            throw new SRMInvalidPathException("Parent path does not exist", (Throwable)e);
        }
        catch (FileExistsCacheException e) {
            throw new SRMDuplicationException("File exists");
        }
        catch (PermissionDeniedCacheException e) {
            throw new SRMAuthorizationException("Permission denied");
        }
        catch (CacheException e) {
            _log.error("Failed to create directory " + surl + ": " + e.getMessage());
            throw new SRMException(String.format("Failed to create directory [rc=%d,msg=%s]", e.getRc(), e.getMessage()));
        }
    }

    public void moveEntry(SRMUser user, URI from, URI to) throws SRMException {
        Subject subject = ((AuthorizationRecord)user).toSubject();
        PnfsHandler handler = new PnfsHandler(this._pnfs, subject);
        FsPath fromPath = this.getPath(from);
        FsPath toPath = this.getPath(to);
        try {
            try {
                FileAttributes attr = handler.getFileAttributes(toPath.toString(), EnumSet.of(FileAttribute.TYPE));
                if (fromPath.equals(toPath)) {
                    return;
                }
                if (attr.getFileType() != FileType.DIR) {
                    throw new SRMDuplicationException("Destination exists");
                }
                toPath = new FsPath(toPath, fromPath.getName());
            }
            catch (FileNotFoundCacheException e) {
                // empty catch block
            }
            handler.renameEntry(fromPath.toString(), toPath.toString(), false);
        }
        catch (FileNotFoundCacheException e) {
            throw new SRMInvalidPathException("No such file or directory", (Throwable)e);
        }
        catch (FileExistsCacheException e) {
            throw new SRMDuplicationException("Destination exists", (Throwable)e);
        }
        catch (NotDirCacheException e) {
            FsPath parent = toPath.getParent();
            throw new SRMInvalidPathException("No such directory: " + parent, (Throwable)e);
        }
        catch (PermissionDeniedCacheException e) {
            throw new SRMException("Permission denied");
        }
        catch (TimeoutCacheException e) {
            _log.error("Failed to rename " + fromPath + " due to timeout");
            throw new SRMInternalErrorException("Internal name space timeout");
        }
        catch (CacheException e) {
            _log.error("Failed to rename " + fromPath + ": " + e.getMessage());
            throw new SRMException(String.format("Rename failed [rc=%d,msg=%s]", e.getRc(), e.getMessage()));
        }
    }

    public boolean canRead(SRMUser user, FileMetaData fmd) {
        int uid = Integer.parseInt(fmd.owner);
        int gid = Integer.parseInt(fmd.group);
        int permissions = fmd.permMode;
        if (permissions == 0) {
            return false;
        }
        if (Permissions.worldCanRead((int)permissions)) {
            return true;
        }
        if (uid == -1 || gid == -1) {
            return false;
        }
        if (user == null || !(user instanceof AuthorizationRecord)) {
            return false;
        }
        AuthorizationRecord duser = (AuthorizationRecord)user;
        if (duser.getGid() == gid && Permissions.groupCanRead((int)permissions)) {
            return true;
        }
        return duser.getUid() == uid && Permissions.userCanRead((int)permissions);
    }

    public static boolean _canWrite(SRMUser user, String fileId, FileMetaData fmd, String parentFileId, FileMetaData parentFmd, boolean overwrite) {
        boolean canWrite;
        if (!overwrite && fileId != null) {
            return false;
        }
        if (parentFileId == null) {
            return false;
        }
        AuthorizationRecord duser = (AuthorizationRecord)user;
        if (fileId == null) {
            canWrite = true;
        } else {
            int uid = Integer.parseInt(fmd.owner);
            int gid = Integer.parseInt(fmd.group);
            int permissions = fmd.permMode;
            canWrite = permissions == 0 ? false : (Permissions.worldCanWrite((int)permissions) ? true : (uid == -1 || gid == -1 ? false : (user == null || !(user instanceof AuthorizationRecord) ? false : (duser.getGid() == gid && Permissions.groupCanWrite((int)permissions) ? true : duser.getUid() == uid && Permissions.userCanWrite((int)permissions)))));
        }
        int parentUid = Integer.parseInt(parentFmd.owner);
        int parentGid = Integer.parseInt(parentFmd.group);
        int parentPermissions = parentFmd.permMode;
        boolean parentCanWrite = parentPermissions == 0 ? false : (Permissions.worldCanWrite((int)parentPermissions) && Permissions.worldCanExecute((int)parentPermissions) ? true : (parentUid == -1 || parentGid == -1 ? false : (user == null || !(user instanceof AuthorizationRecord) ? false : (duser.getGid() == parentGid && Permissions.groupCanWrite((int)parentPermissions) && Permissions.groupCanExecute((int)parentPermissions) ? true : duser.getUid() == parentUid && Permissions.userCanWrite((int)parentPermissions) && Permissions.userCanExecute((int)parentPermissions)))));
        return canWrite && parentCanWrite;
    }

    public String getFromRemoteTURL(SRMUser user, URI remoteTURL, URI surl, SRMUser remoteUser, Long remoteCredentialId, String spaceReservationId, long size, CopyCallbacks callbacks) throws SRMException {
        FsPath path = this.getPath(surl);
        _log.debug(" getFromRemoteTURL from " + remoteTURL + " to " + path);
        return this.performRemoteTransfer(user, remoteTURL, path, true, remoteUser, remoteCredentialId, spaceReservationId, size, callbacks);
    }

    public String getFromRemoteTURL(SRMUser user, URI remoteTURL, URI surl, SRMUser remoteUser, Long remoteCredentialId, CopyCallbacks callbacks) throws SRMException {
        FsPath path = this.getPath(surl);
        _log.debug(" getFromRemoteTURL from " + remoteTURL + " to " + path);
        return this.performRemoteTransfer(user, remoteTURL, path, true, remoteUser, remoteCredentialId, null, null, callbacks);
    }

    public String putToRemoteTURL(SRMUser user, URI surl, URI remoteTURL, SRMUser remoteUser, Long remoteCredentialId, CopyCallbacks callbacks) throws SRMException {
        FsPath path = this.getPath(surl);
        _log.debug(" putToRemoteTURL from " + path + " to " + surl);
        return this.performRemoteTransfer(user, remoteTURL, path, false, remoteUser, remoteCredentialId, null, null, callbacks);
    }

    public void killRemoteTransfer(String transferId) {
        try {
            long callerId = Long.parseLong(transferId);
            TransferInfo info = this.callerIdToHandler.get(callerId);
            if (info != null) {
                CancelTransferMessage cancel = new CancelTransferMessage(info.transferId, callerId);
                this.sendMessage(new CellMessage(info.cellPath, (Object)cancel));
            }
        }
        catch (NoRouteToCellException e) {
            _log.error("Failed to kill remote transfer: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            _log.error("Failed to kill remote transfer: Cannot parse transfer ID");
        }
    }

    private String performRemoteTransfer(SRMUser user, URI remoteTURL, FsPath actualFilePath, boolean store, SRMUser remoteUser, Long remoteCredentialId, String spaceReservationId, Long size, CopyCallbacks callbacks) throws SRMException {
        IpProtocolInfo protocolInfo;
        Subject subject = ((AuthorizationRecord)user).toSubject();
        _log.debug("performRemoteTransfer performing " + (store ? "store" : "restore"));
        if (!this.verifyUserPathIsRootSubpath(actualFilePath, user)) {
            throw new SRMAuthorizationException("user's path " + actualFilePath + " is not subpath of the user's root");
        }
        if (remoteTURL.getScheme().equals("gsiftp")) {
            RequestCredential credential = RequestCredential.getRequestCredential((Long)remoteCredentialId);
            if (credential == null) {
                throw new SRMAuthorizationException("Cannot authenticate with remote gsiftp service; credential delegation required.");
            }
            GSSCredential delegatedCredential = credential.getDelegatedCredential();
            String[] hosts = new String[]{remoteTURL.getHost()};
            RemoteGsiftpTransferProtocolInfo gsiftpProtocolInfo = new RemoteGsiftpTransferProtocolInfo("RemoteGsiftpTransfer", 1, 1, hosts, 0, remoteTURL.toString(), this.getCellName(), this.getCellDomainName(), this.config.getBuffer_size(), this.config.getTcp_buffer_size(), remoteCredentialId, delegatedCredential);
            gsiftpProtocolInfo.setEmode(true);
            gsiftpProtocolInfo.setNumberOfStreams(this.config.getParallel_streams());
            protocolInfo = gsiftpProtocolInfo;
        } else if (remoteTURL.getScheme().equals("http")) {
            String[] hosts = new String[]{remoteTURL.getHost()};
            protocolInfo = new RemoteHttpDataTransferProtocolInfo("RemoteHttpDataTransfer", 1, 1, hosts, 0, this.config.getBuffer_size(), remoteTURL.toString());
        } else {
            throw new SRMException("not implemented");
        }
        RemoteTransferManagerMessage request = store && spaceReservationId != null && size != null ? new RemoteTransferManagerMessage(remoteTURL, actualFilePath, store, remoteCredentialId, spaceReservationId, this.config.isSpace_reservation_strict(), size, protocolInfo) : new RemoteTransferManagerMessage(remoteTURL, actualFilePath, store, remoteCredentialId, protocolInfo);
        request.setSubject(subject);
        try {
            RemoteTransferManagerMessage reply = this._transferManagerStub.sendAndWait(request);
            long id = reply.getId();
            _log.debug("received first RemoteGsiftpTransferManagerMessage reply from transfer manager, id =" + id);
            TransferInfo info = new TransferInfo(id, remoteCredentialId, callbacks, this._transferManagerStub.getDestinationPath());
            _log.debug("storing info for callerId = {}", (Object)id);
            this.callerIdToHandler.put(id, info);
            return String.valueOf(id);
        }
        catch (TimeoutCacheException e) {
            throw new SRMInternalErrorException("Transfer manager is unavailable: " + e.getMessage(), (Throwable)e);
        }
        catch (CacheException e) {
            throw new SRMException("TransferManager error: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new SRMException("Request to transfer manager got interruptd", (Throwable)e);
        }
    }

    private void handleTransferManagerMessage(TransferManagerMessage message) {
        Long callerId = message.getId();
        _log.debug("handleTransferManagerMessage for callerId=" + callerId);
        if (message instanceof RemoteGsiftpDelegateUserCredentialsMessage) {
            RemoteGsiftpDelegateUserCredentialsMessage delegate = (RemoteGsiftpDelegateUserCredentialsMessage)message;
            Long remoteCredentialId = delegate.getRequestCredentialId();
            final String host = delegate.getHost();
            final int port = delegate.getPort();
            RequestCredential remoteCredential = RequestCredential.getRequestCredential((Long)remoteCredentialId);
            if (remoteCredential != null) {
                final GSSCredential gssRemoteCredential = remoteCredential.getDelegatedCredential();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Storage.this.delegate(gssRemoteCredential, host, port);
                    }
                }, "credentialDelegator").start();
            } else {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Storage.this.delegate(null, host, port);
                    }
                }, "credentialDelegator").start();
            }
            return;
        }
        TransferInfo info = this.callerIdToHandler.get(callerId);
        if (info == null) {
            _log.error("TransferInfo for callerId=" + callerId + "not found");
            return;
        }
        if (message instanceof TransferCompleteMessage) {
            TransferCompleteMessage complete = (TransferCompleteMessage)message;
            info.callbacks.copyComplete(null);
            _log.debug("removing TransferInfo for callerId=" + callerId);
            this.callerIdToHandler.remove(callerId);
        } else if (message instanceof TransferFailedMessage) {
            SRMInvalidPathException e;
            Object error = message.getErrorObject();
            if (error instanceof CacheException) {
                error = ((CacheException)error).getMessage();
            }
            switch (message.getReturnCode()) {
                case 10018: {
                    e = new SRMAuthorizationException(String.format("Access denied: %s", error));
                    break;
                }
                case 10001: {
                    e = new SRMInvalidPathException(String.valueOf(error));
                    break;
                }
                default: {
                    e = new SRMException(String.format("Transfer failed: %s [%d]", error, message.getReturnCode()));
                }
            }
            info.callbacks.copyFailed((SRMException)e);
            _log.debug("removing TransferInfo for callerId=" + callerId);
            this.callerIdToHandler.remove(callerId);
        }
    }

    private void delegate(GSSCredential credential, String host, int port) {
        if (credential == null) {
            _log.warn("cannot delegate,  user credential is null");
            try {
                Socket s = new Socket(host, port);
                OutputStream sout = s.getOutputStream();
                sout.close();
                s.close();
            }
            catch (IOException ioe) {
                _log.error(ioe.toString());
            }
        } else {
            try {
                String credname = ((Object)credential.getName()).toString();
                _log.info("SRMCell.Delegator, delegating credentials :" + credential + " to mover at " + host + " listening on port " + port);
            }
            catch (GSSException gsse) {
                _log.error("invalid credentials :" + gsse.getMessage());
                try {
                    Socket s = new Socket(host, port);
                    OutputStream sout = s.getOutputStream();
                    sout.close();
                    s.close();
                }
                catch (IOException ioe) {
                    _log.error(ioe.toString());
                }
                return;
            }
            try {
                SslGsiSocketFactory.delegateCredential((InetAddress)InetAddress.getByName(host), (int)port, (GSSCredential)credential, (boolean)false);
                _log.info("delegation appears to have succeeded");
            }
            catch (RuntimeException e) {
                _log.error("delegation failed", (Throwable)e);
            }
            catch (Exception e) {
                _log.error("delegation failed: " + e.getMessage());
            }
        }
    }

    public StorageElementInfo getStorageElementInfo(SRMUser user) {
        return this.storageElementInfo;
    }

    private StorageElementInfo getStorageElementInfo() {
        return this.storageElementInfo;
    }

    private void updateStorageElementInfo() throws CacheException, InterruptedException {
        this._poolMonitor = this._poolManagerStub.sendAndWait(new PoolManagerGetPoolMonitor()).getPoolMonitor();
        String[] pools = this._poolMonitor.getPoolSelectionUnit().getActivePools();
        if (pools.length == 0) {
            _log.debug("Pool manager provided empty list of pools; assuming pool manager was restarted");
            return;
        }
        CostModule cm = this._poolMonitor.getCostModule();
        StorageElementInfo info = new StorageElementInfo();
        for (String pool : pools) {
            PoolCostInfo.PoolSpaceInfo poolInfo = cm.getPoolCostInfo(pool).getSpaceInfo();
            if (poolInfo == null) continue;
            info.availableSpace += poolInfo.getFreeSpace();
            info.availableSpace += poolInfo.getRemovableSpace();
            info.totalSpace += poolInfo.getTotalSpace();
            info.usedSpace += poolInfo.getPreciousSpace();
            info.usedSpace += poolInfo.getRemovableSpace();
        }
        this.storageElementInfo = info;
    }

    @Override
    public void run() {
        try {
            while (true) {
                try {
                    this.updateStorageElementInfo();
                }
                catch (CacheException e) {
                    _log.error("Pool monitor update failed: {} [{}]", (Object)e.getMessage(), (Object)e.getRc());
                }
                Thread.sleep(this.config.getStorage_info_update_period());
            }
        }
        catch (InterruptedException e) {
            _log.debug("Storage info update thread shut down");
            return;
        }
    }

    public List<URI> listNonLinkedDirectory(SRMUser user, URI surl) throws SRMException {
        AuthorizationRecord duser = (AuthorizationRecord)user;
        Subject subject = duser.toSubject();
        FsPath path = this.getPath(surl);
        try {
            EnumSet<FileAttribute> requestedAttributes = EnumSet.of(FileAttribute.TYPE);
            requestedAttributes.addAll(this.permissionHandler.getRequiredAttributes());
            FileAttributes parentAttr = this._pnfs.getFileAttributes(path.getParent().toString(), requestedAttributes);
            FileAttributes childAttr = this._pnfs.getFileAttributes(path.toString(), requestedAttributes);
            AccessType canDelete = this.permissionHandler.canDeleteDir(subject, parentAttr, childAttr);
            if (canDelete != AccessType.ACCESS_ALLOWED) {
                _log.warn("Cannot delete directory " + path + ": Permission denied");
                throw new SRMAuthorizationException("Permission denied");
            }
            if (childAttr.getFileType() == FileType.LINK) {
                return null;
            }
        }
        catch (FileNotFoundCacheException e) {
            throw new SRMInvalidPathException("No such file or directory", (Throwable)e);
        }
        catch (NotInTrashCacheException e) {
            throw new SRMInvalidPathException("No such file or directory", (Throwable)e);
        }
        catch (TimeoutCacheException e) {
            throw new SRMInternalErrorException("Internal name space timeout", (Throwable)e);
        }
        catch (CacheException e) {
            _log.error("Failed to list directory " + path + ": " + e.getMessage());
            throw new SRMException(String.format("Failed delete directory [rc=%d,msg=%s]", e.getRc(), e.getMessage()));
        }
        return this.listDirectory(user, surl, null);
    }

    public List<URI> listDirectory(SRMUser user, URI surl, FileMetaData fileMetaData) throws SRMException {
        FsPath path = this.getPath(surl);
        final ArrayList<URI> result = new ArrayList<URI>();
        final String base = this.addTrailingSlash(surl.toString());
        Subject subject = ((AuthorizationRecord)user).toSubject();
        DirectoryListPrinter printer = new DirectoryListPrinter(){

            @Override
            public Set<FileAttribute> getRequiredAttributes() {
                return EnumSet.noneOf(FileAttribute.class);
            }

            @Override
            public void print(FsPath dir, FileAttributes dirAttr, DirectoryEntry entry) {
                result.add(URI.create(base + entry.getName()));
            }
        };
        try {
            this._listSource.printDirectory(subject, printer, path, null, (Range<Integer>)Ranges.all());
            return result;
        }
        catch (TimeoutCacheException e) {
            throw new SRMInternalErrorException("Internal name space timeout", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new SRMInternalErrorException("List aborted by administrator", (Throwable)e);
        }
        catch (NotDirCacheException e) {
            throw new SRMInvalidPathException("Not a directory", (Throwable)e);
        }
        catch (FileNotFoundCacheException e) {
            throw new SRMInvalidPathException("No such file or directory", (Throwable)e);
        }
        catch (NotInTrashCacheException e) {
            throw new SRMInvalidPathException("No such file or directory", (Throwable)e);
        }
        catch (PermissionDeniedCacheException e) {
            throw new SRMAuthorizationException("Permission denied", (Throwable)e);
        }
        catch (CacheException e) {
            throw new SRMException(String.format("List failed [rc=%d,msg=%s]", e.getRc(), e.getMessage()));
        }
    }

    public List<FileMetaData> listDirectory(SRMUser user, URI surl, boolean verbose, int offset, int count) throws SRMException {
        try {
            FsPath path = this.getPath(surl);
            Subject subject = ((AuthorizationRecord)user).toSubject();
            FmdListPrinter printer = verbose ? new VerboseListPrinter() : new FmdListPrinter();
            this._listSource.printDirectory(subject, printer, path, null, (Range<Integer>)Ranges.closedOpen((Comparable)Integer.valueOf(offset), (Comparable)Integer.valueOf(offset + count)));
            return printer.getResult();
        }
        catch (TimeoutCacheException e) {
            throw new SRMInternalErrorException("Internal name space timeout", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new SRMInternalErrorException("List aborted by administrator", (Throwable)e);
        }
        catch (NotDirCacheException e) {
            throw new SRMInvalidPathException("Not a directory", (Throwable)e);
        }
        catch (FileNotFoundCacheException e) {
            throw new SRMInvalidPathException("No such file or directory", (Throwable)e);
        }
        catch (NotInTrashCacheException e) {
            throw new SRMInvalidPathException("No such file or directory", (Throwable)e);
        }
        catch (PermissionDeniedCacheException e) {
            throw new SRMAuthorizationException("Permission denied", (Throwable)e);
        }
        catch (CacheException e) {
            throw new SRMException(String.format("List failed [rc=%d,msg=%s]", e.getRc(), e.getMessage()));
        }
    }

    public void srmReserveSpace(SRMUser user, long sizeInBytes, long spaceReservationLifetime, String retentionPolicy, String accessLatency, String description, SrmReserveSpaceCallbacks callbacks) {
        AuthorizationRecord duser = (AuthorizationRecord)user;
        SrmReserveSpaceCompanion.reserveSpace(duser, sizeInBytes, spaceReservationLifetime, retentionPolicy, accessLatency, description, callbacks, this._spaceManagerStub);
    }

    public void srmReleaseSpace(SRMUser user, String spaceToken, Long releaseSizeInBytes, SrmReleaseSpaceCallbacks callbacks) {
        long longSpaceToken;
        try {
            longSpaceToken = Long.parseLong(spaceToken);
        }
        catch (Exception e) {
            callbacks.ReleaseSpaceFailed("invalid space token=" + spaceToken);
            return;
        }
        AuthorizationRecord duser = (AuthorizationRecord)user;
        SrmReleaseSpaceCompanion.releaseSpace(duser, longSpaceToken, releaseSizeInBytes, callbacks, this._spaceManagerStub);
    }

    public void srmMarkSpaceAsBeingUsed(SRMUser user, String spaceToken, URI surl, long sizeInBytes, long useLifetime, boolean overwrite, SrmUseSpaceCallbacks callbacks) {
        try {
            long longSpaceToken = Long.parseLong(spaceToken);
            AuthorizationRecord duser = (AuthorizationRecord)user;
            FsPath fsPath = this.getPath(surl);
            SrmMarkSpaceAsBeingUsedCompanion.markSpace(duser, longSpaceToken, fsPath.toString(), sizeInBytes, useLifetime, overwrite, callbacks, this._spaceManagerStub);
        }
        catch (SRMInvalidPathException e) {
            callbacks.SrmUseSpaceFailed("Invalid path: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            callbacks.SrmUseSpaceFailed("invalid space token=" + spaceToken);
        }
    }

    public void srmUnmarkSpaceAsBeingUsed(SRMUser user, String spaceToken, URI surl, SrmCancelUseOfSpaceCallbacks callbacks) {
        try {
            long longSpaceToken = Long.parseLong(spaceToken);
            AuthorizationRecord duser = (AuthorizationRecord)user;
            FsPath fsPath = this.getPath(surl);
            SrmUnmarkSpaceAsBeingUsedCompanion.unmarkSpace(duser, longSpaceToken, fsPath.toString(), callbacks, this._spaceManagerStub);
        }
        catch (SRMInvalidPathException e) {
            callbacks.CancelUseOfSpaceFailed("Invalid path: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            callbacks.CancelUseOfSpaceFailed("invalid space token=" + spaceToken);
        }
    }

    public TMetaDataSpace[] srmGetSpaceMetaData(SRMUser user, String[] spaceTokens) throws SRMException {
        _log.debug("srmGetSpaceMetaData");
        if (spaceTokens == null) {
            throw new SRMException("null array of space tokens");
        }
        long[] tokens = new long[spaceTokens.length];
        for (int i = 0; i < spaceTokens.length; ++i) {
            try {
                tokens[i] = Long.parseLong(spaceTokens[i]);
                continue;
            }
            catch (Exception e) {
                throw new SRMException("invalid token: " + spaceTokens[i]);
            }
        }
        GetSpaceMetaData getSpaces = new GetSpaceMetaData(tokens);
        try {
            getSpaces = this._spaceManagerStub.sendAndWait(getSpaces);
        }
        catch (TimeoutCacheException e) {
            throw new SRMInternalErrorException("SrmSpaceManager is unavailable: " + e.getMessage(), (Throwable)e);
        }
        catch (CacheException e) {
            _log.warn("GetSpaceMetaData failed with rc=" + e.getRc() + " error=" + e.getMessage());
            throw new SRMException("GetSpaceMetaData failed with rc=" + e.getRc() + " error=" + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new SRMException("Request to SrmSpaceManaget got interrupted", (Throwable)e);
        }
        Space[] spaces = getSpaces.getSpaces();
        tokens = getSpaces.getSpaceTokens();
        TMetaDataSpace[] spaceMetaDatas = new TMetaDataSpace[spaces.length];
        for (int i = 0; i < spaceMetaDatas.length; ++i) {
            if (spaces[i] != null) {
                int lifetimeleft;
                Space space = spaces[i];
                spaceMetaDatas[i] = new TMetaDataSpace();
                spaceMetaDatas[i].setSpaceToken(Long.toString(space.getId()));
                long lifetime = space.getLifetime();
                if (lifetime == -1L) {
                    lifetimeleft = -1;
                    spaceMetaDatas[i].setLifetimeAssigned(Integer.valueOf(-1));
                    spaceMetaDatas[i].setLifetimeLeft(Integer.valueOf(-1));
                } else {
                    lifetimeleft = (int)((space.getCreationTime() + lifetime - System.currentTimeMillis()) / 1000L);
                    lifetimeleft = lifetimeleft < 0 ? 0 : lifetimeleft;
                    spaceMetaDatas[i].setLifetimeAssigned(Integer.valueOf((int)(lifetime / 1000L)));
                    spaceMetaDatas[i].setLifetimeLeft(Integer.valueOf(lifetimeleft));
                }
                TRetentionPolicy policy = space.getRetentionPolicy().equals((Object)RetentionPolicy.CUSTODIAL) ? TRetentionPolicy.CUSTODIAL : (space.getRetentionPolicy().equals((Object)RetentionPolicy.OUTPUT) ? TRetentionPolicy.OUTPUT : TRetentionPolicy.REPLICA);
                TAccessLatency latency = space.getAccessLatency().equals((Object)AccessLatency.ONLINE) ? TAccessLatency.ONLINE : TAccessLatency.NEARLINE;
                spaceMetaDatas[i].setRetentionPolicyInfo(new TRetentionPolicyInfo(policy, latency));
                spaceMetaDatas[i].setTotalSize(new UnsignedLong(space.getSizeInBytes()));
                spaceMetaDatas[i].setGuaranteedSize(spaceMetaDatas[i].getTotalSize());
                spaceMetaDatas[i].setUnusedSize(new UnsignedLong(space.getSizeInBytes() - space.getUsedSizeInBytes()));
                SpaceState spaceState = space.getState();
                if (SpaceState.RESERVED.equals(spaceState)) {
                    if (lifetimeleft == 0) {
                        spaceMetaDatas[i].setStatus(new TReturnStatus(TStatusCode.SRM_SPACE_LIFETIME_EXPIRED, "expired"));
                    } else {
                        spaceMetaDatas[i].setStatus(new TReturnStatus(TStatusCode.SRM_SUCCESS, "ok"));
                    }
                } else if (SpaceState.EXPIRED.equals(spaceState)) {
                    spaceMetaDatas[i].setStatus(new TReturnStatus(TStatusCode.SRM_SPACE_LIFETIME_EXPIRED, "expired"));
                } else {
                    spaceMetaDatas[i].setStatus(new TReturnStatus(TStatusCode.SRM_FAILURE, "space has been released "));
                }
                spaceMetaDatas[i].setOwner("VoGroup=" + space.getVoGroup() + "" + " VoRole=" + space.getVoRole());
                continue;
            }
            spaceMetaDatas[i] = new TMetaDataSpace();
            spaceMetaDatas[i].setSpaceToken(Long.toString(tokens[i]));
            spaceMetaDatas[i].setStatus(new TReturnStatus(TStatusCode.SRM_INVALID_REQUEST, "space not found"));
        }
        return spaceMetaDatas;
    }

    public String[] srmGetSpaceTokens(SRMUser user, String description) throws SRMException {
        AuthorizationRecord duser = (AuthorizationRecord)user;
        _log.debug("srmGetSpaceTokens (" + description + ")");
        GetSpaceTokens getTokens = new GetSpaceTokens(duser, description);
        try {
            getTokens = this._spaceManagerStub.sendAndWait(getTokens);
        }
        catch (TimeoutCacheException e) {
            throw new SRMInternalErrorException("SrmSpaceManager is unavailable: " + e.getMessage(), (Throwable)e);
        }
        catch (CacheException e) {
            _log.warn("GetSpaceTokens failed with rc=" + e.getRc() + " error=" + e.getMessage());
            throw new SRMException("GetSpaceTokens failed with rc=" + e.getRc() + " error=" + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new SRMException("Request to SrmSpaceManager got interrupted", (Throwable)e);
        }
        long[] tokens = getTokens.getSpaceTokens();
        String[] tokenStrings = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokenStrings[i] = Long.toString(tokens[i]);
            _log.debug("srmGetSpaceTokens returns token#" + i + " : " + tokenStrings[i]);
        }
        return tokenStrings;
    }

    public String[] srmGetRequestTokens(SRMUser user, String description) throws SRMException {
        try {
            Set tokens = this.srm.getBringOnlineRequestIds(user, description);
            tokens.addAll(this.srm.getGetRequestIds(user, description));
            tokens.addAll(this.srm.getPutRequestIds(user, description));
            tokens.addAll(this.srm.getCopyRequestIds(user, description));
            tokens.addAll(this.srm.getLsRequestIds(user, description));
            Long[] tokenLongs = tokens.toArray(new Long[0]);
            String[] tokenStrings = new String[tokenLongs.length];
            for (int i = 0; i < tokenLongs.length; ++i) {
                tokenStrings[i] = tokenLongs[i].toString();
            }
            return tokenStrings;
        }
        catch (SQLException e) {
            _log.error("srmGetRequestTokens failed: " + e.getMessage());
            throw new SRMException("srmGetRequestTokens failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private void checkWritePrivileges(SRMUser user, URI surl) throws SRMException {
        try {
            Subject subject = ((AuthorizationRecord)user).toSubject();
            FsPath path = this.getPath(surl);
            PnfsHandler handler = new PnfsHandler(this._pnfs, subject);
            handler.getFileAttributes(path.toString(), EnumSet.noneOf(FileAttribute.class), EnumSet.of(AccessMask.WRITE_DATA));
        }
        catch (TimeoutCacheException e) {
            throw new SRMInternalErrorException("Internal name space timeout", (Throwable)e);
        }
        catch (NotInTrashCacheException e) {
            throw new SRMInvalidPathException("Parent path does not exist", (Throwable)e);
        }
        catch (FileNotFoundCacheException e) {
            throw new SRMInvalidPathException("Parent path does not exist", (Throwable)e);
        }
        catch (PermissionDeniedCacheException e) {
            throw new SRMAuthorizationException("Permission denied");
        }
        catch (CacheException e) {
            throw new SRMException(String.format("Operation failed [rc=%d,msg=%s]", e.getRc(), e.getMessage()));
        }
    }

    public int srmExtendSurlLifetime(SRMUser user, URI surl, int newLifetime) throws SRMException {
        this.checkWritePrivileges(user, surl);
        return -1;
    }

    public long srmExtendReservationLifetime(SRMUser user, String spaceToken, long newReservationLifetime) throws SRMException {
        try {
            long longSpaceToken = Long.parseLong(spaceToken);
            ExtendLifetime extendLifetime = new ExtendLifetime(longSpaceToken, newReservationLifetime);
            extendLifetime = this._spaceManagerStub.sendAndWait(extendLifetime);
            return extendLifetime.getNewLifetime();
        }
        catch (NumberFormatException e) {
            throw new SRMException("Cannot parse space token: " + e.getMessage(), (Throwable)e);
        }
        catch (TimeoutCacheException e) {
            throw new SRMInternalErrorException("SrmSpaceManager is unavailable: " + e.getMessage(), (Throwable)e);
        }
        catch (CacheException e) {
            throw new SRMException("srmExtendReservationLifetime failed, ExtendLifetime.returnCode=" + e.getRc() + " errorObject = " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw new SRMException("Request to SrmSpaceManager got interrupted", (Throwable)e);
        }
    }

    public long extendPinLifetime(SRMUser user, String fileId, String pinId, long newPinLifetime) throws SRMException {
        try {
            if (PinCompanion.isFakePinId(pinId)) {
                return newPinLifetime;
            }
            PnfsId pnfsId = new PnfsId(fileId);
            FileAttributes attributes = new FileAttributes();
            attributes.setPnfsId(pnfsId);
            PinManagerExtendPinMessage extendLifetime = new PinManagerExtendPinMessage(attributes, Long.parseLong(pinId), newPinLifetime);
            extendLifetime.setSubject(((AuthorizationRecord)user).toSubject());
            extendLifetime = this._pinManagerStub.sendAndWait(extendLifetime);
            return extendLifetime.getLifetime();
        }
        catch (IllegalArgumentException e) {
            throw new SRMException("Invalid PNFS ID: " + fileId, (Throwable)e);
        }
        catch (TimeoutCacheException e) {
            throw new SRMInternalErrorException("PinManager is unavailable: " + e.getMessage(), (Throwable)e);
        }
        catch (CacheException e) {
            throw new SRMException("extendPinLifetime failed, PinManagerExtendLifetimeMessage.returnCode=" + e.getRc() + " errorObject = " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw new SRMException("Request to PinManager got interrupted", (Throwable)e);
        }
    }

    public String getStorageBackendVersion() {
        return Version.getVersion();
    }

    public boolean exists(SRMUser user, URI surl) throws SRMException {
        FsPath path = this.getPath(surl);
        try {
            return this._pnfs.getPnfsIdByPath(path.toString()) != null;
        }
        catch (FileNotFoundCacheException e) {
            return false;
        }
        catch (NotInTrashCacheException e) {
            return false;
        }
        catch (CacheException e) {
            _log.error("Failed to find file by path : " + e.getMessage());
            throw new SRMException("Failed to find file by path due to internal system failure or timeout: " + e.getMessage());
        }
    }

    private String addTrailingSlash(String s) {
        if (!s.endsWith("/")) {
            s = s + "/";
        }
        return s;
    }

    private FsPath getPath(String path) {
        return new FsPath(new FsPath(this.config.getSrm_root()), new FsPath(path));
    }

    private FsPath getPath(URI surl) throws SRMInvalidPathException {
        return this.getPath(this.getPathOfSurl(surl));
    }

    private String getPathOfSurl(URI surl) throws SRMInvalidPathException {
        try {
            int i;
            String scheme = surl.getScheme();
            if (scheme != null && !scheme.equalsIgnoreCase("srm")) {
                throw new SRMInvalidPathException("Invalid scheme: " + scheme);
            }
            String host = surl.getHost();
            if (host != null && !Tools.sameHost((Set)this.config.getSrmHosts(), (String)host)) {
                throw new SRMInvalidPathException("SURL is not local: " + surl);
            }
            String path = surl.getPath();
            String query = surl.getQuery();
            if (query != null && (i = query.indexOf(SFN_STRING)) != -1) {
                path = query.substring(i + SFN_STRING.length());
            }
            return path;
        }
        catch (UnknownHostException e) {
            throw new SRMInvalidPathException(e.getMessage());
        }
    }

    private class VerboseListPrinter
    extends FmdListPrinter {
        private static final int PIPELINE_DEPTH = 40;
        private final Semaphore _available;
        private final Set<FileAttribute> _required;

        public VerboseListPrinter() {
            this._available = new Semaphore(40);
            this._required = DcacheFileMetaData.getKnownAttributes();
            this._required.addAll(PoolMonitorV5.getRequiredAttributesForFileLocality());
        }

        @Override
        public Set<FileAttribute> getRequiredAttributes() {
            return this._required;
        }

        @Override
        protected DcacheFileMetaData toFmd(FsPath dir, DirectoryEntry entry) throws InterruptedException {
            DcacheFileMetaData fmd = super.toFmd(dir, entry);
            if (!fmd.isDirectory) {
                this.lookupLocality(entry.getFileAttributes(), fmd);
                this.lookupTokens(entry.getFileAttributes(), fmd);
            }
            return fmd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<FileMetaData> getResult() throws InterruptedException {
            this._available.acquire(40);
            try {
                List list = this._result;
                return list;
            }
            finally {
                this._available.release(40);
            }
        }

        private void lookupLocality(FileAttributes attributes, DcacheFileMetaData fmd) throws InterruptedException {
            FileLocality locality = Storage.this._poolMonitor.getFileLocality(attributes, Storage.this.config.getSrmHost());
            fmd.locality = locality.toTFileLocality();
            switch (locality) {
                case ONLINE: 
                case ONLINE_AND_NEARLINE: {
                    fmd.isCached = true;
                }
            }
        }

        private void lookupTokens(FileAttributes attributes, final DcacheFileMetaData fmd) throws InterruptedException {
            this._available.acquire();
            Storage.this._spaceManagerStub.send(new GetFileSpaceTokensMessage(attributes.getPnfsId()), GetFileSpaceTokensMessage.class, new AbstractMessageCallback<GetFileSpaceTokensMessage>(){

                @Override
                public void success(GetFileSpaceTokensMessage message) {
                    VerboseListPrinter.this._available.release();
                    fmd.spaceTokens = message.getSpaceTokens();
                }

                @Override
                public void failure(int rc, Object error) {
                    VerboseListPrinter.this._available.release();
                    _log.error("Locality lookup failed: {} [{}]", error, (Object)rc);
                }
            });
        }
    }

    private class FmdListPrinter
    implements DirectoryListPrinter {
        protected final List<FileMetaData> _result = new ArrayList<FileMetaData>();
        protected final FsPath _root = new FsPath(Storage.access$400(Storage.this).getSrm_root());

        private FmdListPrinter() {
        }

        @Override
        public Set<FileAttribute> getRequiredAttributes() {
            return EnumSet.of(FileAttribute.SIZE, FileAttribute.SIMPLE_TYPE);
        }

        protected DcacheFileMetaData toFmd(FsPath dir, DirectoryEntry entry) throws InterruptedException {
            FileAttributes attributes = entry.getFileAttributes();
            DcacheFileMetaData fmd = new DcacheFileMetaData(attributes);
            fmd.SURL = this._root.relativize(new FsPath(dir, entry.getName())).toString();
            return fmd;
        }

        @Override
        public void print(FsPath dir, FileAttributes dirAttr, DirectoryEntry entry) throws InterruptedException {
            this._result.add(this.toFmd(dir, entry));
        }

        public List<FileMetaData> getResult() throws InterruptedException {
            return this._result;
        }
    }

    private static class TransferInfo {
        final long transferId;
        final Long remoteCredentialId;
        final CopyCallbacks callbacks;
        final CellPath cellPath;

        public TransferInfo(long transferId, Long remoteCredentialId, CopyCallbacks callbacks, CellPath cellPath) {
            this.transferId = transferId;
            this.remoteCredentialId = remoteCredentialId;
            this.callbacks = callbacks;
            this.cellPath = cellPath;
        }
    }

    private static final class HostnameCacheRecord {
        private String hostname;
        private long creationTime;

        public HostnameCacheRecord(String hostname) {
            this.hostname = hostname;
            this.creationTime = System.currentTimeMillis();
        }

        public String getHostname() {
            return this.hostname;
        }

        public boolean expired() {
            return System.currentTimeMillis() - this.creationTime > 600000L;
        }
    }
}

