/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.srm.dcache;

import diskCacheV111.srm.dcache.DcacheFileMetaData;
import diskCacheV111.util.FsPath;
import diskCacheV111.vehicles.PnfsCreateDirectoryMessage;
import diskCacheV111.vehicles.PnfsDeleteEntryMessage;
import diskCacheV111.vehicles.PnfsGetFileMetaDataMessage;
import diskCacheV111.vehicles.PnfsGetStorageInfoMessage;
import diskCacheV111.vehicles.PnfsMapPathMessage;
import diskCacheV111.vehicles.PnfsMessage;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.dcache.acl.enums.AccessType;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.cells.ThreadManagerMessageCallback;
import org.dcache.namespace.FileType;
import org.dcache.namespace.PermissionHandler;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.PrepareToPutCallbacks;
import org.dcache.srm.util.OneToManyMap;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PutCompanion
extends AbstractMessageCallback<PnfsMessage> {
    private static final Logger _log = LoggerFactory.getLogger(PutCompanion.class);
    public static final long PNFS_TIMEOUT = TimeUnit.MINUTES.toMillis(3L);
    private volatile State state = State.INITIAL_STATE;
    private CellStub pnfsStub;
    private PrepareToPutCallbacks callbacks;
    private String path;
    private boolean recursive_directory_creation;
    private List<String> pathItems = null;
    private int current_dir_depth = -1;
    private AuthorizationRecord user;
    private Subject userSubject;
    private boolean overwrite;
    private String fileId;
    private FileMetaData fileFMD;
    private long creationTime;
    private long lastOperationTime = this.creationTime = System.currentTimeMillis();
    private PermissionHandler permissionHandler;
    private static final Map<String, PutCompanion> directoryCreators = new HashMap<String, PutCompanion>();
    private OneToManyMap waitingForCreators = new OneToManyMap();

    private PutCompanion(AuthorizationRecord user, Subject userSubject, PermissionHandler permissionHandler, String path, PrepareToPutCallbacks callbacks, CellStub pnfsStub, boolean recursive_directory_creation, boolean overwrite) {
        this.user = user;
        this.userSubject = userSubject;
        this.permissionHandler = permissionHandler;
        this.path = path;
        this.pnfsStub = pnfsStub;
        this.callbacks = callbacks;
        this.recursive_directory_creation = recursive_directory_creation;
        this.overwrite = overwrite;
        this.pathItems = new FsPath(path).getPathItemsList();
        _log.debug(" constructor path = " + path + " overwrite=" + overwrite);
    }

    @Override
    public void success(PnfsMessage message) {
        if (message instanceof PnfsCreateDirectoryMessage) {
            PnfsCreateDirectoryMessage response = (PnfsCreateDirectoryMessage)message;
            if (this.state == State.WAITING_FOR_CREATE_DIRECTORY_RESPONSE_MESSAGE) {
                this.state = State.RECEIVED_CREATE_DIRECTORY_RESPONSE_MESSAGE;
                this.directoryInfoArrived(response);
            } else {
                _log.warn(" {}  : unexpected PnfsCreateDirectoryMessage : {} , Ignoring", (Object)this.toString(), (Object)message);
            }
        } else if (message instanceof PnfsMapPathMessage) {
            PnfsMapPathMessage response = (PnfsMapPathMessage)message;
            if (this.state == State.WAITING_FOR_FILE_INFO_MESSAGE) {
                this.state = State.RECEIVED_FILE_INFO_MESSAGE;
                this.fileExists(response);
            } else {
                _log.warn(" {}  : unexpected PnfsMapPathMessage : {} , Ignoring", (Object)this.toString(), (Object)message);
            }
        } else if (message instanceof PnfsGetStorageInfoMessage) {
            PnfsGetStorageInfoMessage response = (PnfsGetStorageInfoMessage)message;
            if (this.state == State.WAITING_FOR_DIRECTORY_INFO_MESSAGE) {
                this.state = State.RECEIVED_DIRECTORY_INFO_MESSAGE;
                this.directoryInfoArrived(response);
            } else {
                _log.warn(" {}  : unexpected PnfsGetStorageInfoMessage : {} , Ignoring", (Object)this.toString(), (Object)message);
            }
        } else if (message instanceof PnfsGetFileMetaDataMessage) {
            PnfsGetFileMetaDataMessage response = (PnfsGetFileMetaDataMessage)message;
            if (this.state == State.WAITING_FOR_DIRECTORY_INFO_MESSAGE) {
                this.state = State.RECEIVED_DIRECTORY_INFO_MESSAGE;
                this.directoryInfoArrived(response);
            } else {
                _log.warn(" {}  : unexpected PnfsGetFileMetaDataMessage : {} , Ignoring", (Object)this.toString(), (Object)message);
            }
        } else if (message instanceof PnfsDeleteEntryMessage) {
            if (this.state == State.WAITING_FOR_FILE_DELETE_RESPONSE_MESSAGE) {
                this.state = State.RECEIVED_FILE_DELETE_RESPONSE_MESSAGE;
                this.askPnfsForParentInfo();
            } else {
                _log.warn(" {}  : unexpected  PnfsDeleteEntryMessage : {} , Ignoring", (Object)this.toString(), (Object)message);
            }
        } else {
            _log.warn(" {}  : unexpected Message : {} , Ignoring", (Object)this.toString(), (Object)message);
        }
    }

    @Override
    public void failure(int rc, Object error) {
        String errorString = error.toString();
        if (_log.isDebugEnabled()) {
            _log.debug("PutCompanion.failure() {}, rc={} error={}", new Object[]{this.toString(), rc, errorString});
        }
        if (this.state == State.WAITING_FOR_CREATE_DIRECTORY_RESPONSE_MESSAGE) {
            this.state = State.RECEIVED_CREATE_DIRECTORY_RESPONSE_MESSAGE;
            errorString = "directory creation failed: " + this.getCurrentDirPath() + " reason: " + error;
            this.unregisterAndFailCreator(errorString);
        } else if (this.state == State.WAITING_FOR_FILE_INFO_MESSAGE) {
            this.state = State.RECEIVED_FILE_INFO_MESSAGE;
            if (rc == 10001) {
                this.current_dir_depth = this.pathItems.size();
            }
        } else if (this.state == State.WAITING_FOR_DIRECTORY_INFO_MESSAGE) {
            this.state = State.RECEIVED_DIRECTORY_INFO_MESSAGE;
            if (rc != 10001 || !this.recursive_directory_creation) {
                this.unregisterAndFailCreator(error.toString());
            }
        } else if (this.state == State.WAITING_FOR_FILE_DELETE_RESPONSE_MESSAGE) {
            this.state = State.RECEIVED_FILE_DELETE_RESPONSE_MESSAGE;
        }
        switch (rc) {
            case 10018: {
                this.callbacks.AuthorizationError(errorString);
                break;
            }
            case 10001: {
                if (this.state != State.RECEIVED_FILE_INFO_MESSAGE && this.state != State.RECEIVED_FILE_DELETE_RESPONSE_MESSAGE && this.state != State.RECEIVED_DIRECTORY_INFO_MESSAGE) break;
                this.askPnfsForParentInfo();
                break;
            }
            case 10015: {
                if (this.state == State.RECEIVED_FILE_DELETE_RESPONSE_MESSAGE) {
                    errorString = "Destination is not a file";
                }
                this.callbacks.InvalidPathError(errorString);
                break;
            }
            case 10006: {
                this.callbacks.Timeout();
                break;
            }
            default: {
                if (this.state == State.RECEIVED_DIRECTORY_INFO_MESSAGE) {
                    this.callbacks.GetStorageInfoFailed("GetStorageInfoFailed PnfsGetStorageInfoMessage.getReturnCode () != 0 => parrent directory does not exist");
                    break;
                }
                this.callbacks.Error(errorString);
            }
        }
    }

    public void noroute() {
        _log.error(this.toString() + " No Route to PnfsManager");
        this.unregisterAndFailCreator("No Route to PnfsManager");
        this.callbacks.Error("No Route to PnfsManager");
    }

    public void timeout() {
        _log.error(this.toString() + " PnfsManager request Timed Out");
        this.unregisterAndFailCreator("PnfsManager request Timed Out");
        this.callbacks.Timeout();
    }

    private void fileExists(PnfsMapPathMessage message) {
        if (!this.overwrite) {
            String errorString = String.format("file/directory %s exists, overwite is not allowed ", this.path);
            _log.debug(errorString);
            this.callbacks.DuplicationError(errorString);
            return;
        }
        this.state = State.WAITING_FOR_FILE_DELETE_RESPONSE_MESSAGE;
        PnfsDeleteEntryMessage deleteMessage = new PnfsDeleteEntryMessage(message.getPnfsId(), EnumSet.of(FileType.LINK, FileType.REGULAR));
        deleteMessage.setSubject(this.userSubject);
        this.pnfsStub.send(deleteMessage, PnfsDeleteEntryMessage.class, new ThreadManagerMessageCallback<PnfsMessage>(this));
        this.current_dir_depth = this.pathItems.size();
    }

    public void directoryInfoArrived(PnfsGetFileMetaDataMessage metadata_msg) {
        try {
            this.unregisterCreator(metadata_msg);
            FileAttributes attributes = metadata_msg.getFileAttributes();
            attributes.setPnfsId(metadata_msg.getPnfsId());
            if (attributes.getFileType() != FileType.DIR) {
                String error = "file " + metadata_msg.getPnfsPath() + " is not a directory";
                this.unregisterAndFailCreator(error);
                this.callbacks.InvalidPathError(error);
                return;
            }
            DcacheFileMetaData srm_dirFmd = new DcacheFileMetaData(attributes);
            if (this.pathItems.size() - 1 > this.current_dir_depth) {
                AccessType canCreateSubDir = this.permissionHandler.canCreateSubDir(this.userSubject, attributes);
                if (canCreateSubDir == AccessType.ACCESS_ALLOWED) {
                    this.createNextDirectory(srm_dirFmd);
                    return;
                }
                String error = "path does not exist and user has no permissions to create it";
                _log.warn(error);
                this.unregisterAndFailCreator(error);
                this.callbacks.InvalidPathError(error);
                return;
            }
            AccessType canCreateFile = this.permissionHandler.canCreateFile(this.userSubject, attributes);
            if (canCreateFile != AccessType.ACCESS_ALLOWED) {
                String error = "user has no permission to create file " + this.getCurrentDirPath();
                _log.warn(error.toString());
                this.callbacks.AuthorizationError(error);
                return;
            }
            this.callbacks.StorageInfoArrived(this.fileId, this.fileFMD, srm_dirFmd.fileId, (FileMetaData)srm_dirFmd);
            return;
        }
        catch (RuntimeException re) {
            _log.error(re.toString(), (Throwable)re);
            throw re;
        }
    }

    private void createNextDirectory(FileMetaData parentFmd) {
        ++this.current_dir_depth;
        String newDirPath = this.getCurrentDirPath();
        int uid = this.user.getUid();
        int gid = this.user.getGid();
        int perm = 493;
        if (parentFmd != null) {
            uid = Integer.parseInt(parentFmd.owner);
            gid = Integer.parseInt(parentFmd.group);
            perm = parentFmd.permMode;
        }
        _log.info("attempting to create " + newDirPath + " with uid=" + uid + " gid=" + gid);
        PnfsCreateDirectoryMessage dirMsg = new PnfsCreateDirectoryMessage(newDirPath, uid, gid, perm, this.permissionHandler.getRequiredAttributes());
        this.state = State.WAITING_FOR_CREATE_DIRECTORY_RESPONSE_MESSAGE;
        dirMsg.setReplyRequired(true);
        try {
            this.pnfsStub.send(dirMsg, PnfsMessage.class, new ThreadManagerMessageCallback<PnfsMessage>(this));
        }
        catch (Exception ee) {
            _log.error(ee.toString());
            this.callbacks.Exception(ee);
        }
        this.lastOperationTime = System.currentTimeMillis();
    }

    private String getCurrentDirPath() {
        if (this.pathItems != null) {
            return FsPath.toString(this.pathItems.subList(0, this.current_dir_depth));
        }
        return "";
    }

    private String getCurrentDirPath(int i) {
        if (this.pathItems != null) {
            return FsPath.toString(this.pathItems.subList(0, i));
        }
        return "";
    }

    private void askPnfsForParentInfo() {
        if (this.current_dir_depth < 1) {
            String error = "we reached the root of the directories, none of the elements exist from the pnfs manager point of view, we do not have permission to create this directory tree: " + this.path;
            this.unregisterAndFailCreator(error);
            this.callbacks.AuthorizationError(error);
            return;
        }
        --this.current_dir_depth;
        String directory = this.getCurrentDirPath();
        if (!PutCompanion.registerCreatorOrWaitForCreation(directory, this)) {
            this.state = State.PASSIVELY_WAITING_FOR_DIRECTORY_INFO_MESSAGE;
            this.lastOperationTime = System.currentTimeMillis();
            return;
        }
        PnfsGetFileMetaDataMessage metadataMsg = this.current_dir_depth == this.pathItems.size() - 1 ? new PnfsGetStorageInfoMessage(this.permissionHandler.getRequiredAttributes()) : new PnfsGetFileMetaDataMessage(this.permissionHandler.getRequiredAttributes());
        metadataMsg.setPnfsPath(directory);
        this.state = State.WAITING_FOR_DIRECTORY_INFO_MESSAGE;
        this.pnfsStub.send(metadataMsg, PnfsMessage.class, new ThreadManagerMessageCallback<PnfsMessage>(this));
        this.lastOperationTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, false);
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void toString(StringBuilder sb, boolean longFormat) {
        sb.append("PutCompanion: ");
        sb.append(" p=\"").append(this.path);
        sb.append("\" s=\"").append(this.getStateString());
        sb.append("\" d=\"").append(this.current_dir_depth);
        sb.append("\" created:").append(new Date(this.creationTime));
        sb.append("\" lastOperation:").append(new Date(this.lastOperationTime));
        if (this.state != State.WAITING_FOR_DIRECTORY_INFO_MESSAGE) {
            if (this.state != State.WAITING_FOR_CREATE_DIRECTORY_RESPONSE_MESSAGE) return;
        }
        try {
            int i = this.current_dir_depth;
            while (i < this.pathItems.size()) {
                String pnfsPath = this.getCurrentDirPath(i);
                sb.append("\n it is creating/getting info for path=");
                sb.append(pnfsPath);
                Set waitingSet = this.waitingForCreators.getValues((Object)pnfsPath);
                if (waitingSet != null) {
                    if (longFormat) {
                        for (PutCompanion waitingCompanion : waitingSet) {
                            sb.append("\n waiting companion:");
                            waitingCompanion.toString(sb, true);
                        }
                    } else {
                        sb.append(" num of waiting companions:");
                        sb.append(waitingSet.size());
                    }
                } else {
                    sb.append(" num of waiting companions: 0");
                }
                ++i;
            }
            return;
        }
        catch (Exception e) {
            sb.append("listing error: ").append(e);
        }
    }

    private String getStateString() {
        return this.state.toString();
    }

    public static void PrepareToPutFile(AuthorizationRecord user, PermissionHandler permissionHandler, String path, PrepareToPutCallbacks callbacks, CellStub pnfsStub, boolean recursive_directory_creation, boolean overwrite) {
        if (user == null) {
            callbacks.AuthorizationError("user unknown, can not write");
            return;
        }
        FsPath pnfsPathFile = new FsPath(path);
        String pnfsPath = pnfsPathFile.toString();
        if (pnfsPath == null) {
            throw new IllegalArgumentException(" FileRequest does not specify path!!!");
        }
        PnfsMapPathMessage message = new PnfsMapPathMessage(pnfsPath);
        Subject userSubject = user.toSubject();
        message.setSubject(userSubject);
        PutCompanion companion = new PutCompanion(user, userSubject, permissionHandler, path, callbacks, pnfsStub, recursive_directory_creation, overwrite);
        _log.debug("sending " + message + " to PnfsManager");
        companion.state = State.WAITING_FOR_FILE_INFO_MESSAGE;
        pnfsStub.send(message, PnfsMapPathMessage.class, new ThreadManagerMessageCallback<PnfsMessage>(companion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThisFromDirectoryCreators() {
        Map<String, PutCompanion> map = directoryCreators;
        synchronized (map) {
            Iterator<PutCompanion> i = directoryCreators.values().iterator();
            while (i.hasNext()) {
                if (this != i.next()) continue;
                i.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void listDirectoriesWaitingForCreation(StringBuilder sb, boolean longformat) {
        Map<String, PutCompanion> map = directoryCreators;
        synchronized (map) {
            for (Map.Entry<String, PutCompanion> entry : directoryCreators.entrySet()) {
                String directory = entry.getKey();
                PutCompanion companion = entry.getValue();
                sb.append("directorty: ").append(directory).append('\n');
                sb.append("\n creating/getting info companion:");
                companion.toString(sb, longformat);
            }
        }
    }

    public static void failCreatorsForPath(String pnfsPath, StringBuilder sb) {
        PutCompanion creatorCompanion = directoryCreators.get(pnfsPath);
        if (creatorCompanion == null) {
            sb.append("no creators for path ").append(pnfsPath).append("found");
            return;
        }
        creatorCompanion.unregisterAndFailCreator("canceled by the admin command");
        sb.append("Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean registerCreatorOrWaitForCreation(String pnfsPath, PutCompanion thisCreator) {
        PutCompanion creatorCompanion;
        long creater_operTime = 0L;
        long currentTime = 0L;
        Map<String, PutCompanion> map = directoryCreators;
        synchronized (map) {
            if (!directoryCreators.containsKey(pnfsPath)) {
                _log.debug("registerCreatorOrWaitForCreation(" + pnfsPath + "," + thisCreator + ")" + " storing this creator");
                directoryCreators.put(pnfsPath, thisCreator);
                return true;
            }
            creatorCompanion = directoryCreators.get(pnfsPath);
            creatorCompanion.waitingForCreators.put((Object)pnfsPath, (Object)thisCreator);
            _log.debug("registerCreatorOrWaitForCreation(" + pnfsPath + "," + thisCreator + ")" + " directoryCreators already contains the creator for the path," + " store and return false");
            creater_operTime = creatorCompanion.lastOperationTime;
            currentTime = System.currentTimeMillis();
        }
        if (currentTime - creater_operTime > PNFS_TIMEOUT) {
            creatorCompanion.unregisterAndFailCreator("pnfs manager timeout");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregisterCreator(String pnfsPath, PutCompanion thisCreator, PnfsGetFileMetaDataMessage message) {
        HashSet<PutCompanion> removed = new HashSet<PutCompanion>();
        Map<String, PutCompanion> map = directoryCreators;
        synchronized (map) {
            if (directoryCreators.containsValue(thisCreator)) {
                _log.debug("unregisterCreator(" + pnfsPath + "," + thisCreator + ")");
                directoryCreators.remove(pnfsPath);
            }
            while (thisCreator.waitingForCreators.containsKey((Object)pnfsPath)) {
                PutCompanion o = (PutCompanion)thisCreator.waitingForCreators.remove((Object)pnfsPath);
                _log.debug("unregisterCreator(" + pnfsPath + "," + thisCreator + ") removing " + o);
                removed.add(o);
            }
        }
        for (PutCompanion waitingcompanion : removed) {
            _log.debug("  unregisterCreator(" + pnfsPath + "," + thisCreator + ") notifying " + waitingcompanion);
            waitingcompanion.directoryInfoArrived(message);
        }
        _log.debug(" unregisterCreator(" + pnfsPath + "," + thisCreator + ") returning");
    }

    private void unregisterCreator(PnfsGetFileMetaDataMessage message) {
        PutCompanion.unregisterCreator(this.getCurrentDirPath(), this, message);
    }

    private void unregisterAndFailCreator(String error) {
        if (this.pathItems != null && this.current_dir_depth != -1) {
            for (int i = this.current_dir_depth; i < this.pathItems.size(); ++i) {
                String pnfsPath = this.getCurrentDirPath(i);
                PutCompanion.unregisterAndFailCreator(pnfsPath, this, error);
            }
        } else {
            this.callbacks.Error(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregisterAndFailCreator(String pnfsPath, PutCompanion thisCreator, String error) {
        HashSet<PutCompanion> removed = new HashSet<PutCompanion>();
        Map<String, PutCompanion> map = directoryCreators;
        synchronized (map) {
            if (directoryCreators.containsValue(thisCreator)) {
                _log.debug(" unregisterAndFailCreator(" + pnfsPath + "," + thisCreator + ")");
                directoryCreators.remove(pnfsPath);
            }
            while (thisCreator.waitingForCreators.containsKey((Object)pnfsPath)) {
                PutCompanion o = (PutCompanion)thisCreator.waitingForCreators.remove((Object)pnfsPath);
                _log.debug("  unregisterAndFailCreator(" + pnfsPath + "," + thisCreator + ") removing " + o);
                removed.add(o);
            }
        }
        for (PutCompanion waitingcompanion : removed) {
            _log.debug(" unregisterAndFailCreator(" + pnfsPath + "," + thisCreator + ") notifying " + waitingcompanion);
            waitingcompanion.callbacks.Error(error);
        }
        _log.debug(" unregisterAndFailCreator(" + pnfsPath + "," + thisCreator + ") returning");
    }

    public static enum State {
        INITIAL_STATE,
        WAITING_FOR_FILE_INFO_MESSAGE,
        RECEIVED_FILE_INFO_MESSAGE,
        WAITING_FOR_DIRECTORY_INFO_MESSAGE,
        RECEIVED_DIRECTORY_INFO_MESSAGE,
        WAITING_FOR_CREATE_DIRECTORY_RESPONSE_MESSAGE,
        RECEIVED_CREATE_DIRECTORY_RESPONSE_MESSAGE,
        WAITING_FOR_FILE_DELETE_RESPONSE_MESSAGE,
        RECEIVED_FILE_DELETE_RESPONSE_MESSAGE,
        FINAL_STATE,
        PASSIVELY_WAITING_FOR_DIRECTORY_INFO_MESSAGE;

    }
}

