/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.srm.dcache;

import diskCacheV111.util.CacheException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import javax.security.auth.Subject;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.auth.Group;
import org.dcache.auth.GroupList;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.LoginStrategy;
import org.dcache.auth.Origin;
import org.dcache.auth.UserAuthRecord;
import org.dcache.auth.persistence.AuthRecordPersistenceManager;
import org.dcache.srm.SRMAuthorization;
import org.dcache.srm.SRMAuthorizationException;
import org.dcache.srm.SRMUser;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DCacheAuthorization
implements SRMAuthorization {
    static Random random = new Random();
    private static Logger _logAuth = LoggerFactory.getLogger(DCacheAuthorization.class);
    private static Map UsernameMap = new HashMap();
    private long cache_lifetime = 0L;
    private AuthRecordPersistenceManager authRecordPersistenceManager;
    private final LoginStrategy loginStrategy;

    public DCacheAuthorization(LoginStrategy loginStrategy, AuthRecordPersistenceManager authRecordPersistenceManager) {
        this.loginStrategy = loginStrategy;
        this.authRecordPersistenceManager = authRecordPersistenceManager;
    }

    public SRMUser authorize(Long requestCredentialId, String secureId, String name, GSSContext gsscontext, String remoteIP) throws SRMAuthorizationException {
        AuthorizationRecord user_rec = null;
        if (_logAuth.isDebugEnabled()) {
            _logAuth.debug("authorize " + requestCredentialId + ":" + secureId + ":" + name + ":");
        }
        if (this.cache_lifetime > 0L) {
            if (_logAuth.isDebugEnabled()) {
                _logAuth.debug("getting user mapping");
            }
            TimedAuthorizationRecord tUserRec = this.getUsernameMapping(requestCredentialId);
            if (_logAuth.isDebugEnabled()) {
                if (tUserRec != null) {
                    AuthorizationRecord userRec = tUserRec.user_rec;
                    if (userRec != null) {
                        _logAuth.debug("cached tUserRec = " + userRec);
                    } else {
                        _logAuth.debug("cached tUserRec = null ");
                    }
                } else {
                    _logAuth.debug("cached tUserRec = null ");
                }
            }
            if (tUserRec != null && tUserRec.age() < this.cache_lifetime && tUserRec.sameDesiredUserName(name)) {
                user_rec = tUserRec.getAuthorizationRecord();
            }
        }
        if (user_rec == null) {
            user_rec = this.authorize(secureId, gsscontext, name, remoteIP);
            AuthorizationRecord persistent = null;
            long id = user_rec.getId();
            do {
                user_rec.setId(id++);
            } while ((persistent = this.authRecordPersistenceManager.find(user_rec.getId())) != null && !persistent.equals(user_rec));
            if (persistent == null) {
                _logAuth.debug("auth object not found in database, persisting ");
                persistent = this.authRecordPersistenceManager.persist(user_rec);
                if (!persistent.equals(user_rec)) {
                    _logAuth.error("Persisted authorization record is different from the original");
                }
            }
            if (this.cache_lifetime > 0L) {
                this.putUsernameMapping(requestCredentialId, new TimedAuthorizationRecord(user_rec, name));
            }
        }
        if (user_rec == null) {
            throw new SRMAuthorizationException("username is null");
        }
        return user_rec;
    }

    private AuthorizationRecord authorize(String secureId, GSSContext serviceContext, String name, String remoteIP) throws SRMAuthorizationException {
        try {
            if (!(serviceContext instanceof ExtendedGSSContext)) {
                throw new RuntimeException("GSSContext not instance of ExtendedGSSContext");
            }
            ExtendedGSSContext extendedcontext = (ExtendedGSSContext)serviceContext;
            X509Certificate[] chain = (X509Certificate[])extendedcontext.inquireByOid(GSSConstants.X509_CERT_CHAIN);
            Subject subject = new Subject();
            if (name != null && !name.isEmpty()) {
                subject.getPrincipals().add((Principal)new LoginNamePrincipal(name));
            }
            if (secureId != null && !secureId.isEmpty()) {
                subject.getPrincipals().add((Principal)new GlobusPrincipal(secureId));
            }
            subject.getPublicCredentials().add(chain);
            try {
                InetAddress remoteOrigin = InetAddress.getByName(remoteIP);
                subject.getPrincipals().add((Principal)new Origin(Origin.AuthType.ORIGIN_AUTHTYPE_STRONG, remoteOrigin));
                _logAuth.debug("User connected from the following IP, setting as origin: {}.", (Object)remoteIP);
            }
            catch (UnknownHostException uhex) {
                _logAuth.info("Could not add the remote-IP {} as an origin principal.", (Object)remoteIP);
            }
            AuthorizationRecord authRecord = new AuthorizationRecord(this.loginStrategy.login(subject));
            return authRecord;
        }
        catch (GSSException e) {
            throw new SRMAuthorizationException(e.getMessage(), (Throwable)e);
        }
        catch (CacheException e) {
            throw new SRMAuthorizationException(e.getMessage(), (Throwable)e);
        }
    }

    public void setCacheLifetime(String lifetime_str) {
        if (lifetime_str == null || lifetime_str.length() == 0) {
            return;
        }
        try {
            this.setCacheLifetime(Long.decode(lifetime_str) * 1000L);
        }
        catch (NumberFormatException nfe) {
            _logAuth.error("Could not format cache lifetime=" + lifetime_str + " as long integer.");
        }
    }

    public void setCacheLifetime(long lifetime) {
        this.cache_lifetime = lifetime;
    }

    private synchronized void putUsernameMapping(Object key, TimedAuthorizationRecord tUserRec) {
        UsernameMap.put(key, tUserRec);
    }

    private synchronized TimedAuthorizationRecord getUsernameMapping(Object key) {
        return (TimedAuthorizationRecord)UsernameMap.get(key);
    }

    public static AuthorizationRecord convertLegacyToNewAuthRec(UserAuthRecord legacyAuthRec) {
        int[] GIDs;
        AuthorizationRecord authRec = new AuthorizationRecord();
        authRec.setId(random.nextLong());
        authRec.setIdentity(legacyAuthRec.Username);
        authRec.setName(legacyAuthRec.DN);
        authRec.setUid(legacyAuthRec.UID);
        authRec.setPriority(legacyAuthRec.priority);
        authRec.setHome(legacyAuthRec.Home);
        authRec.setRoot(legacyAuthRec.Root);
        authRec.setReadOnly(legacyAuthRec.ReadOnly);
        LinkedList<GroupList> grplistcoll = new LinkedList<GroupList>();
        GroupList grplist = new GroupList();
        LinkedList<Group> grpcoll = new LinkedList<Group>();
        for (int gid : GIDs = legacyAuthRec.GIDs) {
            Group grp = new Group();
            grp.setGroupList(grplist);
            grp.setGid(gid);
            grpcoll.add(grp);
        }
        grplist.setGroups(grpcoll);
        grplist.setAttribute(legacyAuthRec.getFqan().toString());
        grplist.setAuthRecord(authRec);
        grplistcoll.add(grplist);
        authRec.setGroupLists(grplistcoll);
        return authRec;
    }

    private class TimedAuthorizationRecord {
        AuthorizationRecord user_rec;
        long timestamp;
        String desiredUserName = null;

        TimedAuthorizationRecord(AuthorizationRecord user_rec) {
            this.user_rec = user_rec;
            this.timestamp = System.currentTimeMillis();
        }

        TimedAuthorizationRecord(AuthorizationRecord user_rec, String desiredUserName) {
            this(user_rec);
            this.desiredUserName = desiredUserName;
        }

        private AuthorizationRecord getAuthorizationRecord() {
            return this.user_rec;
        }

        private long age() {
            return System.currentTimeMillis() - this.timestamp;
        }

        private boolean sameDesiredUserName(String requestDesiredUserName) {
            if (this.desiredUserName == null && requestDesiredUserName == null) {
                return true;
            }
            if (this.desiredUserName == null) {
                return false;
            }
            return this.desiredUserName.equals(requestDesiredUserName);
        }
    }
}

