/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.web;

import diskCacheV111.vehicles.RestoreHandlerInfo;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.util.Args;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPicturesV0
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(WebPicturesV0.class);
    private CellNucleus _nucleus = null;
    private Args _args = null;
    private Date _started = null;
    private long _sleep = 300000L;
    private final Object _sleeper = new Object();
    private boolean _simulation = false;
    private Point _actionPoint = null;
    private int _binCount = 40;
    private Dimension _dimension = new Dimension(400, 300);
    private Map<String, Object> _cellContext;
    private boolean _wasStarted = false;
    private Date _lastMessageArrived = null;
    private SimpleDateFormat _simpleFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private RestoreHandlerInfo[] _currentInfo = null;
    public String hh_start = " # start worker thread";
    public String hh_go = " # start data collection";
    private static BinScale[] _binDefinition = new BinScale[]{new BinScale(10L, 10, "s"), new BinScale(60L, 1, "m"), new BinScale(120L, 2, "m"), new BinScale(240L, 4, "m"), new BinScale(300L, 5, "m"), new BinScale(600L, 10, "m"), new BinScale(1800L, 30, "m"), new BinScale(3600L, 1, "h"), new BinScale(7200L, 2, "h"), new BinScale(14400L, 4, "h"), new BinScale(18000L, 5, "h"), new BinScale(43200L, 12, "h"), new BinScale(86400L, 1, "d"), new BinScale(172800L, 2, "d"), new BinScale(345600L, 4, "d"), new BinScale(604800L, 1, "w"), new BinScale(1209600L, 2, "w")};
    private static int[] _counterDefinition = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000};

    public WebPicturesV0(String name, String args) throws Exception {
        super(name, args, false);
        _log.info("WebPictures started");
        try {
            this._args = this.getArgs();
            this._nucleus = this.getNucleus();
            this._started = new Date();
            this._cellContext = this._nucleus.getDomainContext();
            System.setProperty("java.awt.headless", "true");
            String sizeRange = this._args.getOpt("imageSize");
            if (sizeRange != null) {
                try {
                    int ind = sizeRange.indexOf(":");
                    if (ind <= 0 || ind == sizeRange.length() - 1) {
                        throw new IllegalArgumentException("Not a size pair");
                    }
                    int low = Integer.parseInt(sizeRange.substring(0, ind));
                    int high = Integer.parseInt(sizeRange.substring(ind + 1));
                    this._dimension = new Dimension(low, high);
                }
                catch (NumberFormatException ee) {
                    _log.warn("Invalid size string (command ignored) : " + sizeRange);
                }
            }
            _log.info("Image size : " + this._dimension);
            String intervalString = this._args.getOpt("interval");
            if (intervalString != null) {
                try {
                    this._sleep = 1000L * (long)Integer.parseInt(intervalString);
                }
                catch (NumberFormatException ee) {
                    _log.warn("Invalid 'interval' string (command ignored) : " + intervalString);
                }
            }
            _log.info("Interval (msec) : " + this._sleep);
            if (this._args.hasOption("dontstart")) {
                _log.info("Worker Thread not started : -dontstart");
            } else {
                _log.info("Starting worker Thread");
                this._nucleus.newThread((Runnable)this, "Worker").start();
                this._wasStarted = true;
            }
        }
        catch (Exception ee) {
            this.start();
            this.kill();
            throw ee;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_start(Args args) {
        WebPicturesV0 webPicturesV0 = this;
        synchronized (webPicturesV0) {
            if (this._wasStarted) {
                throw new IllegalArgumentException("Thread already running");
            }
            this._wasStarted = true;
        }
        this._nucleus.newThread((Runnable)this, "Worker").start();
        return "Started";
    }

    public void getInfo(PrintWriter pw) {
        pw.println("   Cell Name : " + this.getCellName());
        pw.println("  Cell Class : " + this.getClass().getName());
        pw.println("     Version : $Id: WebPicturesV0.java,v 1.5 2005-07-19 11:02:10 patrick Exp $");
        pw.println("     Started : " + this._started);
        pw.println("     Sleep   : " + this._sleep);
        pw.println("Picture Size : " + this._dimension);
        pw.println("    Last Msg : " + this._lastMessageArrived);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        CellPath path = new CellPath("PoolManager");
        CellMessage msg = new CellMessage(path, (Object)"xrc ls");
        while (!thread.interrupted()) {
            try {
                _log.info("Sending query : " + msg);
                this.sendMessage(msg);
                this.createTransferPicture();
                this.createFrame();
                Object object = this._sleeper;
                synchronized (object) {
                    this._sleeper.wait(this._sleep);
                }
            }
            catch (InterruptedException ie) {
                _log.warn("Worker interrupted");
                break;
            }
            catch (Exception ee) {
                _log.warn("Exception in while loop : " + ee, (Throwable)ee);
                try {
                    Object object = this._sleeper;
                    synchronized (object) {
                        this._sleeper.wait(60000L);
                    }
                }
                catch (InterruptedException iee) {
                    _log.warn("Worker interrupted2");
                    break;
                }
            }
        }
    }

    public void messageArrived(CellMessage message) {
        Object obj = message.getMessageObject();
        if (obj instanceof RestoreHandlerInfo[]) {
            this._currentInfo = (RestoreHandlerInfo[])obj;
            _log.info("RestoreHandlerInfo [" + this._currentInfo.length + "]");
            this._lastMessageArrived = new Date();
            this.createRestorePictures();
            this.createFrame();
        } else {
            _log.warn("Unknown message type arrived : " + obj.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_go(Args args) throws Exception {
        Object object = this._sleeper;
        synchronized (object) {
            this._sleeper.notifyAll();
        }
        return "";
    }

    private void createFrame() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>\n").append("<head><title>dCache Queue Histograms</title></head>\n").append("<body bgcolor=black>\n");
        String[] histograms = new String[]{"RestoreQueueHistogram", "TransferHistogram0", "TransferHistogram1", "TransferHistogram2", "TransferHistogram3"};
        for (int i = 0; i < histograms.length; ++i) {
            String name = histograms[i];
            sb.append("<br><br><br><hr><br><br><br>");
            String date = (String)this._cellContext.get(name + ".date");
            Object pict = this._cellContext.get(name + ".png");
            if (date != null && pict != null) {
                sb.append("<center>\n").append("<h2><font color=white>").append(name).append(" ").append(date).append("</font></h2>\n").append("<img src=\"/pictures/").append(name).append(".png\">").append("</center>");
                continue;
            }
            sb.append("<center>\n").append("<h3><font color=white>").append(name).append(" not yet ready</font></h3>\n").append("</center>");
        }
        sb.append("<br><br><br><hr><address><font color=white>&copy; dCache.ORG ; last updated : ").append(new Date().toString()).append("</font></address>\n");
        sb.append("</body>\n</html>\n");
        this._cellContext.put("QueueHistograms.html", sb.toString());
    }

    private void createTransferPicture() {
        try {
            List list = this.scanTransferTable();
            this.createTransferPicture(list, "TransferHistogram0", 0L, this._dimension);
            this.createTransferPicture(list, "TransferHistogram1", 604800000L, this._dimension);
            this.createTransferPicture(list, "TransferHistogram2", 86400000L, this._dimension);
            this.createTransferPicture(list, "TransferHistogram3", 3600000L, this._dimension);
        }
        catch (IOException ee) {
            _log.warn("Exception in scanTransferTable : " + ee, (Throwable)ee);
            return;
        }
    }

    private void createTransferPicture(List list, String name, long maxSize, Dimension dimension) {
        BufferedImage image = new BufferedImage(this._dimension.width, this._dimension.height, 13);
        Graphics graphics = image.getGraphics();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            Histogram histogram = WebPicturesV0.prepareTransferHistogram(list, this._binCount, maxSize);
            WebPicturesV0.paintComponent(graphics, dimension, histogram, "Transfers " + this._simpleFormat.format(new Date()));
            ImageIO.write((RenderedImage)image, "png", outStream);
            outStream.flush();
            outStream.close();
        }
        catch (IOException ee) {
            _log.warn("Exception in writing createTransferPictures : " + ee, (Throwable)ee);
            return;
        }
        this._cellContext.put(name + ".png", outStream.toByteArray());
        this._cellContext.put(name + ".date", new Date().toString());
    }

    private void createRestorePictures() {
        BufferedImage image = new BufferedImage(this._dimension.width, this._dimension.height, 13);
        Graphics graphics = image.getGraphics();
        RestoreHandlerInfo[] info = this._currentInfo;
        if (info == null) {
            _log.warn("Histogram not yet ready");
        } else {
            Histogram histogram = this.prepareRestoreManagerHistogram(info, this._binCount);
            WebPicturesV0.paintComponent(graphics, this._dimension, histogram, "Restore " + this._simpleFormat.format(new Date()));
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", outStream);
            outStream.flush();
            outStream.close();
        }
        catch (IOException ee) {
            _log.warn("Exception in writing createRestorePictures : " + ee, (Throwable)ee);
            return;
        }
        this._cellContext.put("RestoreQueueHistogram.png", outStream.toByteArray());
        this._cellContext.put("RestoreQueueHistogram.date", new Date().toString());
    }

    private List scanTransferTable() throws IOException {
        String transferTable = (String)this._cellContext.get("transfers.txt");
        if (transferTable == null) {
            throw new NoSuchElementException("transfers.txt not found");
        }
        BufferedReader br = new BufferedReader(new StringReader(transferTable));
        return WebPicturesV0.scanTransferTable(br);
    }

    private static List scanTransferTable(BufferedReader br) throws IOException {
        ArrayList<long[]> list = new ArrayList<long[]>();
        String line = null;
        while ((line = br.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            try {
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                String status = st.nextToken();
                String time = st.nextToken();
                String mode = st.nextToken();
                long[] t = new long[]{Long.parseLong(time), 0L};
                if (status.equals("WaitingForDoorTransferOk") && mode.equals("No-Mover-Found")) {
                    t[1] = t[0];
                }
                list.add(t);
            }
            catch (NumberFormatException ii) {}
        }
        return list;
    }

    private static Histogram prepareTransferHistogram(List list, int binCount, long cut) {
        int masterPos;
        int pos;
        Histogram histogram = new Histogram();
        long maxTime = 0L;
        for (long[] t : list) {
            if (cut > 0L && t[0] > cut) continue;
            maxTime = Math.max(maxTime, t[0]);
        }
        long secPerBin = maxTime / (long)binCount / 1000L;
        int n = _binDefinition.length;
        for (pos = 0; pos < n && _binDefinition[pos].secondsPerBin <= secPerBin; ++pos) {
        }
        histogram._bin = WebPicturesV0._binDefinition[pos];
        secPerBin = _binDefinition[pos].secondsPerBin;
        int[] array = new int[binCount];
        int[] erray = new int[binCount];
        long largest = secPerBin * (long)binCount;
        for (long[] t : list) {
            if (cut > 0L && t[0] > cut) continue;
            long diff = Math.max(t[0], 0L) / 1000L;
            pos = (int)((float)diff / (float)largest * (float)(binCount - 1));
            int n2 = pos = Math.min(pos, binCount - 1);
            array[n2] = array[n2] + 1;
            if (t[1] == 0L) continue;
            int n3 = pos;
            erray[n3] = erray[n3] + 1;
        }
        int maxDisplayArray = 0;
        int n4 = array.length;
        for (int i = 0; i < n4; ++i) {
            maxDisplayArray = Math.max(maxDisplayArray, array[i]);
        }
        histogram._maxDisplayArray = maxDisplayArray;
        Histogram.access$502(histogram, array);
        Histogram.access$602(histogram, erray);
        int binsPerMasterBin = binCount / 4;
        long secondsPerMasterBin = (long)binsPerMasterBin * secPerBin;
        int n5 = _binDefinition.length;
        for (masterPos = 0; masterPos < n5 && _binDefinition[masterPos].secondsPerBin < secondsPerMasterBin; ++masterPos) {
        }
        masterPos = Math.max(masterPos - 1, 0);
        histogram._secondsPerMasterBin = _binDefinition[masterPos].secondsPerBin;
        histogram._masterBin = WebPicturesV0._binDefinition[masterPos];
        histogram._secondsPerBin = secPerBin;
        return histogram;
    }

    private Histogram prepareRestoreManagerHistogram(RestoreHandlerInfo[] info, int binCount) {
        return this.prepareRestoreManagerHistogram(info, binCount, 0);
    }

    private Histogram prepareRestoreManagerHistogram(RestoreHandlerInfo[] info, int binCount, int unit) {
        int masterPos;
        int pos;
        long now;
        Histogram histogram = new Histogram();
        long youngest = now = System.currentTimeMillis();
        int n = info.length;
        for (int i = 0; i < n; ++i) {
            RestoreHandlerInfo rhi = info[i];
            long start = rhi.getStartTime();
            youngest = Math.min(youngest, start);
        }
        long secPerBin = (now - youngest) / (long)binCount / 1000L;
        _log.info("secPerBin : " + secPerBin);
        int n2 = _binDefinition.length;
        for (pos = 0; pos < n2 && _binDefinition[pos].secondsPerBin <= secPerBin; ++pos) {
        }
        histogram._bin = WebPicturesV0._binDefinition[pos];
        secPerBin = _binDefinition[pos].secondsPerBin;
        _log.info("Seconds per bin (fixed) : " + _binDefinition[pos]);
        int[] array = new int[binCount];
        int[] erray = new int[binCount];
        long largest = secPerBin * (long)binCount;
        for (RestoreHandlerInfo rhi : info) {
            long diff = (now - rhi.getStartTime()) / 1000L;
            pos = (int)((float)diff / (float)largest * (float)(binCount - 1));
            int n3 = pos = Math.min(pos, binCount - 1);
            array[n3] = array[n3] + 1;
            if (rhi.getErrorCode() == 0) continue;
            int n4 = pos;
            erray[n4] = erray[n4] + 1;
        }
        int maxDisplayArray = 0;
        int n5 = array.length;
        for (int i = 0; i < n5; ++i) {
            maxDisplayArray = Math.max(maxDisplayArray, array[i]);
        }
        histogram._maxDisplayArray = maxDisplayArray;
        Histogram.access$502(histogram, array);
        Histogram.access$602(histogram, erray);
        int binsPerMasterBin = binCount / 4;
        long secondsPerMasterBin = (long)binsPerMasterBin * secPerBin;
        _log.info("secPerBin : " + secondsPerMasterBin);
        int n6 = _binDefinition.length;
        for (masterPos = 0; masterPos < n6 && _binDefinition[masterPos].secondsPerBin < secondsPerMasterBin; ++masterPos) {
        }
        masterPos = Math.max(masterPos - 1, 0);
        _log.info("Seconds per bin (fixed) : " + _binDefinition[masterPos]);
        histogram._secondsPerMasterBin = _binDefinition[masterPos].secondsPerBin;
        histogram._masterBin = WebPicturesV0._binDefinition[masterPos];
        histogram._secondsPerBin = secPerBin;
        return histogram;
    }

    public static void paintComponent(Graphics gin, Dimension d, Histogram histogram, String title) {
        int pos;
        Graphics2D g = (Graphics2D)gin;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.black);
        g.fillRect(0, 0, d.width - 1, d.height - 1);
        if (histogram == null) {
            return;
        }
        int fontSize = 12;
        g.setFont(new Font("Serif", 1, fontSize));
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getAscent() - fm.getDescent();
        int[] erray = histogram._displayErray;
        int[] array = histogram._displayArray;
        int maxDisplayArray = histogram._maxDisplayArray;
        int leftMargin = 20;
        int rightMargin = 5;
        int tickLength = 4;
        int topMargin = 40;
        int ybin = maxDisplayArray / 4;
        int n = _counterDefinition.length;
        for (pos = 0; pos < n && _counterDefinition[pos] < ybin; ++pos) {
        }
        pos = Math.max(0, pos - 1);
        ybin = _counterDefinition[pos];
        int maxXLabelPixel = fm.stringWidth("" + ybin * 4);
        int baseline = d.height - 10 - fontHeight - 2 - 4;
        int height = baseline - topMargin;
        int pixelsPerBin = (d.width - (leftMargin += maxXLabelPixel + 2 + 4) - rightMargin) / array.length - 1;
        int x = leftMargin;
        int i = 0;
        int n2 = array.length;
        while (i < n2) {
            int y = (int)((float)array[i] / (float)maxDisplayArray * (float)height);
            g.setColor(Color.green);
            g.fillRect(x, baseline - y, pixelsPerBin, y);
            if (erray[i] != 0) {
                y = (int)((float)erray[i] / (float)maxDisplayArray * (float)height);
                g.setColor(Color.red);
                g.fillRect(x, baseline - y, pixelsPerBin, y);
            }
            ++i;
            x += pixelsPerBin;
        }
        g.setColor(Color.white);
        g.drawLine(leftMargin - tickLength, baseline, leftMargin + array.length * pixelsPerBin, baseline);
        g.drawLine(leftMargin, baseline + tickLength, leftMargin, baseline - height - tickLength);
        int pixelsPerMasterBin = (int)((float)histogram._secondsPerMasterBin / (float)histogram._secondsPerBin * (float)pixelsPerBin);
        int unitCount = histogram._masterBin.unitCount;
        int i2 = 0;
        int n3 = array.length * pixelsPerBin;
        for (int xoffset = leftMargin + pixelsPerMasterBin; xoffset <= n3; xoffset += pixelsPerMasterBin) {
            g.drawLine(xoffset, baseline - tickLength, xoffset, baseline + tickLength);
            String label = "" + unitCount + " " + histogram._masterBin.unitName;
            unitCount += histogram._masterBin.unitCount;
            int stringWidth = fm.stringWidth(label);
            g.drawString(label, xoffset - stringWidth / 2, baseline + tickLength + 2 + fm.getAscent());
            ++i2;
        }
        int i3 = 0;
        for (int yoff = ybin; yoff < maxDisplayArray; yoff += ybin) {
            int y = (int)((float)yoff / (float)maxDisplayArray * (float)height);
            g.drawLine(leftMargin - tickLength, baseline - y, leftMargin + tickLength, baseline - y);
            String label = "" + yoff;
            g.drawString(label, leftMargin - tickLength - 2 - fm.stringWidth(label), baseline - y + fontHeight / 2);
            ++i3;
        }
        for (n3 = topMargin - 15; n3 > 0; n3 -= 5) {
            g.setFont(new Font("SanSerif", 3, n3));
            fm = g.getFontMetrics();
            int length = fm.stringWidth(title);
            if (length > d.width - 20) continue;
            g.drawString(title, (d.width - length) / 2, fm.getAscent() + 5);
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("Usage : <infile> <outfile> <title> <xsize> <ysize>");
            System.exit(4);
        }
        BufferedReader br = new BufferedReader(new FileReader(args[0]));
        Dimension dimension = new Dimension(400, 300);
        if (args.length > 3) {
            dimension = new Dimension(Integer.parseInt(args[3]), Integer.parseInt(args[4]));
        }
        List list = WebPicturesV0.scanTransferTable(br);
        Histogram histogram = WebPicturesV0.prepareTransferHistogram(list, 40, 0L);
        BufferedImage image = new BufferedImage(dimension.width, dimension.height, 13);
        Graphics graphics = image.getGraphics();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WebPicturesV0.paintComponent(graphics, dimension, histogram, args[2]);
        ImageIO.write((RenderedImage)image, "png", new File(args[1]));
    }

    private static class BinScale {
        private long secondsPerBin = 0L;
        private int unitCount = 0;
        private String unitName = null;

        private BinScale(long secondsPerBin, int unitCount, String unitName) {
            this.secondsPerBin = secondsPerBin;
            this.unitCount = unitCount;
            this.unitName = unitName;
        }

        public String toString() {
            return "BinScale(" + this.secondsPerBin + "=" + this.unitCount + " " + this.unitName + ")";
        }
    }

    private static class Histogram {
        private int[] _displayErray = null;
        private int[] _displayArray = null;
        private int _maxDisplayArray = 0;
        private long _secondsPerMasterBin = 0L;
        private long _secondsPerBin = 0L;
        private BinScale _masterBin = null;
        private BinScale _bin = null;

        private Histogram() {
        }

        static /* synthetic */ int[] access$502(Histogram x0, int[] x1) {
            x0._displayArray = x1;
            return x1;
        }

        static /* synthetic */ int[] access$602(Histogram x0, int[] x1) {
            x0._displayErray = x1;
            return x1;
        }
    }
}

