/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.web;

import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.services.web.ActionHeaderExtension;
import diskCacheV111.services.web.PoolCellQueryInfo;
import diskCacheV111.services.web.PoolCostEntry;
import diskCacheV111.util.HTMLWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PoolQueueTableWriter {
    private static final int HEADER_TOP = 0;
    private static final int HEADER_MIDDLE = 1;
    private static final int HEADER_BOTTOM = 2;
    private final int _repeatHeader = 30;
    private final HTMLWriter _html;

    public PoolQueueTableWriter(HTMLWriter html) {
        this._html = html;
    }

    private void printPoolActionTableTotals(ActionHeaderExtension extension, int[][] total) {
        Map<String, int[]> map;
        this._html.beginRow("total");
        this._html.th(2, null, "Total");
        for (int[] row : total) {
            this._html.td("active", row[0]);
            this._html.td("max", row[1]);
            this._html.td("queued", row[2]);
        }
        Map<String, int[]> map2 = map = extension == null ? null : extension.getTotals();
        if (map != null) {
            for (int[] row : map.values()) {
                this._html.td("active", row[0]);
                this._html.td("max", row[1]);
                this._html.td("queued", row[2]);
            }
        }
        this._html.endRow();
    }

    private void printPoolActionRow(PoolCostEntry info, ActionHeaderExtension ext) {
        try {
            this._html.beginRow(null, "odd");
            this._html.td("cell", info._cellName);
            this._html.td("domain", info._domainName);
            for (int[] row : info._row) {
                if (row == null) {
                    this._html.td(3, "integrated", "Integrated");
                    continue;
                }
                this._html.td("active", row[0]);
                this._html.td("max", row[1]);
                if (row[2] > 0) {
                    this._html.td("queued", row[2]);
                    continue;
                }
                this._html.td("idle", 0);
            }
            if (ext != null) {
                for (int[] row : ext.getSortedMovers(info._movers)) {
                    this._html.td("active", row[0]);
                    this._html.td("max", row[1]);
                    if (row[2] > 0) {
                        this._html.td("queued", row[2]);
                        continue;
                    }
                    this._html.td("idle", 0);
                }
            }
            this._html.endRow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printPoolActionTableHeader(ActionHeaderExtension ext, int position) {
        int[][] program = new int[][]{{0, 1, 2, 3}, {0, 3, 2, 1, 2, 3}, {0, 3, 2, 1}};
        Set<String> moverSet = ext != null ? ext.getSet() : null;
        int diff = moverSet == null ? 0 : moverSet.size();
        block6: for (int i : program[position]) {
            switch (i) {
                case 0: {
                    int rowspan = program[position].length / 2;
                    this._html.beginRow(new String[0]);
                    this._html.th(rowspan, 1, "cell", "CellName");
                    this._html.th(rowspan, 1, "domain", "DomainName");
                    continue block6;
                }
                case 1: {
                    this._html.th(3, null, "Movers");
                    this._html.th(3, null, "Restores");
                    this._html.th(3, null, "Stores");
                    this._html.th(3, null, "P2P-Server");
                    this._html.th(3, null, "P2P-Client");
                    if (moverSet != null) {
                        for (String s : moverSet) {
                            this._html.th(3, null, s);
                        }
                    }
                    this._html.endRow();
                    continue block6;
                }
                case 2: {
                    this._html.beginRow(new String[0]);
                    continue block6;
                }
                case 3: {
                    int n = 5 + diff;
                    for (int h = 0; h < n; ++h) {
                        this._html.th("active", "Active");
                        this._html.th("max", "Max");
                        this._html.th("queued", "Queued");
                    }
                    this._html.endRow();
                }
            }
        }
    }

    private int[][] decodePoolCostInfo(PoolCostInfo costInfo) {
        try {
            PoolCostInfo.PoolQueueInfo mover = costInfo.getMoverQueue();
            PoolCostInfo.PoolQueueInfo restore = costInfo.getRestoreQueue();
            PoolCostInfo.PoolQueueInfo store = costInfo.getStoreQueue();
            PoolCostInfo.PoolQueueInfo p2pServer = costInfo.getP2pQueue();
            PoolCostInfo.PoolQueueInfo p2pClient = costInfo.getP2pClientQueue();
            int[][] rows = new int[5][];
            rows[0] = new int[3];
            rows[0][0] = mover.getActive();
            rows[0][1] = mover.getMaxActive();
            rows[0][2] = mover.getQueued();
            rows[1] = new int[3];
            rows[1][0] = restore.getActive();
            rows[1][1] = restore.getMaxActive();
            rows[1][2] = restore.getQueued();
            rows[2] = new int[3];
            rows[2][0] = store.getActive();
            rows[2][1] = store.getMaxActive();
            rows[2][2] = store.getQueued();
            if (p2pServer == null) {
                rows[3] = null;
            } else {
                rows[3] = new int[3];
                rows[3][0] = p2pServer.getActive();
                rows[3][1] = p2pServer.getMaxActive();
                rows[3][2] = p2pServer.getQueued();
            }
            rows[4] = new int[3];
            rows[4][0] = p2pClient.getActive();
            rows[4][1] = p2pClient.getMaxActive();
            rows[4][2] = p2pClient.getQueued();
            return rows;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void print(Collection<PoolCellQueryInfo> itemSet) {
        List<PoolCostEntry> list = this.preparePoolCostTable(itemSet);
        TreeMap<String, int[]> moverMap = new TreeMap<String, int[]>();
        int[][] total = new int[5][3];
        for (PoolCostEntry e : list) {
            if (e._movers != null) {
                for (Map.Entry<String, PoolCostInfo.NamedPoolQueueInfo> entry : e._movers.entrySet()) {
                    String queueName = entry.getKey();
                    int[] t = moverMap.get(queueName);
                    if (t == null) {
                        t = new int[3];
                        moverMap.put(queueName, t);
                    }
                    PoolCostInfo.NamedPoolQueueInfo mover = entry.getValue();
                    t[0] = t[0] + mover.getActive();
                    t[1] = t[1] + mover.getMaxActive();
                    t[2] = t[2] + mover.getQueued();
                }
            }
            int[][] status = e._row;
            for (int j = 0; j < total.length; ++j) {
                for (int l = 0; l < total[j].length; ++l) {
                    if (status[j] == null) continue;
                    int[] nArray = total[j];
                    int n = l;
                    nArray[n] = nArray[n] + status[j][l];
                }
            }
        }
        ActionHeaderExtension extension = new ActionHeaderExtension(moverMap);
        this._html.beginTable(null, new String[0]);
        this.printPoolActionTableHeader(extension, 0);
        this.printPoolActionTableTotals(extension, total);
        int i = 0;
        for (PoolCostEntry e : list) {
            this.printPoolActionRow(e, extension);
            if (++i % 30 != 0) continue;
            this.printPoolActionTableHeader(extension, 1);
        }
        this.printPoolActionTableTotals(extension, total);
        this.printPoolActionTableHeader(extension, 2);
        this._html.endTable();
    }

    private List<PoolCostEntry> preparePoolCostTable(Collection<PoolCellQueryInfo> itemSet) {
        ArrayList<PoolCostEntry> list = new ArrayList<PoolCostEntry>();
        int[][] total = new int[5][3];
        for (PoolCellQueryInfo info : itemSet) {
            try {
                PoolCellInfo pci;
                int[][] status;
                PoolCellInfo cellInfo = info.getPoolCellInfo();
                if (!info.isOk() || !(cellInfo instanceof PoolCellInfo) || (status = this.decodePoolCostInfo((pci = cellInfo).getPoolCostInfo())) == null) continue;
                list.add(new PoolCostEntry(pci.getCellName(), pci.getDomainName(), status, pci.getPoolCostInfo().getExtendedMoverHash()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

