/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.web;

import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.services.web.PoolCellQueryInfo;
import diskCacheV111.util.HTMLWriter;
import java.util.Collection;

public class PoolInfoTableWriter {
    private final HTMLWriter _html;

    public PoolInfoTableWriter(HTMLWriter html) {
        this._html = html;
    }

    private static double round(double value) {
        return Math.floor(value * 10.0) / 10.0;
    }

    private void printPoolInfoRow(String cell, String domain, long total, long freespace, long precious, long removable, String ... classes) {
        long mb = 0x100000L;
        double red = PoolInfoTableWriter.round((float)(100L * precious) / (float)total);
        double green = PoolInfoTableWriter.round((float)(100L * removable) / (float)total);
        double yellow = PoolInfoTableWriter.round((float)(100L * freespace) / (float)total);
        double blue = Math.max(0.0, 100.0 - red - green - yellow);
        this._html.beginRow(classes);
        this._html.td("cell", cell);
        this._html.td("domain", domain);
        this._html.td("total", total / 0x100000L);
        this._html.td("free", freespace / 0x100000L);
        this._html.td("precious", precious / 0x100000L);
        this._html.td("layout", "<div>", "<div class=\"layout_precious\" style=\"width: ", String.format("%.1f", red), "%\"></div>", "<div class=\"layout_rest\" style=\"width: ", String.format("%.1f", blue), "%\"></div>", "<div class=\"layout_used\" style=\"width: ", String.format("%.1f", green), "%\"></div>", "<div class=\"layout_free\" style=\"width: ", String.format("%.1f", yellow), "%\"></div>", "</div>");
        this._html.endRow();
    }

    private void printPoolInfoRow(PoolCellInfo cellInfo) {
        PoolCostInfo.PoolSpaceInfo info = cellInfo.getPoolCostInfo().getSpaceInfo();
        if (cellInfo.getErrorCode() == 0) {
            this.printPoolInfoRow(cellInfo.getCellName(), cellInfo.getDomainName(), info.getTotalSpace(), info.getFreeSpace(), info.getPreciousSpace(), info.getRemovableSpace(), null, "odd");
        } else {
            this._html.beginRow(null, "odd");
            this._html.td("cell", cellInfo.getCellName());
            this._html.td("domain", cellInfo.getDomainName());
            this._html.td("errorcode", "[", cellInfo.getErrorCode(), "]");
            this._html.td(3, "errormessage", cellInfo.getErrorMessage());
            this._html.endRow();
        }
    }

    public void print(Collection<PoolCellQueryInfo> itemSet, boolean showSum) {
        this._html.beginTable("sortable", "cell", "CellName", "domain", "DomainName", "total", "Total Space/MB", "free", "Free Space/MB", "precious", "Precious Space/MB", "layout", "<span>Layout   (<span class=\"layout_precious\">precious/</span><span class=\"layout_used\">used/</span><span class=\"layout_free\">free</span>)</span>");
        long[] spaces = this.sumUpSpaces(itemSet);
        if (showSum) {
            this.printPoolInfoRow("SUM", "-", spaces[0], spaces[1], spaces[2], spaces[3], "total");
        }
        for (PoolCellQueryInfo i : itemSet) {
            try {
                PoolCellQueryInfo info = i;
                PoolCellInfo cellInfo = info.getPoolCellInfo();
                if (!info.isOk() || !(cellInfo instanceof PoolCellInfo)) continue;
                this.printPoolInfoRow(cellInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (showSum) {
            this.printPoolInfoRow("SUM", "-", spaces[0], spaces[1], spaces[2], spaces[3], "total");
        }
        this._html.endTable();
    }

    private long[] sumUpSpaces(Collection itemSet) {
        long[] result = new long[4];
        for (Object i : itemSet) {
            try {
                PoolCellQueryInfo info = (PoolCellQueryInfo)i;
                PoolCellInfo cellInfo = info.getPoolCellInfo();
                if (!info.isOk() || !(cellInfo instanceof PoolCellInfo)) continue;
                PoolCostInfo.PoolSpaceInfo spaceInfo = cellInfo.getPoolCostInfo().getSpaceInfo();
                result[0] = result[0] + spaceInfo.getTotalSpace();
                result[1] = result[1] + spaceInfo.getFreeSpace();
                result[2] = result[2] + spaceInfo.getPreciousSpace();
                result[3] = result[3] + spaceInfo.getRemovableSpace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

