/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.web;

import diskCacheV111.poolManager.PoolManagerCellInfo;
import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.services.web.CellInfoContainer;
import diskCacheV111.services.web.PoolCellQueryContainer;
import diskCacheV111.services.web.PoolCellQueryInfo;
import diskCacheV111.services.web.PoolInfoObserverV1;
import diskCacheV111.util.CacheException;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellPath;
import dmg.util.Args;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import org.dcache.cells.AbstractCell;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.cells.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolInfoObserverV3
extends AbstractCell {
    private static final Logger _log = LoggerFactory.getLogger(PoolInfoObserverV3.class);
    private static final String THREAD_NAME = "pool-info-observer";
    private static final String POOL_MANAGER = "PoolManager";
    private static final String TOPOLOGY_NAME = "PoolManager";
    private static final String TOPOLOGY_CONTEXT_KEY = "poolgroup-map.ser";
    @Option(name="refresh-time", unit="seconds", defaultValue="60")
    protected long _interval;
    private Thread _refreshThread;
    private CellStub _poolManager;
    private CellStub _pool;

    public PoolInfoObserverV3(String name, String args) throws InterruptedException, ExecutionException {
        super(name, PoolInfoObserverV1.class.getName(), new Args((CharSequence)args));
        this.doInit();
    }

    @Override
    protected void init() {
        this._poolManager = new CellStub((CellEndpoint)this, new CellPath("PoolManager"), 30000L);
        this._pool = new CellStub((CellEndpoint)this, null, 60000L);
        this._refreshThread = new Thread(THREAD_NAME){

            @Override
            public void run() {
                try {
                    while (!Thread.interrupted()) {
                        try {
                            PoolInfoObserverV3.this.refresh();
                        }
                        catch (CacheException e) {
                            _log.error("Failed to update topology map: " + e.getMessage());
                        }
                        catch (RuntimeException e) {
                            _log.error("Failed to update topology map: " + e);
                        }
                        Thread.sleep(PoolInfoObserverV3.this._interval * 1000L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        this._refreshThread.start();
    }

    private void refresh() throws CacheException, InterruptedException {
        CellInfoContainer container = this.collectPoolGroups();
        PoolCellQueryContainer topology = this.collectPoolInfo(container);
        this.getNucleus().setDomainContext(TOPOLOGY_CONTEXT_KEY, (Object)topology);
    }

    private CellInfoContainer collectPoolGroups() throws CacheException, InterruptedException {
        Object[] poolGroups;
        CellInfoContainer container = new CellInfoContainer();
        for (Object o : poolGroups = this._poolManager.sendAndWait((Serializable)((Object)"psux ls pgroup"), Object[].class)) {
            if (o == null) continue;
            String name = o.toString();
            Object[] props = this._poolManager.sendAndWait((Serializable)((Object)("psux ls pgroup " + name)), Object[].class);
            if (props.length < 3 || !(props[0] instanceof String) || !(props[1] instanceof Object[])) {
                _log.error("Unexpected reply from PoolManager: {}", props);
                continue;
            }
            for (Object p : (Object[])props[1]) {
                container.addPool("PoolManager", name, p.toString());
            }
        }
        return container;
    }

    private PoolCellQueryContainer collectPoolInfo(final CellInfoContainer container) throws CacheException, InterruptedException {
        PoolManagerCellInfo poolManagerInfo = this._poolManager.sendAndWait((Serializable)((Object)"xgetcellinfo"), PoolManagerCellInfo.class);
        String[] pools = poolManagerInfo.getPoolList();
        final PoolCellQueryContainer result = new PoolCellQueryContainer();
        final CountDownLatch latch = new CountDownLatch(pools.length);
        for (final String pool : pools) {
            final long start = System.currentTimeMillis();
            this._pool.send(new CellPath(pool), (Serializable)((Object)"xgetcellinfo"), PoolCellInfo.class, new AbstractMessageCallback<PoolCellInfo>(){

                @Override
                public void success(PoolCellInfo info) {
                    long now = System.currentTimeMillis();
                    long ping = now - start;
                    result.put(info.getCellName(), new PoolCellQueryInfo(info, ping, now));
                    container.addInfo(info.getCellName(), info);
                    latch.countDown();
                }

                @Override
                public void failure(int rc, Object error) {
                    _log.warn("Failed to query {}: {}", (Object)pool, error);
                    latch.countDown();
                }
            });
        }
        latch.await();
        Map<String, Map<String, Map<String, Object>>> allClasses = container.createExternalTopologyMap();
        for (Map<String, Map<String, Object>> groupMap : allClasses.values()) {
            for (Map<String, Object> tableMap : groupMap.values()) {
                for (String poolName : tableMap.keySet()) {
                    tableMap.put(poolName, result.getInfoByName(poolName));
                }
            }
        }
        result.setTopology(allClasses);
        return result;
    }

    public String ac_show_topology(Args args) {
        Object o = this.getNucleus().getDomainContext(TOPOLOGY_CONTEXT_KEY);
        return o == null ? "" : o.toString();
    }

    @Override
    public void cleanUp() {
        this._refreshThread.interrupt();
    }

    public void getInfo(PrintWriter pw) {
        pw.println("Update interval: " + this._interval + " [sec]");
    }
}

