/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.web;

import diskCacheV111.poolManager.PoolManagerCellInfo;
import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.services.web.CellInfoContainer;
import diskCacheV111.services.web.PoolCellQueryContainer;
import diskCacheV111.services.web.PoolCellQueryInfo;
import diskCacheV111.services.web.PoolInfoObserverException;
import diskCacheV111.services.web.PoolInfoObserverV1;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import dmg.util.CommandExitException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolInfoObserverV2
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(PoolInfoObserverV2.class);
    private File _configFile;
    private long _interval = 60000L;
    private long _counter = 0L;
    private String _dCacheInstance = "?";
    private long _poolManagerTimeout = 30000L;
    private boolean _poolManagerUpdating = false;
    private long _configFileLastModified = 0L;
    private long _poolManagerNextQuery = 0L;
    private long _poolManagerUpdate = 5L * this._interval;
    private String _poolManagerName = "PoolManager";
    private final CellNucleus _nucleus;
    private final Args _args;
    private final Map<String, CellQueryInfo> _infoMap = new HashMap<String, CellQueryInfo>();
    private Thread _collectThread;
    private Thread _senderThread;
    private final Object _lock = new Object();
    private final Object _infoLock = new Object();
    private final Object _poolManagerUpdateLock = new Object();
    private CellInfoContainer _container = new CellInfoContainer();
    private final SimpleDateFormat _formatter = new SimpleDateFormat("MM/dd hh:mm:ss");
    public String hh_x_addto_pgroup = "<groupName>  <name> [-pattern[=<pattern>}] [-class=<className>]";
    public String hh_x_add = "<pool> <poolValue> # debug only";
    public String hh_x_removefrom = "<poolGroup> [-class=<className>] <name> [-pattern]";
    public String hh_scan_poolmanager = "[<poolManager>]";
    public String hh_addto_pgroup = "<poolGroup> [-class=<poolClass>] <poolName> | /poolNamePattern/ [...]";
    public String hh_show_context = "<contextName>";

    public String ac_x_addto_pgroup_$_2(Args args) {
        String groupClass = args.getOpt("view");
        groupClass = groupClass == null ? "default" : groupClass;
        String groupName = args.argv(0);
        String name = args.argv(1);
        String pattern = args.getOpt("pattern");
        if (pattern == null) {
            this._container.addPool(groupClass, groupName, name);
        } else {
            if (pattern.length() == 0) {
                pattern = name;
            }
            this._container.addPattern(groupClass, groupName, name, pattern);
        }
        return "";
    }

    public String ac_x_add_$_2(Args args) {
        this._container.addInfo(args.argv(0), args.argv(1));
        return "";
    }

    public String ac_x_removefrom_$_2(Args args) {
        String groupClass = args.getOpt("view");
        groupClass = groupClass == null ? "default" : groupClass;
        String poolGroup = args.argv(0);
        String name = args.argv(1);
        if (!args.hasOption("pattern")) {
            this._container.removePool(groupClass, poolGroup, name);
        } else {
            this._container.removePattern(groupClass, poolGroup, name);
        }
        return "";
    }

    public String ac_x_info(Args args) {
        return this._container.getInfo();
    }

    public String ac_scan_poolmanager_$_0_1(Args args) {
        final String poolManagerName = args.argc() == 0 ? "PoolManager" : args.argv(0);
        this._nucleus.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                _log.info("Starting pool manager (" + poolManagerName + ") scan");
                try {
                    PoolInfoObserverV2.this.collectPoolManagerPoolGroups(poolManagerName);
                }
                catch (Exception e) {
                    _log.warn("Problem in collectPoolManagerPoolGroups : " + e);
                }
                finally {
                    _log.info("collectPoolManagerPoolGroups done");
                }
            }
        }).start();
        return "Scan initialed (check pinboard for results)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_addto_pgroup_$_2_999(Args args) {
        CellInfoContainer container;
        StringBuffer sb = new StringBuffer();
        String groupName = args.argv(0);
        String className = args.getOpt("view");
        if (className == null) {
            className = "default";
        }
        if (className.length() == 0) {
            throw new IllegalArgumentException("class name must not be \"\"");
        }
        CellInfoContainer cellInfoContainer = container = this._container;
        synchronized (cellInfoContainer) {
            int n = args.argc();
            for (int i = 1; i < n; ++i) {
                String name = args.argv(i);
                if (name.startsWith("/")) {
                    if (name.length() < 3 || !name.endsWith("/")) {
                        sb.append("Not a valid pattern : ").append(name).append("\n");
                        continue;
                    }
                    name = name.substring(1, name.length() - 1);
                    container.addPattern(className, groupName, name, name);
                    continue;
                }
                container.addPool(className, groupName, name);
            }
        }
        String result = sb.toString();
        if (result.length() != 0) {
            throw new IllegalArgumentException(result);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectPoolManagerPoolGroups(String poolManager) throws PoolInfoObserverException, NoRouteToCellException, InterruptedException {
        Object object = this._poolManagerUpdateLock;
        synchronized (object) {
            if (this._poolManagerUpdating) {
                _log.info("PoolManager update already in progress");
                return;
            }
            this._poolManagerUpdating = true;
        }
        try {
            this._collectPoolManagerPoolGroups(poolManager);
        }
        finally {
            object = this._poolManagerUpdateLock;
            synchronized (object) {
                this._poolManagerUpdating = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _collectPoolManagerPoolGroups(String poolManager) throws PoolInfoObserverException, NoRouteToCellException, InterruptedException {
        CellPath path = new CellPath(poolManager);
        CellMessage message = new CellMessage(path, (Object)"psux ls pgroup");
        if ((message = this.sendAndWait(message, this._poolManagerTimeout)) == null) {
            throw new PoolInfoObserverException("Request to " + poolManager + " timed out");
        }
        Object result = message.getMessageObject();
        if (result instanceof Exception) {
            throw new PoolInfoObserverException("Pool manager returned: " + result);
        }
        if (!(result instanceof Object[])) {
            throw new PoolInfoObserverException("Illegal Reply on 'psux ls pgroup");
        }
        for (Object o : (Object[])result) {
            CellInfoContainer container;
            if (o == null) continue;
            String pgroupName = o.toString();
            String request = "psux ls pgroup " + pgroupName;
            message = new CellMessage(path, (Object)request);
            if ((message = this.sendAndWait(message, this._poolManagerTimeout)) == null) {
                _log.warn("Request to " + poolManager + " timed out");
                continue;
            }
            result = message.getMessageObject();
            if (!(result instanceof Object[])) {
                _log.warn("Illegal reply (1) on " + request + " " + result.getClass().getName());
                continue;
            }
            Object[] props = (Object[])result;
            if (props.length < 3 || !(props[0] instanceof String) || !(props[1] instanceof Object[])) {
                _log.warn("Illegal reply (2) on " + request);
                continue;
            }
            CellInfoContainer cellInfoContainer = container = this._container;
            synchronized (cellInfoContainer) {
                for (Object p : (Object[])props[1]) {
                    container.addPool("PoolManager", pgroupName, p.toString());
                }
            }
        }
    }

    public PoolInfoObserverV2(String name, String args) {
        super(name, PoolInfoObserverV1.class.getName(), args, false);
        String intervalString;
        this._args = this.getArgs();
        this._nucleus = this.getNucleus();
        String instance = this._args.getOpt("dCacheInstance");
        this._dCacheInstance = instance == null || instance.length() == 0 ? this._dCacheInstance : instance;
        String configName = this._args.getOpt("config");
        if (configName != null && !configName.equals("")) {
            this._configFile = new File(configName);
        }
        if ((intervalString = this._args.getOpt("pool-refresh-time")) != null) {
            try {
                this._interval = Long.parseLong(intervalString) * 1000L;
            }
            catch (NumberFormatException iee) {
                // empty catch block
            }
        }
        if ((intervalString = this._args.getOpt("poolManager-refresh-time")) != null) {
            try {
                this._poolManagerUpdate = Long.parseLong(intervalString) * 1000L;
            }
            catch (NumberFormatException iee) {
                // empty catch block
            }
        }
        for (int i = 0; i < this._args.argc(); ++i) {
            this.addQuery(this._args.argv(i));
        }
        this._senderThread = this._nucleus.newThread((Runnable)this, "sender");
        this._senderThread.start();
        _log.info("Sender started");
        _log.info("Collector will be started a bit delayed");
        this._nucleus.newThread((Runnable)new DoDelayedOnStartup(), "init").start();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadConfigFile() {
        if (this._configFile == null || !this._configFile.exists() || !this._configFile.canRead()) {
            return false;
        }
        long accessTime = this._configFile.lastModified();
        if (this._configFileLastModified >= accessTime) {
            return false;
        }
        CellInfoContainer c = this._container;
        this._container = new CellInfoContainer();
        try {
            BufferedReader br = new BufferedReader(new FileReader(this._configFile));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    _log.info(line);
                    this.command(line);
                }
            }
            catch (IOException e) {
                _log.warn(e.toString(), (Throwable)e);
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
            this._configFileLastModified = accessTime;
        }
        catch (FileNotFoundException e) {
            _log.warn("Could not open " + this._configFile + " due to " + e);
            this._container = c;
            return false;
        }
        catch (CommandExitException e) {
            _log.warn("Could not execute " + this._configFile + " due to " + (Object)((Object)e));
            this._container = c;
            return false;
        }
        return true;
    }

    private synchronized void addQuery(String destination) {
        if (this._infoMap.get(destination) == null) {
            _log.info("Adding " + destination);
            this._infoMap.put(destination, new CellQueryInfo(destination));
        }
    }

    private synchronized void removeQuery(String destination) {
        _log.info("Removing " + destination);
        this._infoMap.remove(destination);
    }

    @Override
    public void run() {
        Thread x = Thread.currentThread();
        if (x == this._senderThread) {
            this.runSender();
        } else {
            this.runCollector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCollector() {
        while (true) {
            Thread.currentThread();
            if (Thread.interrupted()) break;
            Object object = this._infoLock;
            synchronized (object) {
                _log.debug("Updating info in context poolgroup-map.ser");
                this.flushTopologyMap("poolgroup-map.ser");
                _log.debug("Updating info in context Done");
            }
            try {
                Thread.currentThread();
                Thread.sleep(this._interval);
            }
            catch (InterruptedException iie) {
                _log.info("Collector Thread interrupted");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSender() {
        this._poolManagerNextQuery = System.currentTimeMillis() + this._poolManagerUpdate;
        while (true) {
            Thread.currentThread();
            if (Thread.interrupted()) break;
            ++this._counter;
            Object object = this._infoLock;
            synchronized (object) {
                for (CellQueryInfo info : this._infoMap.values()) {
                    try {
                        CellMessage cellMessage = info.getCellMessage();
                        _log.debug("Sending message to " + cellMessage.getDestinationPath());
                        this.sendMessage(info.getCellMessage());
                    }
                    catch (NoRouteToCellException e) {
                        _log.warn("Problem in sending message : " + (Object)((Object)e));
                    }
                }
            }
            long now = System.currentTimeMillis();
            if (this.loadConfigFile() || this._poolManagerNextQuery < now) {
                try {
                    _log.debug("collectPoolManagerPoolGroups started on " + this._poolManagerName);
                    this.collectPoolManagerPoolGroups(this._poolManagerName);
                    this._poolManagerNextQuery = now + this._poolManagerUpdate;
                }
                catch (Exception e) {
                    _log.warn("Problems reported by 'collectPoolManagerPoolGroups' : " + e);
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(this._interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                _log.info("Sender Thread interrupted");
                break;
            }
        }
    }

    public String ac_show_context_$_1(Args args) {
        String contextName = args.argv(0);
        Object o = this._nucleus.getDomainContext(contextName);
        if (o == null) {
            throw new IllegalArgumentException("Context not found : " + contextName);
        }
        return o.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(CellMessage message) {
        Object object;
        CellPath path = message.getSourcePath();
        Object reply = message.getMessageObject();
        _log.info("Message arrived : " + reply.getClass().getName() + " from " + path);
        String destination = path.getCellName();
        CellQueryInfo info = this._infoMap.get(destination);
        if (info == null) {
            _log.debug("Unexpected reply arrived from : " + path);
            return;
        }
        if (reply instanceof CellInfo) {
            info.infoArrived((CellInfo)reply);
            CellInfoContainer container = this._container;
            object = container;
            synchronized (object) {
                container.addInfo(info.getName(), info);
            }
        }
        if (reply instanceof PoolManagerCellInfo) {
            String[] poolList = ((PoolManagerCellInfo)reply).getPoolList();
            object = this._infoLock;
            synchronized (object) {
                for (String pool : poolList) {
                    this.addQuery(pool);
                }
            }
        }
    }

    public void cleanUp() {
        _log.info("Clean Up sequence started");
        _log.info("Waiting for collector thread to be finished");
        this._collectThread.interrupt();
        this._senderThread.interrupt();
        _log.info("Clean Up sequence done");
    }

    public void getInfo(PrintWriter pw) {
        pw.println("                    Version : $Id: PoolInfoObserverV2.java,v 1.2 2006-06-08 15:23:27 patrick Exp $");
        pw.println("       Pool Update Interval : " + this._interval + " [msec]");
        pw.println("PoolManager Update Interval : " + this._poolManagerUpdate + " [msec]");
        pw.println(" Update Counter : " + this._counter);
        pw.println("       Watching : " + this._infoMap.size() + " cells");
    }

    private Map scanTopologyMap(String topoMapString) {
        HashMap allClasses = new HashMap();
        HashMap currentClass = null;
        HashMap<String, Object> currentGroup = null;
        for (String line : topoMapString.split("\n")) {
            if (line.length() == 0) continue;
            if (line.startsWith("++")) {
                if (currentGroup == null) continue;
                currentGroup.put(line.substring(2), null);
                continue;
            }
            if (line.startsWith("+")) {
                if (currentClass == null) continue;
                currentGroup = new HashMap<String, Object>();
                currentClass.put(line.substring(1), currentGroup);
                continue;
            }
            currentClass = new HashMap();
            allClasses.put(line.trim(), currentClass);
        }
        return allClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushTopologyMap(String topologyMapName) {
        PoolCellQueryContainer container = new PoolCellQueryContainer();
        Object object = this._infoLock;
        synchronized (object) {
            for (CellQueryInfo cellQueryInfo : this._infoMap.values()) {
                CellInfo cellInfo = cellQueryInfo.getCellInfo();
                if (!(cellInfo instanceof PoolCellInfo)) continue;
                container.put(cellQueryInfo.getCellName(), new PoolCellQueryInfo((PoolCellInfo)cellInfo, cellQueryInfo.getPingTime(), cellQueryInfo.getArrivalTime()));
            }
        }
        Map<String, Map<String, Map<String, Object>>> allClasses = this._container.createExternalTopologyMap();
        for (Map map : allClasses.values()) {
            for (Map tableMap : map.values()) {
                for (String poolName : tableMap.keySet()) {
                    tableMap.put(poolName, container.getInfoByName(poolName));
                }
            }
        }
        container.setTopology(allClasses);
        this._nucleus.setDomainContext(topologyMapName, (Object)container);
    }

    private class DoDelayedOnStartup
    implements Runnable {
        private DoDelayedOnStartup() {
        }

        @Override
        public void run() {
            _log.info("Collector will be delayed by " + PoolInfoObserverV2.this._interval / 2000L + " Seconds");
            try {
                Thread.currentThread();
                Thread.sleep(PoolInfoObserverV2.this._interval / 2L);
            }
            catch (InterruptedException ee) {
                Thread.currentThread().interrupt();
                return;
            }
            PoolInfoObserverV2.this._collectThread = PoolInfoObserverV2.this._nucleus.newThread((Runnable)PoolInfoObserverV2.this, "collector");
            PoolInfoObserverV2.this._collectThread.start();
            _log.info("Collector now started as well");
            _log.info("Getting pool groups from PoolManager");
            try {
                PoolInfoObserverV2.this.collectPoolManagerPoolGroups("PoolManager");
            }
            catch (Exception e) {
                _log.warn("Problem in collectPoolManagerPoolGroups : " + e);
            }
            _log.info("collectPoolManagerPoolGroups done");
        }
    }

    private class CellQueryInfo {
        private String _destination = null;
        private long _diff = -1L;
        private long _start = 0L;
        private CellInfo _info = null;
        private CellMessage _message = null;
        private long _lastMessage = 0L;

        private CellQueryInfo(String destination) {
            this._destination = destination;
            this._message = new CellMessage(new CellPath(this._destination), (Object)"xgetcellinfo");
        }

        private String getName() {
            return this._destination;
        }

        private CellInfo getCellInfo() {
            return this._info;
        }

        private long getPingTime() {
            return this._diff;
        }

        private long getArrivalTime() {
            return this._lastMessage;
        }

        private CellMessage getCellMessage() {
            this._start = System.currentTimeMillis();
            return this._message;
        }

        private String getCellName() {
            return this._info.getCellName();
        }

        private String getDomainName() {
            return this._info.getDomainName();
        }

        private void infoArrived(CellInfo info) {
            this._info = info;
            this._lastMessage = System.currentTimeMillis();
            this._diff = this._lastMessage - this._start;
        }

        private boolean isOk() {
            return System.currentTimeMillis() - this._lastMessage < 3L * PoolInfoObserverV2.this._interval;
        }

        public String toString() {
            return "[" + this._destination + "(" + this._diff / 1000L + ")" + (this._info == null ? "NOINFO" : this._info.toString()) + ")]";
        }
    }
}

