/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.web;

import diskCacheV111.poolManager.PoolManagerCellInfo;
import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.pools.PoolCostInfo;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.util.Args;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolInfoObserverV1
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(PoolInfoObserverV1.class);
    private CellNucleus _nucleus = null;
    private Args _args = null;
    private HashMap _infoMap = new HashMap();
    private Object _lock = new Object();
    private final Object _infoLock = new Object();
    private Thread _collectThread = null;
    private final Thread _senderThread;
    private long _interval = 60000L;
    private long _counter = 0L;
    private String _dCacheInstance = "?";
    private final CellInfoContainer _container = new CellInfoContainer();
    private SimpleDateFormat _formatter = new SimpleDateFormat("MM/dd hh:mm:ss");
    public String hh_x_addto_pgroup = "<groupName>  <name> [-pattern[=<pattern>}] [-class=<className>]";
    public String hh_x_add = "<pool> <poolValue> # debug only";
    public String hh_x_removefrom = "<poolGroup> [-class=<className>] <name> [-pattern]";
    public String hh_scan_poolmanager = "[<poolManager>]";
    public String hh_addto_pgroup = "<poolGroup> [-class=<poolClass>] <poolName> | /poolNamePattern/ [...]";
    private long _poolManagerTimeout = 30000L;
    private static final int HEADER_TOP = 0;
    private static final int HEADER_MIDDLE = 1;
    private static final int HEADER_BOTTOM = 2;
    private String _bgImage = "/images/bg.svg";
    private String _linkColor = "red";
    private String _bgType = "image";
    private String _bgColor = "white";
    private String _webPrefix = "web";
    private int _repeatHeader = 20;
    private String[] _rowColors = new String[]{"#efefef", "#bebebe"};
    private String[] _rowTextColors = new String[]{"black", "red", "#008080"};
    private String[] _rowTotalTextColors = new String[]{"black", "red", "white"};
    private String _poolTableTotalColor = "#0000FF";
    private String[] _poolTableHeaderColor = new String[]{"#0000FF", "#0099FF", "#00bbFF", "#115259"};
    private String[] _poolTableHeaderTextColor = new String[]{"white"};
    private String[] _poolTableHeaderTitles = new String[]{"Movers", "Restores", "Stores", "P2P-Server", "P2P-Client"};
    private String _topIndex = "";
    public String hh_web_set_skin = "[OPTIONS] ; please use 'help set skin' for more";
    public String fh_web_set_skin = "  web set skin [OPTIONS]\n      OPTIONS\n          -bgtype=image|color\n          -bgcolor=&lt;background color&gt;\n          -bgimage=&lt;background image&gt;\n          -linkcolor=<link color>\n          -rowcolors=<text1/text2/text3/bg1/bg2[/bg...]>\n          -rowtotalcolors=<text1/text2/text3/bg1>\n          -headercolors=<text1/bg1/bg2/bg3/bg4>\n";

    public String ac_x_addto_pgroup_$_2(Args args) throws Exception {
        try {
            String groupClass = args.getOpt("class");
            groupClass = groupClass == null ? "default" : groupClass;
            String groupName = args.argv(0);
            String name = args.argv(1);
            String pattern = args.getOpt("pattern");
            if (pattern == null) {
                this._container.addPool(groupClass, groupName, name);
            } else {
                if (pattern.length() == 0) {
                    pattern = name;
                }
                this._container.addPattern(groupClass, groupName, name, pattern);
            }
            return "";
        }
        catch (Exception e) {
            _log.warn(e.toString(), (Throwable)e);
            throw e;
        }
    }

    public String ac_x_add_$_2(Args args) throws Exception {
        try {
            this._container.addInfo(args.argv(0), args.argv(1));
        }
        catch (Exception ee) {
            _log.warn(ee.toString(), (Throwable)ee);
            throw ee;
        }
        return "";
    }

    public String ac_x_removefrom_$_2(Args args) throws Exception {
        try {
            String groupClass = args.getOpt("class");
            groupClass = groupClass == null ? "default" : groupClass;
            String poolGroup = args.argv(0);
            String name = args.argv(1);
            if (!args.hasOption("pattern")) {
                this._container.removePool(groupClass, poolGroup, name);
            } else {
                this._container.removePattern(groupClass, poolGroup, name);
            }
        }
        catch (Exception ee) {
            _log.warn(ee.toString(), (Throwable)ee);
            throw ee;
        }
        return "";
    }

    public String ac_x_info(Args args) throws Exception {
        try {
            return this._container.getInfo();
        }
        catch (Exception eee) {
            _log.warn(eee.toString(), (Throwable)eee);
            throw eee;
        }
    }

    public String ac_scan_poolmanager_$_0_1(Args args) {
        final String poolManagerName = args.argc() == 0 ? "PoolManager" : args.argv(0);
        this._nucleus.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                _log.info("Starting pool manager (" + poolManagerName + ") scan");
                try {
                    PoolInfoObserverV1.this.collectPoolManagerPoolGroups(poolManagerName);
                }
                catch (Exception ee) {
                    _log.warn("Problem in collectPoolManagerPoolGroups : " + ee);
                }
                finally {
                    _log.info("collectPoolManagerPoolGroups done");
                }
            }
        }).start();
        return "Scan initialed (check pinboard for results)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_addto_pgroup_$_2_999(Args args) {
        StringBuffer sb = new StringBuffer();
        String groupName = args.argv(0);
        String className = args.getOpt("class");
        if (className == null) {
            className = "default";
        }
        if (className.length() == 0) {
            throw new IllegalArgumentException("class name must not be \"\"");
        }
        CellInfoContainer cellInfoContainer = this._container;
        synchronized (cellInfoContainer) {
            int n = args.argc();
            for (int i = 1; i < n; ++i) {
                String name = args.argv(i);
                if (name.startsWith("/")) {
                    if (name.length() < 3 || !name.endsWith("/")) {
                        sb.append("Not a valid pattern : " + name).append("\n");
                        continue;
                    }
                    name = name.substring(1, name.length() - 1);
                    this._container.addPattern(className, groupName, name, name);
                    continue;
                }
                this._container.addPool(className, groupName, name);
            }
        }
        String result = sb.toString();
        if (result.length() != 0) {
            throw new IllegalArgumentException(result);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectPoolManagerPoolGroups(String poolManager) throws Exception {
        CellPath path = new CellPath(poolManager);
        CellMessage message = new CellMessage(path, (Object)"psux ls pgroup");
        if ((message = this.sendAndWait(message, this._poolManagerTimeout)) == null) {
            throw new Exception("Request to " + poolManager + " timed out");
        }
        Object result = message.getMessageObject();
        if (result instanceof Exception) {
            throw (Exception)result;
        }
        if (!(result instanceof Object[])) {
            throw new Exception("Illegal Reply on 'psux ls pgroup");
        }
        Object[] array = (Object[])result;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            if (array[i] == null) continue;
            String pgroupName = array[i].toString();
            String request = "psux ls pgroup " + pgroupName;
            message = new CellMessage(path, (Object)request);
            if ((message = this.sendAndWait(message, this._poolManagerTimeout)) == null) {
                _log.warn("Request to " + poolManager + " timed out");
                continue;
            }
            result = message.getMessageObject();
            if (!(result instanceof Object[])) {
                _log.warn("Illegal reply (1) on " + request + " " + result.getClass().getName());
                continue;
            }
            Object[] props = (Object[])result;
            if (props.length < 3 || !(props[0] instanceof String) || !(props[1] instanceof Object[])) {
                _log.warn("Illegal reply (2) on " + request);
                continue;
            }
            Object[] list = (Object[])props[1];
            CellInfoContainer cellInfoContainer = this._container;
            synchronized (cellInfoContainer) {
                int m = list.length;
                for (int j = 0; j < m; ++j) {
                    this._container.addPool("PoolManager", pgroupName, list[j].toString());
                }
                continue;
            }
        }
    }

    public PoolInfoObserverV1(String name, String args) throws Exception {
        super(name, PoolInfoObserverV1.class.getName(), args, false);
        this._args = this.getArgs();
        this._nucleus = this.getNucleus();
        try {
            String repeatString = null;
            try {
                repeatString = this._args.getOpt("repeatHeader");
                this._repeatHeader = Math.max(0, Integer.parseInt(repeatString));
            }
            catch (Exception ee) {
                _log.warn("Parsing error in repeatHader command : " + repeatString);
            }
            _log.info("Repeat header set to " + this._repeatHeader);
            String instance = this._args.getOpt("dCacheInstance");
            this._dCacheInstance = instance == null || instance.length() == 0 ? this._dCacheInstance : instance;
            for (int i = 0; i < this._args.argc(); ++i) {
                this.addQuery(this._args.argv(i));
            }
            this._senderThread = this._nucleus.newThread((Runnable)this, "sender");
            this._senderThread.start();
            _log.info("Sender started");
            _log.info("Collector will be started a bit delayed");
            this._nucleus.newThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.currentThread();
                        Thread.sleep(PoolInfoObserverV1.this._interval / 2L);
                        (PoolInfoObserverV1.this._collectThread = PoolInfoObserverV1.this._nucleus.newThread((Runnable)PoolInfoObserverV1.this, "collector")).start();
                        _log.info("Collector now started as well");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }, "init").start();
        }
        catch (Exception ee) {
            _log.warn("<init> of WebCollector reports : " + ee.getMessage(), (Throwable)ee);
            this.start();
            this.kill();
            throw ee;
        }
        this.start();
    }

    private synchronized void addQuery(String destination) {
        if (this._infoMap.get(destination) != null) {
            return;
        }
        _log.info("Adding " + destination);
        this._infoMap.put(destination, new CellQueryInfo(destination));
    }

    private synchronized void removeQuery(String destination) {
        _log.info("Removing " + destination);
        this._infoMap.remove(destination);
    }

    @Override
    public void run() {
        Thread x = Thread.currentThread();
        if (x == this._senderThread) {
            this.runSender();
        } else {
            this.runCollector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCollector() {
        while (true) {
            Thread.currentThread();
            if (Thread.interrupted()) break;
            Object object = this._infoLock;
            synchronized (object) {
                this.prepareTopologyMap("topo-map.txt");
                this.preparePages();
            }
            try {
                Thread.currentThread();
                Thread.sleep(this._interval);
            }
            catch (InterruptedException iie) {
                _log.info("Collector Thread interrupted");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSender() {
        while (true) {
            Thread.currentThread();
            if (Thread.interrupted()) break;
            ++this._counter;
            Object object = this._infoLock;
            synchronized (object) {
                for (CellQueryInfo info : this._infoMap.values()) {
                    try {
                        this.sendMessage(info.getCellMessage());
                    }
                    catch (Exception ee) {}
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(this._interval);
            }
            catch (InterruptedException iie) {
                _log.info("Sender Thread interrupted");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(CellMessage message) {
        CellPath path = message.getSourcePath();
        String destination = path.getCellName();
        CellQueryInfo info = (CellQueryInfo)this._infoMap.get(destination);
        if (info == null) {
            _log.debug("Unexpected reply arrived from : " + path);
            return;
        }
        Object reply = message.getMessageObject();
        if (reply instanceof CellInfo) {
            info.infoArrived((CellInfo)reply);
            CellInfoContainer cellInfoContainer = this._container;
            synchronized (cellInfoContainer) {
                this._container.addInfo(info.getName(), info);
            }
        }
        if (reply instanceof PoolManagerCellInfo) {
            String[] poolList = ((PoolManagerCellInfo)reply).getPoolList();
            Object object = this._infoLock;
            synchronized (object) {
                for (int i = 0; i < poolList.length; ++i) {
                    this.addQuery(poolList[i]);
                }
            }
        }
    }

    private int[][] decodePoolCostInfo(PoolCostInfo costInfo) {
        try {
            PoolCostInfo.PoolQueueInfo mover = costInfo.getMoverQueue();
            PoolCostInfo.PoolQueueInfo restore = costInfo.getRestoreQueue();
            PoolCostInfo.PoolQueueInfo store = costInfo.getStoreQueue();
            PoolCostInfo.PoolQueueInfo p2pServer = costInfo.getP2pQueue();
            PoolCostInfo.PoolQueueInfo p2pClient = costInfo.getP2pClientQueue();
            int[][] rows = new int[5][];
            rows[0] = new int[3];
            rows[0][0] = mover.getActive();
            rows[0][1] = mover.getMaxActive();
            rows[0][2] = mover.getQueued();
            rows[1] = new int[3];
            rows[1][0] = restore.getActive();
            rows[1][1] = restore.getMaxActive();
            rows[1][2] = restore.getQueued();
            rows[2] = new int[3];
            rows[2][0] = store.getActive();
            rows[2][1] = store.getMaxActive();
            rows[2][2] = store.getQueued();
            if (p2pServer == null) {
                rows[3] = null;
            } else {
                rows[3] = new int[3];
                rows[3][0] = p2pServer.getActive();
                rows[3][1] = p2pServer.getMaxActive();
                rows[3][2] = p2pServer.getQueued();
            }
            rows[4] = new int[3];
            rows[4][0] = p2pClient.getActive();
            rows[4][1] = p2pClient.getMaxActive();
            rows[4][2] = p2pClient.getQueued();
            return rows;
        }
        catch (Exception e) {
            _log.warn(e.toString(), (Throwable)e);
            return null;
        }
    }

    public void cleanUp() {
        _log.info("Clean Up sequence started");
        _log.info("Waiting for collector thread to be finished");
        if (this._collectThread != null) {
            this._collectThread.interrupt();
        }
        this._senderThread.interrupt();
        _log.info("Clean Up sequence done");
    }

    public void getInfo(PrintWriter pw) {
        pw.println("        Version : $Id: PoolInfoObserverV1.java,v 1.6 2006-06-05 08:51:27 patrick Exp $");
        pw.println("Update Interval : " + this._interval + " [msec]");
        pw.println("        Updates : " + this._counter);
        pw.println("       Watching : " + this._infoMap.size() + " cells");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTopologyMap(String topologyMapName) {
        StringBuffer sb = new StringBuffer();
        CellInfoContainer cellInfoContainer = this._container;
        synchronized (cellInfoContainer) {
            for (Map.Entry entry : this._container._poolGroupClassHash.entrySet()) {
                String className = (String)entry.getKey();
                Map groupMap = (Map)entry.getValue();
                sb.append(className).append("\n");
                for (Map.Entry groupEntry : groupMap.entrySet()) {
                    String groupName = (String)groupEntry.getKey();
                    Map tableMap = (Map)groupEntry.getValue();
                    sb.append("+").append(groupName).append("\n");
                    Iterator poolNames = tableMap.keySet().iterator();
                    while (poolNames.hasNext()) {
                        String poolName = poolNames.next().toString();
                        sb.append("++").append(poolName).append("\n");
                    }
                }
            }
        }
        this._nucleus.setDomainContext(topologyMapName, (Object)sb.toString());
    }

    private String[] splitColorOptions(String colors) {
        StringTokenizer st = new StringTokenizer(colors, "/");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[0]);
    }

    public String ac_web_set_skin_$_0(Args args) {
        int i;
        int n;
        int rowColorCount;
        int i2;
        int base;
        String[] x;
        String tmp = args.getOpt("bgtype");
        if (tmp != null && tmp.length() > 0) {
            this._bgType = tmp;
        }
        if ((tmp = args.getOpt("bgimage")) != null && tmp.length() > 0) {
            this._bgImage = tmp;
        }
        if ((tmp = args.getOpt("bgcolor")) != null && tmp.length() > 0) {
            this._bgColor = tmp;
        }
        if ((tmp = args.getOpt("linkcolor")) != null && tmp.length() > 0) {
            this._linkColor = tmp;
        }
        if ((tmp = args.getOpt("rowcolors")) != null && tmp.length() > 0) {
            x = this.splitColorOptions(tmp);
            if (x.length < 5) {
                throw new IllegalArgumentException("Not enought row colors (5)");
            }
            base = 3;
            String[] y = new String[base];
            for (i2 = 0; i2 < y.length; ++i2) {
                y[i2] = x[i2];
            }
            this._rowTextColors = y;
            rowColorCount = x.length - y.length;
            y = new String[rowColorCount];
            n = rowColorCount;
            for (i = 0; i < n; ++i) {
                y[i] = x[base + i];
            }
            this._rowColors = y;
        }
        if ((tmp = args.getOpt("rowtotalcolors")) != null && tmp.length() > 0) {
            x = this.splitColorOptions(tmp);
            if (x.length < 4) {
                throw new IllegalArgumentException("Not enought row total colors (4)");
            }
            String[] y = new String[3];
            for (int i3 = 0; i3 < y.length; ++i3) {
                y[i3] = x[i3];
            }
            this._rowTotalTextColors = y;
            this._poolTableTotalColor = x[y.length];
        }
        if ((tmp = args.getOpt("headercolors")) != null && tmp.length() > 0) {
            x = this.splitColorOptions(tmp);
            if (x.length < 5) {
                throw new IllegalArgumentException("Not enought row colors (5)");
            }
            base = 1;
            String[] y = new String[base];
            for (i2 = 0; i2 < y.length; ++i2) {
                y[i2] = x[i2];
            }
            this._poolTableHeaderTextColor = y;
            rowColorCount = x.length - y.length;
            y = new String[rowColorCount];
            n = rowColorCount;
            for (i = 0; i < n; ++i) {
                y[i] = x[base + i];
            }
            this._poolTableHeaderColor = y;
        }
        return "";
    }

    private void preparePages() {
        try {
            this.prepareGroupPages();
        }
        catch (Exception ee) {
            _log.warn(ee.toString(), (Throwable)ee);
        }
    }

    private void printEagle(StringBuffer sb) {
        this.printEagle(sb, "dCache ONLINE");
    }

    private void printEagle(StringBuffer sb, String headTitle) {
        sb.append("<html>\n<head><title>").append(headTitle).append("</title></head>\n");
        sb.append("<body ");
        if (this._bgType.equals("image")) {
            sb.append(" background=\"").append(this._bgImage).append("\" ");
        } else {
            sb.append(" bgcolor=\"").append(this._bgColor).append("\" ");
        }
        String linkColor = "link=\"" + this._linkColor + "\"";
        sb.append(linkColor).append(" v").append(linkColor).append(" a").append(linkColor).append(">\n");
        sb.append("<a href=\"/\"><img border=0 src=\"/images/eagleredtrans.gif\"></a>\n");
        sb.append("<br><font color=red>Birds Home</font>\n");
        sb.append("<center><img src=\"/images/eagle-grey.gif\"></center>\n");
        sb.append("<p>\n");
    }

    private String createTopIndexTable(Map classMap) {
        StringBuffer sb = new StringBuffer();
        this.printDirectoryTable(classMap, sb, 6, " ");
        return sb.toString();
    }

    private void prepareGroupPages() {
        HashMap<String, String> classMap = new HashMap<String, String>();
        for (Map.Entry entry : this._container._poolGroupClassHash.entrySet()) {
            String className = (String)entry.getKey();
            Map groupMap = (Map)entry.getValue();
            HashMap<String, RowInfoAdapter> totalGroupMap = new HashMap<String, RowInfoAdapter>();
            for (Map.Entry groupEntry : groupMap.entrySet()) {
                String groupName = (String)groupEntry.getKey();
                Map tableMap = (Map)groupEntry.getValue();
                int[][] total = this.calculateSum(tableMap, 5);
                StringBuffer sb = new StringBuffer();
                this.prepareBasicTable(sb, className, groupName, tableMap, total);
                String webPageName = this.storeWebPage(sb, className + "-" + groupName + ".html");
                totalGroupMap.put(groupName, new RowInfoAdapter(groupName, webPageName, total));
            }
            StringBuffer sbi = new StringBuffer();
            int[][] classTotal = this.calculateSum(totalGroupMap, 5);
            this.prepareBasicTable(sbi, "index", className, totalGroupMap, classTotal);
            String indexWebName = this.storeWebPage(sbi, "index-" + className + ".html");
            classMap.put(className, indexWebName);
        }
        this._topIndex = this.createTopIndexTable(classMap);
        this.printMainIndexPage(classMap);
    }

    private void printMainIndexPage(Map map) {
        StringBuffer sb = new StringBuffer();
        this.printEagle(sb, "dCache ONLINE : Pool Info Main Index");
        sb.append("<h1>Pool Info Summary Page for ").append(this._dCacheInstance).append("</h1>\n");
        sb.append("<br><br><blockquote>");
        sb.append("<h2>Pool Group Classes</h2>\n");
        this.printDirectoryTable(map, sb, 4, null);
        sb.append("</blockquote>\n");
        sb.append("<br><hr><br><address>").append(new Date().toString()).append("</address>");
        sb.append("</body></html>\n");
        this.storeWebPage(sb, "index.html");
    }

    private void printDirectoryTable(Map map, StringBuffer sb, int rows, String extras) {
        sb.append("<table border=0 cellpadding=4 cellspacing=4 width=\"90%\">\n");
        int item = 0;
        int percent = 100 / rows;
        extras = extras == null ? " bgcolor=\"gray\" " : extras;
        String itemDeco = "<td width=\"" + percent + "%\" " + extras + " align=center>";
        Iterator n = map.entrySet().iterator();
        while (n.hasNext()) {
            if (item % rows == 0) {
                sb.append("<tr>\n");
            }
            sb.append(itemDeco);
            Map.Entry e = n.next();
            sb.append("<h3>").append("<a href=\"").append(e.getValue().toString()).append("\" style=\"text-decoration: none\">").append(e.getKey().toString()).append("</a></h3></td>\n");
            if (item % rows == rows - 1) {
                sb.append("</tr>\n");
            }
            ++item;
        }
        if (item % rows != 0) {
            for (int i = item % rows; i < rows; ++i) {
                sb.append(itemDeco).append("&nbsp;</td>\n");
                if (item % rows != rows - 1) continue;
                sb.append("</tr>\n");
            }
        }
        sb.append("</table>\n");
    }

    private String storeWebPage(StringBuffer sb, String pageName) {
        String webPageName = this._webPrefix + "-" + pageName;
        this._nucleus.setDomainContext(webPageName, (Object)sb.toString());
        return webPageName;
    }

    private void prepareBasicTable(StringBuffer sb, String className, String groupName, Map tableMap, int[][] total) {
        _log.info("prepareBasicTable for " + className + " " + groupName + " map size " + tableMap.size());
        this.printEagle(sb, "dCache ONLINE : Pool Queues " + className + "/" + groupName);
        sb.append("<hr><center>").append(this._topIndex).append("</center><hr>");
        sb.append("<center><table border=0 width=\"90%%\">\n").append("<tr><td><h1><font color=black>").append(groupName).append("</font></h1></td></tr>\n").append("<tr><td><h4><font color=black> class = ").append(className).append("</font></h4></td></tr>\n").append("</table></center>\n");
        this.printPoolQueueTable(sb, tableMap, total);
        sb.append("<br><hr><br><address>").append(new Date().toString()).append("</address>");
        sb.append("</body>\n</html>\n");
        _log.info("prepareBasicTable : ready for " + className + " " + groupName);
    }

    private void printPoolActionTableHeader(StringBuffer sb, int position) {
        String[] colors = this._poolTableHeaderColor;
        String[] textColors = this._poolTableHeaderTextColor;
        String[] titles = new String[]{"Active", "Max", "Queued"};
        String[] titleColors = new String[]{colors[1], colors[1], colors[2]};
        int[] regularProgram = new int[]{0, 1, 2, 3};
        int[] reverseProgram = new int[]{0, 3, 2, 1};
        int[] middleProgram = new int[]{0, 3, 2, 1, 2, 3};
        int[] program = position == 0 ? regularProgram : (position == 1 ? middleProgram : reverseProgram);
        block6: for (int i = 0; i < program.length; ++i) {
            switch (program[i]) {
                case 0: {
                    int rowspan = program.length / 2;
                    sb.append("<tr>\n");
                    sb.append("<td rowspan=").append(rowspan).append(" valign=center bgcolor=\"").append(colors[3]).append("\" align=center><font color=\"").append(textColors[0]).append("\">").append("CellName").append("</font></td>\n");
                    sb.append("<td rowspan=").append(rowspan).append(" valign=center bgcolor=\"").append(colors[3]).append("\" align=center><font color=\"").append(textColors[0]).append("\">").append("DomainName").append("</font></td>\n");
                    continue block6;
                }
                case 1: {
                    for (int m = 0; m < this._poolTableHeaderTitles.length; ++m) {
                        sb.append("<td colspan=3 bgcolor=\"").append(colors[3]).append("\" align=center><font color=\"").append(textColors[0]).append("\">").append(this._poolTableHeaderTitles[m]).append("</font></td>\n");
                    }
                    sb.append("</tr>\n");
                    continue block6;
                }
                case 2: {
                    sb.append("<tr>");
                    continue block6;
                }
                case 3: {
                    for (int h = 0; h < this._poolTableHeaderTitles.length; ++h) {
                        for (int m = 0; m < 3; ++m) {
                            sb.append("<td bgcolor=\"").append(titleColors[m]).append("\" align=center><font color=\"").append(textColors[0]).append("\">").append(titles[m]).append("</font></td>\n");
                        }
                    }
                    sb.append("</tr>\n");
                }
            }
        }
    }

    private int[][] calculateSum(Map tableMap, int size) {
        int[][] total = new int[size][];
        for (int j = 0; j < total.length; ++j) {
            total[j] = new int[3];
        }
        Iterator n = tableMap.values().iterator();
        while (n.hasNext()) {
            int[][] status = ((RowInfo)n.next()).getRows();
            if (status == null) continue;
            for (int j = 0; j < total.length; ++j) {
                for (int l = 0; l < total[j].length; ++l) {
                    if (status[j] == null) continue;
                    int[] nArray = total[j];
                    int n2 = l;
                    nArray[n2] = nArray[n2] + status[j][l];
                }
            }
        }
        return total;
    }

    private synchronized void printPoolQueueTable(StringBuffer sb, Map tableMap, int[][] total) {
        TreeMap tree = new TreeMap(tableMap);
        sb.append("<center>\n<table border=1 cellpadding=4 cellspacing=0 width=\"90%\">\n");
        this.printPoolActionTableHeader(sb, 0);
        if (total != null) {
            this.printPoolActionTableTotals(sb, total);
        }
        Iterator n = tree.values().iterator();
        int i = 1;
        i = 1;
        while (n.hasNext()) {
            RowInfo e = (RowInfo)n.next();
            int[][] rows = e.getRows();
            if (rows == null) continue;
            this.printPoolActionRow(sb, e.getPrimaryName(), e.getSecondaryName(), e.getLinkName(), rows, this._rowColors[i % this._rowColors.length], this._rowTextColors);
            if (this._repeatHeader != 0 && i % this._repeatHeader == 0) {
                this.printPoolActionTableHeader(sb, 1);
            }
            ++i;
        }
        if (total != null) {
            this.printPoolActionTableTotals(sb, total);
        }
        if (i % this._repeatHeader > this._repeatHeader / 2) {
            this.printPoolActionTableHeader(sb, 2);
        }
        sb.append("</table></center>");
    }

    private void printPoolActionTableTotals(StringBuffer sb, int[][] total) {
        this.printPoolActionRow(sb, "Total", null, total, this._poolTableTotalColor, this._rowTotalTextColors);
    }

    private void printPoolActionRow(StringBuffer sb, String firstLabel, String secondLabel, int[][] rows, String color, String[] rowTextColors) {
        this.printPoolActionRow(sb, firstLabel, secondLabel, null, rows, color, rowTextColors);
    }

    private void printPoolActionRow(StringBuffer sb, String firstLabel, String secondLabel, String labelLink, int[][] rows, String color, String[] rowTextColors) {
        sb.append("<tr>\n");
        String colspan = secondLabel == null ? "colspan=2" : "";
        sb.append("<td bgcolor=\"").append(color).append("\" align=center ").append(colspan).append(">");
        if (labelLink == null) {
            sb.append(firstLabel);
        } else {
            sb.append("<a href=\"").append(labelLink).append("\">").append(firstLabel).append("</a>");
        }
        sb.append("</td>\n");
        if (secondLabel != null) {
            sb.append("<td bgcolor=\"" + color + "\" align=center>" + secondLabel + "</td>\n");
        }
        for (int j = 0; j < 5; ++j) {
            if (rows[j] == null) {
                sb.append("<td bgcolor=" + color + " align=center colspan=3>").append("<font color=\"").append(rowTextColors[1]).append("\">").append("Not available").append("</font>").append("</td>\n");
                continue;
            }
            for (int i = 0; i < rows[j].length; ++i) {
                sb.append("<td bgcolor=" + color + " align=center>").append("<font color=\"").append(i < 2 ? rowTextColors[0] : (rows[j][2] > 0 ? rowTextColors[1] : rowTextColors[2])).append("\">").append(rows[j][i]).append("</font>").append("</td>\n");
            }
        }
        sb.append("</tr>\n");
    }

    private class CellQueryInfo
    implements RowInfo {
        private String _destination = null;
        private long _diff = -1L;
        private long _start = 0L;
        private CellInfo _info = null;
        private CellMessage _message = null;
        private long _lastMessage = 0L;
        private int[][] _rows = null;

        private CellQueryInfo(String destination) {
            this._destination = destination;
            this._message = new CellMessage(new CellPath(this._destination), (Object)"xgetcellinfo");
        }

        private String getName() {
            return this._destination;
        }

        private CellInfo getCellInfo() {
            return this._info;
        }

        private long getPingTime() {
            return this._diff;
        }

        private CellMessage getCellMessage() {
            this._start = System.currentTimeMillis();
            return this._message;
        }

        private String getCellName() {
            return this._info.getCellName();
        }

        private String getDomainName() {
            return this._info.getDomainName();
        }

        private void infoArrived(CellInfo info) {
            this._info = info;
            this._lastMessage = System.currentTimeMillis();
            this._diff = this._lastMessage - this._start;
            if (info instanceof PoolCellInfo) {
                PoolCellInfo poolInfo = (PoolCellInfo)info;
                this._rows = PoolInfoObserverV1.this.decodePoolCostInfo(poolInfo.getPoolCostInfo());
            }
        }

        private boolean isOk() {
            return System.currentTimeMillis() - this._lastMessage < 3L * PoolInfoObserverV1.this._interval;
        }

        public String toString() {
            return "[" + this._destination + "(" + this._diff / 1000L + ")" + (this._info == null ? "NOINFO" : this._info.toString()) + ")]";
        }

        @Override
        public String getPrimaryName() {
            return this.getCellName();
        }

        @Override
        public int[][] getRows() {
            return this._rows;
        }

        @Override
        public String getSecondaryName() {
            return this.getDomainName();
        }

        @Override
        public String getLinkName() {
            return null;
        }
    }

    private static interface RowInfo {
        public int[][] getRows();

        public String getPrimaryName();

        public String getSecondaryName();

        public String getLinkName();
    }

    private class RowInfoAdapter
    implements RowInfo {
        private String _primary = null;
        private String _secondary = null;
        private int[][] _rows = null;
        private String _linkName = null;

        private RowInfoAdapter(String primary, String linkName, int[][] rows) {
            this._primary = primary;
            this._linkName = linkName;
            this._rows = rows;
        }

        @Override
        public String getPrimaryName() {
            return this._primary;
        }

        @Override
        public String getLinkName() {
            return this._linkName;
        }

        @Override
        public int[][] getRows() {
            return this._rows;
        }

        @Override
        public String getSecondaryName() {
            return this._secondary;
        }
    }

    private class CellInfoContainer {
        private Map _poolHash = new HashMap();
        private Map _patternHash = new HashMap();
        private Map _poolGroupClassHash = new HashMap();

        private CellInfoContainer() {
        }

        private void addInfo(String poolName, Object payload) {
            Map link = (Map)this._poolHash.get(poolName);
            if (link != null) {
                for (Map table : link.values()) {
                    table.put(poolName, payload);
                }
            }
            for (PatternEntry patternEntry : this._patternHash.values()) {
                if (!patternEntry.pattern.matcher(poolName).matches()) continue;
                link = patternEntry.linkMap;
                for (Map table : link.values()) {
                    table.put(poolName, payload);
                }
            }
        }

        private void addPool(String groupClass, String group, String poolName) {
            HashMap link;
            HashMap table;
            HashMap poolGroupMap = (HashMap)this._poolGroupClassHash.get(groupClass);
            if (poolGroupMap == null) {
                poolGroupMap = new HashMap();
                this._poolGroupClassHash.put(groupClass, poolGroupMap);
            }
            if ((table = (HashMap)poolGroupMap.get(group)) == null) {
                table = new HashMap();
                poolGroupMap.put(group, table);
            }
            if ((link = (HashMap)this._poolHash.get(poolName)) == null) {
                link = new HashMap();
                this._poolHash.put(poolName, link);
            }
            link.put(groupClass + ":" + group, table);
        }

        private void removePool(String groupClass, String group, String poolName) throws NoSuchElementException, IllegalStateException {
            Map poolGroupMap = (Map)this._poolGroupClassHash.get(groupClass);
            if (poolGroupMap == null) {
                throw new NoSuchElementException("groupClass not found : " + groupClass);
            }
            Map tableMap = (Map)poolGroupMap.get(group);
            if (tableMap == null) {
                throw new NoSuchElementException("group not found : " + group);
            }
            Map link = (Map)this._poolHash.get(poolName);
            if (link == null) {
                throw new NoSuchElementException("pool not found : " + poolName);
            }
            tableMap = (Map)link.remove(groupClass + ":" + group);
            if (tableMap == null) {
                throw new IllegalStateException("not found in link map : " + groupClass + ":" + group);
            }
            tableMap.remove(poolName);
        }

        public void removePoolGroup(String className, String groupName) {
            Map groupMap = (Map)this._poolGroupClassHash.get(className);
            if (groupMap == null) {
                throw new NoSuchElementException("not found : " + className);
            }
            Map tableMap = (Map)groupMap.remove(groupName);
            if (tableMap == null) {
                throw new NoSuchElementException("not found : " + groupName);
            }
            String d = className + ":" + groupName;
            for (Map.Entry entry : this._poolHash.entrySet()) {
                String poolName = entry.getKey().toString();
                Map link = (Map)entry.getValue();
                for (Map.Entry domain : link.entrySet()) {
                    String domainName = (String)domain.getKey();
                    Map table = (Map)domain.getValue();
                }
            }
        }

        private void addPattern(String groupClass, String group, String patternName, String pattern) {
            PatternEntry patternEntry;
            HashMap table;
            HashMap poolGroupMap = (HashMap)this._poolGroupClassHash.get(groupClass);
            if (poolGroupMap == null) {
                poolGroupMap = new HashMap();
                this._poolGroupClassHash.put(groupClass, poolGroupMap);
            }
            if ((table = (HashMap)poolGroupMap.get(group)) == null) {
                table = new HashMap();
                poolGroupMap.put(group, table);
            }
            if ((patternEntry = (PatternEntry)this._patternHash.get(patternName)) == null) {
                if (pattern == null) {
                    throw new IllegalArgumentException("patterName is new, so we need pattern");
                }
                patternEntry = new PatternEntry(Pattern.compile(pattern));
                this._patternHash.put(patternName, patternEntry);
            } else if (pattern != null && !patternEntry.pattern.pattern().equals(pattern)) {
                throw new IllegalArgumentException("Conflict in pattern (name in use with different pattern)");
            }
            Map link = patternEntry.linkMap;
            link.put(groupClass + ":" + group, table);
        }

        private void removePattern(String groupClass, String group, String patternName) {
            Map poolGroupMap = (Map)this._poolGroupClassHash.get(groupClass);
            if (poolGroupMap == null) {
                throw new NoSuchElementException("groupClass not found : " + groupClass);
            }
            Map tableMap = (Map)poolGroupMap.get(group);
            if (tableMap == null) {
                throw new NoSuchElementException("group not found : " + group);
            }
            PatternEntry patternEntry = (PatternEntry)this._patternHash.get(patternName);
            if (patternEntry == null) {
                throw new NoSuchElementException("patternName not found : " + patternName);
            }
            Map link = patternEntry.linkMap;
            tableMap = (Map)link.remove(groupClass + ":" + group);
            if (tableMap == null) {
                throw new IllegalStateException("not found in link map : " + groupClass + ":" + group);
            }
            ArrayList<String> toBeRemoved = new ArrayList<String>();
            for (String poolName : tableMap.keySet()) {
                if (!patternEntry.pattern.matcher(poolName).matches()) continue;
                toBeRemoved.add(poolName);
            }
            Iterator<Object> it = toBeRemoved.iterator();
            while (it.hasNext()) {
                tableMap.remove(it.next());
            }
        }

        private String getInfo() {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry entry : this._poolGroupClassHash.entrySet()) {
                String className = (String)entry.getKey();
                Map groupMap = (Map)entry.getValue();
                sb.append("Class : ").append(className).append("\n");
                for (Map.Entry groupEntry : groupMap.entrySet()) {
                    String groupName = (String)groupEntry.getKey();
                    Map tableMap = (Map)groupEntry.getValue();
                    sb.append("   Group : ").append(groupName).append("\n");
                    this.printTable(sb, "            ", tableMap);
                }
            }
            sb.append("PoolHash :\n");
            for (Map.Entry entry : this._poolHash.entrySet()) {
                String poolName = entry.getKey().toString();
                Map link = (Map)entry.getValue();
                sb.append("  ").append(poolName).append("\n");
                for (Map.Entry domain : link.entrySet()) {
                    String domainName = (String)domain.getKey();
                    Map table = (Map)domain.getValue();
                    sb.append("     ").append(domainName).append("\n");
                    this.printTable(sb, "           ", table);
                }
            }
            sb.append("Pattern List :\n");
            for (Map.Entry entry : this._patternHash.entrySet()) {
                String patternName = entry.getKey().toString();
                PatternEntry patternEntry = (PatternEntry)entry.getValue();
                Pattern pattern = patternEntry.pattern;
                Map link = patternEntry.linkMap;
                sb.append("  ").append(patternName).append("(").append(pattern.pattern()).append(")").append("\n");
                for (Map.Entry domain : link.entrySet()) {
                    String domainName = (String)domain.getKey();
                    Map table = (Map)domain.getValue();
                    sb.append("     ").append(domainName).append("\n");
                    this.printTable(sb, "           ", table);
                }
            }
            return sb.toString();
        }

        private void printTable(StringBuffer sb, String prefix, Map table) {
            for (Map.Entry tableEntry : table.entrySet()) {
                String pn = (String)tableEntry.getKey();
                String tc = tableEntry.getValue().toString();
                sb.append(prefix).append(pn).append(" -> ").append(tc).append("\n");
            }
        }

        private class PatternEntry {
            private Map linkMap = new HashMap();
            private Pattern pattern = null;

            private PatternEntry(Pattern pattern) {
                this.pattern = pattern;
            }

            public String toString() {
                return this.pattern.pattern() + " " + this.linkMap.toString();
            }
        }
    }
}

