/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.web;

import diskCacheV111.services.web.CellInfoTableWriter;
import diskCacheV111.services.web.PoolCellQueryContainer;
import diskCacheV111.services.web.PoolCellQueryInfo;
import diskCacheV111.services.web.PoolGroupInfoTableWriter;
import diskCacheV111.services.web.PoolInfoTableWriter;
import diskCacheV111.services.web.PoolQueueTableWriter;
import diskCacheV111.util.HTMLWriter;
import dmg.cells.nucleus.CellNucleus;
import dmg.util.HttpException;
import dmg.util.HttpRequest;
import dmg.util.HttpResponseEngine;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PoolInfoObserverEngineV2
implements HttpResponseEngine {
    private static final int _menuColumns = 4;
    private final CellNucleus _nucleus;
    private final Map<String, String> _tableSelection = new LinkedHashMap<String, String>();
    private boolean _showPoolGroupUsage = false;
    private int _errorCounter = 0;
    private int _requestCounter = 0;
    private PoolCellQueryContainer _container;

    public PoolInfoObserverEngineV2(CellNucleus nucleus, String[] args) {
        this._nucleus = nucleus;
        for (String s : args) {
            if (!s.startsWith("showPoolGroupUsage=")) continue;
            this._showPoolGroupUsage = s.substring("showPoolGroupUsage=".length()).equals("true");
        }
        this._tableSelection.put("Cell View", "cells");
        this._tableSelection.put("Space Usage", "spaces");
        this._tableSelection.put("Request Queues", "queues");
    }

    public void startup() {
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryUrl(HttpRequest request) throws HttpException {
        String[] urlItems = request.getRequestTokens();
        int offset = request.getRequestTokenOffset();
        OutputStream out = request.getOutputStream();
        ++this._requestCounter;
        request.printHttpHeader(0);
        HTMLWriter html = new HTMLWriter(out, (Map<String, Object>)this._nucleus.getDomainContext());
        try {
            html.addHeader("/styles/poolinfo.css", "Pool Property Tables");
            if (urlItems.length < 1) {
                return;
            }
            if (urlItems.length > 1 && urlItems[1].equals("list")) {
                Object o = this._nucleus.getDomainContext("poolgroup-map.ser");
                if (o == null) {
                    html.println("<h3>Information not yet available</h3>");
                    return;
                }
                if (!(o instanceof PoolCellQueryContainer)) {
                    html.println("<h3>Internal error: poolgroup-map.ser contains unknown class</h3>");
                    return;
                }
                this._container = (PoolCellQueryContainer)o;
                String className = urlItems.length > 2 ? urlItems[2] : null;
                String groupName = urlItems.length > 3 ? urlItems[3] : null;
                String selection = urlItems.length > 4 ? urlItems[4] : null;
                this.printClassMenu(html, className);
                if (className == null) {
                    return;
                }
                if (this._showPoolGroupUsage) {
                    this.printGroupList(html, className);
                } else {
                    this.printGroupMenu(html, className, groupName);
                }
                if (groupName == null) {
                    return;
                }
                html.println("<h3>Pool group <emph>" + groupName + "</emph></h3>");
                this.printMenuTable(html, this._tableSelection.entrySet(), "/pools/list/" + className + "/" + groupName + "/", selection);
                if (selection == null) {
                    return;
                }
                Map<String, PoolCellQueryInfo> poolMap = this._container.getPoolMap(className, groupName);
                if (poolMap == null) {
                    return;
                }
                if (selection.equals("cells")) {
                    this.printCells(html, poolMap);
                } else if (selection.equals("spaces")) {
                    this.printPools(html, poolMap);
                } else if (selection.equals("queues")) {
                    this.printPoolActions(html, poolMap);
                }
            }
        }
        catch (Exception e) {
            ++this._errorCounter;
            this.showProblem(html, e.getMessage());
            html.println("<ul>");
            for (int i = 0; i < urlItems.length; ++i) {
                html.println("<li> [" + i + "] " + urlItems[i] + "</li>");
            }
            html.println("</ul>");
        }
        finally {
            html.addFooter(this.getClass().getName() + " [$Rev$]");
        }
    }

    private void printPoolActions(HTMLWriter html, Map poolMap) {
        PoolQueueTableWriter writer = new PoolQueueTableWriter(html);
        writer.print(new TreeMap(poolMap).values());
    }

    private void printPools(HTMLWriter html, Map poolMap) {
        PoolInfoTableWriter writer = new PoolInfoTableWriter(html);
        writer.print(new TreeMap(poolMap).values(), !this._showPoolGroupUsage);
    }

    private void printCells(HTMLWriter html, Map poolMap) {
        CellInfoTableWriter writer = new CellInfoTableWriter(html);
        writer.print(new TreeMap(poolMap).values());
    }

    private void printClassMenu(HTMLWriter pw, String className) {
        Set<String> classSet = this._container.getPoolClassSet();
        pw.println("<h3>Pool Views</h3>");
        this.printMenuTable(pw, classSet, "/pools/list/", className);
    }

    private void printGroupMenu(HTMLWriter pw, String className, String groupName) {
        Set<String> groupSet = this._container.getPoolGroupSetByClassName(className);
        if (groupSet != null) {
            pw.println("<h3>Pool groups of <emph>" + className + "</emph></h3>");
            this.printMenuTable(pw, groupSet, "/pools/list/" + className + "/", groupName);
        }
    }

    private void printGroupList(HTMLWriter html, String className) {
        Set<String> groupSet = this._container.getPoolGroupSetByClassName(className);
        if (groupSet != null) {
            html.println("<h3>Pool groups of <emph>" + className + "</emph></h3>");
            TreeMap<String, Collection<PoolCellQueryInfo>> info = new TreeMap<String, Collection<PoolCellQueryInfo>>();
            for (String group : groupSet) {
                info.put(group, this._container.getPoolMap(className, group).values());
            }
            PoolGroupInfoTableWriter writer = new PoolGroupInfoTableWriter(html);
            writer.print("/pools/list/" + className + "/", info);
        }
    }

    private void printMenuTable(HTMLWriter html, Set itemSet, String linkBase, String currentItem) {
        html.beginTable("menu", new String[0]);
        if (!itemSet.isEmpty()) {
            html.beginRow(new String[0]);
            int n = 0;
            for (Object o : itemSet) {
                String name;
                String linkName;
                if (n > 0 && n % 4 == 0) {
                    html.endRow();
                    html.beginRow(new String[0]);
                }
                ++n;
                if (o instanceof String) {
                    name = linkName = (String)o;
                } else {
                    Map.Entry e = (Map.Entry)o;
                    name = (String)e.getKey();
                    linkName = (String)e.getValue();
                }
                boolean active = currentItem != null && currentItem.equals(linkName);
                html.td(active ? "active" : null, "<a href=\"", linkBase, linkName, "/\">", name, "</a>");
            }
            while (n++ % 4 != 0) {
                html.td(null, new Object[0]);
            }
            html.endRow();
        }
        html.endTable();
    }

    private void showProblem(PrintWriter pw, String message) {
        pw.print("<h1><emph>");
        pw.print(message);
        pw.println("<emph></h1>");
    }
}

