/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.web;

import diskCacheV111.services.web.PoolCellQueryInfo;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class PoolCellQueryContainer
implements Serializable {
    private SortedMap<String, PoolCellQueryInfo> _infoMap = new TreeMap<String, PoolCellQueryInfo>();
    private Map<String, Map<String, Map<String, PoolCellQueryInfo>>> _topology;

    public void put(String name, PoolCellQueryInfo info) {
        this._infoMap.put(name, info);
    }

    public PoolCellQueryInfo getInfoByName(String name) {
        return (PoolCellQueryInfo)this._infoMap.get(name);
    }

    public void setTopology(Map topology) {
        this._topology = topology;
    }

    public Set<String> getPoolClassSet() {
        return this._topology.keySet();
    }

    public Set<String> getPoolGroupSetByClassName(String className) {
        Map<String, Map<String, PoolCellQueryInfo>> map = this._topology.get(className);
        if (map == null) {
            return null;
        }
        return map.keySet();
    }

    public Map<String, PoolCellQueryInfo> getPoolMap(String className, String groupName) {
        Map<String, Map<String, PoolCellQueryInfo>> groupMap = this._topology.get(className);
        if (groupMap == null) {
            return null;
        }
        return groupMap.get(groupName);
    }

    public Map<String, Map<String, Map<String, PoolCellQueryInfo>>> getTopology() {
        return this._topology;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<String, Map<String, PoolCellQueryInfo>>> classes : this._topology.entrySet()) {
            String className = classes.getKey();
            sb.append(" ").append(className).append("\n");
            for (Map.Entry<String, Map<String, PoolCellQueryInfo>> groups : classes.getValue().entrySet()) {
                String groupName = groups.getKey();
                sb.append("  ").append(groupName).append("\n");
                for (Map.Entry<String, PoolCellQueryInfo> pools : groups.getValue().entrySet()) {
                    String poolName = pools.getKey();
                    PoolCellQueryInfo info = pools.getValue();
                    sb.append("    ").append(poolName).append(info.toString()).append("\n");
                }
            }
        }
        return sb.toString();
    }
}

