/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.web;

import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.services.web.PoolCellQueryInfo;
import diskCacheV111.util.HTMLWriter;
import dmg.cells.nucleus.CellInfo;
import java.text.SimpleDateFormat;
import java.util.Collection;

public class CellInfoTableWriter {
    private final SimpleDateFormat _formatter = new SimpleDateFormat("MM/dd HH:mm:ss");
    private final HTMLWriter _html;

    public CellInfoTableWriter(HTMLWriter html) {
        this._html = html;
    }

    public void print(Collection<PoolCellQueryInfo> itemSet) {
        this._html.beginTable("sortable", "cell", "CellName", "domain", "DomainName", "rp", "RP", "th", "TH", "ping", "Ping", "time", "Creation Time", "version", "Version");
        for (PoolCellQueryInfo i : itemSet) {
            try {
                PoolCellQueryInfo info = i;
                PoolCellInfo cellInfo = info.getPoolCellInfo();
                long pingTime = info.getPingTime();
                if (info.isOk()) {
                    this.printCellInfoRow(cellInfo, pingTime);
                    continue;
                }
                this.printOfflineCellInfoRow(cellInfo.getCellName(), cellInfo.getDomainName().length() == 0 ? "&lt;unknown&gt" : cellInfo.getDomainName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this._html.endTable();
    }

    private void printOfflineCellInfoRow(String name, String domain) {
        this._html.beginRow(null, "odd");
        this._html.td("cell", name);
        this._html.td("domain", domain);
        this._html.td(5, "offline", "OFFLINE");
        this._html.endRow();
    }

    private void printCellInfoRow(CellInfo info, long ping) {
        this._html.beginRow(null, "odd");
        this._html.td("cell", info.getCellName());
        this._html.td("domain", info.getDomainName());
        this._html.td("rp", info.getEventQueueSize());
        this._html.td("th", info.getThreadCount());
        this._html.td("ping", ping + " msec");
        this._html.td("time", this._formatter.format(info.getCreationTime()));
        try {
            this._html.td("version", info.getCellVersion());
        }
        catch (NoSuchMethodError e) {
            this._html.td("version", "not-implemented");
        }
        this._html.endRow();
    }
}

