/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class SpaceState
implements Serializable {
    private final String name;
    private final int stateId;
    public static final SpaceState RESERVED = new SpaceState("RESERVED", 0);
    public static final SpaceState RELEASED = new SpaceState("RELEASED", 1);
    public static final SpaceState EXPIRED = new SpaceState("EXPIRED", 2);

    private SpaceState(String name, int stateId) {
        this.name = name;
        this.stateId = stateId;
    }

    public static SpaceState[] getAllStates() {
        return new SpaceState[]{RESERVED, RELEASED, EXPIRED};
    }

    public String toString() {
        return this.name;
    }

    public int getStateId() {
        return this.stateId;
    }

    public static SpaceState getState(String state) throws IllegalArgumentException {
        if (state == null || state.equalsIgnoreCase("null")) {
            throw new NullPointerException(" null state ");
        }
        if (SpaceState.RESERVED.name.equals(state)) {
            return RESERVED;
        }
        if (SpaceState.RELEASED.name.equals(state)) {
            return RELEASED;
        }
        if (SpaceState.EXPIRED.name.equals(state)) {
            return EXPIRED;
        }
        try {
            int stateId = Integer.parseInt(state);
            return SpaceState.getState(stateId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown State");
        }
    }

    public static SpaceState getState(int stateId) throws IllegalArgumentException {
        if (SpaceState.RESERVED.stateId == stateId) {
            return RESERVED;
        }
        if (SpaceState.RELEASED.stateId == stateId) {
            return RELEASED;
        }
        if (SpaceState.EXPIRED.stateId == stateId) {
            return EXPIRED;
        }
        throw new IllegalArgumentException("Unknown State Id");
    }

    public static boolean isFinalState(SpaceState state) {
        return state == RELEASED || state == EXPIRED;
    }

    public Object readResolve() throws ObjectStreamException {
        return SpaceState.getState(this.stateId);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

