/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import diskCacheV111.services.space.LinkGroup;
import diskCacheV111.services.space.Space;
import diskCacheV111.services.space.SpaceAuthorizationException;
import diskCacheV111.services.space.SpaceManagerAuthorizationPolicy;
import diskCacheV111.util.VOInfo;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.auth.FQAN;
import org.dcache.auth.GroupList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSpaceManagerAuthorizationPolicy
implements SpaceManagerAuthorizationPolicy {
    private static Logger logger = LoggerFactory.getLogger(SimpleSpaceManagerAuthorizationPolicy.class);

    @Override
    public void checkReleasePermission(AuthorizationRecord authRecord, Space space) throws SpaceAuthorizationException {
        String spaceGroup = space.getVoGroup();
        String spaceRole = space.getVoRole();
        if ((spaceGroup == null || spaceGroup.equals(authRecord.getVoGroup())) && (spaceRole == null || spaceRole.equals(authRecord.getVoRole()))) {
            if (logger.isDebugEnabled()) {
                logger.debug("userGroup : " + authRecord.getVoGroup() + ", userRole : " + authRecord.getVoRole() + " have permission to release ");
            }
            return;
        }
        for (GroupList groupList : authRecord.getGroupLists()) {
            String userRole;
            String userGroup;
            String attribute = groupList.getAttribute();
            if (attribute == null) continue;
            if (FQAN.isValid((String)attribute)) {
                FQAN fqan = new FQAN(attribute);
                userGroup = fqan.getGroup();
                userRole = fqan.getRole();
            } else {
                userGroup = attribute;
                userRole = "";
            }
            if (spaceGroup != null && !spaceGroup.equals(userGroup) || spaceRole != null && !spaceRole.equals(userRole)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("userGroup : " + userGroup + ", userRole : " + userRole + " have permission to release ");
            }
            return;
        }
        throw new SpaceAuthorizationException("user with " + authRecord + " has no permission to release " + space);
    }

    @Override
    public VOInfo checkReservePermission(AuthorizationRecord authRecord, LinkGroup linkGroup) throws SpaceAuthorizationException {
        VOInfo[] voInfos;
        for (VOInfo voInfo : voInfos = linkGroup.getVOs()) {
            String userRole;
            String userGroup = authRecord.getVoGroup();
            if (voInfo.match(userGroup, userRole = authRecord.getVoRole())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("userGroup : " + userGroup + ", userRole : " + userRole + " have permission to reserve ");
                }
                return new VOInfo(userGroup, userRole);
            }
            for (GroupList groupList : authRecord.getGroupLists()) {
                String attribute = groupList.getAttribute();
                if (attribute == null) continue;
                if (FQAN.isValid((String)attribute)) {
                    FQAN fqan = new FQAN(attribute);
                    userGroup = fqan.getGroup();
                    userRole = fqan.getRole();
                } else {
                    userGroup = attribute;
                    userRole = "";
                }
                if (!voInfo.match(userGroup, userRole) || !logger.isDebugEnabled()) continue;
                logger.debug("userGroup : " + userGroup + ", userRole : " + userRole + " have permission to reserve ");
                return new VOInfo(userGroup, userRole);
            }
        }
        throw new SpaceAuthorizationException("user with " + authRecord + " has no permission to reserve in " + linkGroup);
    }
}

