/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class LinkState
implements Serializable {
    private final String name;
    private final int stateId;
    public static final LinkState RESERVED = new LinkState("Reserved", 0);
    public static final LinkState TRANSFERRING = new LinkState("Transferring", 1);
    public static final LinkState STORED = new LinkState("Stored", 2);

    private LinkState(String name, int stateId) {
        this.name = name;
        this.stateId = stateId;
    }

    public static LinkState[] getAllStates() {
        return new LinkState[]{RESERVED, TRANSFERRING, STORED};
    }

    public String toString() {
        return this.name;
    }

    public int getStateId() {
        return this.stateId;
    }

    public static LinkState getState(String state) throws IllegalArgumentException {
        if (state == null || state.equalsIgnoreCase("null")) {
            throw new NullPointerException(" null state ");
        }
        if (LinkState.RESERVED.name.equals(state)) {
            return RESERVED;
        }
        if (LinkState.TRANSFERRING.name.equals(state)) {
            return TRANSFERRING;
        }
        if (LinkState.STORED.name.equals(state)) {
            return STORED;
        }
        try {
            int stateId = Integer.parseInt(state);
            return LinkState.getState(stateId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown State");
        }
    }

    public static LinkState getState(int stateId) throws IllegalArgumentException {
        if (LinkState.RESERVED.stateId == stateId) {
            return RESERVED;
        }
        if (LinkState.TRANSFERRING.stateId == stateId) {
            return TRANSFERRING;
        }
        if (LinkState.STORED.stateId == stateId) {
            return STORED;
        }
        throw new IllegalArgumentException("Unknown State Id");
    }

    public static boolean isFinalState(LinkState state) {
        return state == STORED;
    }

    public Object readResolve() throws ObjectStreamException {
        return LinkState.getState(this.stateId);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

