/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import diskCacheV111.services.space.LinkGroup;
import diskCacheV111.util.IoPackage;
import diskCacheV111.util.VOInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class LinkGroupIO
extends IoPackage<LinkGroup> {
    public static final String LINKGROUP_TABLE = "srmLinkGroup".toLowerCase();
    public static final String LINKGROUP_VO_TABLE = "srmLinkGroupVOs".toLowerCase();
    public static final String INSERT = "INSERT INTO " + LINKGROUP_TABLE + " (id, name, freeSpaceInBytes, lastUpdateTime, onlineAllowed," + " nearlineAllowed, replicaAllowed, outputAllowed, custodialAllowed,reservedspaceinbytes)" + " VALUES ( ?,?,?,?,?,?,?,?,?,?)";
    public static final String INSERT_LINK_GROUP_VO = "INSERT INTO " + LINKGROUP_VO_TABLE + " (linkgroupid,voGroup,voRole) VALUES (?,?,?) ";
    public static final String SELECT_LINKGROUP_FOR_UPDATE_BY_NAME = "SELECT * FROM " + LINKGROUP_TABLE + " WHERE  name = ? FOR UPDATE";
    public static final String SELECT_LINKGROUP_FOR_UPDATE_BY_ID = "SELECT * FROM " + LINKGROUP_TABLE + " WHERE  id = ? FOR UPDATE";
    public static final String SELECT_LINKGROUP_INFO_FOR_UPDATE = "SELECT * FROM " + LINKGROUP_TABLE + " WHERE  id = ? and freespaceinbytes-reservedspaceinbytes>=? FOR UPDATE";
    public static final String SELECT_LINKGROUP_BY_ID = "SELECT * FROM " + LINKGROUP_TABLE + " WHERE  id = ?";
    public static final String SELECT_LINKGROUP_BY_NAME = "SELECT * FROM " + LINKGROUP_TABLE + " WHERE  name = ?";
    public static final String SELECT_LINKGROUP_VO = "SELECT voGroup,voRole FROM " + LINKGROUP_VO_TABLE + " WHERE linkGroupId=?";
    public static final String SELECT_CURRENT_LINKGROUPS = "SELECT * FROM " + LINKGROUP_TABLE + " where lastUpdateTime >= ?";
    public static final String SELECT_ALL_LINKGROUPS = "SELECT * FROM " + LINKGROUP_TABLE;
    public static final String DECREMENT_RESERVED_SPACE = "UPDATE " + LINKGROUP_TABLE + " SET reservedspaceinbytes = reservedspaceinbytes - ? where id=?";
    public static final String INCREMENT_RESERVED_SPACE = "UPDATE " + LINKGROUP_TABLE + " SET reservedspaceinbytes = reservedspaceinbytes + ? where id=?";
    public static final String DECREMENT_FREE_SPACE = "UPDATE " + LINKGROUP_TABLE + " SET freespaceinbytes = freespaceinbytes - ? where id=?";
    public static final String INCREMENT_FREE_SPACE = "UPDATE " + LINKGROUP_TABLE + " SET freespaceinbytes = freespaceinbytes + ? where id=?";
    public static final String UPDATE = "UPDATE " + LINKGROUP_TABLE + " SET freeSpaceInBytes=?,lastUpdateTime=?,onlineAllowed=?,nearlineAllowed=?," + "replicaAllowed=?,outputAllowed=?,custodialAllowed=? WHERE  id = ?";
    public static final String SELECT_ALL = "SELECT * FROM " + LINKGROUP_TABLE;

    @Override
    public Set<LinkGroup> select(Connection connection, String txt) throws SQLException {
        HashSet<LinkGroup> container = new HashSet<LinkGroup>();
        Statement stmt = connection.createStatement();
        ResultSet set = stmt.executeQuery(txt);
        while (set.next()) {
            LinkGroup lg = new LinkGroup();
            long id = set.getLong("id");
            lg.setId(id);
            lg.setName(set.getString("name"));
            lg.setFreeSpace(set.getLong("freeSpaceInBytes"));
            lg.setUpdateTime(set.getLong("lastUpdateTime"));
            lg.setOnlineAllowed(set.getBoolean("onlineAllowed"));
            lg.setNearlineAllowed(set.getBoolean("nearlineAllowed"));
            lg.setReplicaAllowed(set.getBoolean("replicaAllowed"));
            lg.setOutputAllowed(set.getBoolean("outputAllowed"));
            lg.setCustodialAllowed(set.getBoolean("custodialAllowed"));
            lg.setReservedSpaceInBytes(set.getLong("reservedspaceinbytes"));
            PreparedStatement s = connection.prepareStatement(SELECT_LINKGROUP_VO);
            s.setLong(1, id);
            ResultSet vos = s.executeQuery();
            HashSet<VOInfo> volist = new HashSet<VOInfo>();
            while (vos.next()) {
                volist.add(new VOInfo(vos.getString("vogroup"), vos.getString("vorole")));
            }
            lg.setVOs(volist.toArray(new VOInfo[0]));
            container.add(lg);
            s.close();
        }
        stmt.close();
        return container;
    }

    @Override
    public Set<LinkGroup> selectPrepared(Connection connection, PreparedStatement statement) throws SQLException {
        HashSet<LinkGroup> container = new HashSet<LinkGroup>();
        ResultSet set = statement.executeQuery();
        while (set.next()) {
            LinkGroup lg = new LinkGroup();
            long id = set.getLong("id");
            lg.setId(id);
            lg.setName(set.getString("name"));
            lg.setFreeSpace(set.getLong("freeSpaceInBytes"));
            lg.setUpdateTime(set.getLong("lastUpdateTime"));
            lg.setOnlineAllowed(set.getBoolean("onlineAllowed"));
            lg.setNearlineAllowed(set.getBoolean("nearlineAllowed"));
            lg.setReplicaAllowed(set.getBoolean("replicaAllowed"));
            lg.setOutputAllowed(set.getBoolean("outputAllowed"));
            lg.setCustodialAllowed(set.getBoolean("custodialAllowed"));
            lg.setReservedSpaceInBytes(set.getLong("reservedspaceinbytes"));
            PreparedStatement s = statement.getConnection().prepareStatement(SELECT_LINKGROUP_VO);
            s.setLong(1, id);
            ResultSet vos = s.executeQuery();
            HashSet<VOInfo> volist = new HashSet<VOInfo>();
            while (vos.next()) {
                volist.add(new VOInfo(vos.getString("vogroup"), vos.getString("vorole")));
            }
            lg.setVOs(volist.toArray(new VOInfo[0]));
            container.add(lg);
            s.close();
        }
        return container;
    }
}

