/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class FileState
implements Serializable {
    private final String name;
    private final int stateId;
    public static final FileState RESERVED = new FileState("Reserved", 0);
    public static final FileState TRANSFERRING = new FileState("Transferring", 1);
    public static final FileState STORED = new FileState("Stored", 2);
    public static final FileState FLUSHED = new FileState("Flushed", 3);

    private FileState(String name, int stateId) {
        this.name = name;
        this.stateId = stateId;
    }

    public static FileState[] getAllStates() {
        return new FileState[]{RESERVED, TRANSFERRING, STORED, FLUSHED};
    }

    public String toString() {
        return this.name;
    }

    public int getStateId() {
        return this.stateId;
    }

    public static FileState getState(String state) throws IllegalArgumentException {
        if (state == null || state.equalsIgnoreCase("null")) {
            throw new NullPointerException(" null state ");
        }
        if (FileState.RESERVED.name.equals(state)) {
            return RESERVED;
        }
        if (FileState.TRANSFERRING.name.equals(state)) {
            return TRANSFERRING;
        }
        if (FileState.STORED.name.equals(state)) {
            return STORED;
        }
        if (FileState.FLUSHED.name.equals(state)) {
            return FLUSHED;
        }
        try {
            int stateId = Integer.parseInt(state);
            return FileState.getState(stateId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown State");
        }
    }

    public static FileState getState(int stateId) throws IllegalArgumentException {
        if (FileState.RESERVED.stateId == stateId) {
            return RESERVED;
        }
        if (FileState.TRANSFERRING.stateId == stateId) {
            return TRANSFERRING;
        }
        if (FileState.STORED.stateId == stateId) {
            return STORED;
        }
        if (FileState.FLUSHED.stateId == stateId) {
            return FLUSHED;
        }
        throw new IllegalArgumentException("Unknown State Id");
    }

    public static boolean isFinalState(FileState state) {
        return state == FLUSHED;
    }

    public Object readResolve() throws ObjectStreamException {
        return FileState.getState(this.stateId);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

