/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services;

import diskCacheV111.doors.FTPTransactionLog;
import diskCacheV111.services.TransferManager;
import diskCacheV111.services.TransferManagerHandlerState;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.DoorRequestInfoMessage;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.IpProtocolInfo;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PnfsCreateEntryMessage;
import diskCacheV111.vehicles.PnfsDeleteEntryMessage;
import diskCacheV111.vehicles.PnfsGetFileMetaDataMessage;
import diskCacheV111.vehicles.PnfsGetStorageInfoMessage;
import diskCacheV111.vehicles.PoolAcceptFileMessage;
import diskCacheV111.vehicles.PoolDeliverFileMessage;
import diskCacheV111.vehicles.PoolIoFileMessage;
import diskCacheV111.vehicles.PoolMgrSelectPoolMsg;
import diskCacheV111.vehicles.PoolMgrSelectReadPoolMsg;
import diskCacheV111.vehicles.PoolMgrSelectWritePoolMsg;
import diskCacheV111.vehicles.PoolMoverKillMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.transferManager.CancelTransferMessage;
import diskCacheV111.vehicles.transferManager.TransferCompleteMessage;
import diskCacheV111.vehicles.transferManager.TransferFailedMessage;
import diskCacheV111.vehicles.transferManager.TransferManagerMessage;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Set;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.LongIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import javax.security.auth.Subject;
import org.dcache.acl.enums.AccessMask;
import org.dcache.auth.Subjects;
import org.dcache.namespace.ACLPermissionHandler;
import org.dcache.namespace.ChainedPermissionHandler;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.PermissionHandler;
import org.dcache.namespace.PosixPermissionHandler;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferManagerHandler
implements CellMessageAnswerable,
Detachable,
PersistenceCapable {
    private static final Logger log = LoggerFactory.getLogger(TransferManagerHandler.class);
    private final TransferManager manager;
    private TransferManagerMessage transferRequest;
    private CellPath sourcePath;
    private String pnfsPath;
    private transient String parentDir;
    boolean store;
    boolean created;
    private PnfsId pnfsId;
    private String pnfsIdString;
    private String remoteUrl;
    private StorageInfo storageInfo;
    transient boolean locked;
    private String pool;
    private FTPTransactionLog tlog;
    private FileAttributes fileAttributes;
    public static final int INITIAL_STATE = 0;
    public static final int WAITING_FOR_PNFS_INFO_STATE = 1;
    public static final int RECEIVED_PNFS_INFO_STATE = 2;
    public static final int WAITING_FOR_PNFS_ENTRY_CREATION_INFO_STATE = 5;
    public static final int RECEIVED_PNFS_ENTRY_CREATION_INFO_STATE = 6;
    public static final int WAITING_FOR_POOL_INFO_STATE = 7;
    public static final int RECEIVED_POOL_INFO_STATE = 8;
    public static final int WAITING_FIRST_POOL_REPLY_STATE = 9;
    public static final int RECEIVED_FIRST_POOL_REPLY_STATE = 10;
    public static final int WAITING_FOR_SPACE_INFO_STATE = 11;
    public static final int RECEIVED_SPACE_INFO_STATE = 12;
    public static final int WAITING_FOR_PNFS_ENTRY_DELETE = 13;
    public static final int RECEIVED_PNFS_ENTRY_DELETE = 14;
    public static final int WAITING_FOR_PNFS_CHECK_BEFORE_DELETE_STATE = 15;
    public static final int RECEIVED_PNFS_CHECK_BEFORE_DELETE_STATE = 16;
    public static final int SENT_ERROR_REPLY_STATE = -1;
    public static final int SENT_SUCCESS_REPLY_STATE = -2;
    public int state;
    private long id;
    private Integer moverId;
    private IpProtocolInfo protocol_info;
    private String spaceReservationId;
    private transient Long size;
    private transient boolean space_reservation_strict;
    private long creationTime;
    private long lifeTime;
    private Long credentialId;
    private transient int numberOfRetries;
    private transient int _replyCode;
    private transient Object _errorObject;
    private transient boolean _cancelTimer;
    private DoorRequestInfoMessage info;
    private PermissionHandler permissionHandler;
    private PoolMgrSelectReadPoolMsg.Context _readPoolSelectionContext;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public TransferManagerHandler(TransferManager tManager, TransferManagerMessage message, CellPath sourcePath) {
        this.created = false;
        this.locked = false;
        this.state = 0;
        this.numberOfRetries = 0;
        this.creationTime = System.currentTimeMillis();
        this.manager = tManager;
        this.id = this.manager.getNextMessageID();
        message.setId(this.id);
        this.transferRequest = message;
        this.pnfsPath = this.transferRequest.getPnfsPath();
        this.store = this.transferRequest.isStore();
        this.remoteUrl = this.transferRequest.getRemoteURL();
        this.credentialId = this.transferRequest.getCredentialId();
        Subject subject = this.transferRequest.getSubject();
        this.info = new DoorRequestInfoMessage(this.manager.getCellName() + "@" + this.manager.getCellDomainName());
        this.info.setTransactionDuration(-this.creationTime);
        this.info.setSubject(subject);
        this.info.setPath(this.pnfsPath);
        this.info.setTimeQueued(-System.currentTimeMillis());
        this.info.setMessageType("request");
        this.sourcePath = sourcePath;
        try {
            this.info.setClient(new URI(this.transferRequest.getRemoteURL()).getHost());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.manager.getLogRootName() != null) {
                this.tlog = new FTPTransactionLog(this.manager.getLogRootName());
                String user_info = Subjects.getDn((Subject)this.transferRequest.getSubject()) + "(" + this.info.getUid() + "." + this.info.getGid() + ")";
                String rw = this.store ? "write" : "read";
                InetAddress remoteaddr = InetAddress.getByName(new URI(this.transferRequest.getRemoteURL()).getHost());
                this.tlog.begin(user_info, "remotegsiftp", rw, this.transferRequest.getPnfsPath(), remoteaddr);
            }
        }
        catch (Exception e) {
            log.error("starting tlog failed :", (Throwable)e);
        }
        this.spaceReservationId = this.transferRequest.getSpaceReservationId();
        this.space_reservation_strict = this.transferRequest.isSpaceReservationStrict();
        this.size = this.transferRequest.getSize();
        this.manager.addActiveTransfer(this.id, this);
        this.setState(0);
        this.permissionHandler = new ChainedPermissionHandler(new ACLPermissionHandler(), new PosixPermissionHandler());
    }

    public void handle() {
        PnfsGetStorageInfoMessage message;
        log.debug("handling:  " + this.toString(true));
        int last_slash_pos = TransferManagerHandler.jdoGetpnfsPath(this).lastIndexOf(47);
        if (last_slash_pos == -1) {
            this.transferRequest.setFailed(2, new IOException("pnfsFilePath is not absolute:" + TransferManagerHandler.jdoGetpnfsPath(this)));
            return;
        }
        this.parentDir = TransferManagerHandler.jdoGetpnfsPath(this).substring(0, last_slash_pos);
        if (TransferManagerHandler.jdoGetstore(this)) {
            message = new PnfsCreateEntryMessage(TransferManagerHandler.jdoGetpnfsPath(this));
            message.setSubject(this.transferRequest.getSubject());
            this.setState(5);
        } else {
            EnumSet<FileAttribute> attributes = EnumSet.noneOf(FileAttribute.class);
            attributes.addAll(this.permissionHandler.getRequiredAttributes());
            attributes.addAll(PoolMgrSelectReadPoolMsg.getRequiredAttributes());
            message = new PnfsGetStorageInfoMessage(attributes);
            message.setPnfsPath(TransferManagerHandler.jdoGetpnfsPath(this));
            message.setSubject(this.transferRequest.getSubject());
            message.setAccessMask(EnumSet.of(AccessMask.READ_DATA));
            this.setState(1);
        }
        this.manager.persist(this);
        try {
            this.manager.sendMessage(new CellMessage(new CellPath(this.manager.getPnfsManagerName()), (Object)message), true, true, this, this.manager.getPnfsManagerTimeout() * 1000L);
        }
        catch (Exception ee) {
            log.error(ee.toString());
            this.transferRequest.setFailed(2, ee);
            return;
        }
    }

    public void answerArrived(CellMessage req, CellMessage answer) {
        log.debug("answerArrived(" + req + "," + answer + "), state =" + TransferManagerHandler.jdoGetstate(this));
        Object o = answer.getMessageObject();
        if (o instanceof Message) {
            Message message = (Message)answer.getMessageObject();
            if (message instanceof PnfsCreateEntryMessage) {
                PnfsCreateEntryMessage create_msg = (PnfsCreateEntryMessage)message;
                if (TransferManagerHandler.jdoGetstate(this) == 5) {
                    this.setState(6);
                    this.createEntryResponseArrived(create_msg);
                    return;
                }
                log.error(this.toString() + " got unexpected PnfsCreateEntryMessage " + " : " + create_msg + " ; Ignoring");
            } else if (message instanceof PnfsGetStorageInfoMessage) {
                PnfsGetStorageInfoMessage storage_info_msg = (PnfsGetStorageInfoMessage)message;
                if (TransferManagerHandler.jdoGetstate(this) == 1) {
                    this.setState(2);
                    this.storageInfoArrived(storage_info_msg);
                    return;
                }
                log.error(this.toString() + " got unexpected PnfsGetStorageInfoMessage " + " : " + storage_info_msg + " ; Ignoring");
            } else if (message instanceof PnfsGetFileMetaDataMessage) {
                PnfsGetFileMetaDataMessage storage_metadata = (PnfsGetFileMetaDataMessage)message;
                if (TransferManagerHandler.jdoGetstate(this) == 15) {
                    if (storage_metadata.getReturnCode() != 0) {
                        log.error("We were about to delete entry that does not exist : " + storage_metadata.toString() + " PnfsGetFileMetaDataMessage return code=" + storage_metadata.getReturnCode() + " reason : " + storage_metadata.getErrorObject());
                        this.sendErrorReply();
                        return;
                    }
                    TransferManagerHandler.jdoSetstate(this, 16);
                    this.deletePnfsEntry();
                    return;
                }
                log.error(this.toString() + " got unexpected PnfsGetFileMetaDataMessage " + " : " + storage_metadata + " ; Ignoring");
            } else if (message instanceof PoolMgrSelectPoolMsg) {
                PoolMgrSelectPoolMsg select_pool_msg = (PoolMgrSelectPoolMsg)message;
                if (TransferManagerHandler.jdoGetstate(this) == 7) {
                    this.setState(8);
                    this.poolInfoArrived(select_pool_msg);
                    return;
                }
                log.error(this.toString() + " got unexpected PoolMgrSelectPoolMsg " + " : " + select_pool_msg + " ; Ignoring");
            } else if (message instanceof PoolIoFileMessage) {
                PoolIoFileMessage first_pool_reply = (PoolIoFileMessage)message;
                if (TransferManagerHandler.jdoGetstate(this) == 9) {
                    this.setState(10);
                    this.poolFirstReplyArrived(first_pool_reply);
                    return;
                }
                log.error(this.toString() + " got unexpected PoolIoFileMessage " + " : " + first_pool_reply + " ; Ignoring");
            } else if (message instanceof PnfsDeleteEntryMessage) {
                PnfsDeleteEntryMessage deleteReply = (PnfsDeleteEntryMessage)message;
                if (TransferManagerHandler.jdoGetstate(this) == 13) {
                    this.setState(14);
                    if (deleteReply.getReturnCode() != 0) {
                        log.error("Delete failed : " + deleteReply.getPath() + " PnfsDeleteEntryMessage return code=" + deleteReply.getReturnCode() + " reason : " + deleteReply.getErrorObject());
                        ++this.numberOfRetries;
                        int numberOfRemainingRetries = this.manager.getMaxNumberOfDeleteRetries() - this.numberOfRetries;
                        log.error("Will retry : " + numberOfRemainingRetries + " times");
                        this.deletePnfsEntry();
                    } else {
                        log.debug("Received PnfsDeleteEntryMessage, Deleted  : " + deleteReply.getPath());
                        this.sendErrorReply();
                    }
                }
            }
        }
        this.manager.persist(this);
    }

    public void answerTimedOut(CellMessage request) {
    }

    public void exceptionArrived(CellMessage request, Exception exception) {
    }

    public void createEntryResponseArrived(PnfsCreateEntryMessage create) {
        if (create.getReturnCode() != 0) {
            this.sendErrorReply(create.getReturnCode(), create.getErrorObject());
            return;
        }
        TransferManagerHandler.jdoSetcreated(this, true);
        this.manager.persist(this);
        this.storageInfo = create.getStorageInfo();
        this.fileAttributes = create.getFileAttributes();
        this.pnfsId = create.getPnfsId();
        TransferManagerHandler.jdoSetpnfsIdString(this, this.pnfsId.toString());
        this.info.setPnfsId(this.pnfsId);
        this.selectPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storageInfoArrived(PnfsGetStorageInfoMessage storage_info_msg) {
        if (storage_info_msg.getReturnCode() != 0) {
            this.sendErrorReply(storage_info_msg.getReturnCode(), storage_info_msg.getErrorObject());
            return;
        }
        if (!TransferManagerHandler.jdoGetstore(this) && this.tlog != null) {
            this.tlog.middle(storage_info_msg.getStorageInfo().getFileSize());
        }
        this.pnfsId = storage_info_msg.getPnfsId();
        this.info.setPnfsId(this.pnfsId);
        TransferManagerHandler.jdoSetpnfsIdString(this, this.pnfsId.toString());
        this.manager.persist(this);
        if (TransferManagerHandler.jdoGetstore(this)) {
            Set<PnfsId> set = this.manager.justRequestedIDs;
            synchronized (set) {
                if (this.manager.justRequestedIDs.contains(storage_info_msg.getPnfsId())) {
                    this.sendErrorReply(6, new CacheException("pnfs pnfsid: " + this.pnfsId.toString() + " file " + TransferManagerHandler.jdoGetpnfsPath(this) + "  is already there"));
                    return;
                }
                for (PnfsId pnfsid : this.manager.justRequestedIDs) {
                    log.debug("found pnfsid: {}", (Object)pnfsid);
                }
                this.manager.justRequestedIDs.add(this.pnfsId);
            }
        }
        if (this.storageInfo == null) {
            this.storageInfo = storage_info_msg.getStorageInfo();
        }
        if (this.fileAttributes == null) {
            this.fileAttributes = storage_info_msg.getFileAttributes();
        }
        log.debug("storageInfoArrived(uid={} gid={} pnfsid={} storageInfo={} fileAttributes={}", new Object[]{this.info.getUid(), this.info.getGid(), this.pnfsId, this.storageInfo, this.fileAttributes});
        this.selectPool();
    }

    public void selectPool() {
        try {
            this.protocol_info = this.manager.getProtocolInfo(this.transferRequest);
        }
        catch (IOException ioe) {
            log.error(ioe.toString());
            this.sendErrorReply(4, ioe);
            return;
        }
        Thread current = Thread.currentThread();
        long sizeToSend = this.transferRequest.getSize() == null ? 0L : this.transferRequest.getSize();
        PoolMgrSelectPoolMsg request = TransferManagerHandler.jdoGetstore(this) ? new PoolMgrSelectWritePoolMsg(this.fileAttributes, this.protocol_info, sizeToSend) : new PoolMgrSelectReadPoolMsg(this.fileAttributes, (ProtocolInfo)this.protocol_info, sizeToSend, this._readPoolSelectionContext);
        request.setPnfsPath(TransferManagerHandler.jdoGetpnfsPath(this));
        request.setSubject(this.transferRequest.getSubject());
        log.debug("PoolMgrSelectPoolMsg: " + request);
        this.setState(7);
        this.manager.persist(this);
        try {
            this.manager.sendMessage(new CellMessage(this.manager.getPoolManagerPath(), (Object)request), true, true, this, this.manager.getPoolManagerTimeout() * 1000L);
        }
        catch (Exception e) {
            log.error(e.toString());
            this.sendErrorReply(4, e);
            return;
        }
    }

    public void poolInfoArrived(PoolMgrSelectPoolMsg pool_info) {
        log.debug("poolManagerReply = " + pool_info);
        if (pool_info instanceof PoolMgrSelectReadPoolMsg) {
            this._readPoolSelectionContext = ((PoolMgrSelectReadPoolMsg)pool_info).getContext();
        }
        if (pool_info.getReturnCode() == 10021) {
            this.handle();
            return;
        }
        if (pool_info.getReturnCode() != 0) {
            this.sendErrorReply(5, new CacheException("Pool manager error: " + pool_info.getErrorObject()));
            return;
        }
        this.setPool(pool_info.getPoolName());
        this.manager.persist(this);
        log.debug("Positive reply from pool " + TransferManagerHandler.jdoGetpool(this));
        this.startMoverOnThePool();
    }

    public void startMoverOnThePool() {
        CellPath poolCellPath;
        PoolIoFileMessage poolMessage;
        PoolIoFileMessage poolIoFileMessage = poolMessage = TransferManagerHandler.jdoGetstore(this) ? new PoolAcceptFileMessage(TransferManagerHandler.jdoGetpool(this), this.pnfsId, this.protocol_info, this.storageInfo) : new PoolDeliverFileMessage(TransferManagerHandler.jdoGetpool(this), this.pnfsId, this.protocol_info, this.storageInfo);
        if (this.manager.getIoQueueName() != null) {
            poolMessage.setIoQueueName(this.manager.getIoQueueName());
        }
        poolMessage.setInitiator(this.info.getTransaction());
        poolMessage.setId(TransferManagerHandler.jdoGetid(this));
        this.setState(9);
        this.manager.persist(this);
        String poolProxy = this.manager.getPoolProxy();
        if (poolProxy == null) {
            poolCellPath = new CellPath(TransferManagerHandler.jdoGetpool(this));
        } else {
            poolCellPath = new CellPath(poolProxy);
            poolCellPath.add(TransferManagerHandler.jdoGetpool(this));
        }
        try {
            this.manager.sendMessage(new CellMessage(poolCellPath, (Object)poolMessage), true, true, this, this.manager.getPoolTimeout() * 1000L);
        }
        catch (Exception ee) {
            log.error(ee.toString());
            this.sendErrorReply(4, ee);
            return;
        }
    }

    public void poolFirstReplyArrived(PoolIoFileMessage poolMessage) {
        log.debug("poolReply = " + poolMessage);
        this.info.setTimeQueued(this.info.getTimeQueued() + System.currentTimeMillis());
        if (poolMessage.getReturnCode() != 0) {
            this.sendErrorReply(5, new CacheException("Pool error: " + poolMessage.getErrorObject()));
            return;
        }
        log.debug("Pool " + TransferManagerHandler.jdoGetpool(this) + " will deliver file " + this.pnfsId + " mover id is " + poolMessage.getMoverId());
        log.debug("Starting moverTimeout timer");
        this.manager.startTimer(TransferManagerHandler.jdoGetid(this));
        this.setMoverId(new Integer(poolMessage.getMoverId()));
        this.manager.persist(this);
    }

    public void deletePnfsEntry() {
        if (TransferManagerHandler.jdoGetstate(this) == 16) {
            if (this.numberOfRetries < this.manager.getMaxNumberOfDeleteRetries()) {
                PnfsDeleteEntryMessage pnfsMsg = new PnfsDeleteEntryMessage(TransferManagerHandler.jdoGetpnfsPath(this));
                this.setState(13);
                this.manager.persist(this);
                pnfsMsg.setReplyRequired(true);
                try {
                    this.manager.sendMessage(new CellMessage(new CellPath(this.manager.getPnfsManagerName()), (Object)pnfsMsg), true, true, this, this.manager.getPnfsManagerTimeout() * 1000L);
                    return;
                }
                catch (Exception e) {
                    log.error("sendErrorReply: can not send PnfsDeleteEntryMessage:", (Throwable)e);
                    this.sendErrorReply();
                    return;
                }
            }
            log.error("Failed to remove PNFS entry after " + this.numberOfRetries);
            this.sendErrorReply();
            return;
        }
        PnfsGetFileMetaDataMessage sInfo = new PnfsGetFileMetaDataMessage();
        sInfo.setPnfsPath(TransferManagerHandler.jdoGetpnfsPath(this));
        this.setState(15);
        try {
            this.manager.sendMessage(new CellMessage(new CellPath(this.manager.getPnfsManagerName()), (Object)sInfo), true, true, this, this.manager.getPnfsManagerTimeout() * 1000L);
        }
        catch (Exception ee) {
            log.error(ee.toString());
            this.sendErrorReply();
            return;
        }
    }

    public void poolDoorMessageArrived(DoorTransferFinishedMessage doorMessage) {
        log.debug("poolDoorMessageArrived, doorMessage.getReturnCode()=" + doorMessage.getReturnCode());
        if (doorMessage.getReturnCode() != 0) {
            this.sendErrorReply(8, "tranfer failed :" + doorMessage.getErrorObject());
            return;
        }
        DoorTransferFinishedMessage finished = doorMessage;
        if (TransferManagerHandler.jdoGetstore(this) && this.tlog != null) {
            this.tlog.middle(finished.getStorageInfo().getFileSize());
        }
        this.sendSuccessReply();
    }

    public void sendErrorReply(int replyCode, Object errorObject) {
        this.sendErrorReply(replyCode, errorObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendErrorReply(int replyCode, Object errorObject, boolean cancelTimer) {
        this._replyCode = replyCode;
        this._errorObject = errorObject;
        this._cancelTimer = cancelTimer;
        log.error("sending error reply, reply code=" + replyCode + " errorObject=" + errorObject + " for " + this.toString(true));
        if (TransferManagerHandler.jdoGetstore(this) && TransferManagerHandler.jdoGetcreated(this) && TransferManagerHandler.jdoGetstate(this) != 13 && TransferManagerHandler.jdoGetstate(this) != 14) {
            log.error(" we created the pnfs entry and the store failed: deleting " + TransferManagerHandler.jdoGetpnfsPath(this));
            this.deletePnfsEntry();
            return;
        }
        if (this.tlog != null) {
            this.tlog.error("getFromRemoteGsiftpUrl failed: state = " + TransferManagerHandler.jdoGetstate(this) + " replyCode=" + replyCode + " errorObject=" + errorObject);
        }
        if (this.info.getTimeQueued() < 0L) {
            this.info.setTimeQueued(this.info.getTimeQueued() + System.currentTimeMillis());
        }
        if (this.info.getTransactionDuration() < 0L) {
            this.info.setTransactionDuration(this.info.getTransactionDuration() + System.currentTimeMillis());
        }
        this.sendDoorRequestInfo(replyCode, errorObject.toString());
        this.setState(-1, errorObject);
        this.manager.persist(this);
        if (cancelTimer) {
            this.manager.stopTimer(TransferManagerHandler.jdoGetid(this));
        }
        if (TransferManagerHandler.jdoGetstore(this)) {
            Set<PnfsId> set = this.manager.justRequestedIDs;
            synchronized (set) {
                this.manager.justRequestedIDs.remove(this.pnfsId);
            }
        }
        this.manager.finishTransfer();
        try {
            TransferFailedMessage errorReply = new TransferFailedMessage(this.transferRequest, replyCode, errorObject);
            this.manager.sendMessage(new CellMessage(this.sourcePath, (Object)errorReply));
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        Long longId = new Long(TransferManagerHandler.jdoGetid(this));
        this.manager.removeActiveTransfer(longId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendErrorReply() {
        int replyCode = this._replyCode;
        Object errorObject = this._errorObject;
        boolean cancelTimer = this._cancelTimer;
        log.error("sending error reply, reply code=" + replyCode + " errorObject=" + errorObject + " for " + this.toString(true));
        if (this.tlog != null) {
            this.tlog.error("getFromRemoteGsiftpUrl failed: state = " + TransferManagerHandler.jdoGetstate(this) + " replyCode=" + replyCode + " errorObject=" + errorObject);
        }
        if (this.info.getTimeQueued() < 0L) {
            this.info.setTimeQueued(this.info.getTimeQueued() + System.currentTimeMillis());
        }
        if (this.info.getTransactionDuration() < 0L) {
            this.info.setTransactionDuration(this.info.getTransactionDuration() + System.currentTimeMillis());
        }
        this.sendDoorRequestInfo(replyCode, errorObject.toString());
        this.setState(-1, errorObject);
        this.manager.persist(this);
        if (cancelTimer) {
            this.manager.stopTimer(TransferManagerHandler.jdoGetid(this));
        }
        if (TransferManagerHandler.jdoGetstore(this)) {
            Set<PnfsId> set = this.manager.justRequestedIDs;
            synchronized (set) {
                this.manager.justRequestedIDs.remove(this.pnfsId);
            }
        }
        this.manager.finishTransfer();
        try {
            TransferFailedMessage errorReply = new TransferFailedMessage(this.transferRequest, replyCode, errorObject);
            this.manager.sendMessage(new CellMessage(this.sourcePath, (Object)errorReply));
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        Long longId = new Long(TransferManagerHandler.jdoGetid(this));
        this.manager.removeActiveTransfer(longId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSuccessReply() {
        log.debug("sendSuccessReply for: " + this.toString(true));
        if (this.info.getTimeQueued() < 0L) {
            this.info.setTimeQueued(this.info.getTimeQueued() + System.currentTimeMillis());
        }
        if (this.info.getTransactionDuration() < 0L) {
            this.info.setTransactionDuration(this.info.getTransactionDuration() + System.currentTimeMillis());
        }
        this.sendDoorRequestInfo(0, "");
        this.setState(-2);
        this.manager.persist(this);
        this.manager.stopTimer(TransferManagerHandler.jdoGetid(this));
        if (TransferManagerHandler.jdoGetstore(this)) {
            Set<PnfsId> set = this.manager.justRequestedIDs;
            synchronized (set) {
                this.manager.justRequestedIDs.remove(this.pnfsId);
            }
        }
        this.manager.finishTransfer();
        if (this.tlog != null) {
            this.tlog.success();
        }
        try {
            TransferCompleteMessage errorReply = new TransferCompleteMessage(this.transferRequest);
            this.manager.sendMessage(new CellMessage(this.sourcePath, (Object)errorReply));
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        Long longId = new Long(TransferManagerHandler.jdoGetid(this));
        this.manager.removeActiveTransfer(longId);
    }

    void sendDoorRequestInfo(int code, String msg) {
        try {
            this.info.setResult(code, msg);
            log.debug("Sending info: " + this.info);
            this.manager.sendMessage(new CellMessage(new CellPath("billing"), (Object)this.info));
        }
        catch (NoRouteToCellException e) {
            log.error("Couldn't send billing info", (Throwable)e);
        }
    }

    public CellPath getRequestSourcePath() {
        return this.sourcePath;
    }

    public void cancel() {
        log.warn("the transfer is canceled by admin command, killing mover");
        if (TransferManagerHandler.jdoGetmoverId(this) != null) {
            this.killMover(TransferManagerHandler.jdoGetpool(this), TransferManagerHandler.jdoGetmoverId(this));
        }
        this.sendErrorReply(24, new IOException("canceled"));
    }

    public void timeout() {
        log.error(" transfer timed out");
        if (TransferManagerHandler.jdoGetmoverId(this) != null) {
            this.killMover(TransferManagerHandler.jdoGetpool(this), TransferManagerHandler.jdoGetmoverId(this));
        }
        this.sendErrorReply(24, new IOException("timed out while waiting for mover reply"), false);
    }

    public void cancel(CancelTransferMessage cancel) {
        log.warn("the transfer is canceled by " + cancel + ", killing mover");
        if (TransferManagerHandler.jdoGetmoverId(this) != null) {
            this.killMover(TransferManagerHandler.jdoGetpool(this), TransferManagerHandler.jdoGetmoverId(this));
        }
        this.sendErrorReply(24, new IOException("canceled"));
    }

    public synchronized String toString(boolean long_format) {
        StringBuffer sb = new StringBuffer("id=");
        sb.append(TransferManagerHandler.jdoGetid(this));
        if (!long_format) {
            if (TransferManagerHandler.jdoGetstore(this)) {
                sb.append(" store src=");
                sb.append(this.transferRequest.getRemoteURL());
                sb.append(" dest=");
                sb.append(this.transferRequest.getPnfsPath());
            } else {
                sb.append(" restore src=");
                sb.append(this.transferRequest.getPnfsPath());
                sb.append(" dest=");
                sb.append(this.transferRequest.getRemoteURL());
            }
            return sb.toString();
        }
        sb.append("\n  state=").append(TransferManagerHandler.jdoGetstate(this));
        sb.append("\n  user=").append(this.transferRequest.getSubject());
        if (this.pnfsId != null) {
            sb.append("\n   pnfsId=").append(this.pnfsId);
        }
        if (this.storageInfo != null) {
            sb.append("\n  storageInfo=").append(this.storageInfo);
        }
        if (TransferManagerHandler.jdoGetpool(this) != null) {
            sb.append("\n   pool=").append(TransferManagerHandler.jdoGetpool(this));
            if (TransferManagerHandler.jdoGetmoverId(this) != null) {
                sb.append("\n   moverId=").append(TransferManagerHandler.jdoGetmoverId(this));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public String getPool() {
        return TransferManagerHandler.jdoGetpool(this);
    }

    public void setPool(String pool) {
        TransferManagerHandler.jdoSetpool(this, pool);
    }

    public void killMover(String pool, int moverId) {
        log.warn("sending mover kill to pool " + pool + " for moverId=" + moverId);
        PoolMoverKillMessage killMessage = new PoolMoverKillMessage(pool, moverId);
        killMessage.setReplyRequired(false);
        try {
            this.manager.sendMessage(new CellMessage(new CellPath(pool), (Object)killMessage));
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }

    public void setState(int istate) {
        TransferManagerHandler.jdoSetstate(this, istate);
        TransferManagerHandlerState ts = new TransferManagerHandlerState(this, null);
        this.manager.persist(ts);
    }

    public void setState(int istate, Object errorObject) {
        TransferManagerHandler.jdoSetstate(this, istate);
        TransferManagerHandlerState ts = new TransferManagerHandlerState(this, errorObject);
        this.manager.persist(ts);
    }

    public void setMoverId(Integer moverid) {
        TransferManagerHandler.jdoSetmoverId(this, moverid);
    }

    public static final void main(String[] args) {
        System.out.println("This is a main in handler");
    }

    public String getPnfsPath() {
        return TransferManagerHandler.jdoGetpnfsPath(this);
    }

    public boolean getStore() {
        return TransferManagerHandler.jdoGetstore(this);
    }

    public boolean getCreated() {
        return TransferManagerHandler.jdoGetcreated(this);
    }

    public boolean getLocked() {
        return this.locked;
    }

    public String getPnfsIdString() {
        return TransferManagerHandler.jdoGetpnfsIdString(this);
    }

    public String getRemoteUrl() {
        return TransferManagerHandler.jdoGetremoteUrl(this);
    }

    public int getState() {
        return TransferManagerHandler.jdoGetstate(this);
    }

    public long getId() {
        return TransferManagerHandler.jdoGetid(this);
    }

    public Integer getMoverId() {
        return TransferManagerHandler.jdoGetmoverId(this);
    }

    public String getSpaceReservationId() {
        return TransferManagerHandler.jdoGetspaceReservationId(this);
    }

    public long getCreationTime() {
        return TransferManagerHandler.jdoGetcreationTime(this);
    }

    public long getLifeTime() {
        return TransferManagerHandler.jdoGetlifeTime(this);
    }

    public Long getCredentialId() {
        return TransferManagerHandler.jdoGetcredentialId(this);
    }

    static {
        jdoFieldNames = TransferManagerHandler.__jdoFieldNamesInit();
        jdoFieldTypes = TransferManagerHandler.__jdoFieldTypesInit();
        jdoFieldFlags = TransferManagerHandler.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = TransferManagerHandler.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = TransferManagerHandler.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)TransferManagerHandler.___jdo$loadClass("diskCacheV111.services.TransferManagerHandler"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new TransferManagerHandler());
    }

    protected TransferManagerHandler() {
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.LongIdentity");
        }
        LongIdentity o = (LongIdentity)oid;
        fc.storeLongField(3, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.LongIdentity or null");
        }
        LongIdentity o = (LongIdentity)oid;
        this.id = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new LongIdentity(this.getClass(), this.id);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongIdentity(this.getClass(), (Long)key);
        }
        return new LongIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        TransferManagerHandler result = new TransferManagerHandler();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        TransferManagerHandler result = new TransferManagerHandler();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.created = this.jdoStateManager.replacingBooleanField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.creationTime = this.jdoStateManager.replacingLongField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.credentialId = (Long)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.id = this.jdoStateManager.replacingLongField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.lifeTime = this.jdoStateManager.replacingLongField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.moverId = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.pnfsIdString = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.pnfsPath = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.pool = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.remoteUrl = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.spaceReservationId = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.state = this.jdoStateManager.replacingIntField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.store = this.jdoStateManager.replacingBooleanField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedBooleanField((PersistenceCapable)this, index, this.created);
                break;
            }
            case 1: {
                this.jdoStateManager.providedLongField((PersistenceCapable)this, index, this.creationTime);
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.credentialId);
                break;
            }
            case 3: {
                this.jdoStateManager.providedLongField((PersistenceCapable)this, index, this.id);
                break;
            }
            case 4: {
                this.jdoStateManager.providedLongField((PersistenceCapable)this, index, this.lifeTime);
                break;
            }
            case 5: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.moverId);
                break;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.pnfsIdString);
                break;
            }
            case 7: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.pnfsPath);
                break;
            }
            case 8: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.pool);
                break;
            }
            case 9: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.remoteUrl);
                break;
            }
            case 10: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.spaceReservationId);
                break;
            }
            case 11: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, index, this.state);
                break;
            }
            case 12: {
                this.jdoStateManager.providedBooleanField((PersistenceCapable)this, index, this.store);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(TransferManagerHandler obj, int index) {
        switch (index) {
            case 0: {
                this.created = obj.created;
                break;
            }
            case 1: {
                this.creationTime = obj.creationTime;
                break;
            }
            case 2: {
                this.credentialId = obj.credentialId;
                break;
            }
            case 3: {
                this.id = obj.id;
                break;
            }
            case 4: {
                this.lifeTime = obj.lifeTime;
                break;
            }
            case 5: {
                this.moverId = obj.moverId;
                break;
            }
            case 6: {
                this.pnfsIdString = obj.pnfsIdString;
                break;
            }
            case 7: {
                this.pnfsPath = obj.pnfsPath;
                break;
            }
            case 8: {
                this.pool = obj.pool;
                break;
            }
            case 9: {
                this.remoteUrl = obj.remoteUrl;
                break;
            }
            case 10: {
                this.spaceReservationId = obj.spaceReservationId;
                break;
            }
            case 11: {
                this.state = obj.state;
                break;
            }
            case 12: {
                this.store = obj.store;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof TransferManagerHandler)) {
            throw new IllegalArgumentException("object is not an object of type diskCacheV111.services.TransferManagerHandler");
        }
        TransferManagerHandler other = (TransferManagerHandler)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"created", "creationTime", "credentialId", "id", "lifeTime", "moverId", "pnfsIdString", "pnfsPath", "pool", "remoteUrl", "spaceReservationId", "state", "store"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Boolean.TYPE, Long.TYPE, TransferManagerHandler.___jdo$loadClass("java.lang.Long"), Long.TYPE, Long.TYPE, TransferManagerHandler.___jdo$loadClass("java.lang.Integer"), TransferManagerHandler.___jdo$loadClass("java.lang.String"), TransferManagerHandler.___jdo$loadClass("java.lang.String"), TransferManagerHandler.___jdo$loadClass("java.lang.String"), TransferManagerHandler.___jdo$loadClass("java.lang.String"), TransferManagerHandler.___jdo$loadClass("java.lang.String"), Integer.TYPE, Boolean.TYPE};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 24, 21, 21, 21, 21, 21, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 13;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        TransferManagerHandler o = (TransferManagerHandler)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    static boolean jdoGetcreated(TransferManagerHandler objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getBooleanField((PersistenceCapable)objPC, 0, objPC.created);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"created\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.created;
    }

    static void jdoSetcreated(TransferManagerHandler objPC, boolean val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setBooleanField((PersistenceCapable)objPC, 0, objPC.created, val);
        } else {
            objPC.created = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static long jdoGetcreationTime(TransferManagerHandler objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getLongField((PersistenceCapable)objPC, 1, objPC.creationTime);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"creationTime\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.creationTime;
    }

    private static void jdoSetcreationTime(TransferManagerHandler objPC, long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setLongField((PersistenceCapable)objPC, 1, objPC.creationTime, val);
        } else {
            objPC.creationTime = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static Long jdoGetcredentialId(TransferManagerHandler objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return (Long)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2, (Object)objPC.credentialId);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"credentialId\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.credentialId;
    }

    private static void jdoSetcredentialId(TransferManagerHandler objPC, Long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2, (Object)objPC.credentialId, (Object)val);
        } else {
            objPC.credentialId = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static long jdoGetid(TransferManagerHandler objPC) {
        return objPC.id;
    }

    private static void jdoSetid(TransferManagerHandler objPC, long val) {
        if (objPC.jdoStateManager == null) {
            objPC.id = val;
        } else {
            objPC.jdoStateManager.setLongField((PersistenceCapable)objPC, 3, objPC.id, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(3);
        }
    }

    private static long jdoGetlifeTime(TransferManagerHandler objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getLongField((PersistenceCapable)objPC, 4, objPC.lifeTime);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"lifeTime\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.lifeTime;
    }

    private static void jdoSetlifeTime(TransferManagerHandler objPC, long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setLongField((PersistenceCapable)objPC, 4, objPC.lifeTime, val);
        } else {
            objPC.lifeTime = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static Integer jdoGetmoverId(TransferManagerHandler objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 5, (Object)objPC.moverId);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"moverId\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.moverId;
    }

    private static void jdoSetmoverId(TransferManagerHandler objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 5, (Object)objPC.moverId, (Object)val);
        } else {
            objPC.moverId = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static String jdoGetpnfsIdString(TransferManagerHandler objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 6, objPC.pnfsIdString);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"pnfsIdString\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.pnfsIdString;
    }

    private static void jdoSetpnfsIdString(TransferManagerHandler objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC.pnfsIdString, val);
        } else {
            objPC.pnfsIdString = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static String jdoGetpnfsPath(TransferManagerHandler objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 7, objPC.pnfsPath);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"pnfsPath\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.pnfsPath;
    }

    private static void jdoSetpnfsPath(TransferManagerHandler objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 7, objPC.pnfsPath, val);
        } else {
            objPC.pnfsPath = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static String jdoGetpool(TransferManagerHandler objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 8, objPC.pool);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"pool\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.pool;
    }

    private static void jdoSetpool(TransferManagerHandler objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 8, objPC.pool, val);
        } else {
            objPC.pool = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static String jdoGetremoteUrl(TransferManagerHandler objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 9, objPC.remoteUrl);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"remoteUrl\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.remoteUrl;
    }

    private static void jdoSetremoteUrl(TransferManagerHandler objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 9, objPC.remoteUrl, val);
        } else {
            objPC.remoteUrl = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private static String jdoGetspaceReservationId(TransferManagerHandler objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 10, objPC.spaceReservationId);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"spaceReservationId\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.spaceReservationId;
    }

    private static void jdoSetspaceReservationId(TransferManagerHandler objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 10, objPC.spaceReservationId, val);
        } else {
            objPC.spaceReservationId = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(10);
            }
        }
    }

    public static int jdoGetstate(TransferManagerHandler objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 11, objPC.state);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"state\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.state;
    }

    public static void jdoSetstate(TransferManagerHandler objPC, int val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 11, objPC.state, val);
        } else {
            objPC.state = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(11);
            }
        }
    }

    static boolean jdoGetstore(TransferManagerHandler objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return objPC.jdoStateManager.getBooleanField((PersistenceCapable)objPC, 12, objPC.store);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"store\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.store;
    }

    static void jdoSetstore(TransferManagerHandler objPC, boolean val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setBooleanField((PersistenceCapable)objPC, 12, objPC.store, val);
        } else {
            objPC.store = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(12);
            }
        }
    }
}

