/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services;

import com.google.common.base.Strings;
import diskCacheV111.services.TransferManagerHandler;
import diskCacheV111.services.TransferManagerHandlerBackup;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.Pgpass;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.Version;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.IpProtocolInfo;
import diskCacheV111.vehicles.transferManager.CancelTransferMessage;
import diskCacheV111.vehicles.transferManager.TransferManagerMessage;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellVersion;
import dmg.util.Args;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;
import org.dcache.cells.AbstractCell;
import org.dcache.srm.request.sql.RequestsPropertyStorage;
import org.dcache.srm.scheduler.JobIdGenerator;
import org.dcache.srm.scheduler.JobIdGeneratorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransferManager
extends AbstractCell {
    private static final Logger log = LoggerFactory.getLogger(TransferManager.class);
    private String _jdbcUrl = "jdbc:postgresql://localhost/srmdcache";
    private String _jdbcDriver = "org.postgresql.Driver";
    private String _user = "srmdcache";
    private String _pass;
    private String _pwdFile;
    private PersistenceManager _pm;
    private final Map<Long, TransferManagerHandler> _activeTransfers = new ConcurrentHashMap<Long, TransferManagerHandler>();
    private int _maxTransfers;
    private int _numTransfers;
    private long _poolTimeout;
    private long _poolManagerTimeout;
    private long _pnfsManagerTimeout;
    private long _moverTimeout;
    protected static long nextMessageID = 0L;
    private String _tLogRoot;
    protected String _poolManager;
    protected String _pnfsManager;
    private CellPath _poolMgrPath;
    private boolean _overwrite = false;
    private boolean _doDatabaseLogging = false;
    private int _maxNumberOfDeleteRetries;
    private final Timer _moverTimeoutTimer = new Timer(true);
    private final Map<Long, TimerTask> _moverTimeoutTimerTasks = new ConcurrentHashMap<Long, TimerTask>();
    private String _ioQueueName;
    private JobIdGenerator idGenerator;
    public final Set<PnfsId> justRequestedIDs = new HashSet<PnfsId>();
    private String _poolProxy;
    public static final String hh_set_dblogging = "<true/false switch db loggin on/off>";
    public static final String hh_set_tlog = "<direcory for ftp logs or \"null\" for none>";
    public static final String hh_set_max_transfers = "<#max transfers>";
    public static final String hh_set_pool_timeout = "<#seconds>";
    public static final String hh_set_pool_manager_timeout = "<#seconds>";
    public static final String hh_set_pnfs_manager_timeout = "<#seconds>";
    public static final String hh_ls = "[-l] [<#transferId>]";
    public static final String hh_kill = " id";
    public static final String hh_killall = " [-p pool] pattern [pool] \n for example killall .* ketchup will kill all transfers with movers on the ketchup pool";
    public static final String hh_set_io_queue = "<io-queue name >";

    public TransferManager(String cellName, String args) throws InterruptedException, ExecutionException {
        super(cellName, args);
        this.doInit();
    }

    @Override
    protected void init() {
        Args args;
        block13: {
            String dbLog;
            args = this.getArgs();
            this._jdbcUrl = args.getOpt("jdbcUrl");
            this._jdbcDriver = args.getOpt("jdbcDriver");
            this._user = args.getOpt("dbUser");
            this._pass = args.getOpt("dbPass");
            this._pwdFile = args.getOpt("pgPass");
            if (this._pwdFile != null && !this._pwdFile.isEmpty()) {
                Pgpass pgpass = new Pgpass(this._pwdFile);
                this._pass = pgpass.getPgpass(this._jdbcUrl, this._user);
            }
            if ((dbLog = args.getOpt("doDbLog")).equalsIgnoreCase("true") || dbLog.equalsIgnoreCase("t")) {
                this.setDbLogging(true);
            } else if (dbLog.equalsIgnoreCase("false") || dbLog.equalsIgnoreCase("f")) {
                this.setDbLogging(false);
            } else {
                log.error("Unrecognized value of \"doDbLog\" option : " + dbLog + " , ignored");
            }
            try {
                if (this._jdbcUrl != null && this._jdbcDriver != null && this._user != null && this._pass != null) {
                    try {
                        RequestsPropertyStorage.initPropertyStorage((String)this._jdbcUrl, (String)this._jdbcDriver, (String)this._user, (String)this._pass, (String)"srmnextrequestid");
                    }
                    catch (IllegalStateException ise) {
                        // empty catch block
                    }
                    this.idGenerator = JobIdGeneratorFactory.getJobIdGeneratorFactory().getJobIdGenerator();
                    break block13;
                }
                this.idGenerator = null;
            }
            catch (Exception e) {
                log.error("Failed to initialize Data Base connection to generate nextTransferId using default values");
                log.error("jdbcUrl=" + this._jdbcUrl + " jdbcDriver=" + this._jdbcDriver + " dbUser=" + this._user + " dbPass=" + this._pass + " pgPass=" + this._pwdFile);
                this.idGenerator = null;
            }
        }
        if (this.doDbLogging()) {
            try {
                Properties properties = new Properties();
                properties.setProperty("javax.jdo.PersistenceManagerFactoryClass", "org.datanucleus.jdo.JDOPersistenceManagerFactory");
                properties.setProperty("javax.jdo.option.ConnectionDriverName", this._jdbcDriver);
                properties.setProperty("javax.jdo.option.ConnectionURL", this._jdbcUrl);
                properties.setProperty("javax.jdo.option.ConnectionUserName", this._user);
                properties.setProperty("javax.jdo.option.ConnectionPassword", this._pass);
                properties.setProperty("javax.jdo.option.DetachAllOnCommit", "true");
                properties.setProperty("javax.jdo.option.Optimistic", "true");
                properties.setProperty("javax.jdo.option.NontransactionalRead", "true");
                properties.setProperty("javax.jdo.option.RetainValues", "true");
                properties.setProperty("javax.jdo.option.Multithreaded", "true");
                properties.setProperty("datanucleus.autoCreateSchema", "true");
                properties.setProperty("datanucleus.validateTables", "false");
                properties.setProperty("datanucleus.validateConstraints", "false");
                properties.setProperty("datanucleus.autoCreateColumns", "true");
                PersistenceManagerFactory pmf = JDOHelper.getPersistenceManagerFactory((Map)properties);
                this._pm = pmf.getPersistenceManager();
            }
            catch (Exception e) {
                log.error("Failed to initialize Data Base connection using default values");
                log.error("jdbcUrl=" + this._jdbcUrl + " jdbcDriver=" + this._jdbcDriver + " dbUser=" + this._user + " dbPass=" + this._pass + " pgPass=" + this._pwdFile);
                log.error(e.toString());
                this._pm = null;
                this.setDbLogging(false);
            }
        }
        this._tLogRoot = Strings.emptyToNull((String)args.getOpt("tlog"));
        this._maxNumberOfDeleteRetries = args.getIntOption("maxNumberOfDeleteRetries");
        this._poolManagerTimeout = args.getIntOption("pool_manager_timeout");
        this._pnfsManagerTimeout = args.getIntOption("pnfs_timeout");
        this._poolTimeout = args.getIntOption("pool_timeout");
        this._maxTransfers = args.getIntOption("max_transfers");
        this._overwrite = Strings.nullToEmpty((String)args.getOpt("overwrite")).equalsIgnoreCase("true");
        this._poolManager = args.getOpt("poolManager");
        this._pnfsManager = args.getOpt("pnfsManager");
        this._moverTimeout = args.getIntOption("mover_timeout");
        this._ioQueueName = Strings.emptyToNull((String)args.getOpt("io-queue"));
        this._poolProxy = args.getOpt("poolProxy");
        log.debug("Pool Proxy " + (this._poolProxy == null ? "not set" : "set to " + this._poolProxy));
        this._poolMgrPath = new CellPath(this._poolManager);
    }

    @Override
    public CellVersion getCellVersion() {
        return new CellVersion(Version.getVersion(), "$Revision: 1.38 $");
    }

    public void getInfo(PrintWriter pw) {
        pw.printf("    %s\n", ((Object)((Object)this)).getClass().getName());
        pw.println("---------------------------------");
        pw.printf("Name   : %s\n", this.getCellName());
        pw.printf("jdbcClass : %s\n", this._jdbcDriver);
        pw.printf("jdbcUrl : %s\n", this._jdbcUrl);
        pw.printf("jdbcUser : %s\n", this._user);
        if (this.doDbLogging()) {
            pw.println("dblogging=true");
        } else {
            pw.println("dblogging=false");
        }
        if (this.idGenerator != null) {
            pw.println("TransferID is generated using Data Base");
        } else {
            pw.println("TransferID is generated w/o DB access");
        }
        pw.printf("number of active transfers : %d\n", this._numTransfers);
        pw.printf("max number of active transfers  : %d\n", this.getMaxTransfers());
        pw.printf("PoolManager  : %s\n", this._poolManager);
        pw.printf("PoolManager timeout : %d seconds\n", this._poolManagerTimeout);
        pw.printf("PnfsManager timeout : %d seconds\n", this._pnfsManagerTimeout);
        pw.printf("Pool timeout  : %d seconds\n", this._poolTimeout);
        pw.printf("next id  : %d seconds\n", nextMessageID);
        pw.printf("io-queue  : %s\n", this._ioQueueName);
        pw.printf("maxNumberofDeleteRetries  : %d\n", this._maxNumberOfDeleteRetries);
        pw.printf("Pool Proxy : %s\n", this._poolProxy == null ? "not set" : "set to " + this._poolProxy);
    }

    public String ac_set_dblogging_$_1(Args args) {
        String logString = args.argv(0);
        StringBuilder sb = new StringBuilder();
        if (logString.equalsIgnoreCase("true") || logString.equalsIgnoreCase("t")) {
            this.setDbLogging(true);
            sb.append("remote ftp transaction db logging is on\n");
        } else if (logString.equalsIgnoreCase("false") || logString.equalsIgnoreCase("f")) {
            this.setDbLogging(false);
            sb.append("remote ftp transaction db logging is off\n");
        } else {
            return "unrecognized value : \"" + logString + "\" only true or false are allowed";
        }
        if (this.doDbLogging() && this._pm == null) {
            sb.append(this.getCellName() + " has been started w/ db logging disabed\n");
            sb.append("Attempting to initialize JDO Peristsency Manager using parameters provided at startup\n");
            try {
                Properties properties = new Properties();
                properties.setProperty("javax.jdo.PersistenceManagerFactoryClass", "org.datanucleus.jdo.JDOPersistenceManagerFactory");
                properties.setProperty("javax.jdo.option.ConnectionDriverName", this._jdbcDriver);
                properties.setProperty("javax.jdo.option.ConnectionURL", this._jdbcUrl);
                properties.setProperty("javax.jdo.option.ConnectionUserName", this._user);
                properties.setProperty("javax.jdo.option.ConnectionPassword", this._pass);
                properties.setProperty("javax.jdo.option.DetachAllOnCommit", "true");
                properties.setProperty("javax.jdo.option.Optimistic", "true");
                properties.setProperty("javax.jdo.option.NontransactionalRead", "true");
                properties.setProperty("javax.jdo.option.RetainValues", "true");
                properties.setProperty("javax.jdo.option.Multithreaded", "true");
                properties.setProperty("datanucleus.autoCreateSchema", "true");
                properties.setProperty("datanucleus.validateTables", "false");
                properties.setProperty("datanucleus.validateConstraints", "false");
                properties.setProperty("datanucleus.autoCreateColumns", "true");
                PersistenceManagerFactory pmf = JDOHelper.getPersistenceManagerFactory((Map)properties);
                this._pm = pmf.getPersistenceManager();
                sb.append("Success...\n");
            }
            catch (Exception e) {
                log.error(e.toString());
                sb.append("Failure...\n");
                sb.append("setting doDbLog back to false. \n");
                sb.append("Try to set correct Jdbc driver, username or password for DB connection.\n");
                this._pm = null;
                this.setDbLogging(false);
            }
        }
        return sb.toString();
    }

    public String ac_set_jdbcDriver_$_1(Args args) {
        this._jdbcDriver = args.argv(0);
        return "setting jdbcDriver to " + this._jdbcDriver;
    }

    public String ac_set_maxNumberOfDeleteRetries_$_1(Args args) {
        this._maxNumberOfDeleteRetries = Integer.parseInt(args.argv(0));
        return "setting maxNumberOfDeleteRetries " + this._maxNumberOfDeleteRetries;
    }

    public String ac_set_jdbcUrl_$_1(Args args) {
        this._jdbcUrl = args.argv(0);
        return "setting jdbcUrl to " + this._jdbcUrl;
    }

    public String ac_set_dbUser_$_1(Args args) {
        this._user = args.argv(0);
        return "setting db to " + this._user;
    }

    public String ac_set_dbpass_$_1(Args args) {
        this._pass = args.argv(0);
        return "OK";
    }

    public String ac_dbinit_$_0(Args args) {
        if (this.idGenerator != null) {
            return "database connection is already initialized\n";
        }
        try {
            try {
                RequestsPropertyStorage.initPropertyStorage((String)this._jdbcUrl, (String)this._jdbcDriver, (String)this._user, (String)this._pass, (String)"srmnextrequestid");
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            this.idGenerator = RequestsPropertyStorage.getJobIdGeneratorFactory().getJobIdGenerator();
        }
        catch (Exception e) {
            log.error("Failed to initialize Data Base connection to generate nextTransferId\n");
            this.idGenerator = null;
            log.error(e.toString());
            return "Failed to initialize Data Base connection to generate nextTransferId\n";
        }
        return "OK";
    }

    public String ac_set_tlog_$_1(Args args) {
        this._tLogRoot = args.argv(0);
        if (this._tLogRoot.equals("null")) {
            this._tLogRoot = null;
            return "remote ftp transaction logging is off";
        }
        return "remote ftp transactions will be logged to " + this._tLogRoot;
    }

    public String ac_set_max_transfers_$_1(Args args) {
        int max = Integer.parseInt(args.argv(0));
        if (max <= 0) {
            return "Error, max transfers number should be greater then 0 ";
        }
        this.setMaxTransfers(max);
        return "set maximum number of active transfers to " + max;
    }

    public String ac_set_pool_timeout_$_1(Args args) {
        int timeout = Integer.parseInt(args.argv(0));
        if (timeout <= 0) {
            return "Error, pool timeout should be greater then 0 ";
        }
        this._poolTimeout = timeout;
        return "set pool timeout to " + timeout + " seconds";
    }

    public String ac_set_pool_manager_timeout_$_1(Args args) {
        int timeout = Integer.parseInt(args.argv(0));
        if (timeout <= 0) {
            return "Error, pool manger timeout should be greater then 0 ";
        }
        this._poolManagerTimeout = timeout;
        return "set pool manager timeout to " + timeout + " seconds";
    }

    public String ac_set_pnfs_manager_timeout_$_1(Args args) {
        int timeout = Integer.parseInt(args.argv(0));
        if (timeout <= 0) {
            return "Error, pnfs manger timeout should be greater then 0 ";
        }
        this._pnfsManagerTimeout = timeout;
        return "set pnfs manager timeout to " + timeout + " seconds";
    }

    public String ac_ls_$_0_1(Args args) {
        boolean long_format = args.hasOption("l");
        if (args.argc() > 0) {
            long id = Long.parseLong(args.argv(0));
            TransferManagerHandler handler = this._activeTransfers.get(id);
            if (handler == null) {
                return "ID not found : " + id;
            }
            return " transfer id=" + id + " : " + handler.toString(long_format);
        }
        StringBuilder sb = new StringBuilder();
        if (this._activeTransfers.isEmpty()) {
            return "No Active Transfers";
        }
        sb.append("  Active Transfers ");
        for (Map.Entry<Long, TransferManagerHandler> e : this._activeTransfers.entrySet()) {
            sb.append("\n#").append(e.getKey());
            sb.append(" ").append(e.getValue().toString(long_format));
        }
        return sb.toString();
    }

    public String ac_kill_$_1(Args args) {
        long id = Long.parseLong(args.argv(0));
        TransferManagerHandler handler = this._activeTransfers.get(id);
        if (handler == null) {
            return "ID not found : " + id;
        }
        handler.cancel(null);
        return "this will kill the running mover or the mover queued on the pool!!!\nkilling the Transfer:\n" + handler.toString(true);
    }

    public String ac_killall_$_1_2(Args args) {
        try {
            Pattern p = Pattern.compile(args.argv(0));
            String pool = null;
            if (args.argc() > 1) {
                pool = args.argv(1);
            }
            ArrayList<TransferManagerHandler> handlersToKill = new ArrayList<TransferManagerHandler>();
            for (Map.Entry<Long, TransferManagerHandler> e : this._activeTransfers.entrySet()) {
                long id = e.getKey();
                TransferManagerHandler handler = e.getValue();
                Matcher m = p.matcher(String.valueOf(id));
                if (m.matches()) {
                    log.debug("pattern: \"{}\" matches id=\"{}\"", (Object)args.argv(0), (Object)id);
                    if (pool != null && pool.equals(handler.getPool())) {
                        handlersToKill.add(handler);
                        continue;
                    }
                    if (pool != null) continue;
                    handlersToKill.add(handler);
                    continue;
                }
                log.debug("pattern: \"{}\" does not match id=\"{}\"", (Object)args.argv(0), (Object)id);
            }
            if (handlersToKill.isEmpty()) {
                return "no active transfers match the pattern and the pool";
            }
            StringBuilder sb = new StringBuilder("Killing these transfers: \n");
            for (TransferManagerHandler handler : handlersToKill) {
                handler.cancel();
                sb.append(handler.toString(true)).append('\n');
            }
            return sb.toString();
        }
        catch (Exception e) {
            log.error(e.toString());
            return e.toString();
        }
    }

    public String ac_set_io_queue_$_1(Args args) {
        String newIoQueueName = args.argv(0);
        if (newIoQueueName.equals("null")) {
            this._ioQueueName = null;
            return "io-queue is set to null";
        }
        this._ioQueueName = newIoQueueName;
        return "io_queue was set to " + this._ioQueueName;
    }

    public void messageArrived(CellMessage envelope, DoorTransferFinishedMessage message) {
        long id = message.getId();
        TransferManagerHandler h = this.getHandler(id);
        if (h != null) {
            h.poolDoorMessageArrived(message);
        } else {
            log.error("can not find handler with id={}", (Object)id);
        }
    }

    public CancelTransferMessage messageArrived(CellMessage envelope, CancelTransferMessage message) {
        long id = message.getId();
        TransferManagerHandler h = this.getHandler(id);
        if (h != null) {
            h.cancel(message);
        } else {
            log.error("can not find handler with id={}", (Object)id);
        }
        return message;
    }

    public TransferManagerMessage messageArrived(CellMessage envelope, TransferManagerMessage message) throws CacheException {
        if (!this.newTransfer()) {
            throw new CacheException(1, "too many transfers!");
        }
        new TransferManagerHandler(this, message, envelope.getSourceAddress()).handle();
        return message;
    }

    public int getMaxTransfers() {
        return this._maxTransfers;
    }

    public void setMaxTransfers(int max_transfers) {
        this._maxTransfers = max_transfers;
    }

    private synchronized boolean newTransfer() {
        log.debug("newTransfer() num_transfers = {} max_transfers={}", (Object)this._numTransfers, (Object)this._maxTransfers);
        if (this._numTransfers == this._maxTransfers) {
            log.debug("newTransfer() returns false");
            return false;
        }
        log.debug("newTransfer() INCREMENT and return true");
        ++this._numTransfers;
        return true;
    }

    synchronized void finishTransfer() {
        log.debug("finishTransfer() num_transfers = {} DECREMENT", (Object)this._numTransfers);
        --this._numTransfers;
    }

    public synchronized long getNextMessageID() {
        if (this.idGenerator != null) {
            try {
                nextMessageID = this.idGenerator.nextLong();
            }
            catch (Exception e) {
                log.error("Having trouble getting getNextMessageID from DB");
                log.error(e.toString());
                log.error("will nullify requestsPropertyStorage");
                this.idGenerator = null;
                this.getNextMessageID();
            }
        } else {
            if (nextMessageID == Long.MAX_VALUE) {
                nextMessageID = 0L;
                return Long.MAX_VALUE;
            }
            return nextMessageID++;
        }
        return nextMessageID;
    }

    protected abstract IpProtocolInfo getProtocolInfo(TransferManagerMessage var1) throws IOException;

    protected TransferManagerHandler getHandler(long handlerId) {
        return this._activeTransfers.get(handlerId);
    }

    public void startTimer(final long id) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                log.error("timer for handler " + id + " has expired, killing");
                Object o = TransferManager.this._moverTimeoutTimerTasks.remove(id);
                if (o == null) {
                    log.error("TimerTask.run(): timer task for handler Id={} not found in moverTimoutTimerTasks hashtable", (Object)id);
                    return;
                }
                TransferManagerHandler handler = TransferManager.this.getHandler(id);
                if (handler == null) {
                    log.error("TimerTask.run(): timer task for handler Id={} could not find handler !!!", (Object)id);
                    return;
                }
                handler.timeout();
            }
        };
        this._moverTimeoutTimerTasks.put(id, task);
        this._moverTimeoutTimer.schedule(task, this._moverTimeout * 1000L);
    }

    public void stopTimer(long id) {
        TimerTask tt = this._moverTimeoutTimerTasks.remove(id);
        if (tt == null) {
            log.error("stopTimer(): timer not found for Id={}", (Object)id);
            return;
        }
        log.debug("canceling the mover timer for handler id {}", (Object)id);
        tt.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveTransfer(long id, TransferManagerHandler handler) {
        this._activeTransfers.put(id, handler);
        PersistenceManager persistanceManager = this._pm;
        if (this.doDbLogging() && persistanceManager != null) {
            PersistenceManager persistenceManager = persistanceManager;
            synchronized (persistenceManager) {
                Transaction tx = persistanceManager.currentTransaction();
                try {
                    tx.begin();
                    persistanceManager.makePersistent((Object)handler);
                    tx.commit();
                    log.debug("Recording new handler into database.");
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
                finally {
                    TransferManager.rollbackIfActive(tx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveTransfer(long id) {
        TransferManagerHandler handler = this._activeTransfers.remove(id);
        PersistenceManager persistanceManager = this._pm;
        if (this.doDbLogging() && persistanceManager != null) {
            PersistenceManager persistenceManager = persistanceManager;
            synchronized (persistenceManager) {
                TransferManagerHandlerBackup handlerBackup = new TransferManagerHandlerBackup(handler);
                Transaction tx = persistanceManager.currentTransaction();
                try {
                    tx.begin();
                    persistanceManager.makePersistent((Object)handler);
                    persistanceManager.deletePersistent((Object)handler);
                    persistanceManager.makePersistent((Object)handlerBackup);
                    tx.commit();
                    log.debug("handler removed from db");
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
                finally {
                    TransferManager.rollbackIfActive(tx);
                }
            }
        }
    }

    public int getNumberOfTranfers() {
        return this._numTransfers;
    }

    public long getPoolTimeout() {
        return this._poolTimeout;
    }

    public long getPoolManagerTimeout() {
        return this._poolManagerTimeout;
    }

    public long getPnfsManagerTimeout() {
        return this._pnfsManagerTimeout;
    }

    public long getMoverTimeout() {
        return this._moverTimeout;
    }

    public String getLogRootName() {
        return this._tLogRoot;
    }

    public boolean isOverwrite() {
        return this._overwrite;
    }

    public CellPath getPoolManagerPath() {
        return this._poolMgrPath;
    }

    public String getPoolManagerName() {
        return this._poolManager;
    }

    public String getPnfsManagerName() {
        return this._pnfsManager;
    }

    public String getIoQueueName() {
        return this._ioQueueName;
    }

    public synchronized PersistenceManager getPersistenceManager() {
        return this._pm;
    }

    public static void rollbackIfActive(Transaction tx) {
        if (tx != null && tx.isActive()) {
            tx.rollback();
        }
    }

    public boolean doDbLogging() {
        return this._doDatabaseLogging;
    }

    public void setDbLogging(boolean yes) {
        this._doDatabaseLogging = yes;
    }

    public void setMaxNumberOfDeleteRetries(int nretries) {
        this._maxNumberOfDeleteRetries = nretries;
    }

    public int getMaxNumberOfDeleteRetries() {
        return this._maxNumberOfDeleteRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object o) {
        PersistenceManager persistanceManager = this._pm;
        if (this.doDbLogging() && persistanceManager != null) {
            PersistenceManager persistenceManager = persistanceManager;
            synchronized (persistenceManager) {
                Transaction tx = persistanceManager.currentTransaction();
                try {
                    tx.begin();
                    persistanceManager.makePersistent(o);
                    tx.commit();
                    log.debug("[" + o.toString() + "]: Recording new state of handler into database.");
                }
                catch (Exception e) {
                    log.error("[" + o.toString() + "]: failed to persist obhject " + o.toString());
                    log.error(e.toString());
                }
                finally {
                    TransferManager.rollbackIfActive(tx);
                }
            }
        }
    }

    public String getPoolProxy() {
        return this._poolProxy;
    }

    public void setPoolProxy(String poolProxy) {
        this._poolProxy = poolProxy;
    }
}

