/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.repository;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.StorageInfo;
import java.io.Serializable;
import org.dcache.pool.repository.CacheEntry;

public class CacheRepositoryEntryInfo
implements Serializable {
    static final long serialVersionUID = -4494188511917602601L;
    private static final int PRECIOUS_BIT = 0;
    private static final int CACHED_BIT = 1;
    private static final int RECEIVINGFROMCLIENT_BIT = 2;
    private static final int RECEIVINGFROMSTORE_BIT = 3;
    private static final int SENDINGTOSTORE_BIT = 4;
    private static final int BAD_BIT = 5;
    private static final int REMOVED_BIT = 6;
    private static final int DESTROYED_BIT = 7;
    private static final int STICKY_BIT = 8;
    private PnfsId pnfsId;
    private int bitmask;
    private long lastAccessTime;
    private long creationTime;
    private StorageInfo storageInfo;
    private long size;

    public CacheRepositoryEntryInfo() {
    }

    public CacheRepositoryEntryInfo(CacheEntry entry) {
        this.pnfsId = entry.getPnfsId();
        this.lastAccessTime = entry.getLastAccessTime();
        this.creationTime = entry.getCreationTime();
        this.storageInfo = entry.getStorageInfo();
        this.size = entry.getReplicaSize();
        switch (entry.getState()) {
            case PRECIOUS: {
                this.setBit(0, true);
                break;
            }
            case CACHED: {
                this.setBit(1, true);
                break;
            }
            case FROM_CLIENT: {
                this.setBit(2, true);
                break;
            }
            case FROM_POOL: 
            case FROM_STORE: {
                this.setBit(3, true);
                break;
            }
            case BROKEN: {
                this.setBit(5, true);
                break;
            }
            case REMOVED: {
                this.setBit(6, true);
                break;
            }
            case NEW: 
            case DESTROYED: {
                throw new RuntimeException("Bug. An entry should never be in NEW or DESTROYED.");
            }
        }
        this.setBit(8, entry.isSticky());
    }

    private final void setBit(int bitnum, boolean val) {
        this.bitmask = val ? (this.bitmask |= 1 << bitnum) : (this.bitmask &= ~(1 << bitnum));
    }

    private final boolean getBit(int bitnum) {
        return (this.bitmask & 1 << bitnum) != 0;
    }

    private String getBitMaskString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 31; i >= 0; --i) {
            sb.append(this.getBit(i) ? (char)'1' : '0');
        }
        return sb.toString();
    }

    public int getBitMask() {
        return this.bitmask;
    }

    public boolean isPrecious() {
        return this.getBit(0);
    }

    public boolean isCached() {
        return this.getBit(1);
    }

    public boolean isReceivingFromClient() {
        return this.getBit(2);
    }

    public boolean isReceivingFromStore() {
        return this.getBit(3);
    }

    public boolean isSendingToStore() {
        return this.getBit(4);
    }

    public boolean isBad() {
        return this.getBit(5);
    }

    public boolean isRemoved() {
        return this.getBit(6);
    }

    public boolean isDestroyed() {
        return this.getBit(7);
    }

    public boolean isSticky() {
        return this.getBit(8);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public StorageInfo getStorageInfo() {
        return this.storageInfo;
    }

    public PnfsId getPnfsId() {
        return this.pnfsId;
    }

    public long getSize() {
        return this.size;
    }

    public static void main(String[] args) {
        CacheRepositoryEntryInfo info = new CacheRepositoryEntryInfo();
        System.out.printf(" bitmask = %1$S\n", info.getBitMaskString());
        info.setBit(0, true);
        info.setBit(1, true);
        info.setBit(15, true);
        System.out.printf(" bitmask = %1$S\n", info.getBitMaskString());
        System.out.printf(" bit 0 = %1$b", info.getBit(0));
        System.out.printf(" bit 1 = %1$b", info.getBit(1));
        System.out.printf(" bit 3 = %1$b", info.getBit(3));
        System.out.printf(" bit 14 = %1$b", info.getBit(14));
        System.out.printf(" bit 15 = %1$b", info.getBit(15));
        System.out.printf(" bit 16 = %1$b", info.getBit(16));
    }
}

