/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.replicaManager;

import diskCacheV111.replicaManager.ReplicaDb1;
import diskCacheV111.repository.CacheRepositoryEntryInfo;
import diskCacheV111.util.PnfsId;
import dmg.cells.nucleus.CellAdapter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.dcache.commons.util.SqlHelper;
import org.dcache.util.JdbcConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaDbV1
implements ReplicaDb1 {
    private static final String _cvsId = "$Id: ReplicaDbV1.java 17266 2012-05-21 20:28:45Z tigran $";
    private static final Logger _log = LoggerFactory.getLogger(ReplicaDbV1.class);
    private CellAdapter _cell = null;
    private static DataSource DATASOURCE = null;
    private static final String ERRCODE_UNIQUE_VIOLATION = "23505";

    public ReplicaDbV1(CellAdapter cell) throws SQLException {
        this._cell = cell;
    }

    private void reportSQLException(String m, SQLException ex, String sql) {
        int iErr = ex.getErrorCode();
        String sState = ex.getSQLState();
        _log.warn("SQL exception in method " + m + ": '" + ex + "', errCode=" + iErr + " SQLState=" + sState + " SQLStatement=[" + sql + "]");
    }

    private void ignoredSQLException(String m, SQLException ex, String sql) {
        int iErr = ex.getErrorCode();
        String sState = ex.getSQLState();
        String exMsg = ex.getMessage().substring(5);
        _log.info("Ignore SQL exception in method " + m + ": '" + exMsg + "', errCode=" + iErr + " SQLState=" + sState + " SQLStatement=[" + sql + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addPool(PnfsId pnfsId, String poolName) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql1 = "INSERT INTO replicas SELECT ?, ?, now(), pools.poolid, ?, ?, ? FROM pools WHERE pools.pool=?";
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            pstmt = conn.prepareStatement("INSERT INTO replicas SELECT ?, ?, now(), pools.poolid, ?, ?, ? FROM pools WHERE pools.pool=?");
            pstmt.setString(1, poolName);
            pstmt.setString(2, pnfsId.toString());
            pstmt.setInt(3, 1);
            pstmt.setBoolean(4, true);
            pstmt.setBoolean(5, false);
            pstmt.setString(6, poolName);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            block5: {
                try {
                    String exState = ex.getSQLState();
                    if (exState.equals(ERRCODE_UNIQUE_VIOLATION)) {
                        String s = ex.getMessage().substring(5);
                        _log.info("WARNING" + s + "; caused by duplicate message, ignore for now. pnfsid=" + pnfsId.toString() + " pool=" + poolName);
                        this.ignoredSQLException("addPool()", ex, "INSERT INTO replicas SELECT ?, ?, now(), pools.poolid, ?, ?, ? FROM pools WHERE pools.pool=?");
                        break block5;
                    }
                    _log.warn("Database access error", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SqlHelper.tryToClose(pstmt);
                    SqlHelper.tryToClose((Connection)conn);
                    throw throwable;
                }
            }
            SqlHelper.tryToClose((PreparedStatement)pstmt);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((PreparedStatement)pstmt);
        SqlHelper.tryToClose((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addPnfsToPool(List<CacheRepositoryEntryInfo> fileList, String poolName) {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        String sql = MessageFormat.format("INSERT INTO replicas SELECT ''{0}'', ?, now(), pools.poolid, ?, ?, ? FROM pools WHERE pools.pool=''{0}''", poolName);
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.createStatement();
            pstmt = conn.prepareStatement(sql);
            for (CacheRepositoryEntryInfo info : fileList) {
                String pnfsId = info.getPnfsId().toString();
                int bitmask = info.getBitMask();
                boolean countable = info.isPrecious() && !info.isReceivingFromClient() && !info.isReceivingFromStore() && !info.isBad() && !info.isRemoved() && !info.isDestroyed();
                try {
                    pstmt.setString(1, pnfsId);
                    pstmt.setInt(2, bitmask);
                    pstmt.setBoolean(3, countable);
                    pstmt.setBoolean(4, false);
                    pstmt.executeUpdate();
                }
                catch (SQLException ex) {
                    String exState = ex.getSQLState();
                    if (exState.equals(ERRCODE_UNIQUE_VIOLATION)) {
                        String s = ex.getMessage().substring(5);
                        _log.info("WARNING" + s + "; caused by duplicate message, ignore for now. pnfsid=" + pnfsId + " pool=" + poolName);
                        this.ignoredSQLException("addPool()", ex, sql);
                        continue;
                    }
                    _log.warn("Database access error", (Throwable)ex);
                }
            }
        }
        catch (SQLException e) {
            try {
                _log.warn("addPnfsToPool: prepareStatement error", (Throwable)e);
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(pstmt);
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose(pstmt);
            SqlHelper.tryToClose((Statement)stmt);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((PreparedStatement)pstmt);
        SqlHelper.tryToClose((Statement)stmt);
        SqlHelper.tryToClose((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePool(PnfsId pnfsId, String poolName) {
        Connection conn = null;
        PreparedStatement stmt = null;
        String sql = "DELETE FROM ONLY replicas WHERE pool = ? and pnfsId = ?";
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, poolName);
            stmt.setString(2, pnfsId.toString());
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _log.warn("WARNING: Database access error, can not delete pnfsId='" + pnfsId.toString() + "' " + "at pool = '" + poolName + "' from replicas DB table");
                this.reportSQLException("removePool()", ex, sql);
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((PreparedStatement)stmt);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((PreparedStatement)stmt);
        SqlHelper.tryToClose((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countPools(PnfsId pnfsId) {
        int n;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rset = null;
        String sql = "SELECT pool FROM ONLY replicas WHERE pnfsId = ?";
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pnfsId.toString());
            rset = stmt.executeQuery();
            n = rset.getFetchSize();
        }
        catch (SQLException ex) {
            int n2;
            try {
                _log.warn("Database access error", (Throwable)ex);
                this.reportSQLException("countPools()", ex, sql);
                n2 = -1;
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(rset);
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose(rset);
            SqlHelper.tryToClose((PreparedStatement)stmt);
            SqlHelper.tryToClose((Connection)conn);
            return n2;
        }
        SqlHelper.tryToClose((ResultSet)rset);
        SqlHelper.tryToClose((PreparedStatement)stmt);
        SqlHelper.tryToClose((Connection)conn);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPools(PnfsId pnfsId) {
        Connection conn = null;
        PreparedStatement statement = null;
        String sqlDeleteFromReplicas = "DELETE FROM replicas WHERE pnfsId = ?";
        String sqlDeleteFromExcluded = "DELETE FROM excluded WHERE pnfsId = ?";
        String sqlDeleteFromFiles = "DELETE FROM files    WHERE pnfsId = ?";
        try {
            conn = DATASOURCE.getConnection();
            conn.setTransactionIsolation(8);
            conn.setAutoCommit(false);
            statement = conn.prepareStatement(sqlDeleteFromReplicas);
            statement.setString(1, pnfsId.toString());
            statement.executeUpdate();
            statement = conn.prepareStatement(sqlDeleteFromExcluded);
            statement.setString(1, pnfsId.toString());
            statement.executeUpdate();
            statement = conn.prepareStatement(sqlDeleteFromFiles);
            statement.setString(1, pnfsId.toString());
            statement.executeUpdate();
            conn.commit();
        }
        catch (Exception ex) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e) {
                    _log.error(e.toString());
                }
                _log.warn("Database access error", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(statement);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((PreparedStatement)statement);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((PreparedStatement)statement);
        SqlHelper.tryToClose((Connection)conn);
    }

    @Override
    public Iterator pnfsIds() {
        try {
            return new PnfsIdIterator();
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    public Iterator getPnfsIds() {
        try {
            return new PnfsIdIterator();
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    @Override
    public Iterator pnfsIds(String poolName) {
        try {
            return new PnfsIdIterator(poolName);
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    public Iterator getPnfsIds(String poolName) {
        try {
            return new PnfsIdIterator(poolName);
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    @Override
    public Iterator getPools() {
        try {
            return new PoolsIterator();
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    @Override
    public Iterator getPools(PnfsId pnfsId) {
        try {
            return new PoolsIterator(pnfsId);
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    @Override
    public Iterator getPoolsWritable() {
        try {
            return new PoolsWritableIterator();
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    @Override
    public Iterator getPoolsReadable() {
        try {
            return new PoolsReadableIterator();
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DATASOURCE.getConnection();
            conn.setTransactionIsolation(8);
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            stmt.executeUpdate("TRUNCATE TABLE replicas");
            stmt.executeUpdate("TRUNCATE TABLE pools");
            stmt.executeUpdate("TRUNCATE TABLE deficient");
            stmt.executeUpdate("TRUNCATE TABLE redundant");
            stmt.executeUpdate("TRUNCATE TABLE excluded");
            conn.commit();
        }
        catch (Exception ex) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    _log.error(e1.toString());
                }
                _log.warn("Can't clear the tables");
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((Statement)stmt);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((Statement)stmt);
        SqlHelper.tryToClose((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPool(String poolName) {
        Connection conn = null;
        PreparedStatement statement = null;
        String sqlDeleteReplicas = "DELETE FROM ONLY replicas WHERE pool=?";
        String sqlDeletePools = "DELETE FROM pools    WHERE pool=?";
        try {
            conn = DATASOURCE.getConnection();
            conn.setTransactionIsolation(8);
            conn.setAutoCommit(false);
            statement = conn.prepareStatement(sqlDeleteReplicas);
            statement.setString(1, poolName);
            statement.executeUpdate();
            statement = conn.prepareStatement(sqlDeletePools);
            statement.setString(1, poolName);
            statement.executeUpdate();
            conn.commit();
        }
        catch (SQLException ex) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    _log.error(ex.toString());
                }
                _log.warn("Can't remove pool '" + poolName + "' from the DB");
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(statement);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((PreparedStatement)statement);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((PreparedStatement)statement);
        SqlHelper.tryToClose((Connection)conn);
    }

    @Override
    public Iterator getRedundant(int maxcnt) {
        try {
            return new getRedundantIterator(maxcnt);
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    @Override
    public Iterator getDeficient(int mincnt) {
        try {
            return new getDeficientIterator(mincnt);
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    @Override
    public Iterator getMissing() {
        try {
            return new getMissingIterator();
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePoolStatus(String poolName) {
        Connection conn = null;
        PreparedStatement stmt = null;
        String sql = "DELETE FROM pools WHERE pool=?";
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, poolName);
            stmt.executeUpdate();
        }
        catch (Exception ex) {
            try {
                _log.warn("Can't remove pool '" + poolName + "' from the DB", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((PreparedStatement)stmt);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((PreparedStatement)stmt);
        SqlHelper.tryToClose((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolStatus(String poolName, String poolStatus) {
        Connection conn = null;
        PreparedStatement stmt = null;
        String sql_i = "insert into pools values (?,?,now())";
        String sql_u = "update pools set status=?, datestamp=now() where pool=?";
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.prepareStatement(sql_i);
            stmt.setString(1, poolName);
            stmt.setString(2, poolStatus);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                _log.debug(ex.toString(), (Throwable)ex);
                try {
                    stmt = conn.prepareStatement(sql_u);
                    stmt.setString(1, poolStatus);
                    stmt.setString(2, poolName);
                    stmt.executeUpdate();
                }
                catch (SQLException ex2) {
                    _log.warn("setPoolStatus() ERROR: Can't add/update pool '" + poolName + "'" + " status in 'pools' table in DB", (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((PreparedStatement)stmt);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((PreparedStatement)stmt);
        SqlHelper.tryToClose((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPoolStatus(String poolName) {
        String string;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rset = null;
        String sql = "SELECT status FROM pools WHERE pool=?";
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, poolName);
            rset = stmt.executeQuery();
            rset.next();
            string = rset.getString(1);
        }
        catch (SQLException ex) {
            String string2;
            try {
                this.reportSQLException("getPoolStatus()", ex, sql);
                _log.warn("DB: Can't get status for pool '" + poolName + "' from pools table, return 'UNKNOWN'");
                string2 = "UNKNOWN";
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(rset);
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((ResultSet)rset);
            SqlHelper.tryToClose((PreparedStatement)stmt);
            SqlHelper.tryToClose((Connection)conn);
            return string2;
        }
        SqlHelper.tryToClose((ResultSet)rset);
        SqlHelper.tryToClose((PreparedStatement)stmt);
        SqlHelper.tryToClose((Connection)conn);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransaction(PnfsId pnfsId, long timestamp, int count) {
        Connection conn = null;
        Statement stmt = null;
        String op = count > 0 ? "replicate" : (count < 0 ? "reduce" : "exclude");
        String sql = MessageFormat.format("INSERT INTO actions VALUES (''{0}'',''{1}'',''{2}'',''{3}'',now(),{4,number,#})", op, "s", pnfsId.toString(), "d", timestamp);
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            try {
                _log.warn("Can't add transaction to the DB", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((Statement)stmt);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((Statement)stmt);
        SqlHelper.tryToClose((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExcluded(PnfsId pnfsId, long timestamp, String errcode, String errmsg) {
        Connection conn = null;
        Statement stmt = null;
        String sql = MessageFormat.format("INSERT INTO excluded VALUES (''{0}'',''{1}'',now(),{2,number,#},10000,{3,number,#},''{4}'',''{5}'')", "s", pnfsId.toString(), timestamp, 65535, errcode, errmsg);
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            try {
                _log.warn("Can't add transaction to the DB", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((Statement)stmt);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((Statement)stmt);
        SqlHelper.tryToClose((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransaction(PnfsId pnfsId) {
        Connection conn = null;
        Statement stmt = null;
        String sql = MessageFormat.format("DELETE FROM actions WHERE pnfsId = ''{0}''", pnfsId.toString());
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            try {
                _log.warn("Can't remove transaction from the DB", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((Statement)stmt);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((Statement)stmt);
        SqlHelper.tryToClose((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int releaseExcluded(long timestamp) {
        Connection conn = null;
        Statement stmt = null;
        String sql = "DELETE FROM excluded WHERE timestamp < " + timestamp;
        int count = 0;
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.createStatement();
            count = stmt.executeUpdate(sql);
        }
        catch (Exception ex) {
            try {
                _log.warn("Can't delete old records from the 'excluded' table", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((Statement)stmt);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((Statement)stmt);
        SqlHelper.tryToClose((Connection)conn);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTransactions() {
        Connection conn = null;
        Statement stmt = null;
        String sql = "DELETE FROM actions WHERE action IN ('replicate', 'reduce')";
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.createStatement();
            stmt.executeUpdate("DELETE FROM actions WHERE action IN ('replicate', 'reduce')");
        }
        catch (Exception ex) {
            try {
                _log.warn("Can't clear transactions from the DB", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((Statement)stmt);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((Statement)stmt);
        SqlHelper.tryToClose((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimestamp(PnfsId pnfsId) {
        long l;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rset = null;
        String sql = "SELECT timestamp FROM actions WHERE pnfsId = ?";
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pnfsId.toString());
            rset = stmt.executeQuery();
            rset.next();
            l = rset.getLong(1);
        }
        catch (Exception ex) {
            long l2;
            try {
                _log.warn("Can't get data from the DB", (Throwable)ex);
                l2 = -1L;
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(rset);
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose(rset);
            SqlHelper.tryToClose((PreparedStatement)stmt);
            SqlHelper.tryToClose((Connection)conn);
            return l2;
        }
        SqlHelper.tryToClose((ResultSet)rset);
        SqlHelper.tryToClose((PreparedStatement)stmt);
        SqlHelper.tryToClose((Connection)conn);
        return l;
    }

    @Override
    public Iterator pnfsIds(long timestamp) {
        try {
            return new PnfsIdIterator(timestamp);
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    public Iterator getPnfsIds(long timestamp) {
        try {
            return new PnfsIdIterator(timestamp);
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePool(String poolName) {
        Connection conn = null;
        PreparedStatement statement = null;
        String sql = "DELETE FROM ONLY replicas WHERE pool=?";
        try {
            conn = DATASOURCE.getConnection();
            conn.setTransactionIsolation(8);
            conn.setAutoCommit(false);
            statement = conn.prepareStatement(sql);
            statement.setString(1, poolName);
            statement.executeUpdate();
            conn.commit();
        }
        catch (Exception ex) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                _log.warn("Can't remove pool '" + poolName + "' from the DB");
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(statement);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((PreparedStatement)statement);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((PreparedStatement)statement);
        SqlHelper.tryToClose((Connection)conn);
    }

    @Override
    public Iterator getInDrainoffOnly() {
        try {
            return new getDrainingIterator();
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    @Override
    public Iterator getInOfflineOnly() {
        try {
            return new getOfflineIterator();
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
            return new HashSet().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHeartBeat(String name, String desc) {
        Connection conn = null;
        PreparedStatement stmt = null;
        String sql_i = "insert into heartbeat values (?,?,now())";
        String sql_u = "update heartbeat set description=?, datestamp=now() where process=?";
        try {
            conn = DATASOURCE.getConnection();
            conn.setAutoCommit(true);
            stmt = conn.prepareStatement("insert into heartbeat values (?,?,now())");
            stmt.setString(1, name);
            stmt.setString(2, desc);
            stmt.executeUpdate();
        }
        catch (Exception ex) {
            try {
                _log.debug(ex.toString());
                try {
                    stmt = conn.prepareStatement("update heartbeat set description=?, datestamp=now() where process=?");
                    stmt.setString(1, desc);
                    stmt.setString(2, name);
                    stmt.executeUpdate();
                }
                catch (Exception ex2) {
                    _log.warn("setHeartBeat() ERROR: Can't add/update process '" + name + "' status in 'heartbeat' table in DB", (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
            SqlHelper.tryToClose((PreparedStatement)stmt);
            SqlHelper.tryToClose((Connection)conn);
        }
        SqlHelper.tryToClose((PreparedStatement)stmt);
        SqlHelper.tryToClose((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHeartBeat(String name) {
        block5: {
            Connection conn = null;
            PreparedStatement stmt = null;
            String sql = "DELETE FROM heartbeat WHERE process = ?";
            try {
                conn = DATASOURCE.getConnection();
                conn.setAutoCommit(true);
                stmt = conn.prepareStatement("DELETE FROM heartbeat WHERE process = ?");
                stmt.setString(1, name);
                stmt.executeUpdate();
                SqlHelper.tryToClose((PreparedStatement)stmt);
            }
            catch (Exception ex) {
                _log.warn("Database access error", (Throwable)ex);
                break block5;
            }
            finally {
                SqlHelper.tryToClose(stmt);
                SqlHelper.tryToClose((Connection)conn);
            }
            SqlHelper.tryToClose((Connection)conn);
        }
    }

    public static void printClassName(Object obj) {
        System.out.println("The class of " + obj + " is " + obj.getClass().getName());
    }

    public static final void setup(String connectURI, String jdbcClass, String user, String password) {
        try {
            DATASOURCE = JdbcConnectionPool.getDataSource(connectURI, jdbcClass, user, password);
        }
        catch (SQLException e) {
            _log.error(e.toString(), (Throwable)e);
        }
    }

    public static void main(String[] args) throws SQLException {
        Object[] r;
        System.out.println("Test ReplicaDbV1, cvsId=$Id: ReplicaDbV1.java 17266 2012-05-21 20:28:45Z tigran $");
        ReplicaDbV1.setup("jdbc:postgresql://localhost:5432/replicas", "org.postgresql.Driver", "enstore", "NoPassword");
        ReplicaDbV1 db = new ReplicaDbV1(null);
        System.out.println("List pnfsId's in all pools");
        Iterator i = db.pnfsIds();
        while (i.hasNext()) {
            System.out.println(i.next().toString());
        }
        Iterator p = db.getPools();
        while (p.hasNext()) {
            String pool = p.next().toString();
            System.out.println("Pool : " + pool);
            Iterator j = db.pnfsIds(pool);
            while (j.hasNext()) {
                System.out.println(j.next().toString());
            }
        }
        PnfsId pnfsId = new PnfsId("1234");
        System.out.println("WARNING: db.countPools(...) is depreciated and will not work with newer postgres release ");
        db.addPool(pnfsId, "pool1");
        db.addPool(pnfsId, "pool2");
        db.addPool(pnfsId, "pool3");
        System.out.println("pools: " + db.countPools(pnfsId));
        db.removePool(pnfsId, "pool1");
        System.out.println("pools: " + db.countPools(pnfsId));
        db.addPool(pnfsId, "pool1");
        System.out.println("pools: " + db.countPools(pnfsId));
        db.clearPools(pnfsId);
        System.out.println("pools: " + db.countPools(pnfsId));
        db.addPool(pnfsId, "pool2");
        System.out.println("pools: " + db.countPools(pnfsId));
        Iterator i2 = db.getPools(pnfsId);
        while (i2.hasNext()) {
            System.out.println(" pnfsid : " + pnfsId + ", pool : " + i2.next());
        }
        db.removePool(pnfsId, "pool2");
        System.out.println("pools: " + db.countPools(pnfsId));
        i2 = db.getPools(pnfsId);
        while (i2.hasNext()) {
            System.out.println(" pnfsid : " + pnfsId + ", pool : " + i2.next());
        }
        i2 = db.getMissing();
        while (i2.hasNext()) {
            System.out.println(" Missing pnfsid : " + i2.next());
        }
        i2 = db.getDeficient(2);
        while (i2.hasNext()) {
            r = (Object[])i2.next();
            System.out.println(" Deficient pnfsid : " + r[0] + ": " + r[1]);
        }
        i2 = db.getRedundant(3);
        while (i2.hasNext()) {
            r = (Object[])i2.next();
            System.out.println(" Redundant pnfsid : " + r[0] + ": " + r[1]);
        }
        System.out.println("pool1: Status : '" + db.getPoolStatus("pool1") + "'");
        System.out.println("pool11111111111: Status : '" + db.getPoolStatus("pool11111111111") + "'");
        db.setPoolStatus("pool9", "offline");
        System.out.println("pool9: Status : '" + db.getPoolStatus("pool9") + "'");
        db.clearPool("pool9");
        System.exit(0);
    }

    static /* synthetic */ DataSource access$000() {
        return DATASOURCE;
    }

    private class getOfflineIterator
    extends DbIterator {
        private getOfflineIterator() throws SQLException {
            String sql = "SELECT ro.pnfsid FROM ONLY replicas ro, pools po WHERE ro.pool = po.pool AND po.status = 'offline-prepare' GROUP BY ro.pnfsid EXCEPT SELECT r.pnfsid FROM (       SELECT rr.pnfsid FROM ONLY replicas rr, pools pp        WHERE rr.pool = pp.pool  AND pp.status = 'offline-prepare'        GROUP BY rr.pnfsid     ) r,      ONLY replicas r1,      pools p1 WHERE r.pnfsid = r1.pnfsid AND  p1.pool  = r1.pool AND  ( p1.status = 'online'      OR r.pnfsid IN (SELECT pnfsid FROM actions) ) GROUP BY r.pnfsid";
            this.stmt = this.conn.createStatement();
            this.rset = this.stmt.executeQuery(sql);
        }
    }

    private class getDrainingIterator
    extends DbIterator {
        private getDrainingIterator() throws SQLException {
            this.conn.setTransactionIsolation(8);
            this.conn.setAutoCommit(false);
            this.stmt = this.conn.createStatement();
            this.stmt.executeUpdate("TRUNCATE TABLE drainoff");
            String sql = "INSERT INTO drainoff        SELECT rd.pnfsid        FROM ONLY replicas rd, pools pd            WHERE rd.poolid = pd.poolid AND pd.status = 'drainoff'        GROUP BY rd.pnfsid";
            this.stmt.executeUpdate(sql);
            sql = "DELETE FROM drainoff WHERE pnfsid IN        (SELECT pnfsid         FROM ONLY replicas rd, pools pd            WHERE rd.poolid = pd.poolid AND pd.status = 'online'         GROUP BY pnfsid         UNION ALL         SELECT pnfsid FROM actions         UNION ALL         SELECT pnfsid FROM excluded        )";
            this.stmt.executeUpdate(sql);
            this.conn.commit();
            this.conn.setAutoCommit(true);
            this.rset = this.stmt.executeQuery("SELECT * FROM drainoff ORDER BY pnfsid");
        }
    }

    private class getMissingIterator
    extends DbIterator {
        private getMissingIterator() throws SQLException {
            String sql = "SELECT pnfsid FROM (SELECT pnfsid, sum(CASE WHEN pools.status='online' OR pools.status='offline' OR pools.status='offline-prepare' THEN 1 WHEN pools.status='reduce' THEN -1 ELSE 0 END) FROM replicas, pools WHERE replicas.pool=pools.pool GROUP BY pnfsid) AS tmp WHERE sum=0";
            this.stmt = this.conn.createStatement();
            this.rset = this.stmt.executeQuery(sql);
        }
    }

    private class getDeficientIterator
    extends DbIterator {
        private getDeficientIterator(int mincnt) throws SQLException {
            this.conn.setTransactionIsolation(8);
            this.conn.setAutoCommit(false);
            this.stmt = this.conn.createStatement();
            this.stmt.executeUpdate("TRUNCATE TABLE deficient");
            String sql = "INSERT INTO deficient  SELECT pnfsid, count(*)  FROM replicas, pools  WHERE        replicas.poolid=pools.poolid        AND pools.status IN ('online','offline','offline-prepare')       AND replicas.countable  GROUP BY pnfsid  HAVING count(*) < " + mincnt;
            this.stmt.executeUpdate(sql);
            this.stmt.executeUpdate("DELETE FROM deficient WHERE pnfsid IN (SELECT pnfsid FROM actions)");
            this.stmt.executeUpdate("DELETE FROM deficient WHERE pnfsid IN (SELECT pnfsid FROM excluded)");
            this.conn.commit();
            this.conn.setAutoCommit(true);
            this.rset = this.stmt.executeQuery("SELECT * FROM deficient ORDER BY count ASC");
        }

        @Override
        public Object next() {
            try {
                return new Object[]{this.rset.getObject(1), this.rset.getObject(2)};
            }
            catch (Exception ex) {
                _log.warn("Can't get the next element of the result set", (Throwable)ex);
                return null;
            }
        }
    }

    private class getRedundantIterator
    extends DbIterator {
        private getRedundantIterator(int maxcnt) throws SQLException {
            this.conn.setTransactionIsolation(8);
            this.conn.setAutoCommit(false);
            this.stmt = this.conn.createStatement();
            this.stmt.executeUpdate("TRUNCATE TABLE redundant");
            String sql = "INSERT  INTO redundant  SELECT pnfsid, count(*)  FROM ONLY replicas, pools  WHERE        replicas.poolid=pools.poolid        AND pools.status='online'       AND replicas.countable  GROUP BY pnfsid  HAVING count(*) > " + maxcnt;
            this.stmt.executeUpdate(sql);
            this.stmt.executeUpdate("DELETE FROM redundant WHERE pnfsid IN (SELECT pnfsid FROM actions)");
            this.stmt.executeUpdate("DELETE FROM redundant WHERE pnfsid IN (SELECT pnfsid FROM excluded)");
            this.conn.commit();
            this.conn.setAutoCommit(true);
            this.rset = this.stmt.executeQuery("SELECT * FROM redundant ORDER BY count DESC");
        }

        @Override
        public Object next() {
            try {
                return new Object[]{this.rset.getObject(1), this.rset.getObject(2)};
            }
            catch (Exception ex) {
                _log.warn("Can't get the next element of the result set", (Throwable)ex);
                return null;
            }
        }
    }

    private class PoolsReadableIterator
    extends DbIterator {
        private PoolsReadableIterator() throws SQLException {
            String query = "select * from pools WHERE (  status='online' OR status='drainoff' OR status='offline-prepare')";
            this.stmt = this.conn.createStatement();
            this.rset = this.stmt.executeQuery(query);
        }
    }

    private class PoolsWritableIterator
    extends DbIterator {
        private PoolsWritableIterator() throws SQLException {
            String query = "select * from pools WHERE status='online'";
            this.stmt = this.conn.createStatement();
            this.rset = this.stmt.executeQuery("select * from pools WHERE status='online'");
        }
    }

    private class PoolsIterator
    extends DbIterator {
        private PoolsIterator() throws SQLException {
            String sql = "SELECT * FROM pools";
            this.stmt = this.conn.createStatement();
            this.rset = this.stmt.executeQuery("SELECT * FROM pools");
        }

        private PoolsIterator(PnfsId pnfsId) throws SQLException {
            String sql = "SELECT pool FROM ONLY replicas WHERE pnfsId = ?";
            PreparedStatement statement = this.conn.prepareStatement(sql);
            statement.setString(1, pnfsId.toString());
            this.stmt = statement;
            this.rset = statement.executeQuery();
        }
    }

    private class PnfsIdIterator
    extends DbIterator {
        private PnfsIdIterator() throws SQLException {
            String sql = "SELECT pnfsId FROM ONLY replicas GROUP BY pnfsid";
            this.stmt = this.conn.createStatement();
            this.rset = this.stmt.executeQuery("SELECT pnfsId FROM ONLY replicas GROUP BY pnfsid");
        }

        private PnfsIdIterator(String poolName) throws SQLException {
            String sql = "SELECT pnfsId FROM ONLY replicas WHERE  pool = ?";
            PreparedStatement statement = this.conn.prepareStatement(sql);
            statement.setString(1, poolName);
            this.stmt = statement;
            this.rset = statement.executeQuery();
        }

        private PnfsIdIterator(long timestamp) throws SQLException {
            String sql = "SELECT pnfsId FROM actions WHERE timestamp < ?";
            PreparedStatement statement = this.conn.prepareStatement(sql);
            statement.setLong(1, timestamp);
            this.stmt = statement;
            this.rset = statement.executeQuery();
        }
    }

    protected abstract class DbIterator
    implements Iterator {
        protected Connection conn = ReplicaDbV1.access$000().getConnection();
        protected Statement stmt = null;
        protected ResultSet rset = null;

        public DbIterator() throws SQLException {
            this.conn.setAutoCommit(true);
        }

        @Override
        public boolean hasNext() {
            try {
                return this.rset.next();
            }
            catch (Exception ex) {
                _log.warn("Can't step to the next element of the result set", (Throwable)ex);
                return false;
            }
        }

        public Object next() {
            try {
                return this.rset.getObject(1);
            }
            catch (Exception ex) {
                _log.warn("Can't get the next element of the result set", (Throwable)ex);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("No remove");
        }

        public void close() {
            SqlHelper.tryToClose((ResultSet)this.rset);
            SqlHelper.tryToClose((Statement)this.stmt);
            SqlHelper.tryToClose((Connection)this.conn);
        }
    }
}

