/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.pools;

import diskCacheV111.pools.CostCalculatable;
import diskCacheV111.pools.PoolCostInfo;
import java.io.Serializable;
import java.util.Map;

public class CostCalculationV5
implements CostCalculatable,
Serializable {
    private final PoolCostInfo _info;
    private double _performanceCost = 0.0;
    private double _spaceCost = 0.0;
    private long _spaceCut = 60L;
    private final PoolCostInfo.PoolSpaceInfo _space;
    private static final long serialVersionUID = 1466064905628901498L;

    public CostCalculationV5(PoolCostInfo info) {
        this._info = info;
        this._space = this._info.getSpaceInfo();
    }

    @Override
    public double getSpaceCost() {
        return this._spaceCost;
    }

    @Override
    public double getPerformanceCost() {
        return this._performanceCost;
    }

    private double recalculateV4(long filesize) {
        if (filesize < this._space.getFreeSpace()) {
            return (double)filesize / (double)this._space.getFreeSpace() / this._space.getBreakEven();
        }
        if (this._space.getRemovableSpace() < this._space.getGap()) {
            return Double.POSITIVE_INFINITY;
        }
        return (double)filesize / (double)(this._space.getRemovableSpace() + this._space.getFreeSpace());
    }

    private double recalculateV5(long filesize, long lru) {
        double SPACECOST_AFTER_ONE_WEEK = this._space.getBreakEven();
        double spaceFactor = SPACECOST_AFTER_ONE_WEEK * 604800.0;
        if (this._space.getFreeSpace() > this._space.getGap()) {
            return (double)filesize / (double)this._space.getFreeSpace();
        }
        if (this._space.getRemovableSpace() < this._space.getGap()) {
            return Double.POSITIVE_INFINITY;
        }
        return 1.0 + spaceFactor / (double)Math.max(lru, this._spaceCut);
    }

    @Override
    public void recalculate(long filesize) {
        filesize = 3L * Math.max(filesize, 50000000L);
        long lru = this._space.getLRUSeconds();
        this._spaceCost = this._space.getBreakEven() >= 1.0 ? this.recalculateV4(filesize) : this.recalculateV5(filesize, lru);
        double cost = 0.0;
        double div = 0.0;
        Object var9_5 = null;
        Map<String, PoolCostInfo.NamedPoolQueueInfo> map = this._info.getExtendedMoverHash();
        PoolCostInfo.PoolQueueInfo[] q = new PoolCostInfo.PoolQueueInfo[]{map == null ? this._info.getMoverQueue() : null, this._info.getP2pQueue(), this._info.getP2pClientQueue(), this._info.getStoreQueue(), this._info.getRestoreQueue()};
        for (int i = 0; i < q.length; ++i) {
            PoolCostInfo.PoolQueueInfo poolQueueInfo = q[i];
            if (poolQueueInfo == null || poolQueueInfo.getMaxActive() <= 0) continue;
            cost += ((double)poolQueueInfo.getQueued() + (double)poolQueueInfo.getActive()) / (double)poolQueueInfo.getMaxActive();
            div += 1.0;
        }
        if (map != null) {
            for (PoolCostInfo.PoolQueueInfo poolQueueInfo : map.values()) {
                if (poolQueueInfo == null || poolQueueInfo.getMaxActive() <= 0) continue;
                cost += ((double)poolQueueInfo.getQueued() + (double)poolQueueInfo.getActive()) / (double)poolQueueInfo.getMaxActive();
                div += 1.0;
            }
        }
        this._performanceCost = div > 0.0 ? cost / div : 1000000.0;
    }
}

