/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import diskCacheV111.poolManager.PoolPreferenceLevel;
import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.poolManager.PoolSelectionUnitV2;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.vehicles.CostModulePoolInfoTable;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolSelectionUnitV2wgap
extends PoolSelectionUnitV2 {
    private static final Logger _log = LoggerFactory.getLogger(PoolSelectionUnitV2wgap.class);
    private static final String __version = "$Id: PoolSelectionUnitV2wgap.java,v 1.0 2008-08-05 14:03:54 catalind Exp $";
    private static final Logger _logPoolSelection = LoggerFactory.getLogger((String)("logger.org.dcache.poolselection." + PoolSelectionUnitV2wgap.class.getName()));
    private static final long _TO_GetFreeSpace = 120000L;
    private static final long _TO_GetGapSpace = 3600000L;
    private static CostModulePoolInfoTable _costTable = null;
    private static final Object _costTableLock = new Object();
    private static CellAdapter _cell4SelectionWithGap = null;

    public PoolSelectionUnitV2wgap() {
        _cell4SelectionWithGap = new CellAdapter("SelectorWithGap", "", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolPreferenceLevel[] match(PoolSelectionUnit.DirectionType type, String netUnitName, String protocolUnitName, StorageInfo storageInfo, String linkGroupName) {
        PoolPreferenceLevel[] result = super.match(type, netUnitName, protocolUnitName, storageInfo, linkGroupName);
        if (type == PoolSelectionUnit.DirectionType.WRITE) {
            Object object = _costTableLock;
            synchronized (object) {
                try {
                    this.getCostTable(_cell4SelectionWithGap);
                }
                catch (Exception e) {
                    _log.debug("failed getting a cost table");
                }
                if (_costTable != null) {
                    for (int prio = 0; prio < result.length; ++prio) {
                        ArrayList<String> resultList = new ArrayList<String>();
                        List<String> poolList = result[prio].getPoolList();
                        for (String poolName : poolList) {
                            if (_costTable.getPoolCostInfoByName(poolName) != null) {
                                PoolCostInfo.PoolSpaceInfo plSpace = _costTable.getPoolCostInfoByName(poolName).getSpaceInfo();
                                _log.debug(poolName + "> checking: " + plSpace.getGap() + " " + plSpace.getFreeSpace());
                                if (plSpace.getGap() >= plSpace.getFreeSpace()) continue;
                                _log.debug(poolName + "> included on level " + prio);
                                resultList.add(poolName);
                                continue;
                            }
                            _log.debug("missing data for " + poolName);
                        }
                        result[prio] = new PoolPreferenceLevel(resultList, result[prio].getTag());
                    }
                } else {
                    throw new IllegalArgumentException("CostTable is not defined (null pointer)");
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCostTable(CellAdapter cell) throws InterruptedException, NoRouteToCellException, NotSerializableException {
        Object object = _costTableLock;
        synchronized (object) {
            if (_costTable == null || System.currentTimeMillis() > _costTable.getTimestamp() + 3600000L) {
                String command = new String("xcm ls");
                CellMessage cellMessage = new CellMessage(new CellPath("PoolManager"), (Object)command);
                CellMessage reply = null;
                _log.debug("gtCstTble(): sendMessage,  command=[" + command + "]\n" + "message=" + cellMessage);
                reply = cell.sendAndWait(cellMessage, 120000L);
                _log.debug("DEBUG: Cst tble reply arrived");
                if (reply == null || !(reply.getMessageObject() instanceof CostModulePoolInfoTable)) {
                    throw new IllegalArgumentException("received null pinter or wrong object type from PoolManager in getCostTable");
                }
                Object obj = reply.getMessageObject();
                if (obj == null) {
                    throw new IllegalArgumentException("received null pinter from getCostTable from PoolManager");
                }
                _costTable = (CostModulePoolInfoTable)obj;
            }
        }
    }
}

