/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import diskCacheV111.poolManager.LinkReadWritePreferences;
import diskCacheV111.poolManager.PoolPreferenceLevel;
import diskCacheV111.pools.PoolV2Mode;
import diskCacheV111.vehicles.StorageInfo;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public interface PoolSelectionUnit {
    public SelectionPool getPool(String var1);

    public SelectionPool getPool(String var1, boolean var2);

    public SelectionLink getLinkByName(String var1) throws NoSuchElementException;

    public PoolPreferenceLevel[] match(DirectionType var1, String var2, String var3, StorageInfo var4, String var5);

    public String[] getActivePools();

    public String[] getDefinedPools(boolean var1);

    public String getVersion();

    public String getNetIdentifier(String var1) throws UnknownHostException;

    public String getProtocolUnit(String var1);

    public SelectionLinkGroup getLinkGroupByName(String var1) throws NoSuchElementException;

    public String[] getLinkGroups();

    public String[] getLinksByGroupName(String var1) throws NoSuchElementException;

    public Collection<SelectionPool> getPoolsByPoolGroup(String var1) throws NoSuchElementException;

    public Collection<SelectionPool> getAllDefinedPools(boolean var1);

    public Collection<SelectionPoolGroup> getPoolGroups();

    public Collection<SelectionPoolGroup> getPoolGroupsOfPool(String var1);

    public Collection<SelectionLink> getLinksPointingToPoolGroup(String var1) throws NoSuchElementException;

    public Collection<SelectionLink> getLinks();

    public Collection<SelectionUnit> getSelectionUnits();

    public Collection<SelectionUnitGroup> getUnitGroups();

    public static interface SelectionUnitGroup
    extends SelectionEntity {
        public Collection<SelectionUnit> getMemeberUnits();

        public Collection<SelectionLink> getLinksPointingTo();
    }

    public static interface SelectionUnit
    extends SelectionEntity {
        public String getUnitType();

        public Collection<SelectionUnitGroup> getMemberOfUnitGroups();
    }

    public static interface SelectionLinkGroup
    extends SelectionEntity {
        public void add(SelectionLink var1);

        public boolean remove(SelectionLink var1);

        public Collection<SelectionLink> links();

        public void attribute(String var1, String var2, boolean var3);

        public Set<String> attribute(String var1);

        public void removeAttribute(String var1, String var2);

        public Map<String, Set<String>> attributes();

        public void setCustodialAllowed(boolean var1);

        public void setOutputAllowed(boolean var1);

        public void setReplicaAllowed(boolean var1);

        public void setOnlineAllowed(boolean var1);

        public void setNearlineAllowed(boolean var1);

        public boolean isCustodialAllowed();

        public boolean isOutputAllowed();

        public boolean isReplicaAllowed();

        public boolean isOnlineAllowed();

        public boolean isNearlineAllowed();
    }

    public static interface SelectionPoolGroup
    extends SelectionEntity {
    }

    public static interface SelectionPool
    extends SelectionEntity {
        public long getActive();

        public void setActive(boolean var1);

        public boolean isReadOnly();

        public void setReadOnly(boolean var1);

        public boolean isEnabled();

        public boolean setSerialId(long var1);

        public boolean isActive();

        public void setPoolMode(PoolV2Mode var1);

        public PoolV2Mode getPoolMode();

        public boolean canRead();

        public boolean canWrite();

        public boolean canReadFromTape();

        public boolean canReadForP2P();

        public Set<String> getHsmInstances();

        public void setHsmInstances(Set<String> var1);

        public Collection<SelectionPoolGroup> getPoolGroupsMemberOf();

        public Collection<SelectionLink> getLinksTargetingPool();
    }

    public static interface SelectionLink
    extends SelectionEntity {
        public Collection<SelectionPool> pools();

        public String getTag();

        public LinkReadWritePreferences getPreferences();

        public Collection<SelectionPoolGroup> getPoolGroupsPointingTo();

        public Collection<SelectionUnitGroup> getUnitGroupsTargetedBy();
    }

    public static interface SelectionEntity {
        public String getName();
    }

    public static enum DirectionType {
        READ,
        WRITE,
        CACHE,
        P2P,
        ANY;

    }
}

