/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import diskCacheV111.poolManager.CostModule;
import diskCacheV111.poolManager.PoolManagerCellInfo;
import diskCacheV111.poolManager.PoolMonitorV5;
import diskCacheV111.poolManager.PoolPreferenceLevel;
import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.poolManager.RequestContainerV5;
import diskCacheV111.pools.PoolV2Mode;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.Version;
import diskCacheV111.vehicles.GenericStorageInfo;
import diskCacheV111.vehicles.IpProtocolInfo;
import diskCacheV111.vehicles.PoolCostCheckable;
import diskCacheV111.vehicles.PoolLinkGroupInfo;
import diskCacheV111.vehicles.PoolManagerGetPoolListMessage;
import diskCacheV111.vehicles.PoolManagerGetPoolMonitor;
import diskCacheV111.vehicles.PoolManagerGetPoolsByLinkMessage;
import diskCacheV111.vehicles.PoolManagerGetPoolsByNameMessage;
import diskCacheV111.vehicles.PoolManagerGetPoolsByPoolGroupMessage;
import diskCacheV111.vehicles.PoolManagerPoolInformation;
import diskCacheV111.vehicles.PoolManagerPoolModeMessage;
import diskCacheV111.vehicles.PoolManagerPoolUpMessage;
import diskCacheV111.vehicles.PoolMgrGetPoolByLink;
import diskCacheV111.vehicles.PoolMgrGetPoolLinkGroups;
import diskCacheV111.vehicles.PoolMgrQueryPoolsMsg;
import diskCacheV111.vehicles.PoolMgrSelectWritePoolMsg;
import diskCacheV111.vehicles.PoolStatusChangedMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.QuotaMgrCheckQuotaMessage;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.DelayedReply;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.namespace.FileAttribute;
import org.dcache.poolmanager.Partition;
import org.dcache.poolmanager.PoolInfo;
import org.dcache.poolmanager.Utils;
import org.dcache.vehicles.FileAttributes;
import org.dcache.vehicles.PoolManagerSelectLinkGroupForWriteMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolManagerV5
extends AbstractCellComponent
implements CellCommandListener,
CellMessageReceiver {
    private int _writeThreads = 0;
    private int _readThreads = 0;
    private int _counterPoolUp = 0;
    private int _counterSelectWritePool = 0;
    private int _counterSelectReadPool = 0;
    private PoolSelectionUnit _selectionUnit;
    private PoolMonitorV5 _poolMonitor;
    private CostModule _costModule;
    private CellPath _poolStatusRelayPath = null;
    private PnfsHandler _pnfsHandler;
    private RequestContainerV5 _requestContainer;
    private WatchdogThread _watchdog = null;
    private boolean _quotasEnabled = false;
    private String _quotaManager = "none";
    private static final Logger _log = LoggerFactory.getLogger(PoolManagerV5.class);
    private static final Logger _logPoolMonitor = LoggerFactory.getLogger((String)("logger.org.dcache.poolmonitor." + PoolManagerV5.class.getName()));
    public static final String hh_set_max_threads = "# OBSOLETE";
    public static final String hh_set_timeout_pool = "# OBSOLETE";
    public static final String hh_getpoolsbylink = "<linkName> [-size=<filesize>]";
    public String hh_get_av_pools = "<pnfsId> <hsm> <storageClass> <host>";

    public void setPoolSelectionUnit(PoolSelectionUnit selectionUnit) {
        this._selectionUnit = selectionUnit;
    }

    public void setCostModule(CostModule costModule) {
        this._costModule = costModule;
    }

    public void setPoolMonitor(PoolMonitorV5 poolMonitor) {
        this._poolMonitor = poolMonitor;
    }

    public void setRequestContainer(RequestContainerV5 requestContainer) {
        this._requestContainer = requestContainer;
    }

    public void setPoolStatusRelayPath(CellPath poolStatusRelayPath) {
        this._poolStatusRelayPath = poolStatusRelayPath.hops() == 0 ? null : poolStatusRelayPath;
    }

    public void setQuotaManager(String quotaManager) {
        this._quotaManager = quotaManager;
        this._quotasEnabled = !this._quotaManager.equals("none");
    }

    public void setPnfsHandler(PnfsHandler pnfsHandler) {
        this._pnfsHandler = pnfsHandler;
    }

    public void init() {
        String watchdogParam = this.getArgs().getOpt("watchdog");
        this._watchdog = watchdogParam != null && watchdogParam.length() > 0 ? new WatchdogThread(watchdogParam) : new WatchdogThread();
        _log.info("Watchdog : " + this._watchdog);
    }

    @Override
    public CellInfo getCellInfo(CellInfo info) {
        PoolManagerCellInfo pminfo = new PoolManagerCellInfo(info);
        pminfo.setCellVersion(new CellVersion(Version.getVersion(), "$Revision: 16563 $"));
        pminfo.setPoolList(this._selectionUnit.getActivePools());
        return pminfo;
    }

    @Override
    public void printSetup(PrintWriter writer) {
        writer.print("#\n# Setup of ");
        writer.print(this.getCellName());
        writer.print(" (");
        writer.print(this.getClass().getName());
        writer.print(") at ");
        writer.println(new Date().toString());
        writer.println("#");
    }

    public PoolManagerPoolModeMessage messageArrived(PoolManagerPoolModeMessage msg) {
        PoolSelectionUnit.SelectionPool pool = this._selectionUnit.getPool(msg.getPoolName());
        if (pool == null) {
            msg.setFailed(563, "Pool not found : " + msg.getPoolName());
        } else if (msg.getPoolMode() == 0) {
            msg.setPoolMode(0x10 | (pool.isReadOnly() ? 0 : 32));
        } else {
            pool.setReadOnly((msg.getPoolMode() & 0x20) == 0);
        }
        msg.setSucceeded();
        return msg;
    }

    private void runWatchdogSequence(long deathDetectedTimer) {
        for (String name : this._selectionUnit.getDefinedPools(false)) {
            PoolSelectionUnit.SelectionPool pool = this._selectionUnit.getPool(name);
            if (pool == null || pool.getActive() <= deathDetectedTimer || !pool.setSerialId(0L)) continue;
            if (_logPoolMonitor.isDebugEnabled()) {
                _logPoolMonitor.debug("Pool " + name + " declared as DOWN (no ping in " + deathDetectedTimer / 1000L + " seconds).");
            }
            this._requestContainer.poolStatusChanged(name, 2);
            this.sendPoolStatusRelay(name, 2, null, 666, "DEAD");
        }
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("PoolManager V [$Id: PoolManagerV5.java,v 1.48 2007-10-10 08:05:34 tigran Exp $]");
        pw.println(" SelectionUnit : " + this._selectionUnit.getVersion());
        pw.println(" Write Threads : " + this._writeThreads);
        pw.println(" Read  Threads : " + this._readThreads);
        pw.println("Message counts");
        pw.println("           PoolUp : " + this._counterPoolUp);
        pw.println("   SelectReadPool : " + this._counterSelectReadPool);
        pw.println("  SelectWritePool : " + this._counterSelectWritePool);
        if (this._watchdog == null) {
            pw.println("         Watchdog : disabled");
        } else {
            pw.println("         Watchdog : " + this._watchdog);
        }
    }

    public String ac_set_max_threads_$_1(Args args) {
        return "'set max threads' is obsolete";
    }

    public String ac_set_timeout_pool_$_1(Args args) {
        return "'set timeout pool' is obsolete";
    }

    public String ac_getpoolsbylink_$_1(Args args) throws NumberFormatException {
        String sizeString = args.getOpt("size");
        long size = sizeString == null ? 50000000L : Long.parseLong(sizeString);
        String link = args.argv(0);
        StringBuilder sb = new StringBuilder();
        for (PoolCostCheckable pool : this._poolMonitor.queryPoolsByLinkName(link, size)) {
            sb.append(pool).append("\n");
        }
        return sb.toString();
    }

    public synchronized void messageArrived(PoolManagerPoolUpMessage poolMessage) {
        ++this._counterPoolUp;
        String poolName = poolMessage.getPoolName();
        PoolSelectionUnit.SelectionPool pool = this._selectionUnit.getPool(poolName, true);
        PoolV2Mode newMode = poolMessage.getPoolMode();
        PoolV2Mode oldMode = pool.getPoolMode();
        if (_logPoolMonitor.isDebugEnabled()) {
            _logPoolMonitor.debug("PoolUp message from " + poolName + " with mode " + newMode + " and serialId " + poolMessage.getSerialId());
        }
        boolean disabled = newMode.getMode() == 1 || newMode.isDisabled(64) || newMode.isDisabled(63);
        long serial = disabled ? 0L : poolMessage.getSerialId();
        boolean changed = pool.setSerialId(serial) || pool.isActive() == disabled || newMode.getMode() != oldMode.getMode() || !((Object)pool.getHsmInstances()).equals(poolMessage.getHsmInstances());
        pool.setPoolMode(newMode);
        pool.setHsmInstances(poolMessage.getHsmInstances());
        pool.setActive(!disabled);
        if (changed) {
            _logPoolMonitor.warn("Pool " + poolName + " changed from mode " + oldMode + " to " + newMode);
            if (disabled) {
                this._requestContainer.poolStatusChanged(poolName, 2);
                this.sendPoolStatusRelay(poolName, 2, poolMessage.getPoolMode(), poolMessage.getCode(), poolMessage.getMessage());
            } else {
                this._requestContainer.poolStatusChanged(poolName, 1);
                this.sendPoolStatusRelay(poolName, 3);
            }
        }
    }

    private void sendPoolStatusRelay(String poolName, int status) {
        this.sendPoolStatusRelay(poolName, status, null, 0, null);
    }

    private void sendPoolStatusRelay(String poolName, int status, PoolV2Mode poolMode, int statusCode, String statusMessage) {
        if (this._poolStatusRelayPath == null) {
            return;
        }
        try {
            PoolStatusChangedMessage msg = new PoolStatusChangedMessage(poolName, status);
            msg.setPoolMode(poolMode);
            msg.setDetail(statusCode, statusMessage);
            _log.info("sendPoolStatusRelay : " + msg);
            this.sendMessage(new CellMessage(this._poolStatusRelayPath, (Object)msg));
        }
        catch (Exception ee) {
            _log.warn("Failed to send poolStatus changed message : " + ee);
        }
    }

    public PoolMgrGetPoolLinkGroups messageArrived(PoolMgrGetPoolLinkGroups msg) {
        Collection<PoolLinkGroupInfo> linkGroupInfos = Utils.linkGroupInfos(this._selectionUnit, this._costModule).values();
        PoolLinkGroupInfo[] poolLinkGroupInfos = linkGroupInfos.toArray(new PoolLinkGroupInfo[linkGroupInfos.size()]);
        msg.setPoolLinkGroupInfos(poolLinkGroupInfos);
        msg.setSucceeded();
        return msg;
    }

    public PoolManagerGetPoolListMessage messageArrived(PoolManagerGetPoolListMessage msg) {
        String[] pools = this._selectionUnit.getActivePools();
        msg.setPoolList(Arrays.asList(pools));
        msg.setSucceeded();
        return msg;
    }

    public PoolMgrGetPoolByLink messageArrived(PoolMgrGetPoolByLink msg) throws CacheException {
        String linkName = msg.getLinkName();
        long filesize = msg.getFilesize();
        Function<PoolSelectionUnit.SelectionPool, String> getName = new Function<PoolSelectionUnit.SelectionPool, String>(){

            public String apply(PoolSelectionUnit.SelectionPool pool) {
                return pool.getName();
            }
        };
        PoolSelectionUnit.SelectionLink link = this._selectionUnit.getLinkByName(linkName);
        List<PoolInfo> pools = this._costModule.getPoolInfo(Iterables.transform(link.pools(), (Function)getName));
        if (pools.isEmpty()) {
            throw new CacheException(57, "No appropriate pools found for link: " + linkName);
        }
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setSize(filesize);
        Partition partition = this._poolMonitor.getPartitionManager().getPartition(link.getTag());
        msg.setPoolName(partition.selectWritePool(this._costModule, pools, fileAttributes).getName());
        msg.setSucceeded();
        return msg;
    }

    public PoolManagerGetPoolsByNameMessage messageArrived(PoolManagerGetPoolsByNameMessage msg) throws CacheException {
        try {
            ArrayList<PoolManagerPoolInformation> pools = new ArrayList<PoolManagerPoolInformation>();
            for (String name : msg.getPoolNames()) {
                try {
                    pools.add(this._poolMonitor.getPoolInformation(name));
                }
                catch (NoSuchElementException e) {}
            }
            msg.setPools(pools);
            msg.setSucceeded();
        }
        catch (InterruptedException e) {
            throw new CacheException(10011, "Pool manager is shutting down");
        }
        return msg;
    }

    public PoolManagerGetPoolsByLinkMessage messageArrived(PoolManagerGetPoolsByLinkMessage msg) throws CacheException {
        try {
            msg.setPools(this._poolMonitor.getPoolsByLink(msg.getLink()));
            msg.setSucceeded();
        }
        catch (InterruptedException e) {
            throw new CacheException(10011, "Pool manager is shutting down");
        }
        catch (NoSuchElementException e) {
            List<PoolManagerPoolInformation> empty = Collections.emptyList();
            msg.setPools(empty);
            msg.setSucceeded();
        }
        return msg;
    }

    public PoolManagerGetPoolsByPoolGroupMessage messageArrived(PoolManagerGetPoolsByPoolGroupMessage msg) throws CacheException {
        try {
            msg.setPools(this._poolMonitor.getPoolsByPoolGroup(msg.getPoolGroup()));
            msg.setSucceeded();
        }
        catch (InterruptedException e) {
            throw new CacheException(10011, "Pool manager is shutting down");
        }
        catch (NoSuchElementException e) {
            List<PoolManagerPoolInformation> empty = Collections.emptyList();
            msg.setPools(empty);
            msg.setSucceeded();
        }
        return msg;
    }

    public PoolMgrQueryPoolsMsg messageArrived(PoolMgrQueryPoolsMsg msg) {
        PoolSelectionUnit.DirectionType accessType = msg.getAccessType();
        msg.setPoolList(PoolPreferenceLevel.fromPoolPreferenceLevelToList(this._selectionUnit.match(accessType, msg.getNetUnitName(), msg.getProtocolUnitName(), msg.getStorageInfo(), null)));
        msg.setSucceeded();
        return msg;
    }

    public String ac_get_av_pools_$_4(Args args) throws Exception {
        try {
            PnfsId pnfsId = new PnfsId(args.argv(0));
            XStorageInfo storageInfo = new XStorageInfo(args.argv(1), args.argv(2));
            XProtocolInfo protocolInfo = new XProtocolInfo(args.argv(3));
            FileAttributes fileAttributes = this._pnfsHandler.getFileAttributes(pnfsId, EnumSet.of(FileAttribute.LOCATIONS));
            fileAttributes.setPnfsId(pnfsId);
            fileAttributes.setStorageInfo(storageInfo);
            PoolMonitorV5.PnfsFileLocation pnfsFileLocation = this._poolMonitor.getPnfsFileLocation(fileAttributes, protocolInfo, null);
            List<List<PoolInfo>> available = pnfsFileLocation.getReadPools();
            StringBuffer sb = new StringBuffer();
            sb.append("Available and allowed\n");
            for (PoolInfo pool : available.get(0)) {
                sb.append("  ").append(pool).append("\n");
            }
            sb.append("Allowed (not available)\n");
            return sb.toString();
        }
        catch (Exception ee) {
            ee.printStackTrace();
            throw ee;
        }
    }

    private boolean quotasExceeded(StorageInfo info) {
        String storageClass = info.getStorageClass() + "@" + info.getHsm();
        QuotaMgrCheckQuotaMessage quotas = new QuotaMgrCheckQuotaMessage(storageClass);
        CellMessage msg = new CellMessage(new CellPath(this._quotaManager), (Object)quotas);
        try {
            msg = this.sendAndWait(msg, 20000L);
            if (msg == null) {
                _log.warn("quotasExceeded of " + storageClass + " : request timed out");
                return false;
            }
            Object obj = msg.getMessageObject();
            if (!(obj instanceof QuotaMgrCheckQuotaMessage)) {
                _log.warn("quotasExceeded of " + storageClass + " : unexpected object arrived : " + obj.getClass().getName());
                return false;
            }
            return ((QuotaMgrCheckQuotaMessage)obj).isHardQuotaExceeded();
        }
        catch (Exception ee) {
            _log.warn("quotasExceeded of " + storageClass + " : Exception : " + ee);
            _log.warn(ee.toString());
            return false;
        }
    }

    private long determineExpectedFileSize(long expectedLength, StorageInfo storageInfo) {
        if (expectedLength > 0L) {
            return expectedLength;
        }
        if (storageInfo.getFileSize() > 0L) {
            return storageInfo.getFileSize();
        }
        String s = storageInfo.getKey("alloc-size");
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return 0L;
    }

    public DelayedReply messageArrived(PoolManagerSelectLinkGroupForWriteMessage message) throws CacheException {
        if (message.getStorageInfo() == null) {
            throw new IllegalArgumentException("Storage info is missing");
        }
        if (message.getProtocolInfo() == null) {
            throw new IllegalArgumentException("Protocol info is missing");
        }
        return new LinkGroupSelectionTask(message);
    }

    public PoolManagerGetPoolMonitor messageArrived(PoolManagerGetPoolMonitor msg) {
        msg.setPoolMonitor(this._poolMonitor);
        return msg;
    }

    public DelayedReply messageArrived(CellMessage envelope, PoolMgrSelectWritePoolMsg msg) {
        return new WriteRequestHandler(envelope, msg);
    }

    public String ac_free_$_0(Args args) {
        Map<String, PoolLinkGroupInfo> linkGroupSize = Utils.linkGroupInfos(this._selectionUnit, this._costModule);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, PoolLinkGroupInfo> linkGourp : linkGroupSize.entrySet()) {
            sb.append(linkGourp.getKey()).append(" : ").append(linkGourp.getValue().getAvailableSpaceInBytes()).append("\n");
        }
        return sb.toString();
    }

    public class WriteRequestHandler
    extends DelayedReply
    implements Runnable {
        private CellMessage _envelope;
        private PoolMgrSelectWritePoolMsg _request;
        private PnfsId _pnfsId;

        public WriteRequestHandler(CellMessage envelope, PoolMgrSelectWritePoolMsg msg) {
            this._envelope = envelope;
            this._request = msg;
            this._pnfsId = this._request.getPnfsId();
            new Thread((Runnable)this, "writeHandler").start();
        }

        @Override
        public void run() {
            StorageInfo storageInfo = this._request.getStorageInfo();
            ProtocolInfo protocolInfo = this._request.getProtocolInfo();
            _log.info(this._pnfsId.toString() + " write handler started");
            long started = System.currentTimeMillis();
            if (storageInfo == null) {
                this.requestFailed(21, "Storage info not available for write request : " + this._pnfsId);
                return;
            }
            if (protocolInfo == null) {
                this.requestFailed(22, "Protocol info not available for write request : " + this._pnfsId);
                return;
            }
            if (PoolManagerV5.this._quotasEnabled && PoolManagerV5.this.quotasExceeded(storageInfo)) {
                this.requestFailed(55, "Quotas Exceeded for StorageClass : " + storageInfo.getStorageClass());
                return;
            }
            long expectedLength = PoolManagerV5.this.determineExpectedFileSize(this._request.getFileSize(), storageInfo);
            this._request.setFileSize(expectedLength);
            try {
                FileAttributes fileAttributes = new FileAttributes();
                fileAttributes.setPnfsId(this._pnfsId);
                fileAttributes.setStorageInfo(storageInfo);
                fileAttributes.setSize(expectedLength);
                String poolName = PoolManagerV5.this._poolMonitor.getPnfsFileLocation(fileAttributes, protocolInfo, this._request.getLinkGroup()).selectWritePool().getName();
                _log.info("{} write handler selected {} after {} ms", new Object[]{this._pnfsId, poolName, System.currentTimeMillis() - started});
                this.requestSucceeded(poolName);
            }
            catch (CacheException ce) {
                this.requestFailed(ce.getRc(), ce.getMessage());
            }
            catch (Exception ee) {
                this.requestFailed(17, ee.getMessage());
            }
        }

        protected void requestFailed(int errorCode, String errorMessage) {
            this._request.setFailed(errorCode, errorMessage);
            try {
                this.send(this._request);
            }
            catch (Exception e) {
                _log.warn("Exception requestFailed : " + e, (Throwable)e);
            }
        }

        protected void requestSucceeded(String poolName) {
            this._request.setPoolName(poolName);
            this._request.setSucceeded();
            try {
                this.send(this._request);
                if (!this._request.getSkipCostUpdate()) {
                    PoolManagerV5.this._costModule.messageArrived(this._envelope);
                }
            }
            catch (Exception e) {
                _log.warn("Exception in requestSucceeded : " + e, (Throwable)e);
            }
        }
    }

    public class LinkGroupSelectionTask
    extends DelayedReply
    implements Runnable {
        private final PoolManagerSelectLinkGroupForWriteMessage _message;
        private final CDC _cdc;

        public LinkGroupSelectionTask(PoolManagerSelectLinkGroupForWriteMessage message) {
            this._message = message;
            this._cdc = new CDC();
            new Thread((Runnable)this, "LinkGroupSelectionTask").start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            long started = System.currentTimeMillis();
            this._cdc.restore();
            try {
                _log.info("Select link group handler started");
                this._message.setLinkGroups(this.selectLinkGroups());
                this._message.setSucceeded();
                _log.info("Select link group handler finished after {} ms", (Object)(System.currentTimeMillis() - started));
                return;
            }
            catch (Exception e) {
                this._message.setFailed(10011, e.getMessage());
                return;
            }
            finally {
                try {
                    this.send(this._message);
                }
                catch (NoRouteToCellException e) {
                    _log.error("Failed to send reply: " + e.getMessage());
                }
                catch (InterruptedException e) {
                    _log.warn("Link group selection handler was interrupted");
                }
                finally {
                    CDC.clear();
                }
            }
        }

        protected List<String> selectLinkGroups() {
            StorageInfo storageInfo = this._message.getStorageInfo();
            ProtocolInfo protocolInfo = this._message.getProtocolInfo();
            String protocol = protocolInfo.getProtocol() + "/" + protocolInfo.getMajorVersion();
            String hostName = protocolInfo instanceof IpProtocolInfo ? ((IpProtocolInfo)protocolInfo).getHosts()[0] : null;
            Collection<String> linkGroups = this._message.getLinkGroups();
            if (linkGroups == null) {
                linkGroups = Utils.linkGroupInfos(PoolManagerV5.this._selectionUnit, PoolManagerV5.this._costModule).keySet();
            }
            ArrayList<String> outputLinkGroups = new ArrayList<String>(linkGroups.size());
            for (String linkGroup : linkGroups) {
                PoolPreferenceLevel[] level = PoolManagerV5.this._selectionUnit.match(PoolSelectionUnit.DirectionType.WRITE, hostName, protocol, storageInfo, linkGroup);
                if (level.length <= 0) continue;
                outputLinkGroups.add(linkGroup);
            }
            return outputLinkGroups;
        }
    }

    private static class XStorageInfo
    extends GenericStorageInfo {
        private static final long serialVersionUID = -6624549402952279903L;

        private XStorageInfo(String hsm, String storageClass) {
            super(hsm, storageClass);
        }

        @Override
        public String getBitfileId() {
            return "";
        }

        @Override
        public long getFileSize() {
            return 100L;
        }

        @Override
        public void setFileSize(long fileSize) {
        }

        @Override
        public boolean isStored() {
            return true;
        }
    }

    private static class XProtocolInfo
    implements IpProtocolInfo {
        private String[] _host = new String[1];
        private static final long serialVersionUID = -5817364111427851052L;

        private XProtocolInfo(String hostName) {
            this._host[0] = hostName;
        }

        @Override
        public String getProtocol() {
            return "DCap";
        }

        @Override
        public int getMinorVersion() {
            return 0;
        }

        @Override
        public int getMajorVersion() {
            return 0;
        }

        @Override
        public String getVersionString() {
            return "0.0";
        }

        @Override
        public String[] getHosts() {
            return this._host;
        }

        @Override
        public int getPort() {
            return 0;
        }

        @Override
        public InetSocketAddress getSocketAddress() {
            return null;
        }
    }

    private class WatchdogThread
    implements Runnable {
        private long _deathDetected = 600000L;
        private long _sleepTimer = 60000L;
        private long _watchdogSequenceCounter = 0L;

        public WatchdogThread() {
            new Thread((Runnable)this, "watchdog").start();
            _log.info("WatchdogThread initialized with : " + this);
        }

        public WatchdogThread(String parameter) {
            long deathDetected = 0L;
            long sleeping = 0L;
            try {
                StringTokenizer st = new StringTokenizer(parameter, ":");
                String tmp = null;
                if (st.hasMoreTokens() && (tmp = st.nextToken()).length() > 0) {
                    deathDetected = Long.parseLong(tmp);
                }
                if (st.hasMoreTokens() && (tmp = st.nextToken()).length() > 0) {
                    sleeping = Long.parseLong(tmp);
                }
                if (deathDetected < 10L || sleeping < 10L) {
                    throw new IllegalArgumentException("Timers to small : " + parameter);
                }
                if (deathDetected > 0L) {
                    this._deathDetected = deathDetected * 1000L;
                }
                if (sleeping > 0L) {
                    this._sleepTimer = sleeping * 1000L;
                }
            }
            catch (Exception ee) {
                _log.warn("WatchdogThread : illegal arguments [" + parameter + "] (using defaults) " + ee.getMessage());
            }
            new Thread((Runnable)this, "watchdog").start();
            _log.info("WatchdogThread initialized with : " + this);
        }

        @Override
        public void run() {
            _log.info("watchdog thread activated");
            while (true) {
                try {
                    Thread.sleep(this._sleepTimer);
                }
                catch (InterruptedException e) {
                    _log.info("watchdog thread interrupted");
                    break;
                }
                PoolManagerV5.this.runWatchdogSequence(this._deathDetected);
                ++this._watchdogSequenceCounter;
            }
            _log.info("watchdog finished");
        }

        public String toString() {
            return "DeathDetection=" + this._deathDetected / 1000L + ";Sleep=" + this._sleepTimer / 1000L + ";Counter=" + this._watchdogSequenceCounter + ";";
        }
    }
}

