/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import diskCacheV111.poolManager.PGroup;
import diskCacheV111.poolManager.PoolCore;
import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.pools.PoolV2Mode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class Pool
extends PoolCore
implements PoolSelectionUnit.SelectionPool {
    static final long serialVersionUID = 8108406418388363116L;
    final Map<String, PGroup> _pGroupList = new HashMap<String, PGroup>();
    boolean _enabled = true;
    private long _active = 0L;
    private boolean _ping = true;
    private long _serialId = 0L;
    boolean _rdOnly = false;
    private Set<String> _hsmInstances = new HashSet<String>(0);
    private PoolV2Mode _mode = new PoolV2Mode(1);

    Pool(String name) {
        super(name);
    }

    @Override
    public Collection<PoolSelectionUnit.SelectionLink> getLinksTargetingPool() {
        return new ArrayList<PoolSelectionUnit.SelectionLink>(this._linkList.values());
    }

    @Override
    public Collection<PoolSelectionUnit.SelectionPoolGroup> getPoolGroupsMemberOf() {
        return new ArrayList<PoolSelectionUnit.SelectionPoolGroup>(this._pGroupList.values());
    }

    @Override
    public void setActive(boolean active) {
        this._active = active ? System.currentTimeMillis() : 0L;
    }

    @Override
    public long getActive() {
        return this._ping ? System.currentTimeMillis() - this._active : 0L;
    }

    @Override
    public boolean isActive() {
        return this.getActive() < 300000L;
    }

    @Override
    public void setReadOnly(boolean rdOnly) {
        this._rdOnly = rdOnly;
    }

    @Override
    public boolean isReadOnly() {
        return this._rdOnly;
    }

    @Override
    public boolean canRead() {
        return this.isEnabled() && this._mode.getMode() != 1 && !this._mode.isDisabled(2) && !this._mode.isDisabled(64);
    }

    @Override
    public boolean canWrite() {
        return this.isEnabled() && !this.isReadOnly() && this._mode.getMode() != 1 && !this._mode.isDisabled(4) && !this._mode.isDisabled(64) && !this._mode.isDisabled(32);
    }

    @Override
    public boolean canReadFromTape() {
        return this.isEnabled() && !this.isReadOnly() && this._mode.getMode() != 1 && !this._mode.isDisabled(8) && !this._mode.isDisabled(64);
    }

    @Override
    public boolean canReadForP2P() {
        return this.isEnabled() && this._mode.getMode() != 1 && !this._mode.isDisabled(32) && !this._mode.isDisabled(64);
    }

    public boolean canWriteForP2P() {
        return this.isEnabled() && !this.isReadOnly() && this._mode.getMode() != 1 && !this._mode.isDisabled(16) && !this._mode.isDisabled(64);
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    public void setPing(boolean ping) {
        this._ping = ping;
    }

    public boolean isPing() {
        return this._ping;
    }

    public String toString() {
        return this._name + "  (enabled=" + this._enabled + ";active=" + (this._active > 0L ? Long.valueOf(this.getActive() / 1000L) : "no") + ";rdOnly=" + this.isReadOnly() + ";links=" + this._linkList.size() + ";pgroups=" + this._pGroupList.size() + ";hsm=" + this._hsmInstances.toString() + ";mode=" + this._mode + ")";
    }

    @Override
    public boolean setSerialId(long serialId) {
        if (serialId == this._serialId) {
            return false;
        }
        this._serialId = serialId;
        return true;
    }

    @Override
    public void setPoolMode(PoolV2Mode mode) {
        this._mode = mode;
    }

    @Override
    public PoolV2Mode getPoolMode() {
        return this._mode;
    }

    @Override
    public Set<String> getHsmInstances() {
        return this._hsmInstances;
    }

    @Override
    public void setHsmInstances(Set<String> hsmInstances) {
        if (hsmInstances == null) {
            hsmInstances = new HashSet<String>(0);
        }
        this._hsmInstances = hsmInstances;
    }
}

