/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import diskCacheV111.poolManager.NetUnit;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

class NetHandler
implements Serializable {
    static final long serialVersionUID = 8911153851483100573L;
    Map<Long, NetUnit>[] _netList = new HashMap[33];
    private String[] _maskStrings = new String[33];
    private long[] _masks = new long[33];
    Map<BigInteger, NetUnit>[] _netListV6 = new HashMap[129];
    private String[] _maskStringsV6 = new String[129];
    private BigInteger[] _masksV6 = new BigInteger[129];

    NetHandler() {
        long mask = 0L;
        long xmask = 0L;
        long cursor = 1L;
        for (int i = 0; i < this._maskStrings.length; ++i) {
            this._masks[i] = xmask = mask ^ 0xFFFFFFFFFFFFFFFFL;
            int a = (int)(xmask >> 24 & 0xFFL);
            int b = (int)(xmask >> 16 & 0xFFL);
            int c = (int)(xmask >> 8 & 0xFFL);
            int d = (int)(xmask & 0xFFL);
            this._maskStrings[i] = a + "." + b + "." + c + "." + d;
            mask |= cursor;
            cursor <<= 1;
        }
        BigInteger maskV6 = BigInteger.ZERO;
        BigInteger xmaskV6 = BigInteger.ZERO;
        BigInteger cursorV6 = BigInteger.ONE;
        for (int i = 0; i < this._maskStringsV6.length; ++i) {
            this._masksV6[i] = xmaskV6 = maskV6.not();
            this._maskStringsV6[i] = Integer.toString(xmaskV6.bitCount());
            maskV6 = maskV6.or(cursorV6);
            cursorV6 = cursorV6.shiftLeft(1);
        }
    }

    void clear() {
        int i;
        for (i = 0; i < this._netList.length; ++i) {
            if (this._netList[i] == null) continue;
            this._netList[i].clear();
        }
        for (i = 0; i < this._netListV6.length; ++i) {
            if (this._netListV6[i] == null) continue;
            this._netListV6[i].clear();
        }
    }

    private BigInteger inetAddressToBigInteger(InetAddress address) {
        return new BigInteger(address.getAddress());
    }

    private long inetAddressToLong(InetAddress address) {
        long value = 0L;
        int i = 24;
        for (byte b : address.getAddress()) {
            long bv = b >= 0 ? (long)b : 256L + (long)b;
            value |= bv << i;
            i -= 8;
        }
        return value;
    }

    void add(NetUnit net) {
        int bit = net.getHostBits();
        if (net.getHostAddress() instanceof Inet4Address) {
            if (this._netList[bit] == null) {
                this._netList[bit] = new HashMap<Long, NetUnit>();
            }
            long addr = this.inetAddressToLong(net.getHostAddress());
            long maskedAddr = addr & this._masks[bit];
            this._netList[bit].put(maskedAddr, net);
        } else {
            if (this._netListV6[bit] == null) {
                this._netListV6[bit] = new HashMap<BigInteger, NetUnit>();
            }
            BigInteger addr = this.inetAddressToBigInteger(net.getHostAddress());
            this._netListV6[bit].put(addr.and(this._masksV6[bit]), net);
        }
    }

    void remove(NetUnit net) {
        int bit = net.getHostBits();
        if (net.getHostAddress() instanceof Inet4Address) {
            if (this._netList[bit] == null) {
                return;
            }
            long addr = this.inetAddressToLong(net.getHostAddress());
            this._netList[bit].remove(addr & this._masks[bit]);
            if (this._netList.length == 0) {
                this._netList[bit] = null;
            }
        } else {
            if (this._netListV6[bit] == null) {
                return;
            }
            BigInteger addr = this.inetAddressToBigInteger(net.getHostAddress());
            this._netListV6[bit].remove(addr.and(this._masksV6[bit]));
            if (this._netList.length == 0) {
                this._netListV6[bit] = null;
            }
        }
    }

    NetUnit find(NetUnit net) {
        int bit = net.getHostBits();
        NetUnit result = null;
        if (this._netListV6[bit] != null) {
            BigInteger addr = this.inetAddressToBigInteger(net.getHostAddress());
            result = this._netListV6[bit].get(addr.and(this._masksV6[bit]));
        }
        if (result == null && this._netList[bit] != null) {
            long addr = this.inetAddressToLong(net.getHostAddress());
            result = this._netList[bit].get(addr & this._masks[bit]);
        }
        return result;
    }

    NetUnit match(String inetAddress) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(inetAddress);
        if (address instanceof Inet4Address) {
            long addr = this.inetAddressToLong(address);
            long mask = 0L;
            long cursor = 1L;
            NetUnit unit = null;
            for (Map<Long, NetUnit> map : this._netList) {
                Long l;
                if (map != null && (unit = map.get(l = Long.valueOf(addr & (mask ^ 0xFFFFFFFFFFFFFFFFL)))) != null) {
                    return unit;
                }
                mask |= cursor;
                cursor <<= 1;
            }
        } else {
            BigInteger addr = this.inetAddressToBigInteger(address);
            BigInteger mask = BigInteger.ZERO;
            BigInteger cursor = BigInteger.ONE;
            NetUnit unit = null;
            for (Map<BigInteger, NetUnit> map : this._netListV6) {
                BigInteger l;
                if (map != null && (unit = map.get(l = addr.and(mask.not()))) != null) {
                    return unit;
                }
                mask = mask.or(cursor);
                cursor = cursor.shiftLeft(1);
            }
        }
        return null;
    }

    String bitsToString(int bits) {
        return this._maskStringsV6[bits];
    }
}

