/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import com.google.common.collect.ImmutableMap;
import diskCacheV111.poolManager.CostModule;
import diskCacheV111.poolManager.PoolCheckAdapter;
import diskCacheV111.pools.CostCalculatable;
import diskCacheV111.pools.CostCalculationEngine;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.pools.PoolV2Mode;
import diskCacheV111.vehicles.CostModulePoolInfoTable;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.Pool2PoolTransferMsg;
import diskCacheV111.vehicles.PoolAcceptFileMessage;
import diskCacheV111.vehicles.PoolCostCheckable;
import diskCacheV111.vehicles.PoolFetchFileMessage;
import diskCacheV111.vehicles.PoolIoFileMessage;
import diskCacheV111.vehicles.PoolManagerPoolUpMessage;
import diskCacheV111.vehicles.PoolMgrSelectPoolMsg;
import diskCacheV111.vehicles.PoolMgrSelectWritePoolMsg;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.util.Args;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellInfoProvider;
import org.dcache.cells.CellMessageDispatcher;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellSetupProvider;
import org.dcache.poolmanager.PoolInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CostModuleV1
implements Serializable,
CostModule,
CellCommandListener,
CellMessageReceiver,
CellInfoProvider,
CellSetupProvider {
    private static final Logger _log = LoggerFactory.getLogger(CostModuleV1.class);
    public static final long PERCENTILE_FILE_SIZE = 0x6400000L;
    static final long serialVersionUID = -267023006449629909L;
    private final Map<String, Entry> _hash = new HashMap<String, Entry>();
    private boolean _isActive = true;
    private boolean _update = true;
    private boolean _magic = true;
    private boolean _debug = false;
    private boolean _cachedPercentileCostCutIsValid = false;
    private double _cachedPercentileCostCut;
    private double _cachedPercentileFraction;
    private transient CellMessageDispatcher _handlers = new CellMessageDispatcher("messageToForward");
    private CostCalculationEngine _costCalculationEngine = null;
    public String hh_cm_info = "";
    public String hh_cm_set_debug = "on|off";
    public String hh_cm_set_active = "on|off";
    public String hh_cm_set_update = "on|off";
    public String hh_cm_set_magic = "on|off";
    public String hh_cm_fake = "<poolName> [off] | [-space=<spaceCost>|off] [-cpu=<cpuCost>|off]";
    public String hh_xcm_ls = "<poolName> [<filesize>] [-l]";
    public String hh_cm_ls = " -d  | -t | -r [-size=<filesize>] <pattern> # list all pools";

    public CostModuleV1() {
        this._handlers.addMessageListener(this);
    }

    public void setCostCalculationEngine(CostCalculationEngine engine) {
        this._costCalculationEngine = engine;
    }

    public synchronized void messageArrived(PoolManagerPoolUpMessage msg) {
        boolean shouldRemovePool;
        if (!this._update) {
            return;
        }
        String poolName = msg.getPoolName();
        PoolV2Mode poolMode = msg.getPoolMode();
        PoolCostInfo newInfo = msg.getPoolCostInfo();
        Entry poolEntry = this._hash.get(poolName);
        boolean isNewPool = poolEntry == null;
        boolean bl = shouldRemovePool = poolMode.getMode() == 1 || poolMode.isDisabled(63) || poolMode.isDisabled(64);
        if (isNewPool || shouldRemovePool) {
            this._cachedPercentileCostCutIsValid = false;
        } else {
            PoolCostInfo currentInfo = poolEntry.getPoolCostInfo();
            this.considerInvalidatingCache(currentInfo, newInfo);
        }
        if (shouldRemovePool) {
            this._hash.remove(poolName);
        } else if (newInfo != null) {
            this._hash.put(poolName, new Entry(newInfo, msg.getTagMap()));
        }
    }

    private void considerInvalidatingCache(PoolCostInfo currentInfo, PoolCostInfo newInfo) {
        if (!this._cachedPercentileCostCutIsValid) {
            return;
        }
        double currentCost = this.getPerformanceCost(currentInfo);
        double newCost = this.getPerformanceCost(newInfo);
        this.considerInvalidatingCache(currentCost, newCost);
    }

    private void considerInvalidatingCache(double currentCost, PoolCostInfo newInfo) {
        if (!this._cachedPercentileCostCutIsValid) {
            return;
        }
        double newCost = this.getPerformanceCost(newInfo);
        this.considerInvalidatingCache(currentCost, newCost);
    }

    private void considerInvalidatingCache(double currentCost, double newCost) {
        if (Math.signum(currentCost - this._cachedPercentileCostCut) != Math.signum(newCost - this._cachedPercentileCostCut)) {
            this._cachedPercentileCostCutIsValid = false;
        }
    }

    private double getPerformanceCost(PoolCostInfo info) {
        CostCalculatable cost = this._costCalculationEngine.getCostCalculatable(info);
        cost.recalculate(0x6400000L);
        return cost.getPerformanceCost();
    }

    public synchronized void messageToForward(PoolIoFileMessage msg) {
        PoolCostInfo.PoolQueueInfo queue;
        String poolName = msg.getPoolName();
        Entry e = this._hash.get(poolName);
        if (e == null) {
            return;
        }
        String requestedQueueName = msg.getIoQueueName();
        PoolCostInfo costInfo = e.getPoolCostInfo();
        double currentPerformanceCost = this.getPerformanceCost(costInfo);
        Map<String, PoolCostInfo.NamedPoolQueueInfo> map = costInfo.getExtendedMoverHash();
        PoolCostInfo.PoolSpaceInfo spaceInfo = costInfo.getSpaceInfo();
        if (map == null) {
            queue = costInfo.getMoverQueue();
        } else {
            requestedQueueName = requestedQueueName == null || map.get(requestedQueueName) == null ? costInfo.getDefaultQueueName() : requestedQueueName;
            queue = map.get(requestedQueueName);
        }
        int diff = 0;
        long pinned = 0L;
        if (msg.isReply() && msg.getReturnCode() != 0) {
            diff = -1;
            if (msg instanceof PoolAcceptFileMessage) {
                pinned = -msg.getStorageInfo().getFileSize();
            }
        } else if (!msg.isReply() && !this._magic) {
            diff = 1;
            if (msg instanceof PoolAcceptFileMessage) {
                pinned = msg.getStorageInfo().getFileSize();
            }
        }
        queue.modifyQueue(diff);
        spaceInfo.modifyPinnedSpace(pinned);
        this.considerInvalidatingCache(currentPerformanceCost, costInfo);
        this.xsay("Mover" + (requestedQueueName == null ? "" : "(" + requestedQueueName + ")"), poolName, diff, pinned, msg);
    }

    public synchronized void messageToForward(DoorTransferFinishedMessage msg) {
        PoolCostInfo.PoolQueueInfo queue;
        String poolName = msg.getPoolName();
        Entry e = this._hash.get(poolName);
        if (e == null) {
            return;
        }
        PoolCostInfo costInfo = e.getPoolCostInfo();
        double currentPerformanceCost = this.getPerformanceCost(costInfo);
        String requestedQueueName = msg.getIoQueueName();
        Map<String, PoolCostInfo.NamedPoolQueueInfo> map = costInfo.getExtendedMoverHash();
        if (map == null) {
            queue = costInfo.getMoverQueue();
        } else {
            requestedQueueName = requestedQueueName == null || map.get(requestedQueueName) == null ? costInfo.getDefaultQueueName() : requestedQueueName;
            queue = map.get(requestedQueueName);
        }
        int diff = -1;
        long pinned = 0L;
        queue.modifyQueue(diff);
        this.considerInvalidatingCache(currentPerformanceCost, costInfo);
        this.xsay("Mover" + (requestedQueueName == null ? "" : "(" + requestedQueueName + ")"), poolName, diff, pinned, msg);
    }

    public synchronized void messageToForward(PoolFetchFileMessage msg) {
        long pinned;
        int diff;
        String poolName = msg.getPoolName();
        Entry e = this._hash.get(poolName);
        if (e == null) {
            return;
        }
        PoolCostInfo costInfo = e.getPoolCostInfo();
        double currentPerformanceCost = this.getPerformanceCost(costInfo);
        PoolCostInfo.PoolQueueInfo queue = costInfo.getRestoreQueue();
        PoolCostInfo.PoolSpaceInfo spaceInfo = costInfo.getSpaceInfo();
        if (!msg.isReply()) {
            diff = 1;
            pinned = msg.getStorageInfo().getFileSize();
        } else {
            diff = -1;
            pinned = 0L;
        }
        queue.modifyQueue(diff);
        spaceInfo.modifyPinnedSpace(pinned);
        this.considerInvalidatingCache(currentPerformanceCost, costInfo);
        this.xsay("Restore", poolName, diff, pinned, msg);
    }

    public synchronized void messageToForward(PoolMgrSelectPoolMsg msg) {
        PoolCostInfo.PoolQueueInfo queue;
        if (!this._magic) {
            return;
        }
        if (!msg.isReply()) {
            return;
        }
        String poolName = msg.getPoolName();
        Entry e = this._hash.get(poolName);
        if (e == null) {
            return;
        }
        String requestedQueueName = msg.getIoQueueName();
        PoolCostInfo costInfo = e.getPoolCostInfo();
        double currentPerformanceCost = this.getPerformanceCost(costInfo);
        Map<String, PoolCostInfo.NamedPoolQueueInfo> map = costInfo.getExtendedMoverHash();
        PoolCostInfo.PoolSpaceInfo spaceInfo = costInfo.getSpaceInfo();
        if (map == null) {
            queue = costInfo.getMoverQueue();
        } else {
            requestedQueueName = requestedQueueName == null || map.get(requestedQueueName) == null ? costInfo.getDefaultQueueName() : requestedQueueName;
            queue = map.get(requestedQueueName);
        }
        int diff = 1;
        long pinned = msg instanceof PoolMgrSelectWritePoolMsg ? msg.getFileSize() : 0L;
        queue.modifyQueue(diff);
        spaceInfo.modifyPinnedSpace(pinned);
        this.considerInvalidatingCache(currentPerformanceCost, costInfo);
        this.xsay("Mover (magic)" + (requestedQueueName == null ? "" : "(" + requestedQueueName + ")"), poolName, diff, pinned, msg);
    }

    public synchronized void messageToForward(Pool2PoolTransferMsg msg) {
        _log.debug("Pool2PoolTransferMsg : reply=" + msg.isReply());
        String sourceName = msg.getSourcePoolName();
        Entry source = this._hash.get(sourceName);
        if (source == null) {
            return;
        }
        PoolCostInfo sourceCostInfo = source.getPoolCostInfo();
        double currentSourcePerformanceCost = this.getPerformanceCost(sourceCostInfo);
        PoolCostInfo.PoolQueueInfo sourceQueue = sourceCostInfo.getP2pQueue();
        String destinationName = msg.getDestinationPoolName();
        Entry destination = this._hash.get(destinationName);
        if (destination == null) {
            return;
        }
        PoolCostInfo destinationCostInfo = destination.getPoolCostInfo();
        double currentDestinationPerformanceCost = this.getPerformanceCost(destinationCostInfo);
        PoolCostInfo.PoolQueueInfo destinationQueue = destinationCostInfo.getP2pClientQueue();
        PoolCostInfo.PoolSpaceInfo destinationSpaceInfo = destinationCostInfo.getSpaceInfo();
        int diff = msg.isReply() ? -1 : 1;
        long pinned = msg.getStorageInfo().getFileSize();
        sourceQueue.modifyQueue(diff);
        destinationQueue.modifyQueue(diff);
        destinationSpaceInfo.modifyPinnedSpace(pinned);
        this.considerInvalidatingCache(currentSourcePerformanceCost, sourceCostInfo);
        this.considerInvalidatingCache(currentDestinationPerformanceCost, destinationCostInfo);
        this.xsay("P2P client (magic)", destinationName, diff, pinned, msg);
        this.xsay("P2P server (magic)", sourceName, diff, 0L, msg);
    }

    @Override
    public void messageArrived(CellMessage cellMessage) {
        this._handlers.call(cellMessage);
    }

    @Override
    public CellInfo getCellInfo(CellInfo info) {
        return info;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.append("Submodule : CostModule (cm) : ").println(this.getClass().getName());
        pw.println("Version : $Revision: 16563 $");
        pw.append(" Debug   : ").println(this._debug ? "on" : "off");
        pw.append(" Update  : ").println(this._update ? "on" : "off");
        pw.append(" Active  : ").println(this._isActive ? "yes" : "no");
        pw.append(" Magic   : ").println(this._magic ? "yes" : "no");
    }

    @Override
    public void beforeSetup() {
    }

    @Override
    public void afterSetup() {
    }

    @Override
    public void printSetup(PrintWriter pw) {
        pw.append("#\n# Submodule CostModule (cm) : ").println(this.getClass().getName());
        pw.println("# $Revision: 16563 $ \n#\n");
        pw.println("cm set debug " + (this._debug ? "on" : "off"));
        pw.println("cm set update " + (this._update ? "on" : "off"));
        pw.println("cm set magic " + (this._magic ? "on" : "off"));
    }

    private void xsay(String queue, String pool, int diff, long pinned, Object obj) {
        if (this._debug) {
            _log.debug("CostModuleV1 : " + queue + " queue of " + pool + " modified by " + diff + "/" + pinned + " due to " + obj.getClass().getName());
        }
    }

    @Override
    public synchronized PoolCostCheckable getPoolCost(String poolName, long filesize) {
        Entry cost = this._hash.get(poolName);
        if (cost == null || !cost.isValid() && this._update) {
            return null;
        }
        return new CostCheck(poolName, cost, filesize);
    }

    @Override
    public synchronized double getPoolsPercentilePerformanceCost(double fraction) {
        if (fraction <= 0.0 || fraction >= 1.0) {
            throw new IllegalArgumentException("supplied fraction (" + Double.toString(fraction) + ") not between 0 and 1");
        }
        if (!this._cachedPercentileCostCutIsValid || this._cachedPercentileFraction != fraction) {
            this._cachedPercentileCostCut = this.calculatePercentileCostCut(fraction);
            this._cachedPercentileFraction = fraction;
            this._cachedPercentileCostCutIsValid = true;
        }
        return this._cachedPercentileCostCut;
    }

    private double calculatePercentileCostCut(double fraction) {
        if (this._hash.isEmpty()) {
            _log.debug("no pools available");
            return 0.0;
        }
        _log.debug("{} pools available", (Object)this._hash.size());
        double[] poolCosts = new double[this._hash.size()];
        int idx = 0;
        for (Entry poolInfo : this._hash.values()) {
            poolCosts[idx] = this.getPerformanceCost(poolInfo.getPoolCostInfo());
            ++idx;
        }
        Arrays.sort(poolCosts);
        return poolCosts[(int)Math.floor(fraction * (double)this._hash.size())];
    }

    @Override
    public boolean isActive() {
        return this._isActive;
    }

    public String ac_cm_info(Args args) {
        StringWriter s = new StringWriter();
        this.getInfo(new PrintWriter(s));
        return s.toString();
    }

    public String ac_cm_set_debug_$_1(Args args) {
        if (args.argv(0).equals("on")) {
            this._debug = true;
        } else if (args.argv(0).equals("off")) {
            this._debug = false;
        } else {
            throw new IllegalArgumentException("on|off");
        }
        return "";
    }

    public String ac_cm_set_active_$_1(Args args) {
        if (args.argv(0).equals("on")) {
            this._isActive = true;
        } else if (args.argv(0).equals("off")) {
            this._isActive = false;
        } else {
            throw new IllegalArgumentException("on|off");
        }
        return "";
    }

    public String ac_cm_set_update_$_1(Args args) {
        if (args.argv(0).equals("on")) {
            this._update = true;
        } else if (args.argv(0).equals("off")) {
            this._update = false;
        } else {
            throw new IllegalArgumentException("on|off");
        }
        return "";
    }

    public String ac_cm_set_magic_$_1(Args args) {
        if (args.argv(0).equals("on")) {
            this._magic = true;
        } else if (args.argv(0).equals("off")) {
            this._magic = false;
        } else {
            throw new IllegalArgumentException("on|off");
        }
        return "";
    }

    public synchronized String ac_cm_fake_$_1_2(Args args) {
        String poolName = args.argv(0);
        Entry e = this._hash.get(poolName);
        if (e == null) {
            throw new IllegalArgumentException("Pool not found : " + poolName);
        }
        if (args.argc() > 1) {
            if (!args.argv(1).equals("off")) {
                throw new IllegalArgumentException("Unknown argument : " + args.argv(1));
            }
            e._fakeCpu = -1.0;
            e._fakeSpace = -1.0;
            return "Faked Costs switched off for " + poolName;
        }
        String val = args.getOpt("cpu");
        if (val != null) {
            e._fakeCpu = Double.parseDouble(val);
        }
        if ((val = args.getOpt("space")) != null) {
            e._fakeSpace = Double.parseDouble(val);
        }
        return poolName + " -space=" + e._fakeSpace + " -cpu=" + e._fakeCpu;
    }

    public synchronized Object ac_xcm_ls_$_0_2(Args args) throws Exception {
        Object[] reply;
        if (args.argc() == 0) {
            CostModulePoolInfoTable reply2 = new CostModulePoolInfoTable();
            for (Entry e : this._hash.values()) {
                reply2.addPoolCostInfo(e.getPoolCostInfo().getPoolName(), e.getPoolCostInfo());
            }
            return reply2;
        }
        String poolName = args.argv(0);
        long filesize = Long.parseLong(args.argc() < 2 ? "0" : args.argv(2));
        boolean pci = args.hasOption("l");
        if (pci) {
            Entry e = this._hash.get(poolName);
            reply = new Object[]{poolName, e == null ? null : e.getPoolCostInfo(), e == null ? null : Long.valueOf(System.currentTimeMillis() - e.timestamp)};
        } else {
            PoolCostCheckable pcc = this.getPoolCost(poolName, filesize);
            reply = new Object[]{poolName, filesize, pcc == null ? null : new Double(pcc.getSpaceCost()), pcc == null ? null : new Double(pcc.getPerformanceCost())};
        }
        return reply;
    }

    public synchronized String ac_cm_ls_$_0_1(Args args) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean useTime = args.hasOption("t");
        boolean useDetail = args.hasOption("d");
        boolean useReal = args.hasOption("r");
        String sizeStr = args.getOpt("size");
        long filesize = Long.parseLong(sizeStr == null ? "0" : sizeStr);
        Pattern pattern = args.argc() == 0 ? null : Pattern.compile(args.argv(0));
        for (Entry e : this._hash.values()) {
            String poolName = e.getPoolCostInfo().getPoolName();
            if (pattern != null && !pattern.matcher(poolName).matches()) continue;
            sb.append(e.getPoolCostInfo().toString()).append("\n");
            if (useReal) {
                PoolCostCheckable pcc = this.getPoolCost(poolName, filesize);
                if (pcc == null) {
                    sb.append("NONE\n");
                } else {
                    sb.append(this.getPoolCost(poolName, filesize).toString()).append("\n");
                }
            }
            if (useDetail) {
                sb.append(new CostCheck(poolName, e, filesize).toString()).append("\n");
            }
            if (!useTime) continue;
            sb.append(poolName).append("=").append(System.currentTimeMillis() - e.timestamp).append("\n");
        }
        return sb.toString();
    }

    @Override
    public synchronized Collection<PoolCostInfo> getPoolCostInfos() {
        ArrayList<PoolCostInfo> costInfos = new ArrayList<PoolCostInfo>();
        for (Entry entry : this._hash.values()) {
            if (!entry.isValid() && this._update) continue;
            costInfos.add(entry.getPoolCostInfo());
        }
        return costInfos;
    }

    @Override
    public synchronized PoolCostInfo getPoolCostInfo(String poolName) {
        Entry entry = this._hash.get(poolName);
        if (entry != null && (entry.isValid() || !this._update)) {
            return entry.getPoolCostInfo();
        }
        return null;
    }

    @Override
    public synchronized List<PoolInfo> getPoolInfo(Iterable<String> pools) {
        ArrayList<PoolInfo> infos = new ArrayList<PoolInfo>();
        for (String pool : pools) {
            Entry entry = this._hash.get(pool);
            if (entry == null || !entry.isValid() && this._update) continue;
            infos.add(entry.getPoolInfo());
        }
        return infos;
    }

    @Override
    public synchronized Map<String, PoolInfo> getPoolInfoAsMap(Iterable<String> pools) {
        HashMap<String, PoolInfo> map = new HashMap<String, PoolInfo>();
        for (String pool : pools) {
            Entry entry = this._hash.get(pool);
            if (entry == null || !entry.isValid() && this._update) continue;
            map.put(pool, entry.getPoolInfo());
        }
        return map;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._handlers = new CellMessageDispatcher("messageToForward");
        this._handlers.addMessageListener(this);
    }

    private class CostCheck
    extends PoolCheckAdapter
    implements PoolCostCheckable {
        static final long serialVersionUID = -77487683158664348L;
        private PoolCostInfo _info;

        private CostCheck(String poolName, Entry e, long filesize) {
            super(poolName, filesize);
            this._info = e.getPoolCostInfo();
            CostCalculatable cost = CostModuleV1.this._costCalculationEngine.getCostCalculatable(this._info);
            cost.recalculate(filesize);
            this.setSpaceCost(e._fakeSpace > -1.0 ? e._fakeSpace : cost.getSpaceCost());
            this.setPerformanceCost(e._fakeCpu > -1.0 ? e._fakeCpu : cost.getPerformanceCost());
            this.setTagMap((Map<String, String>)e.getTagMap());
        }
    }

    private static class Entry
    implements Serializable {
        static final long serialVersionUID = -6380756950554320179L;
        private final long timestamp = System.currentTimeMillis();
        private final PoolCostInfo _info;
        private double _fakeCpu = -1.0;
        private double _fakeSpace = -1.0;
        private final ImmutableMap<String, String> _tagMap;

        public Entry(PoolCostInfo info, Map<String, String> tagMap) {
            this._info = info;
            this._tagMap = tagMap == null ? ImmutableMap.of() : ImmutableMap.copyOf(tagMap);
        }

        public boolean isValid() {
            return System.currentTimeMillis() - this.timestamp < 300000L;
        }

        public PoolCostInfo getPoolCostInfo() {
            return this._info;
        }

        public ImmutableMap<String, String> getTagMap() {
            return this._tagMap;
        }

        public PoolInfo getPoolInfo() {
            return new PoolInfo(this._info, this._tagMap);
        }
    }
}

