/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.namespace;

import diskCacheV111.namespace.NameSpaceProvider;
import diskCacheV111.namespace.Operation;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileMetaData;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.StorageInfo;
import dmg.util.Args;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.dcache.auth.Subjects;
import org.dcache.namespace.FileAttribute;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;
import org.dcache.vehicles.FileAttributes;

public class PerformanceTest
extends Thread {
    private static NameSpaceProvider provider;
    private static BlockingQueue<String> queue;
    private static List<Operation> ops;
    private static final String CACHE_LOCATION = "myPoolD";
    private static final int UID = 0;
    private static final int GID = 0;
    private static final int PERMISSION = 777;
    private static final Checksum CHECKSUM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPaths(String fileName) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        ArrayList<String> toReturn = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                toReturn.add(line);
            }
        }
        finally {
            reader.close();
        }
        return toReturn;
    }

    public static List<Operation> getOps(Args args) {
        ArrayList<Operation> toReturn = new ArrayList<Operation>();
        for (Operation aOp : Operation.values()) {
            if (!args.hasOption(aOp.getUserInput())) continue;
            toReturn.add(aOp);
        }
        return toReturn;
    }

    public static void main(String[] arguments) throws Exception {
        int i;
        Args args = new Args(arguments);
        if (args.argc() < 2) {
            System.err.print("Usage: PerformanceTest [-threads=<n>] ");
            for (Operation aOp : Operation.values()) {
                System.err.print("[-" + aOp.getUserInput() + "] ");
            }
            System.err.println(" <file> <provider-factory>");
            System.err.println("  where <file> contains a list of paths to load.");
            System.err.println("  and   <provider-factory> is of the type DcacheNameSpaceProviderFactory");
            System.err.println("Options:");
            for (Operation aOp : Operation.values()) {
                System.err.println((Object)aOp);
            }
            System.err.println("\t-threads\tSets number of concurrent reads");
            System.err.println("");
            System.err.println("Remaining arguments are passed on to the provider factory.");
            System.exit(2);
        }
        String fileName = args.argv(0);
        String factoryName = args.argv(1);
        args.shift();
        args.shift();
        ops = PerformanceTest.getOps(args);
        int concurrency = args.hasOption("threads") ? Integer.parseInt(args.getOpt("threads")) : 1;
        Class<?> factory = Class.forName(factoryName);
        Method factoryMethod = factory.getMethod("getProvider", Args.class);
        provider = (NameSpaceProvider)factoryMethod.invoke(null, args);
        System.out.println("Loading " + fileName);
        queue = new LinkedBlockingQueue<String>();
        List<String> paths = PerformanceTest.getPaths(fileName);
        queue.addAll(paths);
        System.out.println("Running test...");
        long start = System.currentTimeMillis();
        Thread[] threads = new Thread[concurrency];
        for (i = 0; i < concurrency; ++i) {
            threads[i] = new PerformanceTest();
            threads[i].start();
        }
        for (i = 0; i < concurrency; ++i) {
            threads[i].join();
        }
        long end = System.currentTimeMillis();
        long total = end - start;
        System.out.println("Number of files  : " + paths.size());
        System.out.println("Number of threads: " + concurrency);
        System.out.print("Operations       : [");
        for (Operation aOp : ops) {
            System.out.print(aOp.getUserInput() + ", ");
        }
        System.out.println("]");
        System.out.println("Start time       : " + new Date(start));
        System.out.println("End time         : " + new Date(end));
        System.out.println("Total time       : " + total + " ms");
        System.out.println("Average pr. op   : " + (double)total / (double)paths.size() + " ms");
    }

    private PnfsId getPnfsid(String path) throws CacheException {
        return provider.pathToPnfsid(Subjects.ROOT, path, true);
    }

    private void processOperation(Operation aOp, String path) {
        try {
            switch (aOp) {
                case CREATE_ENTRY: {
                    provider.createEntry(Subjects.ROOT, path, 0, 0, 777, false);
                    break;
                }
                case PATH_TO_PNFS_ID: {
                    this.getPnfsid(path);
                    break;
                }
                case FILE_META_DATA: {
                    provider.getFileAttributes(Subjects.ROOT, this.getPnfsid(path), FileMetaData.getKnownFileAttributes());
                    break;
                }
                case DELETE_ENTRY: {
                    provider.deleteEntry(Subjects.ROOT, this.getPnfsid(path));
                    break;
                }
                case PNFS_ID_TO_PATH: {
                    provider.pnfsidToPath(Subjects.ROOT, this.getPnfsid(path));
                    break;
                }
                case GET_PARENT: {
                    provider.getParentOf(Subjects.ROOT, this.getPnfsid(path));
                    break;
                }
                case ADD_CHECKSUM: {
                    FileAttributes fileAttributes = new FileAttributes();
                    fileAttributes.setChecksums(Collections.singleton(CHECKSUM));
                    provider.setFileAttributes(Subjects.ROOT, this.getPnfsid(path), fileAttributes);
                    break;
                }
                case GET_CHECKSUMS: {
                    Set<Checksum> cksums = provider.getFileAttributes(Subjects.ROOT, this.getPnfsid(path), EnumSet.of(FileAttribute.CHECKSUM)).getChecksums();
                    break;
                }
                case SET_FILE_ATTR: {
                    FileAttributes fileAttributes = new FileAttributes();
                    fileAttributes.setDefaultAccessLatency();
                    fileAttributes.setDefaultRetentionPolicy();
                    provider.setFileAttributes(Subjects.ROOT, this.getPnfsid(path), fileAttributes);
                    break;
                }
                case GET_FILE_ATTR: {
                    provider.getFileAttributes(Subjects.ROOT, this.getPnfsid(path), EnumSet.of(FileAttribute.FLAGS));
                    break;
                }
                case ADD_CACHE_LOC: {
                    provider.addCacheLocation(Subjects.ROOT, this.getPnfsid(path), CACHE_LOCATION);
                    break;
                }
                case GET_CACHE_LOC: {
                    List<String> loc = provider.getCacheLocation(Subjects.ROOT, this.getPnfsid(path));
                    break;
                }
                case STORAGE_INFO: {
                    StorageInfo info = provider.getFileAttributes(Subjects.ROOT, this.getPnfsid(path), EnumSet.of(FileAttribute.STORAGEINFO)).getStorageInfo();
                    break;
                }
                case SET_STORAGE_INFO: {
                    StorageInfo info = provider.getFileAttributes(Subjects.ROOT, this.getPnfsid(path), EnumSet.of(FileAttribute.STORAGEINFO)).getStorageInfo();
                    info.isSetAccessLatency(true);
                    info.isSetRetentionPolicy(true);
                    provider.setStorageInfo(Subjects.ROOT, this.getPnfsid(path), info, 1);
                    break;
                }
            }
        }
        catch (CacheException e) {
            System.err.println("Exception " + aOp.getUserInput() + " :" + e.getMessage());
        }
    }

    @Override
    public void run() {
        String path;
        while ((path = (String)queue.poll()) != null) {
            for (Operation aOp : ops) {
                this.processOperation(aOp, path);
            }
        }
    }

    static {
        CHECKSUM = new Checksum(ChecksumType.ADLER32, "123456");
    }
}

