/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.namespace;

enum Operation {
    PATH_TO_PNFS_ID("pathtopnfsid", "Reads the pnfs id of a file"),
    FILE_META_DATA("filemetadata", "Reads the meta data of the file"),
    CREATE_ENTRY("createentry", "Create a new file entry in the pool"),
    DELETE_ENTRY("deleteentry", "Removes file entry from the pool"),
    PNFS_ID_TO_PATH("pnfsidtopath", "Reads path of the file"),
    GET_PARENT("getparent", "Reads the parent pnfsid of the file"),
    ADD_CHECKSUM("addchecksum", "Adds the given checksum to the file"),
    GET_CHECKSUMS("getchecksums", "Reads all the checksums of the file"),
    SET_FILE_ATTR("setfileattr", "Updates the file attributes"),
    GET_FILE_ATTR("getfileattr", "Reads the attributes of the file"),
    ADD_CACHE_LOC("addcacheloc", "Add a new pool to the file"),
    GET_CACHE_LOC("getcacheloc", "Reads all the pools of the file"),
    SET_STORAGE_INFO("setstorageinfo", "Updates the storage info of the file"),
    STORAGE_INFO("storageinfo", "Read storage info of files (implies -filemetadata)");

    private final String userInput;
    private final String desc;

    private Operation(String userInput, String desc) {
        this.userInput = userInput;
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getUserInput() {
        return this.userInput;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\t');
        sb.append('-');
        sb.append(this.userInput);
        sb.append('\t');
        sb.append(this.desc);
        return sb.toString();
    }
}

