/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.namespace;

import com.google.common.collect.Range;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.StorageInfo;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.ListHandler;
import org.dcache.util.ChecksumType;
import org.dcache.util.Glob;
import org.dcache.vehicles.FileAttributes;

public interface NameSpaceProvider {
    public static final int UMASK_DIR = 511;
    public static final int UMASK_FILE = 438;
    public static final int DEFAULT = -1;
    public static final int SI_EXCLUSIVE = 0;
    public static final int SI_OVERWRITE = 1;
    public static final int SI_APPEND = 2;

    public PnfsId createEntry(Subject var1, String var2, int var3, int var4, int var5, boolean var6) throws CacheException;

    public void deleteEntry(Subject var1, PnfsId var2) throws CacheException;

    public void deleteEntry(Subject var1, String var2) throws CacheException;

    public void renameEntry(Subject var1, PnfsId var2, String var3, boolean var4) throws CacheException;

    public String pnfsidToPath(Subject var1, PnfsId var2) throws CacheException;

    public PnfsId pathToPnfsid(Subject var1, String var2, boolean var3) throws CacheException;

    public PnfsId getParentOf(Subject var1, PnfsId var2) throws CacheException;

    public void removeFileAttribute(Subject var1, PnfsId var2, String var3) throws CacheException;

    public void removeChecksum(Subject var1, PnfsId var2, ChecksumType var3) throws CacheException;

    public void setStorageInfo(Subject var1, PnfsId var2, StorageInfo var3, int var4) throws CacheException;

    public void addCacheLocation(Subject var1, PnfsId var2, String var3) throws CacheException;

    public List<String> getCacheLocation(Subject var1, PnfsId var2) throws CacheException;

    public void clearCacheLocation(Subject var1, PnfsId var2, String var3, boolean var4) throws CacheException;

    public FileAttributes getFileAttributes(Subject var1, PnfsId var2, Set<FileAttribute> var3) throws CacheException;

    public void setFileAttributes(Subject var1, PnfsId var2, FileAttributes var3) throws CacheException;

    public void list(Subject var1, String var2, Glob var3, Range<Integer> var4, Set<FileAttribute> var5, ListHandler var6) throws CacheException;
}

