/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.hsmControl.flush.driver;

import diskCacheV111.hsmControl.flush.HsmFlushControlCore;
import diskCacheV111.hsmControl.flush.HsmFlushSchedulable;
import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.pools.StorageClassFlushInfo;
import dmg.cells.nucleus.CellAdapter;
import dmg.util.Args;
import dmg.util.CommandInterpreter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerExample
implements HsmFlushSchedulable {
    private static final Logger _log = LoggerFactory.getLogger(HandlerExample.class);
    private HsmFlushControlCore _core = null;
    private CommandInterpreter _interpreter = null;
    private HashMap _poolHash = new HashMap();
    private boolean _doNothing = false;
    private Map _properties = new HashMap();

    public HandlerExample(CellAdapter cell, HsmFlushControlCore core) {
        _log.info("HandlerExample started");
        this._core = core;
        this._interpreter = new CommandInterpreter((Object)this);
    }

    @Override
    public void init() {
        int i;
        _log.info("init called");
        Args args = this._core.getDriverArgs();
        for (i = 0; i < args.argc(); ++i) {
            _log.info("    args " + i + " : " + args.argv(i));
        }
        for (i = 0; i < args.optc(); ++i) {
            _log.info("    opts " + args.optv(i) + "=" + args.getOpt(args.optv(i)));
        }
        this._doNothing = args.hasOption("do-nothing");
        this._properties.put("mode", this._doNothing ? "manual" : "auto");
        Iterator i2 = this._core.getConfiguredPoolNames().iterator();
        while (i2.hasNext()) {
            String poolName = i2.next().toString();
            _log.info("    configured pool : " + poolName + this._core.getPoolByName(poolName).toString());
            this._poolHash.put(poolName, new Pool(poolName));
        }
    }

    @Override
    public void prepareUnload() {
        _log.info("preparing unload");
    }

    @Override
    public void configuredPoolAdded(String poolName) {
        _log.info("configured pool added : " + poolName);
    }

    @Override
    public void configuredPoolRemoved(String poolName) {
        _log.info("configured pool removed : " + poolName);
        this._poolHash.remove(poolName);
    }

    @Override
    public void flushingDone(String poolName, String storageClassName, HsmFlushControlCore.FlushInfo flushInfo) {
        _log.info("flushingDone : pool =" + poolName + ";class=" + storageClassName);
    }

    @Override
    public void command(Args args) {
        _log.info("command : " + args);
        try {
            Object reply = this._interpreter.command(args);
            if (reply == null) {
                throw new Exception("Null pointer from command call");
            }
            _log.info("Command returns : " + reply.toString());
        }
        catch (Exception ee) {
            _log.warn("Command returns an exception (" + ee.getClass().getName() + ") : " + ee.toString());
        }
    }

    public String ac_set_mode_$_1(Args args) {
        String com = args.argv(0);
        if (com.equals("auto")) {
            this._doNothing = false;
        } else if (com.equals("manual")) {
            this._doNothing = true;
        }
        return "";
    }

    public String ac_set_property_$_1_2(Args args) {
        String com = args.argv(0);
        if (args.argc() == 1) {
            this._properties.remove(com);
        } else {
            this._properties.put(com, args.argv(1));
        }
        return "";
    }

    @Override
    public void poolSetupUpdated() {
        _log.info("pool Setup updated");
    }

    @Override
    public void poolIoModeUpdated(String poolName, HsmFlushControlCore.Pool pool) {
        _log.info("pool io mode updated : " + pool);
    }

    @Override
    public void reset() {
        _log.info("EVENT : reset");
    }

    @Override
    public void timer() {
        _log.info("Timer at : " + System.currentTimeMillis());
    }

    @Override
    public void propertiesUpdated(Map properties) {
        HashSet keys = new HashSet(properties.keySet());
        for (String key : keys) {
            String ourPropertyValue = (String)this._properties.get(key);
            if (ourPropertyValue == null) {
                properties.remove(key);
                continue;
            }
            if (key.equals("mode")) {
                Object obj = properties.get(key);
                if (obj == null) continue;
                String mode = obj.toString();
                if (mode.equals("auto")) {
                    this._doNothing = false;
                    this._properties.put(key, "auto");
                    continue;
                }
                if (!mode.equals("manual")) continue;
                this._doNothing = true;
                this._properties.put(key, "manual");
                continue;
            }
            this._properties.put(key, properties.get(key));
        }
        properties.clear();
        properties.putAll(this._properties);
    }

    @Override
    public void poolFlushInfoUpdated(String poolName, HsmFlushControlCore.Pool pool) {
        if (this._doNothing) {
            return;
        }
        if (!pool.isActive()) {
            _log.info("poolFlushInfoUpdated : Pool : " + poolName + " inactive");
            return;
        }
        PoolCellInfo cellInfo = pool.getCellInfo();
        PoolCostInfo costInfo = cellInfo.getPoolCostInfo();
        PoolCostInfo.PoolSpaceInfo spaceInfo = costInfo.getSpaceInfo();
        PoolCostInfo.PoolQueueInfo queueInfo = costInfo.getStoreQueue();
        long total = spaceInfo.getTotalSpace();
        long precious = spaceInfo.getPreciousSpace();
        _log.info("poolFlushInfoUpdated : Pool : " + poolName + ";total=" + total + ";precious=" + precious);
        Iterator i = pool.getStorageClassNames().iterator();
        while (i.hasNext()) {
            String storageClass = i.next().toString();
            HsmFlushControlCore.FlushInfo info = pool.getFlushInfoByStorageClass(storageClass);
            StorageClassFlushInfo flush = info.getStorageClassFlushInfo();
            long size = flush.getTotalPendingFileSize();
            _log.info("poolFlushInfoUpdated :       class = " + storageClass + " size = " + size + " flushing = " + info.isFlushing());
            try {
                if (size <= 0L || info.isFlushing()) continue;
                _log.info("poolFlushInfoUpdated :       flushing " + poolName + " " + storageClass);
                info.flush(0);
            }
            catch (Exception ee) {
                _log.warn("poolFlushInfoUpdated : Problem flushing " + poolName + " " + storageClass + " " + ee);
            }
        }
    }

    private class Pool {
        private String _name = null;
        private long _lastUpdated = 0L;
        private int _count = 0;

        private Pool(String name) {
            this._name = name;
        }

        private void updated() {
            this._lastUpdated = System.currentTimeMillis();
            ++this._count;
        }
    }
}

