/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.hsmControl.flush.driver;

import diskCacheV111.hsmControl.flush.HsmFlushControlCore;
import diskCacheV111.hsmControl.flush.HsmFlushSchedulable;
import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.pools.StorageClassFlushInfo;
import dmg.cells.nucleus.CellAdapter;
import dmg.util.Args;
import dmg.util.CommandInterpreter;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlternatingFlushSchedulerV1
implements HsmFlushSchedulable {
    private static final Logger _log = LoggerFactory.getLogger(AlternatingFlushSchedulerV1.class);
    private HsmFlushControlCore _core = null;
    private CommandInterpreter _interpreter = null;
    private AltParameter _parameter = new AltParameter();
    private Map _hostMap = new HashMap();
    private boolean _suspendFlushing = false;
    private static final int STATE_IDLE = 0;
    private static final int STATE_WAITING_FOR_MODE_CHANGE = 1;
    private static final int STATE_WAITING_FOR_IO_DONE = 2;
    private static final int STATE_WAITING_FOR_FLUSH_READY = 4;
    private static final int PS_IDLE = 0;
    private static final int PS_WAITING_FOR_STATE_CHANGE = 1;
    private static final int PS_WAITING_FOR_FLUSH_DONE = 2;
    private static final long MEGA_BYTES = 0x100000L;
    private PoolComparator _poolComparator = new PoolComparator();
    public String hh_dummy = "# dummy call";
    public String hh_suspend = "# suspend next flush sequence, not preemptive";
    public String hh_resume = "# resume flush sequence";
    public String hh_list_pools = "[-p [-l]] [-c]";
    public String ac_flush_poolset = "<poolSetName>";
    private static String PARAMETER_MAX_FILE = "max.files";
    private static String PARAMETER_MAX_MINUTES = "max.minutes";
    private static String PARAMETER_MAX_MEGABYTES = "max.megabytes";
    private static String PARAMETER_TIMER = "timer";
    private static String PARAMETER_MODE = "mode";
    private static String PARAMETER_FLUSH_PERCENTAGE = "max.rdonly.fraction";
    private static String PARAMETER_FLUSH_ATONCE = "flush.atonce";
    private static String PARAMETER_RULE_TYPE = "rules.type";
    private static String PARAMETER_PRINT_EVENTS = "print.events";
    private static String PARAMETER_PRINT_RULES = "print.rules";
    private static String PARAMETER_PRINT_POOL_PROGRESS = "print.pool.progress";
    private static String PARAMETER_PRINT_POOLSET_PROGRESS = "print.poolset.progress";

    private Pool getInternalPool(HsmFlushControlCore.Pool pool) {
        Pool ip = (Pool)pool.getDriverHandle();
        if (ip == null) {
            _log.warn("getInternalPool : Yet unconfigured pool arrived " + pool.getName() + "; configuring");
            ip = new Pool(pool.getName(), pool);
            pool.setDriverHandle(ip);
        }
        return ip;
    }

    public AlternatingFlushSchedulerV1(CellAdapter cell, HsmFlushControlCore core) {
        _log.info("AlternateFlush started");
        this._core = core;
        this._interpreter = new CommandInterpreter((Object)this);
    }

    @Override
    public void init() {
        int i;
        if (this._parameter._p_events) {
            _log.info("EVENT : Initiating ...");
        }
        Args args = this._core.getDriverArgs();
        for (i = 0; i < args.argc(); ++i) {
            _log.info("    args " + i + " : " + args.argv(i));
        }
        for (i = 0; i < args.optc(); ++i) {
            _log.info("    opts " + args.optv(i) + "=" + args.getOpt(args.optv(i)));
        }
        Iterator i2 = this._core.getConfiguredPools().iterator();
        while (i2.hasNext()) {
            _log.info("    configured pool : " + i2.next().toString());
        }
        for (HsmFlushControlCore.Pool pool : this._core.getConfiguredPools()) {
            Pool ip = this.getInternalPool(pool);
            _log.info("init : " + pool.getName() + " " + ip);
        }
        String tmp = args.getOpt("driver-config-file");
        if (tmp != null) {
            this._parameter = new AltParameter(new File(tmp));
        }
    }

    @Override
    public void propertiesUpdated(Map properties) {
        if (this._parameter._p_events) {
            _log.info("EVENT : propertiesUpdated : " + properties);
        }
        this._parameter.propertiesUpdated(properties);
    }

    @Override
    public void poolIoModeUpdated(String poolName, HsmFlushControlCore.Pool pool) {
        if (this._parameter._p_events) {
            _log.info("EVENT : poolIoModeUpdated : " + pool);
        }
        if (!pool.isActive()) {
            _log.warn("poolIoModeUpdated : Pool " + poolName + " not yet active (ignoring)");
            return;
        }
        Pool ip = this.getInternalPool(pool);
        ip.poolIoModeUpdated(pool.isReadOnly());
        PoolSet poolSet = ip.getParentPoolSet();
        poolSet.poolIoModeUpdated(ip, pool.isReadOnly());
    }

    @Override
    public void flushingDone(String poolName, String storageClassName, HsmFlushControlCore.FlushInfo flushInfo) {
        HsmFlushControlCore.Pool pool;
        if (this._parameter._p_events) {
            _log.info("EVENT : flushingDone : pool =" + poolName + ";class=" + storageClassName);
        }
        if ((pool = this._core.getPoolByName(poolName)) == null) {
            _log.warn("flushingDone : for a non configured pool : " + poolName);
            return;
        }
        if (!pool.isActive()) {
            _log.warn("flushingDone : Pool " + poolName + " not yet active (ignoring)");
            return;
        }
        Pool ip = this.getInternalPool(pool);
        ip.flushingDone(flushInfo);
        if (ip._flushCounter == 0) {
            PoolSet poolSet = ip.getParentPoolSet();
            poolSet.flushingDone(ip, storageClassName, flushInfo);
        }
    }

    @Override
    public void poolFlushInfoUpdated(String poolName, HsmFlushControlCore.Pool pool) {
        if (this._parameter._p_events) {
            _log.info("EVENT : poolFlushInfoUpdated : " + pool.getName());
        }
        if (!pool.isActive()) {
            _log.warn("poolFlushInfoUpdated : Pool " + poolName + " not yet active (ignoring)");
            return;
        }
        Pool ip = this.getInternalPool(pool);
        ip.poolFlushInfoUpdated(pool);
    }

    @Override
    public void reset() {
        if (this._parameter._p_events) {
            _log.info("EVENT : reset");
        }
    }

    @Override
    public void timer() {
        if (this._parameter._p_events) {
            _log.info("EVENT : timer");
        }
        this._parameter.updateIfNeeded();
        for (Map.Entry hostEntry : this._hostMap.entrySet()) {
            PoolSet hostMap = (PoolSet)hostEntry.getValue();
            for (Map.Entry e : hostMap.entrySet()) {
                ((Pool)e.getValue()).timer();
            }
        }
        if (!this._suspendFlushing) {
            this.processPoolsetRules();
        }
    }

    @Override
    public void command(Args args) {
        if (this._parameter._p_events) {
            _log.info("EVENT : command : " + args);
        }
        try {
            Object reply = this._interpreter.command(args);
            if (reply == null) {
                throw new Exception("Null pointer from command call");
            }
            _log.info("Command returns : " + reply.toString());
        }
        catch (Exception ee) {
            _log.warn("Command returns an exception (" + ee.getClass().getName() + ") : " + ee.toString());
        }
    }

    @Override
    public void prepareUnload() {
        if (this._parameter._p_events) {
            _log.info("EVENT : Preparing unload (ignoring)");
        }
    }

    @Override
    public void configuredPoolAdded(String poolName) {
        HsmFlushControlCore.Pool pool;
        if (this._parameter._p_events) {
            _log.info("EVENT : Configured pool added : " + poolName);
        }
        if ((pool = this._core.getPoolByName(poolName)) == null) {
            _log.warn("Pool not found in _core database : " + poolName);
            return;
        }
        if (!pool.isActive()) {
            _log.warn("Pool " + poolName + " not yet active (ignoring)");
            return;
        }
        Pool ip = this.getInternalPool(pool);
    }

    @Override
    public void poolSetupUpdated() {
        if (this._parameter._p_events) {
            _log.info("EVENT : Pool Setup updated (ignoring)");
        }
    }

    @Override
    public void configuredPoolRemoved(String poolName) {
        if (this._parameter._p_events) {
            _log.info("EVENT : Configured pool removed : " + poolName + "  (ignoring)");
        }
    }

    private void processPoolsetRules() {
        if (this._parameter._p_rules) {
            _log.info("RULES : Processing PoolSet Rules...");
        }
        int totalAvailable = 0;
        int totalReadOnly = 0;
        int totalFlushing = 0;
        int inProgress = 0;
        ArrayList<Pool> candidates = new ArrayList<Pool>();
        HashSet<String> rdOnlyHash = new HashSet<String>();
        for (HsmFlushControlCore.Pool pool : this._core.getConfiguredPools()) {
            Pool ip = (Pool)pool.getDriverHandle();
            if (ip == null || !ip.isReady()) continue;
            ++totalAvailable;
            if (ip.isFlushing()) {
                ++totalFlushing;
            }
            if (pool.isReadOnly()) {
                ++totalReadOnly;
                rdOnlyHash.add(pool.getName());
            }
            if (ip.getParentPoolSet().inProgress()) {
                ++inProgress;
                continue;
            }
            if (!this.isCandidate(ip)) continue;
            candidates.add(ip);
        }
        if (this._parameter._p_rules) {
            _log.info("RULES : statistics : total=" + totalAvailable + ";readOnly=" + totalReadOnly + ";flushing=" + totalFlushing + ";progress=" + inProgress + ";candidates=" + candidates.size());
        }
        if (candidates.size() == 0) {
            if (this._parameter._p_rules) {
                _log.info("RULES : no candidates found");
            }
            return;
        }
        if (this._parameter._p_rules) {
            for (Pool pp : candidates) {
                _log.info("RULES : weight of " + pp._name + " " + this.getPoolMetric(pp));
            }
        }
        Collections.sort(candidates, this._poolComparator);
        Pool ip = (Pool)candidates.get(0);
        if (this._parameter._p_rules) {
            _log.info("RULES : weight of top " + ip._name + " " + this.getPoolMetric(ip));
        }
        PoolSet best = null;
        for (Pool pp : candidates) {
            int total;
            PoolSet ps = pp.getParentPoolSet();
            if (this._parameter._p_rules) {
                _log.info("RULES : checking " + pp._name + "/" + ps._name + " " + this.getPoolMetric(pp));
            }
            HashSet<String> potentialRdOnlyPools = new HashSet<String>(rdOnlyHash);
            Iterator ppp = ps.keySet().iterator();
            while (ppp.hasNext()) {
                potentialRdOnlyPools.add(ppp.next().toString());
            }
            if (this._parameter._p_rules) {
                _log.info("RULES : potential rdOnlyPools : " + potentialRdOnlyPools);
            }
            if ((total = potentialRdOnlyPools.size()) > (int)((double)totalAvailable * this._parameter._percentageToFlush)) {
                if (!this._parameter._p_rules) continue;
                _log.info("RULES : " + ps._name + " would be too many pools ReadOnly (" + total + " out of " + totalAvailable + ")");
                continue;
            }
            best = ps;
            break;
        }
        if (best == null) {
            if (this._parameter._p_rules) {
                _log.info("RULES : no candidates found after all");
            }
            return;
        }
        if (this._parameter._p_rules) {
            _log.info("RULES : flushing poolset : " + best._name + " with pools " + best.keySet());
        }
        best.flushAll();
    }

    private double getPoolMetric(Pool ip) {
        return ((double)ip._preciousSpace / (double)(this._parameter._maxPreciousStored * 0x100000L) + (double)ip._preciousFileCount / (double)this._parameter._maxFilesStored + (double)(System.currentTimeMillis() - ip._oldestTimestamp) / (double)(this._parameter._maxTimeStored * 60000L)) / 3.0;
    }

    private boolean isCandidate(Pool ip) {
        ip.refreshLocalVariables();
        return ip._preciousSpace > this._parameter._maxPreciousStored * 0x100000L || (long)ip._preciousFileCount > this._parameter._maxFilesStored || ip._oldestTimestamp + this._parameter._maxTimeStored * 60000L < System.currentTimeMillis();
    }

    public String ac_dummy_$_1_99(Args args) {
        return args.toString();
    }

    public String ac_suspend(Args args) {
        this._suspendFlushing = true;
        return "";
    }

    public String ac_resume(Args args) {
        this._suspendFlushing = false;
        return "";
    }

    public String ac_list_pools(Args args) {
        block4: {
            boolean configuredView;
            block3: {
                boolean parentView = args.hasOption("p");
                configuredView = args.hasOption("c");
                boolean extended = args.hasOption("e");
                if (!parentView) break block3;
                for (Map.Entry hostEntry : this._hostMap.entrySet()) {
                    String hostName = (String)hostEntry.getKey();
                    Map hostMap = (Map)hostEntry.getValue();
                    _log.info(" >>" + hostName + "<<");
                    for (Map.Entry e : hostMap.entrySet()) {
                        String name = (String)e.getKey();
                        _log.info("     " + name + (extended ? e.getValue().toString() : ""));
                    }
                }
                break block4;
            }
            if (!configuredView) break block4;
            for (HsmFlushControlCore.Pool pool : this._core.getConfiguredPools()) {
                _log.info("" + pool);
            }
        }
        return "";
    }

    public String ac_flush_poolset_$_1(Args args) {
        String poolSetName = args.argv(0);
        PoolSet poolSet = (PoolSet)this._hostMap.get(poolSetName);
        if (poolSet == null) {
            throw new IllegalArgumentException("PoolSet not found : " + poolSetName);
        }
        if (poolSet.inProgress()) {
            throw new IllegalArgumentException("PoolSet in progress : " + poolSetName);
        }
        poolSet.flushAll();
        return "";
    }

    private int flushPool(HsmFlushControlCore.Pool pool) {
        int flushing = 0;
        for (HsmFlushControlCore.FlushInfo info : pool.getFlushInfos()) {
            StorageClassFlushInfo flush = info.getStorageClassFlushInfo();
            long size = flush.getTotalPendingFileSize();
            _log.info("flushPool : class = " + info.getName() + " size = " + size + " flushing = " + info.isFlushing());
            try {
                if (size <= 0L || info.isFlushing()) continue;
                _log.info("flushPool : !!! flushing " + this._parameter._flushAtOnce + " of " + pool.getName() + " " + info.getName());
                info.flush(this._parameter._flushAtOnce);
                ++flushing;
            }
            catch (Exception ee) {
                _log.warn("flushPool : Problem flushing " + pool.getName() + " " + info.getName() + " " + ee);
            }
        }
        return flushing;
    }

    private int countTotalActivePool(HsmFlushControlCore.Pool pool) {
        int total = 0;
        for (HsmFlushControlCore.FlushInfo info : pool.getFlushInfos()) {
            StorageClassFlushInfo flush = info.getStorageClassFlushInfo();
            total += flush.getActiveCount();
        }
        return total;
    }

    private int countTotalPendingPool(HsmFlushControlCore.Pool pool) {
        int total = 0;
        for (HsmFlushControlCore.FlushInfo info : pool.getFlushInfos()) {
            StorageClassFlushInfo flush = info.getStorageClassFlushInfo();
            total += flush.getRequestCount();
        }
        return total;
    }

    private long getOldestFileTimestampPool(HsmFlushControlCore.Pool pool) {
        long oldest = System.currentTimeMillis();
        for (HsmFlushControlCore.FlushInfo info : pool.getFlushInfos()) {
            StorageClassFlushInfo flush = info.getStorageClassFlushInfo();
            oldest = Math.min(oldest, flush.getOldestFileTimestamp());
        }
        return oldest;
    }

    private int countStorageClassesFlushing(HsmFlushControlCore.Pool pool) {
        int flushing = 0;
        Iterator i = pool.getFlushInfos().iterator();
        while (i.hasNext()) {
            if (!((HsmFlushControlCore.FlushInfo)i.next()).isFlushing()) continue;
            ++flushing;
        }
        return flushing;
    }

    private class Parameter {
        private long _configLastModified = 0L;
        private File _configFile = null;

        private Parameter() {
        }

        private Parameter(File configFile) {
            this._configFile = configFile;
        }

        protected void updateIfNeeded() {
            if (this._configFile == null) {
                return;
            }
            try {
                Map map = this.updateConfigIfNewer(this._configFile);
                if (map == null) {
                    return;
                }
                AlternatingFlushSchedulerV1.this.propertiesUpdated(map);
            }
            catch (Exception ee) {
                return;
            }
        }

        private Map updateConfigIfNewer(File configFile) throws IOException {
            if (!configFile.exists()) {
                return null;
            }
            long lastModified = configFile.lastModified();
            if (lastModified <= this._configLastModified) {
                return null;
            }
            this._configLastModified = lastModified;
            return this.readConfigFile(configFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map readConfigFile(File configFile) throws IOException {
            BufferedReader br = new BufferedReader(new FileReader(configFile));
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                String line = null;
                while ((line = br.readLine()) != null) {
                    String value;
                    String key;
                    int pos;
                    if ((line = line.trim()).equals("") || line.startsWith("#") || (pos = line.indexOf(61)) <= 0 || pos == line.length() - 1 || (key = line.substring(0, pos).trim()).length() == 0 || (value = line.substring(pos + 1).trim()).length() == 0) continue;
                    map.put(key, value);
                }
            }
            catch (EOFException eof) {
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException ee) {}
            }
            String[] x = null;
            x = new String[]{"x", "y"};
            return map;
        }

        protected String handleString(Map properties, String key, String[] options) {
            Object obj = properties.get(key);
            if (obj == null) {
                throw new IllegalArgumentException("No Value for " + key);
            }
            String x = obj.toString();
            if (options == null) {
                return x;
            }
            for (int i = 0; i < options.length; ++i) {
                if (!options[i].equals(x)) continue;
                return x;
            }
            throw new IllegalArgumentException("Value for " + key + " is not legal");
        }

        protected int handleInt(Map properties, String key, int minValue, int maxValue) {
            Object obj = properties.get(key);
            if (obj == null) {
                throw new IllegalArgumentException("No Value for " + key);
            }
            int count = Integer.parseInt(obj.toString());
            if (count < minValue || count > maxValue) {
                throw new IllegalArgumentException("Value for " + key + " not in range " + minValue + " < n < " + maxValue);
            }
            return count;
        }

        protected double handleDouble(Map properties, String key, double minValue, double maxValue) {
            Object obj = properties.get(key);
            if (obj == null) {
                throw new IllegalArgumentException("No Value for " + key);
            }
            double count = Double.parseDouble(obj.toString());
            if (count < minValue || count > maxValue) {
                throw new IllegalArgumentException("Value for " + key + " not in range " + minValue + " < n < " + maxValue);
            }
            return count;
        }

        protected long handleLong(Map properties, String key, long minValue, long maxValue) {
            Object obj = properties.get(key);
            if (obj == null) {
                throw new IllegalArgumentException("No Value for " + key);
            }
            long count = Integer.parseInt(obj.toString());
            if (count < minValue || count > maxValue) {
                throw new IllegalArgumentException("Value for " + key + " not in range " + minValue + " < n < " + maxValue);
            }
            return count;
        }

        protected boolean handleBoolean(Map properties, String key) {
            Object obj = properties.get(key);
            if (obj == null) {
                throw new IllegalArgumentException("No Value for " + key);
            }
            if (obj.toString().equals("true")) {
                return true;
            }
            if (obj.toString().equals("false")) {
                return false;
            }
            throw new IllegalArgumentException("Value for " + key + " must be boolean (true/false)");
        }
    }

    private class AltParameter
    extends Parameter {
        private long _maxFilesStored;
        private long _maxPreciousStored;
        private long _maxTimeStored;
        private long _timer;
        private double _percentageToFlush;
        private int _countToFlush;
        private int _flushAtOnce;
        private boolean _p_events;
        private boolean _p_rules;
        private boolean _p_poolset;

        public AltParameter() {
            this._maxFilesStored = 500L;
            this._maxPreciousStored = 512000L;
            this._maxTimeStored = 120L;
            this._timer = 60L;
            this._percentageToFlush = 0.5;
            this._countToFlush = 5;
            this._flushAtOnce = 0;
            this._p_events = false;
            this._p_rules = false;
            this._p_poolset = false;
        }

        public AltParameter(File configFile) {
            super(configFile);
            this._maxFilesStored = 500L;
            this._maxPreciousStored = 512000L;
            this._maxTimeStored = 120L;
            this._timer = 60L;
            this._percentageToFlush = 0.5;
            this._countToFlush = 5;
            this._flushAtOnce = 0;
            this._p_events = false;
            this._p_rules = false;
            this._p_poolset = false;
        }

        public void propertiesUpdated(Map properties) {
            HashSet keys = new HashSet(properties.keySet());
            for (String key : keys) {
                try {
                    if (key.equals(PARAMETER_MAX_FILE)) {
                        this._maxFilesStored = this.handleLong(properties, PARAMETER_MAX_FILE, 0L, 999999999L);
                        continue;
                    }
                    if (key.equals(PARAMETER_MAX_MEGABYTES)) {
                        this._maxPreciousStored = this.handleLong(properties, PARAMETER_MAX_MEGABYTES, 0L, 999999999L);
                        continue;
                    }
                    if (key.equals(PARAMETER_MAX_MINUTES)) {
                        this._maxTimeStored = this.handleLong(properties, PARAMETER_MAX_MINUTES, 0L, 999999999L);
                        continue;
                    }
                    if (key.equals(PARAMETER_TIMER)) {
                        this._timer = this.handleLong(properties, PARAMETER_TIMER, 0L, 999999999L);
                        continue;
                    }
                    if (key.equals(PARAMETER_FLUSH_ATONCE)) {
                        this._flushAtOnce = this.handleInt(properties, PARAMETER_FLUSH_ATONCE, 0, 999999999);
                        continue;
                    }
                    if (key.equals(PARAMETER_PRINT_EVENTS)) {
                        this._p_events = this.handleBoolean(properties, PARAMETER_PRINT_EVENTS);
                        continue;
                    }
                    if (key.equals(PARAMETER_PRINT_RULES)) {
                        this._p_rules = this.handleBoolean(properties, PARAMETER_PRINT_RULES);
                        continue;
                    }
                    if (key.equals(PARAMETER_PRINT_POOLSET_PROGRESS)) {
                        this._p_poolset = this.handleBoolean(properties, PARAMETER_PRINT_POOLSET_PROGRESS);
                        continue;
                    }
                    if (key.equals(PARAMETER_FLUSH_PERCENTAGE)) {
                        this._percentageToFlush = this.handleDouble(properties, PARAMETER_FLUSH_PERCENTAGE, 0.0, 1.0);
                        continue;
                    }
                    properties.remove(key);
                }
                catch (Exception ee) {
                    _log.warn("Exception while seting " + key + " " + ee);
                }
            }
            properties.put(PARAMETER_MAX_FILE, "" + this._maxFilesStored);
            properties.put(PARAMETER_MAX_MEGABYTES, "" + this._maxPreciousStored);
            properties.put(PARAMETER_MAX_MINUTES, "" + this._maxTimeStored);
            properties.put(PARAMETER_TIMER, "" + this._timer);
            properties.put(PARAMETER_FLUSH_PERCENTAGE, "" + this._percentageToFlush);
            properties.put(PARAMETER_FLUSH_ATONCE, "" + this._flushAtOnce);
            properties.put(PARAMETER_PRINT_EVENTS, "" + this._p_events);
            properties.put(PARAMETER_PRINT_RULES, "" + this._p_rules);
            properties.put(PARAMETER_PRINT_POOLSET_PROGRESS, "" + this._p_poolset);
        }
    }

    public class PoolComparator
    implements Comparator<Pool> {
        @Override
        public int compare(Pool a, Pool b) {
            double da = AlternatingFlushSchedulerV1.this.getPoolMetric(a);
            double db = AlternatingFlushSchedulerV1.this.getPoolMetric(b);
            return db == da ? 0 : (da > db ? -1 : 1);
        }
    }

    private class PoolSet {
        private Map _poolMap = new HashMap();
        private String _name = null;
        private int _progressState = 0;
        private long _progressStarted = 0L;
        private boolean _expectedReadOnly = false;

        private PoolSet(String name) {
            this._name = name;
        }

        public void put(String name, Pool pool) {
            this._poolMap.put(name, pool);
        }

        public Pool get(String name) {
            return (Pool)this._poolMap.get(name);
        }

        public Set keySet() {
            return this._poolMap.keySet();
        }

        public Collection values() {
            return this._poolMap.values();
        }

        public Set entrySet() {
            return this._poolMap.entrySet();
        }

        public void poolIoModeUpdated(Pool ip, boolean newIsReadOnly) {
            if (AlternatingFlushSchedulerV1.this._parameter._p_poolset) {
                _log.info("PROGRESS-H(" + this._name + "/" + ip._name + ") new pool i/o mode " + newIsReadOnly);
            }
            if (this._progressState != 1) {
                _log.warn("PROGRESS-H(" + this._name + "/" + ip._name + ") Warning : new pool i/o mode arrived unexpectedly in state " + this._progressState);
                return;
            }
            if (ip._expectedReadOnly != newIsReadOnly) {
                _log.warn("PROGRESS-H(" + this._name + "/" + ip._name + ") Warning : got I/O mode rdonly=" + newIsReadOnly + " expected rdOnly=" + this._expectedReadOnly);
                return;
            }
            int total = 0;
            int modeOk = 0;
            for (Pool ipool : this._poolMap.values()) {
                if (!ipool._pool.isActive()) continue;
                ++total;
                if (ipool._pool.isReadOnly() ^ ipool._expectedReadOnly) continue;
                ++modeOk;
            }
            if (AlternatingFlushSchedulerV1.this._parameter._p_poolset) {
                _log.info("PROGRESS-H(" + this._name + "/" + ip._name + ") new pool i/o mode total=" + total + ";rdOnly=" + modeOk);
            }
            if (modeOk < total) {
                return;
            }
            if (this._expectedReadOnly) {
                if (AlternatingFlushSchedulerV1.this._parameter._p_poolset) {
                    _log.info("PROGRESS-H(" + this._name + "/" + ip._name + ") new pool i/o mode done; Flushing all");
                }
                int flushed = 0;
                for (Pool ipool : this._poolMap.values()) {
                    ipool._flushCounter = 0;
                    ipool.flush();
                    if (ipool._flushCounter <= 0) continue;
                    ++flushed;
                }
                if (flushed > 0) {
                    if (AlternatingFlushSchedulerV1.this._parameter._p_poolset) {
                        _log.info("PROGRESS-H(" + this._name + "/" + ip._name + ") new pool i/o mode done; flushed " + flushed + " pools");
                    }
                    this.newState(2);
                } else {
                    if (AlternatingFlushSchedulerV1.this._parameter._p_poolset) {
                        _log.info("PROGRESS-H(" + this._name + "/" + ip._name + ") new pool i/o mode done; nothing to flush; switching back to read/write");
                    }
                    this.switchToNewPoolMode(false);
                }
            } else {
                if (AlternatingFlushSchedulerV1.this._parameter._p_poolset) {
                    _log.info("PROGRESS-H(" + this._name + "/" + ip._name + ") new pool i/o mode done; Switching back to IDLE");
                }
                this.newState(0);
            }
        }

        public boolean inProgress() {
            return this._progressState != 0;
        }

        public void flushingDone(Pool ip, String storageClassName, HsmFlushControlCore.FlushInfo flushInfo) {
            if (AlternatingFlushSchedulerV1.this._parameter._p_poolset) {
                _log.info("PROGRESS-H(" + this._name + "/" + ip._name + ") flushingDone");
            }
            int total = 0;
            int flushDone = 0;
            for (Pool ipool : this._poolMap.values()) {
                if (!ipool._pool.isActive()) continue;
                ++total;
                if (ipool._flushCounter != 0) continue;
                ++flushDone;
            }
            if (AlternatingFlushSchedulerV1.this._parameter._p_poolset) {
                _log.info("PROGRESS-H(" + this._name + "/" + ip._name + ") flushing done : total=" + total + ";flushDone=" + flushDone);
            }
            if (flushDone < total) {
                return;
            }
            this.switchToNewPoolMode(false);
        }

        private void flushAll() {
            if (AlternatingFlushSchedulerV1.this._parameter._p_poolset) {
                _log.info("PROGRESS-H(" + this._name + ") flush all; switching to readOnly");
            }
            this.switchToNewPoolMode(true);
        }

        private void newState(int state) {
            this._progressState = state;
            this._progressStarted = System.currentTimeMillis();
        }

        private void switchToNewPoolMode(boolean readOnly) {
            this.newState(1);
            this._expectedReadOnly = readOnly;
            for (Pool ip : this._poolMap.values()) {
                if (readOnly) {
                    ip.setReadOnly(readOnly);
                    continue;
                }
                ip.setReadOnly(ip._previousWasRdOnly);
            }
        }
    }

    private class Pool
    implements HsmFlushControlCore.DriverHandle {
        private String _name = null;
        private int _flushCounter = 0;
        private long _totalSpace = 0L;
        private long _preciousSpace = 0L;
        private PoolSet _hostPoolMap = null;
        private boolean _expectedReadOnly = false;
        private int _preciousFileCount = 0;
        private String _hostTag = null;
        private boolean _previousWasRdOnly = false;
        private long _oldestTimestamp = 0L;
        private HsmFlushControlCore.Pool _pool = null;

        private Pool(String name, HsmFlushControlCore.Pool pool) {
            this._name = name;
            this.update(pool);
            if (this._pool.isActive()) {
                this.linkUs();
            }
        }

        private PoolSet getParentPoolSet() {
            return this._hostPoolMap;
        }

        private void refreshLocalVariables() {
            PoolCellInfo cellInfo = this._pool.getCellInfo();
            if (cellInfo == null) {
                return;
            }
            PoolCostInfo costInfo = cellInfo.getPoolCostInfo();
            PoolCostInfo.PoolSpaceInfo spaceInfo = costInfo.getSpaceInfo();
            this._totalSpace = spaceInfo.getTotalSpace();
            this._preciousSpace = spaceInfo.getPreciousSpace();
            this._preciousFileCount = this.countTotalPending();
            this._oldestTimestamp = this.getOldestFileTimestamp();
        }

        private void update(HsmFlushControlCore.Pool pool) {
            this._pool = pool;
            if (!this._pool.isActive()) {
                return;
            }
            this.refreshLocalVariables();
            if (this._hostPoolMap == null) {
                this.linkUs();
            }
        }

        private void linkUs() {
            PoolCellInfo cellInfo = this._pool.getCellInfo();
            Map tagMap = cellInfo.getTagMap();
            this._hostTag = (String)tagMap.get("hostname");
            this._hostTag = this._hostTag == null ? "x-" + this._name : this._hostTag;
            this._hostPoolMap = (PoolSet)AlternatingFlushSchedulerV1.this._hostMap.get(this._hostTag);
            if (this._hostPoolMap == null) {
                this._hostPoolMap = new PoolSet(this._hostTag);
            }
            AlternatingFlushSchedulerV1.this._hostMap.put(this._hostTag, this._hostPoolMap);
            this._hostPoolMap.put(this._name, this);
        }

        private void setReadOnly(boolean readOnly) {
            this._previousWasRdOnly = this._pool.isReadOnly();
            this._expectedReadOnly = readOnly;
            this._pool.setReadOnly(readOnly);
        }

        private boolean isReady() {
            return this._pool != null && this._pool.isActive() && this._pool.isPoolIoModeKnown();
        }

        private void flush() {
            this._flushCounter += AlternatingFlushSchedulerV1.this.flushPool(this._pool);
        }

        private boolean isFlushing() {
            return this._flushCounter > 0;
        }

        private int countTotalPending() {
            return AlternatingFlushSchedulerV1.this.countTotalPendingPool(this._pool);
        }

        private long getOldestFileTimestamp() {
            return AlternatingFlushSchedulerV1.this.getOldestFileTimestampPool(this._pool);
        }

        public String toString() {
            if (this.isReady()) {
                return this._name + " precious file count : " + this._preciousFileCount + " core : " + this._pool;
            }
            return this._name + " Not Ready";
        }

        private void timer() {
        }

        public void poolIoModeUpdated(boolean newIsReadOnly) {
        }

        public void flushingDone(HsmFlushControlCore.FlushInfo flushInfo) {
            --this._flushCounter;
        }

        public void poolFlushInfoUpdated(HsmFlushControlCore.Pool pool) {
            if (!this._pool.isActive()) {
                return;
            }
            this.refreshLocalVariables();
        }
    }
}

