/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.hsmControl.flush;

import java.util.Comparator;

class HttpFlushManagerHelper {
    HttpFlushManagerHelper() {
    }

    static class FlushEntry {
        String _poolName = null;
        boolean _isFlushing = false;
        String _storageClass = null;
        long _total = 0L;
        long _precious = 0L;
        int _active = 0;
        int _pending = 0;
        int _failed = 0;

        FlushEntry() {
        }
    }

    static class FlushEntryComparator
    extends EntryComparator {
        FlushEntryComparator() {
        }

        @Override
        public int compare(Object a, Object b) {
            FlushEntry[] info1 = new FlushEntry[]{(FlushEntry)a, (FlushEntry)b};
            FlushEntry[] info2 = new FlushEntry[]{(FlushEntry)b, (FlushEntry)a};
            FlushEntry[] info = this._topHigh ? info1 : info2;
            int t = 0;
            switch (this._sortColumn) {
                case 0: {
                    t = info[0]._poolName.compareTo(info[1]._poolName);
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 1: {
                    t = info[0]._storageClass.compareTo(info[1]._storageClass);
                    return t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                }
                case 2: {
                    t = this.compareBoolean(info[0]._isFlushing, info[1]._isFlushing);
                    t = t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 3: {
                    t = this.compareLong(info[0]._total, info[1]._total);
                    t = t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 4: {
                    t = this.compareLong(info[0]._precious, info[1]._precious);
                    t = t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 5: {
                    t = this.compareInt(info[0]._active, info[1]._active);
                    t = t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 6: {
                    t = this.compareInt(info[0]._pending, info[1]._pending);
                    t = t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 7: {
                    t = this.compareInt(info[0]._failed, info[1]._failed);
                    t = t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 8: {
                    return this.compareDouble((double)info[0]._precious / (double)info[0]._total, (double)info[1]._precious / (double)info[1]._total);
                }
            }
            return 0;
        }
    }

    static class PoolEntryComparator
    extends EntryComparator {
        PoolEntryComparator() {
        }

        @Override
        public int compare(Object a, Object b) {
            PoolEntry[] info1 = new PoolEntry[]{(PoolEntry)a, (PoolEntry)b};
            PoolEntry[] info2 = new PoolEntry[]{(PoolEntry)b, (PoolEntry)a};
            PoolEntry[] info = this._topHigh ? info1 : info2;
            int t = 0;
            switch (this._sortColumn) {
                case 0: {
                    return info[0]._poolName.compareTo(info[1]._poolName);
                }
                case 1: {
                    t = this.compareBoolean(info[0]._isReadOnly, info[1]._isReadOnly);
                    return t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                }
                case 2: {
                    t = this.compareInt(info[0]._flushing, info[1]._flushing);
                    return t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                }
                case 3: {
                    t = this.compareLong(info[0]._total, info[1]._total);
                    return t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                }
                case 4: {
                    t = this.compareLong(info[0]._precious, info[1]._precious);
                    return t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                }
                case 5: {
                    return this.compareDouble((double)info[0]._precious / (double)info[0]._total, (double)info[1]._precious / (double)info[1]._total);
                }
            }
            return 0;
        }
    }

    private static abstract class EntryComparator
    implements Comparator {
        boolean _topHigh = false;
        int _sortColumn = 0;

        private EntryComparator() {
        }

        void setColumn(int column) {
            if (this._sortColumn == column) {
                this._topHigh = !this._topHigh;
            } else {
                this._sortColumn = column;
                this._topHigh = false;
            }
        }

        public abstract int compare(Object var1, Object var2);

        int compareBoolean(boolean a, boolean b) {
            return a ^ b ? (a ? 1 : -1) : 0;
        }

        int compareInt(int a, int b) {
            return a == b ? 0 : (a > b ? 1 : -1);
        }

        int compareLong(long a, long b) {
            return a == b ? 0 : (a > b ? 1 : -1);
        }

        int compareDouble(double a, double b) {
            return a == b ? 0 : (a > b ? 1 : -1);
        }
    }

    static class PoolEntry {
        String _poolName = null;
        long _total = 0L;
        long _precious = 0L;
        int _flushing = 0;
        boolean _isReadOnly = false;
        String _storageClass = null;

        PoolEntry() {
        }
    }
}

