/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.hsmControl.flush;

import diskCacheV111.hsmControl.flush.FlushControlCellInfo;
import diskCacheV111.hsmControl.flush.HsmFlushControlCore;
import diskCacheV111.hsmControl.flush.HsmFlushControllerFlushInfoDetails;
import diskCacheV111.hsmControl.flush.HsmFlushControllerPoolDetails;
import diskCacheV111.hsmControl.flush.HsmFlushSchedulable;
import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.pools.StorageClassFlushInfo;
import diskCacheV111.vehicles.PoolFlushControlInfoMessage;
import diskCacheV111.vehicles.PoolFlushDoFlushMessage;
import diskCacheV111.vehicles.PoolFlushGainControlMessage;
import diskCacheV111.vehicles.PoolManagerPoolModeMessage;
import diskCacheV111.vehicles.PoolStatusChangedMessage;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsmFlushControlManager
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(HsmFlushControlManager.class);
    private CellNucleus _nucleus = null;
    private Args _args = null;
    private int _requests = 0;
    private int _failed = 0;
    private File _database = null;
    private String _status = "init";
    private boolean _logEnabled = true;
    private final PoolCollector _poolCollector;
    private Set _poolGroupList = new HashSet();
    private long _getPoolCollectionTicker = 120000L;
    private long _timerInterval = 30000L;
    private FlushController _flushController = new FlushController();
    private EventDispatcher _eventDispatcher = new EventDispatcher();
    private SimpleDateFormat formatter = new SimpleDateFormat("MM.dd hh:mm:ss");
    private QueueWatch _queueWatch = null;
    private Map _properties = new HashMap();
    private final Object _propertyLock = new Object();
    private long _propertiesUpdated = 0L;
    public String hh_pgroup_add = "<pGroup0> [<pgroup1> [...]]";
    public String hh_pgroup_remove = "<pGroup0> [<pgroup1> [...]]";
    public String hh_pgroup_ls = "";
    public String hh_set_control = "on|off [-interval=<seconds>]";
    public String hh_set_pool = "<poolName> rdonly|rw";
    public String hh_query_pool_mode = "<poolName>";
    public String hh_flush_pool = "<poolName> <storageClass> [-count=<count>]";
    public String hh_ls_pool = "[<poolName>] -l ";
    public String hh_driver_reset = " # resets driver ";
    public String hh_driver_command = " commands send to driver ... ";
    public String hh_driver_properties = " OPTIONS : -<key>=<value> ...";
    public String hh_load_driver = "<driveClassName> [driver arguments and options]";
    public String hh_unload_driver = "";

    public HsmFlushControlManager(String name, String args) throws Exception {
        super(name, args, false);
        this._nucleus = this.getNucleus();
        this._args = this.getArgs();
        try {
            if (this._args.argc() < 1) {
                throw new IllegalArgumentException("Usage : ... <pgroup0> [<pgroup1>[...]]");
            }
            int n = this._args.argc();
            for (int i = 0; i < n; ++i) {
                this._poolGroupList.add(this._args.argv(0));
                this._args.shift();
            }
            String tmp = this._args.getOpt("scheduler");
            if (tmp != null && !tmp.equals("")) {
                this._eventDispatcher.loadHandler(tmp, false, this._args);
            }
            this._queueWatch = new QueueWatch();
            tmp = this._args.getOpt("poolCollectionUpdate");
            if (tmp != null && !tmp.equals("")) {
                try {
                    this._getPoolCollectionTicker = Long.parseLong(tmp) * 60L * 1000L;
                }
                catch (Exception ee) {
                    _log.warn("Illegal value for poolCollectionUpdate : " + tmp + " (chosing " + this._getPoolCollectionTicker + " millis)");
                }
            }
            if ((tmp = this._args.getOpt("gainControlUpdate")) != null && !tmp.equals("")) {
                long gainControlTicker = 0L;
                try {
                    gainControlTicker = Long.parseLong(tmp) * 60L * 1000L;
                    this._queueWatch.setGainControlTicker(gainControlTicker);
                }
                catch (Exception ee) {
                    _log.warn("Illegal value for gainControlUpdate : " + tmp + " (chosing " + gainControlTicker + " millis)");
                }
            }
            if ((tmp = this._args.getOpt("timer")) != null && !tmp.equals("")) {
                try {
                    this._timerInterval = Long.parseLong(tmp) * 1000L;
                }
                catch (Exception ee) {
                    _log.warn("Illegal value for timer : " + tmp + " (chosing " + this._timerInterval + " millis)");
                }
            }
        }
        catch (Exception e) {
            this.start();
            this.kill();
            throw e;
        }
        this.useInterpreter(true);
        this._nucleus.newThread((Runnable)this._queueWatch, "queueWatch").start();
        this.start();
        this._poolCollector = new PoolCollector();
    }

    private void flushStorageClass(String poolName, String storageClass, int count) throws Exception {
        PoolFlushDoFlushMessage msg = new PoolFlushDoFlushMessage(poolName, storageClass);
        msg.setMaxFlushCount(count);
        this.sendMessage(new CellMessage(new CellPath(poolName), (Object)msg));
    }

    private void setPoolReadOnly(String poolName, boolean rdOnly) {
        try {
            PoolManagerPoolModeMessage msg = new PoolManagerPoolModeMessage(poolName, 0x10 | (rdOnly ? 0 : 32));
            this.sendMessage(new CellMessage(new CellPath("PoolManager"), (Object)msg));
        }
        catch (Exception ee) {
            _log.warn("setPoolReadOnly : couldn't sent message to PoolManager" + ee);
        }
    }

    private void queryPoolMode(String poolName) {
        try {
            PoolManagerPoolModeMessage msg = new PoolManagerPoolModeMessage(poolName, 0);
            this.sendMessage(new CellMessage(new CellPath("PoolManager"), (Object)msg));
        }
        catch (Exception ee) {
            _log.warn("queryPoolMode : couldn't sent message to PoolManager" + ee);
        }
    }

    public String ac_pgroup_add_$_1_99(Args args) {
        for (int i = 0; i < args.argc(); ++i) {
            this._poolGroupList.add(args.argv(i));
        }
        return "";
    }

    public String ac_pgroup_remove_$_1_99(Args args) {
        for (int i = 0; i < args.argc(); ++i) {
            this._poolGroupList.remove(args.argv(i));
        }
        return "";
    }

    public String ac_pgroup_ls(Args args) {
        StringBuffer sb = new StringBuffer();
        Iterator it = this._poolGroupList.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        return sb.toString();
    }

    public String ac_set_control_$_1(Args args) {
        String mode = args.argv(0);
        String iString = args.getOpt("interval");
        long interval = 0L;
        if (iString != null && (interval = Long.parseLong(iString) * 1000L) < 30000L) {
            throw new IllegalArgumentException("interval must be greater than 30");
        }
        if (mode.equals("on")) {
            this._flushController.setControl(true);
        } else if (mode.equals("off")) {
            this._flushController.setControl(false);
        } else {
            throw new IllegalArgumentException("set control on|off");
        }
        if (interval > 0L) {
            this._queueWatch.setGainControlTicker(interval);
        }
        return "";
    }

    public String ac_set_pool_$_2(Args args) throws Exception {
        String poolName = args.argv(0);
        String mode = args.argv(1);
        HFCPool pool = this._poolCollector.getPoolByName(poolName);
        if (pool == null) {
            throw new NoSuchElementException("Pool not found : " + poolName);
        }
        if (mode.equals("rdonly")) {
            pool.setReadOnly(true);
        } else if (mode.equals("rw")) {
            pool.setReadOnly(false);
        } else {
            throw new IllegalArgumentException("Illegal mode : rdonly|rw");
        }
        return "Pool " + poolName + " set to " + mode;
    }

    public String ac_query_pool_mode_$_1(Args args) throws Exception {
        String poolName = args.argv(0);
        HFCPool pool = this._poolCollector.getPoolByName(poolName);
        if (pool == null) {
            throw new NoSuchElementException("Pool not found : " + poolName);
        }
        pool.queryMode();
        return "Pool mode query sent to Pool " + poolName;
    }

    public String ac_flush_pool_$_2(Args args) throws Exception {
        String poolName = args.argv(0);
        String storageClass = args.argv(1);
        String countString = args.getOpt("count");
        int count = countString == null || countString.equals("") ? 0 : Integer.parseInt(countString);
        HFCPool pool = this._poolCollector.getPoolByName(poolName);
        if (pool == null) {
            throw new NoSuchElementException("Pool not found : " + poolName);
        }
        HsmFlushControlCore.FlushInfo info = pool.getFlushInfoByStorageClass(storageClass);
        if (info == null) {
            throw new NoSuchElementException("StorageClass not found : " + storageClass);
        }
        info.flush(count);
        return "Flush initiated for (" + poolName + "," + storageClass + ")";
    }

    public Object ac_ls_pool_$_0_1(Args args) {
        String poolName = args.argc() == 0 ? null : args.argv(0);
        boolean detail = args.hasOption("l");
        boolean binary = args.hasOption("binary");
        StringBuffer sb = new StringBuffer();
        if (poolName == null) {
            if (binary) {
                ArrayList<HsmFlushControlCore.PoolDetails> list = new ArrayList<HsmFlushControlCore.PoolDetails>();
                Iterator i = this._eventDispatcher.getConfiguredPools().iterator();
                while (i.hasNext()) {
                    list.add(((HFCPool)i.next()).getDetails());
                }
                return list;
            }
            TreeSet set = new TreeSet(this._poolCollector.getConfiguredPoolNames());
            ArrayList list = new ArrayList();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                String name = it.next().toString();
                if (!detail) {
                    sb.append(name).append("\n");
                    continue;
                }
                HFCPool pool = this._poolCollector.getPoolByName(name);
                this.printPoolDetails2(pool, sb);
            }
        } else {
            HFCPool pool = this._poolCollector.getPoolByName(poolName);
            if (pool == null) {
                throw new NoSuchElementException("Pool not found : " + poolName);
            }
            if (binary) {
                return pool.getDetails();
            }
            this.printPoolDetails2(pool, sb);
        }
        return sb.toString();
    }

    private void printPoolDetails2(HFCPool pool, StringBuffer sb) {
        sb.append(pool._poolName);
        sb.append("\n").append(pool.toString()).append(" ");
        if (pool.cellInfo == null) {
            return;
        }
        PoolCellInfo cellInfo = pool.cellInfo;
        PoolCostInfo costInfo = cellInfo.getPoolCostInfo();
        PoolCostInfo.PoolSpaceInfo spaceInfo = costInfo.getSpaceInfo();
        PoolCostInfo.PoolQueueInfo queueInfo = costInfo.getStoreQueue();
        long total = spaceInfo.getTotalSpace();
        long precious = spaceInfo.getPreciousSpace();
        sb.append("   ").append("Mode=").append(pool.getPoolModeString()).append(";Total=").append(total).append(";Precious=").append(precious).append(";Frac=").append((float)precious / (float)total).append(";Queue={").append(queueInfo.toString()).append("}\n");
        for (HFCFlushInfo info : pool.flushInfos.values()) {
            StorageClassFlushInfo flush = info.getStorageClassFlushInfo();
            String storeName = flush.getStorageClass() + "@" + flush.getHsm();
            long size = flush.getTotalPendingFileSize();
            int count = flush.getRequestCount();
            int active = flush.getActiveCount();
            sb.append("   ").append(storeName).append("  ").append(info._flushingRequested ? "R" : "-").append(info._flushingPending ? "P" : "-").append(info._flushingError != 0 ? "E" : "-").append("(").append(info._flushingId).append(")").append(";Size=").append(size).append(";Count=").append(count).append(";Active=").append(active).append("\n");
        }
    }

    private void printFlushInfo(StorageClassFlushInfo flush, StringBuffer sb) {
        sb.append("count=").append(flush.getRequestCount()).append(";bytes=").append(flush.getTotalPendingFileSize());
    }

    public String toString() {
        return "Req=" + this._requests + ";Err=" + this._failed + ";";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInfo(PrintWriter pw) {
        Object pools;
        pw.println("HsmFlushControlManager : [$Id: HsmFlushControlManager.java,v 1.6 2006-07-31 16:35:50 patrick Exp $]");
        pw.println("Status     : " + this._status);
        pw.print("PoolGroups : ");
        for (Map.Entry entry : this._poolCollector.getPoolGroupHash().entrySet()) {
            String groupName = (String)entry.getKey();
            pools = (Object[])entry.getValue();
            pw.println(groupName + "(" + ((Object[])pools).length + "),");
        }
        pw.println("");
        pw.println("Driver     : " + (this._eventDispatcher._schedulerName == null ? "NONE" : this._eventDispatcher._schedulerName));
        pw.println("Control    : " + (this._flushController._control ? "on" : "off"));
        pw.println("Update     : " + this._queueWatch._gainControlTicker / 1000L + " seconds");
        long propertiesUpdated = this._propertiesUpdated;
        if (propertiesUpdated == 0L) {
            pw.println("Update     : " + this._queueWatch._gainControlTicker / 1000L + " seconds");
            pw.println("Properties : Not queried yet");
        } else {
            Map properties = null;
            pools = this._propertyLock;
            synchronized (pools) {
                properties = this._properties;
            }
            if (properties != null && properties.size() > 0) {
                pw.println("Properties : (age " + (System.currentTimeMillis() - propertiesUpdated) / 1000L + " seconds)");
                for (Map.Entry entry : properties.entrySet()) {
                    pw.println("  " + entry.getKey() + "=" + entry.getValue());
                }
            } else {
                pw.println("Properties : None");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellInfo getCellInfo() {
        FlushControlCellInfo info = new FlushControlCellInfo(super.getCellInfo());
        info.setParameter(this._eventDispatcher._schedulerName == null ? "NONE" : this._eventDispatcher._schedulerName, this._queueWatch._gainControlTicker, this._flushController._control, new ArrayList(this._poolCollector.getPoolGroupHash().keySet()), this._status);
        Object object = this._propertyLock;
        synchronized (object) {
            info.setDriverProperties(System.currentTimeMillis() - this._propertiesUpdated, this._properties);
        }
        return info;
    }

    public String ac_driver_reset(Args args) throws Exception {
        this._eventDispatcher.callDriver(args);
        return "Command sent to driver";
    }

    public String ac_driver_command_$_0_999(Args args) throws Exception {
        this._eventDispatcher.callDriver(args);
        return "Command sent to driver";
    }

    public String ac_driver_properties(Args args) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        int n = args.optc();
        for (int i = 0; i < n; ++i) {
            String key = args.optv(i);
            String value = args.getOpt(key);
            map.put(key, value);
        }
        this._eventDispatcher.propertiesUpdated(map);
        return "Properties sent to driver, check with 'info'";
    }

    public String ac_load_driver_$_999(Args args) throws Exception {
        String driverClass = args.argv(0);
        args.shift();
        this._eventDispatcher.loadHandler(driverClass, true, args);
        return "Loaded : " + driverClass;
    }

    public String ac_unload_driver(Args args) throws Exception {
        this._eventDispatcher.unloadHandler();
        return "Unload scheduled";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poolFlushDoFlushMessageArrived(PoolFlushDoFlushMessage msg) {
        if (this._logEnabled) {
            _log.info("poolFlushDoFlushMessageArrived : " + msg);
        }
        String poolName = msg.getPoolName();
        PoolCollector poolCollector = this._poolCollector;
        synchronized (poolCollector) {
            HFCPool pool = this._poolCollector.getPoolByName(poolName);
            if (pool == null) {
                _log.warn("poolFlushDoFlushMessageArrived : message arrived for non configured pool : " + poolName);
                return;
            }
            String storageClass = msg.getStorageClassName() + "@" + msg.getHsmName();
            HFCFlushInfo info = (HFCFlushInfo)pool.flushInfos.get(storageClass);
            if (info == null) {
                _log.warn("poolFlushDoFlushMessageArrived : message arrived for non existing storage class : " + storageClass);
                info = new HFCFlushInfo(pool, new StorageClassFlushInfo(msg.getHsmName(), msg.getStorageClassName()));
            }
            if (msg.getReturnCode() != 0) {
                if (this._logEnabled) {
                    _log.info("Flush failed (msg=" + (msg.isFinished() ? "Finished" : "Ack") + ") : " + msg);
                }
                info.setFlushingFailed(msg.getReturnCode(), msg.getErrorObject());
                return;
            }
            if (msg.isFinished()) {
                if (this._logEnabled) {
                    _log.info("Flush finished : " + msg);
                }
                this.updateFlushCellAndFlushInfos(msg, pool);
                info.setFlushingDone();
                this._eventDispatcher.flushingDone(info);
            } else {
                info.setFlushingAck(msg.getFlushId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poolFlushGainControlMessageDidntArrive(String poolName) {
        if (this._logEnabled) {
            _log.info("poolFlushGainControlMessageDidntArrive : " + poolName);
        }
        PoolCollector poolCollector = this._poolCollector;
        synchronized (poolCollector) {
            HFCPool pool = this._poolCollector.getPoolByName(poolName);
            if (pool == null) {
                _log.warn("PoolFlushGainControlMessage : message arrived for non configured pool : " + poolName);
                return;
            }
            pool.isActive = false;
            pool.lastUpdated = System.currentTimeMillis();
            pool.answerCount++;
            this._eventDispatcher.poolFlushInfoUpdated(pool);
        }
    }

    private void updateFlushCellAndFlushInfos(PoolFlushControlInfoMessage msg, HFCPool pool) {
        pool.cellInfo = msg.getCellInfo();
        StorageClassFlushInfo[] flush = msg.getFlushInfos();
        HashMap<String, HFCFlushInfo> map = new HashMap<String, HFCFlushInfo>();
        if (flush != null) {
            for (int i = 0; i < flush.length; ++i) {
                String storageClass = flush[i].getStorageClass() + "@" + flush[i].getHsm();
                HFCFlushInfo info = (HFCFlushInfo)pool.flushInfos.get(storageClass);
                if (info == null) {
                    map.put(storageClass, new HFCFlushInfo(pool, flush[i]));
                    continue;
                }
                info.updateFlushInfo(flush[i]);
                map.put(storageClass, info);
            }
        }
        pool.flushInfos = map;
        pool.isActive = true;
        pool.lastUpdated = System.currentTimeMillis();
        pool.answerCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poolFlushGainControlMessageArrived(PoolFlushGainControlMessage msg) {
        if (this._logEnabled) {
            _log.info("PoolFlushGainControlMessage : " + msg);
        }
        String poolName = msg.getPoolName();
        PoolCollector poolCollector = this._poolCollector;
        synchronized (poolCollector) {
            HFCPool pool = this._poolCollector.getPoolByName(poolName);
            if (pool == null) {
                _log.warn("PoolFlushGainControlMessage : message arrived for non configured pool : " + poolName);
                return;
            }
            this.updateFlushCellAndFlushInfos(msg, pool);
            this._eventDispatcher.poolFlushInfoUpdated(pool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poolModeInfoArrived(PoolManagerPoolModeMessage msg) {
        if (this._logEnabled) {
            _log.info("PoolManagerPoolModeMessage : " + msg);
        }
        String poolName = msg.getPoolName();
        PoolCollector poolCollector = this._poolCollector;
        synchronized (poolCollector) {
            HFCPool pool = this._poolCollector.getPoolByName(poolName);
            if (pool == null) {
                _log.warn("poolModeInfoArrived : message arrived for non configured pool : " + poolName);
                return;
            }
            pool.mode = msg.getPoolMode();
            this._eventDispatcher.poolIoModeUpdated(pool);
        }
    }

    private void poolStatusChanged(PoolStatusChangedMessage msg) {
        String poolName = msg.getPoolName();
    }

    public void messageArrived(CellMessage msg) {
        Object obj = msg.getMessageObject();
        ++this._requests;
        if (obj instanceof PoolFlushGainControlMessage) {
            this.poolFlushGainControlMessageArrived((PoolFlushGainControlMessage)obj);
        } else if (obj instanceof PoolFlushDoFlushMessage) {
            this.poolFlushDoFlushMessageArrived((PoolFlushDoFlushMessage)obj);
        } else if (obj instanceof PoolManagerPoolModeMessage) {
            this.poolModeInfoArrived((PoolManagerPoolModeMessage)obj);
        } else if (obj instanceof PoolStatusChangedMessage) {
            this.poolStatusChanged((PoolStatusChangedMessage)obj);
        } else if (obj instanceof NoRouteToCellException) {
            NoRouteToCellException nrtc = (NoRouteToCellException)((Object)obj);
            CellPath path = nrtc.getDestinationPath();
            CellAddressCore core = path.getDestinationAddress();
            String cellName = core.getCellName();
            _log.warn("NoRouteToCell : " + cellName + " (" + path + ")");
            this.poolFlushGainControlMessageDidntArrive(cellName);
        } else {
            _log.warn("Unknown message arrived (" + msg.getSourcePath() + ") : " + msg.getMessageObject());
            ++this._failed;
        }
    }

    private class EventDispatcher
    implements HsmFlushControlCore,
    Runnable {
        private Class[] _argumentClasses = new Class[]{CellAdapter.class, HsmFlushControlCore.class};
        private Object[] _argumentObjects = new Object[]{HsmFlushControlManager.this, this};
        private HsmFlushSchedulable _scheduler = null;
        private String _schedulerName = null;
        private String _printoutName = null;
        private Pipe _pipe = null;
        private Thread _worker = null;
        private boolean _initDone = false;
        private Args _driverArgs = new Args((CharSequence)"");

        private EventDispatcher() {
        }

        @Override
        public void run() {
            this.runIt(this._pipe);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runIt(Pipe pipe) {
            HsmFlushSchedulable s = null;
            Event event = null;
            boolean done = false;
            boolean initDone = false;
            _log.info(this._printoutName + ": Worker event loop started for " + this._schedulerName);
            while (!Thread.interrupted() && !done) {
                try {
                    event = pipe.pop();
                }
                catch (InterruptedException e) {
                    break;
                }
                EventDispatcher e = this;
                synchronized (e) {
                    s = this._scheduler;
                    if (s == null) {
                        break;
                    }
                }
                try {
                    if (!initDone && HsmFlushControlManager.this._poolCollector.isPoolSetupReady() && HsmFlushControlManager.this._poolCollector.isPoolConfigDone()) {
                        s.init();
                        initDone = true;
                        HsmFlushControlManager.this._poolCollector.queryAllPoolModes();
                    }
                    if (!initDone) continue;
                    switch (event.type) {
                        case 2: {
                            HFCFlushInfo info = (HFCFlushInfo)event.args[0];
                            s.flushingDone(info._pool._poolName, info._flushInfo.getStorageClass() + "@" + info._flushInfo.getHsm(), info);
                            break;
                        }
                        case 3: {
                            HFCPool pool = (HFCPool)event.args[0];
                            s.poolFlushInfoUpdated(pool._poolName, pool);
                            break;
                        }
                        case 8: {
                            HFCPool pool = (HFCPool)event.args[0];
                            s.poolIoModeUpdated(pool._poolName, pool);
                            break;
                        }
                        case 6: {
                            String poolName = (String)event.args[0];
                            s.configuredPoolAdded(poolName);
                            break;
                        }
                        case 7: {
                            String poolName = (String)event.args[0];
                            s.configuredPoolRemoved(poolName);
                            break;
                        }
                        case 10: {
                            Map properties = (Map)event.args[0];
                            s.propertiesUpdated(properties);
                            Object object = HsmFlushControlManager.this._propertyLock;
                            synchronized (object) {
                                HsmFlushControlManager.this._propertiesUpdated = System.currentTimeMillis();
                                HsmFlushControlManager.this._properties = properties;
                                break;
                            }
                        }
                        case 5: {
                            s.poolSetupUpdated();
                            break;
                        }
                        case 4: {
                            Args args = (Args)event.args[0];
                            s.command(args);
                            break;
                        }
                        case 9: {
                            s.timer();
                            break;
                        }
                        case 11: {
                            s.reset();
                            break;
                        }
                        case 1: {
                            done = true;
                        }
                    }
                }
                catch (Throwable t) {
                    _log.warn(this._printoutName + ": Exception reported by " + event.type + " : " + t, t);
                }
            }
            _log.info(this._printoutName + ": Worker event loop stopped");
            _log.info(this._printoutName + ": Preparing unload");
            EventDispatcher eventDispatcher = this;
            synchronized (eventDispatcher) {
                if (this._scheduler == null) {
                    return;
                }
                try {
                    this._scheduler.prepareUnload();
                }
                catch (Throwable t) {
                    _log.warn(this._printoutName + ": Exception in prepareUnload " + t, t);
                }
                this._scheduler = null;
                this._worker = null;
                this._initDone = false;
            }
        }

        private synchronized void flushingDone(HFCFlushInfo info) {
            if (this._pipe != null) {
                this._pipe.push(new Event(2, info));
            }
        }

        private synchronized void poolSetupReady() {
            if (this._pipe != null) {
                this._pipe.push(new Event(5, null));
            }
        }

        private synchronized void poolFlushInfoUpdated(HFCPool pool) {
            if (this._pipe != null) {
                this._pipe.push(new Event(3, pool));
            }
        }

        private synchronized void configuredPoolAdded(String pool) {
            if (this._pipe != null) {
                this._pipe.push(new Event(6, pool));
            }
        }

        private synchronized void configuredPoolRemoved(String pool) {
            if (this._pipe != null) {
                this._pipe.push(new Event(7, pool));
            }
        }

        private synchronized void callDriver(Args args) {
            if (this._pipe != null) {
                this._pipe.push(new Event(4, args));
            }
        }

        private synchronized void poolIoModeUpdated(HFCPool pool) {
            if (this._pipe != null) {
                this._pipe.push(new Event(8, pool));
            }
        }

        private synchronized void propertiesUpdated(Map properties) {
            if (this._pipe != null) {
                this._pipe.push(new Event(10, properties));
            }
        }

        private synchronized void timer() {
            if (this._pipe != null) {
                this._pipe.push(new Event(9));
            }
        }

        private synchronized void reset() {
            if (this._pipe != null) {
                this._pipe.push(new Event(11));
            }
        }

        private synchronized void loadHandler(String handlerName, boolean doInit, Args args) throws Exception {
            if (this._scheduler != null) {
                throw new IllegalArgumentException("Handler already registered");
            }
            Class<?> c = Class.forName(handlerName);
            Constructor<?> con = c.getConstructor(this._argumentClasses);
            this._driverArgs = args;
            this._schedulerName = handlerName;
            String[] tmp = handlerName.split("\\.");
            this._printoutName = tmp[tmp.length - 1];
            this._scheduler = (HsmFlushSchedulable)con.newInstance(this._argumentObjects);
            this._pipe = new Pipe();
            this._worker = HsmFlushControlManager.this._nucleus.newThread((Runnable)this, "driver");
            this._worker.start();
        }

        private synchronized void unloadHandler() {
            if (this._pipe == null) {
                throw new IllegalArgumentException("No handler active");
            }
            Pipe pipe = this._pipe;
            this._pipe = null;
            pipe.push(new Event(1));
        }

        private synchronized void something() {
        }

        @Override
        public Args getDriverArgs() {
            return this._driverArgs;
        }

        @Override
        public HsmFlushControlCore.Pool getPoolByName(String poolName) {
            return HsmFlushControlManager.this._poolCollector.getPoolByName(poolName);
        }

        @Override
        public List getConfiguredPools() {
            return HsmFlushControlManager.this._poolCollector.getConfiguredPools();
        }

        @Override
        public Set getConfiguredPoolNames() {
            return HsmFlushControlManager.this._poolCollector.getConfiguredPoolNames();
        }

        private class Pipe {
            private ArrayList _list = new ArrayList();

            private Pipe() {
            }

            public synchronized void push(Event obj) {
                this._list.add(obj);
                this.notifyAll();
            }

            public synchronized Event pop() throws InterruptedException {
                while (this._list.isEmpty()) {
                    this.wait();
                }
                return (Event)this._list.remove(0);
            }
        }

        private class Event {
            private static final int INIT = 0;
            private static final int UNLOAD = 1;
            private static final int FLUSHING_DONE = 2;
            private static final int POOL_FLUSH_INFO_UPDATED = 3;
            private static final int CALL_DRIVER = 4;
            private static final int POOL_SETUP_UPDATED = 5;
            private static final int CONFIGURED_POOL_ADDED = 6;
            private static final int CONFIGURED_POOL_REMOVED = 7;
            private static final int POOL_IO_MODE_UPDATED = 8;
            private static final int TIMER = 9;
            private static final int PROPERTIES_UPDATED = 10;
            private static final int RESET = 11;
            int type = 0;
            Object[] args = null;
            long timestamp = System.currentTimeMillis();

            private Event(int type) {
                this.type = type;
            }

            private Event(int type, Object obj) {
                this.type = type;
                this.args = new Object[1];
                this.args[0] = obj;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append("Event type : ").append(this.type);
                if (this.args != null) {
                    for (int i = 0; i < this.args.length; ++i) {
                        sb.append(";arg(").append(i).append(")=").append(this.args[i].toString());
                    }
                }
                return sb.toString();
            }
        }
    }

    private class PoolCollector
    implements CellMessageAnswerable {
        private boolean _active = false;
        private int _waitingFor = 0;
        private HashMap _poolGroupHash = new HashMap();
        private HashMap _configuredPoolList = new HashMap();
        private boolean _poolSetupReady = false;

        private PoolCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queryAllPoolModes() {
            ArrayList list;
            PoolCollector poolCollector = this;
            synchronized (poolCollector) {
                list = new ArrayList(this._configuredPoolList.values());
            }
            for (HFCPool pool : list) {
                pool.queryMode();
            }
        }

        private synchronized boolean isPoolSetupReady() {
            return this._poolSetupReady;
        }

        private boolean isPoolConfigDone() {
            long now = System.currentTimeMillis();
            int pools = 0;
            int c = 0;
            for (HFCPool pool : this._configuredPoolList.values()) {
                if (pool.answerCount > 1) {
                    return true;
                }
                if (pool.answerCount > 0) {
                    ++c;
                }
                ++pools;
            }
            return c == pools;
        }

        private synchronized Map getPoolGroupHash() {
            return new HashMap(this._poolGroupHash);
        }

        private synchronized Set getConfiguredPoolNames() {
            return new HashSet(this._configuredPoolList.keySet());
        }

        private synchronized List getConfiguredPools() {
            return new ArrayList(this._configuredPoolList.values());
        }

        private synchronized void runCollector(Collection list) {
            if (this._active) {
                _log.warn("runCollector : Still running");
                return;
            }
            this._active = true;
            CellPath path = new CellPath("PoolManager");
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String command = "psux ls pgroup " + i.next();
                if (HsmFlushControlManager.this._logEnabled) {
                    _log.info("runCollector sending : " + command + " to " + path);
                }
                try {
                    HsmFlushControlManager.this.sendMessage(new CellMessage(path, (Object)command), true, true, this, 30000L);
                    ++this._waitingFor;
                }
                catch (Exception ee) {
                    _log.warn("Coudn't send <" + command + "> to " + path + " " + ee);
                }
            }
        }

        private synchronized void answer() {
            --this._waitingFor;
            if (this._waitingFor == 0) {
                String poolName;
                if (HsmFlushControlManager.this._logEnabled) {
                    _log.info("PoolCollector : we are done : " + this._poolGroupHash);
                }
                this._active = false;
                HashMap<String, HFCPool> map = new HashMap<String, HFCPool>();
                if (HsmFlushControlManager.this._logEnabled) {
                    _log.info("Creating ping set");
                }
                for (Object[] c : this._poolGroupHash.values()) {
                    for (int i = 0; i < c.length; ++i) {
                        HFCPool p;
                        String pool = (String)c[i];
                        if (HsmFlushControlManager.this._logEnabled) {
                            _log.info("Adding pool : " + pool);
                        }
                        map.put(pool, (p = (HFCPool)this._configuredPoolList.get(pool)) == null ? new HFCPool(pool) : p);
                    }
                }
                Iterator<Object> it = map.keySet().iterator();
                while (it.hasNext()) {
                    poolName = it.next().toString();
                    if (this._configuredPoolList.get(poolName) != null) continue;
                    HsmFlushControlManager.this._eventDispatcher.configuredPoolAdded(poolName);
                }
                it = this._configuredPoolList.keySet().iterator();
                while (it.hasNext()) {
                    poolName = it.next().toString();
                    if (map.get(poolName) != null) continue;
                    HsmFlushControlManager.this._eventDispatcher.configuredPoolRemoved(poolName);
                }
                HsmFlushControlManager.this._flushController.updatePoolList(map.keySet());
                this._configuredPoolList = map;
                this._poolSetupReady = true;
                HsmFlushControlManager.this._eventDispatcher.poolSetupReady();
            }
        }

        public synchronized HFCPool getPoolByName(String poolName) {
            return (HFCPool)this._configuredPoolList.get(poolName);
        }

        public void answerArrived(CellMessage request, CellMessage answer) {
            Object reply;
            if (HsmFlushControlManager.this._logEnabled) {
                _log.info("answer Arrived : " + answer);
            }
            if ((reply = answer.getMessageObject()) instanceof Object[] && ((Object[])reply).length >= 3 && ((Object[])reply)[0] instanceof String && ((Object[])reply)[1] instanceof Object[]) {
                Object[] r = (Object[])reply;
                String poolGroupName = (String)r[0];
                this._poolGroupHash.put(poolGroupName, r[1]);
                if (HsmFlushControlManager.this._logEnabled) {
                    _log.info("PoolCollector : " + ((Object[])r[1]).length + " pools arrived for " + poolGroupName);
                }
            } else {
                _log.warn("PoolCollector : invalid reply arrived");
            }
            this.answer();
        }

        public void exceptionArrived(CellMessage request, Exception exception) {
            _log.warn("PoolCollector : exceptionArrived : " + exception);
            this.answer();
        }

        public void answerTimedOut(CellMessage request) {
            _log.warn("PoolCollector : answerTimedOut ");
            this.answer();
        }
    }

    private class HFCPool
    implements HsmFlushControlCore.Pool {
        private String _poolName = null;
        private HashMap flushInfos = new HashMap();
        private PoolCellInfo cellInfo = null;
        private int mode = 0;
        private boolean isActive = false;
        private long lastUpdated = 0L;
        private int answerCount = 0;
        private HsmFlushControlCore.DriverHandle _driverHandle = null;

        private HFCPool(String poolName) {
            this._poolName = poolName;
        }

        @Override
        public void setDriverHandle(HsmFlushControlCore.DriverHandle handle) {
            this._driverHandle = handle;
        }

        @Override
        public String getName() {
            return this._poolName;
        }

        public HsmFlushControlCore.PoolDetails getDetails() {
            HsmFlushControllerPoolDetails details = new HsmFlushControllerPoolDetails();
            details._name = this._poolName;
            details._isActive = this.isActive;
            details._isReadOnly = this.isReadOnly();
            details._cellInfo = this.cellInfo;
            details._flushInfos = new ArrayList();
            for (HFCFlushInfo info : this.flushInfos.values()) {
                details._flushInfos.add(info.getDetails());
            }
            return details;
        }

        @Override
        public HsmFlushControlCore.DriverHandle getDriverHandle() {
            return this._driverHandle;
        }

        @Override
        public boolean isActive() {
            return this.isActive;
        }

        @Override
        public void setReadOnly(boolean rdOnly) {
            HsmFlushControlManager.this.setPoolReadOnly(this._poolName, rdOnly);
        }

        @Override
        public void queryMode() {
            HsmFlushControlManager.this.queryPoolMode(this._poolName);
        }

        @Override
        public boolean isReadOnly() {
            return (this.mode & 0x20) == 0;
        }

        @Override
        public boolean isPoolIoModeKnown() {
            return this.mode != 0;
        }

        @Override
        public Set getStorageClassNames() {
            return new TreeSet(this.flushInfos.keySet());
        }

        @Override
        public List getFlushInfos() {
            return new ArrayList(this.flushInfos.values());
        }

        @Override
        public PoolCellInfo getCellInfo() {
            return this.cellInfo;
        }

        @Override
        public HsmFlushControlCore.FlushInfo getFlushInfoByStorageClass(String storageClass) {
            return (HsmFlushControlCore.FlushInfo)this.flushInfos.get(storageClass);
        }

        public String getPoolModeString() {
            StringBuffer sb = new StringBuffer();
            if (this.mode == 0) {
                return "UU";
            }
            String res = "";
            res = (this.mode & 0x10) == 0 ? "-" : "R";
            res = res + ((this.mode & 0x20) == 0 ? "-" : "W");
            return res;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._poolName).append(";IOMode=").append(this.getPoolModeString());
            sb.append(";A=").append(this.isActive).append(";LU=").append(this.lastUpdated == 0L ? "Never" : "" + (System.currentTimeMillis() - this.lastUpdated) / 1000L);
            return sb.toString();
        }
    }

    public class HFCFlushInfo
    implements HsmFlushControlCore.FlushInfo {
        private StorageClassFlushInfo _flushInfo = null;
        private StorageClassFlushInfo _previousFlushInfo = null;
        private boolean _flushingRequested = false;
        private boolean _flushingPending = false;
        private int _flushingError = 0;
        private Object _flushingErrorObj = null;
        private long _flushingId = 0L;
        private HFCPool _pool = null;
        private String _name = null;

        public HFCFlushInfo(HFCPool pool, StorageClassFlushInfo flush) {
            this._flushInfo = flush;
            this._pool = pool;
            this._name = this._flushInfo.getStorageClass() + "@" + this._flushInfo.getHsm();
        }

        @Override
        public synchronized String getName() {
            return this._name;
        }

        public HsmFlushControlCore.FlushInfoDetails getDetails() {
            HsmFlushControllerFlushInfoDetails details = new HsmFlushControllerFlushInfoDetails();
            details._name = this._name;
            details._isFlushing = this.isFlushing();
            details._flushInfo = this._flushInfo;
            return details;
        }

        private synchronized void updateFlushInfo(StorageClassFlushInfo flush) {
            this._previousFlushInfo = this._flushInfo;
            this._flushInfo = flush;
        }

        @Override
        public synchronized boolean isFlushing() {
            return this._flushingRequested || this._flushingPending;
        }

        @Override
        public synchronized void flush(int count) throws Exception {
            HsmFlushControlManager.this.flushStorageClass(this._pool._poolName, this._name, count);
            this._flushingRequested = true;
            this._flushingPending = false;
            this._flushingError = 0;
        }

        public synchronized void setFlushingAck(long id) {
            this._flushingPending = true;
            this._flushingId = id;
        }

        public synchronized void setFlushingFailed(int errorCode, Object errorObject) {
            this._flushingPending = false;
            this._flushingRequested = false;
            this._flushingId = 0L;
            this._flushingError = errorCode;
            this._flushingErrorObj = errorObject;
        }

        public synchronized void setFlushingDone() {
            this.setFlushingFailed(0, null);
        }

        @Override
        public synchronized StorageClassFlushInfo getStorageClassFlushInfo() {
            return this._flushInfo;
        }
    }

    private class FlushController {
        private List _poolList = null;
        private boolean _control = true;

        private FlushController() {
        }

        private synchronized void updatePoolList(Collection c) {
            this._poolList = new ArrayList(c);
        }

        private synchronized void setControl(boolean control) {
            this._control = control;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendFlushControlMessages(long gainControlInterval) {
            List poolList = null;
            FlushController flushController = this;
            synchronized (flushController) {
                poolList = this._poolList;
            }
            if (poolList == null) {
                return;
            }
            for (String poolName : poolList) {
                PoolFlushGainControlMessage msg = new PoolFlushGainControlMessage(poolName, this._control ? gainControlInterval : 0L);
                try {
                    if (HsmFlushControlManager.this._logEnabled) {
                        _log.info("sendFlushControlMessage : sending PoolFlushGainControlMessage to " + poolName);
                    }
                    HsmFlushControlManager.this.sendMessage(new CellMessage(new CellPath(poolName), (Object)msg));
                }
                catch (NoRouteToCellException ee) {
                    _log.warn("sendFlushControlMessage : couldn't send _poolGroupHash to " + poolName);
                }
            }
        }
    }

    private class QueueWatch
    implements Runnable {
        private long _gainControlTicker = 60000L;
        private long next_getPoolCollection;
        private long next_sendGainControl;
        private long next_timerEvent;

        private QueueWatch() {
        }

        private synchronized void setGainControlTicker(long gainControl) {
            this._gainControlTicker = gainControl;
            this.triggerGainControl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            _log.info("QueueWatch started");
            try {
                _log.info("QueueWatch : waiting awhile before starting");
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {
                _log.warn("QueueWatch: interrupted during initial wait. Stopping");
                return;
            }
            HsmFlushControlManager.this._status = "Running Collector";
            HsmFlushControlManager.this._poolCollector.runCollector(HsmFlushControlManager.this._poolGroupList);
            long now = System.currentTimeMillis();
            this.next_getPoolCollection = now + 0L;
            this.next_sendGainControl = now + this._gainControlTicker;
            this.next_timerEvent = now + HsmFlushControlManager.this._timerInterval;
            while (true) {
                Thread.currentThread();
                if (Thread.interrupted()) break;
                QueueWatch queueWatch = this;
                synchronized (queueWatch) {
                    HsmFlushControlManager.this._status = "Sleeping";
                    try {
                        this.wait(10000L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                    now = System.currentTimeMillis();
                    if (now > this.next_getPoolCollection) {
                        HsmFlushControlManager.this._status = "Running Collector";
                        HsmFlushControlManager.this._poolCollector.runCollector(HsmFlushControlManager.this._poolGroupList);
                        this.next_getPoolCollection = now + HsmFlushControlManager.this._getPoolCollectionTicker;
                    }
                    if (now > this.next_sendGainControl) {
                        HsmFlushControlManager.this._status = "Sending Flush Controls";
                        HsmFlushControlManager.this._flushController.sendFlushControlMessages(2L * this._gainControlTicker);
                        this.next_sendGainControl = now + this._gainControlTicker;
                    }
                    if (now > this.next_timerEvent) {
                        HsmFlushControlManager.this._eventDispatcher.timer();
                        this.next_timerEvent = now + HsmFlushControlManager.this._timerInterval;
                    }
                }
                HsmFlushControlManager.this._nucleus.updateWaitQueue();
            }
            _log.info("QueueWatch stopped");
        }

        public synchronized void triggerGainControl() {
            this.next_sendGainControl = System.currentTimeMillis() - 10L;
            this.notifyAll();
        }

        public synchronized void triggerGetPoolCollection() {
            this.next_getPoolCollection = System.currentTimeMillis() - 10L;
            this.notifyAll();
        }
    }
}

