/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.hsmControl;

import diskCacheV111.hsmControl.HsmControllable;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.OSMStorageInfo;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.hsmControl.HsmControlGetBfDetailsMsg;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.SyncFifo2;
import dmg.util.Args;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsmControlOsm
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(HsmControlOsm.class);
    private CellNucleus _nucleus;
    private Args _args;
    private int _requests = 0;
    private int _failed = 0;
    private int _outstandingRequests = 0;
    private File _database = null;
    private SyncFifo2 _fifo = new SyncFifo2();
    private SimpleDateFormat formatter = new SimpleDateFormat("MM.dd hh:mm:ss");
    private int _maxQueueSize = 100;
    private Map _driverMap = new HashMap();
    public String hh_check_osm = "<store> <bfid>";
    public String hh_define_driver = "<hsm> <driverClass> [<options>]";
    public String hh_ls_driver = "";

    public HsmControlOsm(String name, String args) throws Exception {
        super(name, args, false);
        this._nucleus = this.getNucleus();
        this._args = this.getArgs();
        try {
            if (this._args.argc() < 1) {
                throw new IllegalArgumentException("Usage : ... <database>");
            }
            this._database = new File(this._args.argv(0));
            if (!this._database.isDirectory()) {
                throw new IllegalArgumentException("Not a directory : " + this._database);
            }
        }
        catch (Exception e) {
            this.start();
            this.kill();
            throw e;
        }
        this.useInterpreter(true);
        this._nucleus.newThread((Runnable)this, "queueWatch").start();
        this.start();
        this.export();
    }

    public void getInfo(PrintWriter pw) {
        pw.println("HsmControlOsm : [$Id: HsmControlOsm.java,v 1.4 2005-01-17 16:21:33 patrick Exp $]");
        pw.println("Requests    : " + this._requests);
        pw.println("Failed      : " + this._failed);
        pw.println("Outstanding : " + this._fifo.size());
    }

    public void messageArrived(CellMessage msg) {
        Object obj = msg.getMessageObject();
        ++this._requests;
        String error = "";
        if (!(obj instanceof Message)) {
            error = "Illegal dCache message class : " + obj.getClass().getName();
        } else if (this._fifo.size() > this._maxQueueSize) {
            error = "Queue size exceeded " + this._maxQueueSize + ", Request rejected";
        } else {
            this._fifo.push((Object)msg);
            return;
        }
        ++this._failed;
        _log.warn(error);
        ((Message)obj).setFailed(33, error);
        msg.revertDirection();
        try {
            this.sendMessage(msg);
        }
        catch (Exception ee) {
            _log.warn("Problem replying : " + ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block15: {
            _log.info("Starting working thread");
            block11: while (true) {
                try {
                    while (true) {
                        CellMessage msg;
                        if ((msg = (CellMessage)this._fifo.pop()) == null) {
                            _log.warn("fifo empty");
                            break block15;
                        }
                        Message request = (Message)msg.getMessageObject();
                        try {
                            if (!(request instanceof HsmControlGetBfDetailsMsg)) {
                                throw new IllegalArgumentException("Not supported " + request.getClass().getName());
                            }
                            this.getBfDetails(((HsmControlGetBfDetailsMsg)request).getStorageInfo());
                            request.setSucceeded();
                            msg.revertDirection();
                            try {
                                this.sendMessage(msg);
                            }
                            catch (Exception ee) {
                                _log.warn("Problem replying : " + ee);
                            }
                            continue block11;
                        }
                        catch (Exception eee) {
                            ++this._failed;
                            _log.warn(eee.toString(), (Throwable)eee);
                            request.setFailed(34, eee.toString());
                            msg.revertDirection();
                            try {
                                this.sendMessage(msg);
                                continue block11;
                            }
                            catch (Exception ee) {
                                _log.warn("Problem replying : " + ee);
                                continue;
                            }
                        }
                        break;
                    }
                }
                catch (Exception ee) {
                    _log.warn("Got exception from run while : " + ee);
                    break block15;
                }
            }
            finally {
                _log.info("Working thread finished");
            }
        }
    }

    public String ac_check_osm_$_2(Args args) throws Exception {
        String store = args.argv(0);
        String bfid = args.argv(1);
        OSMStorageInfo si = new OSMStorageInfo(store, "", bfid);
        this.getBfDetails(si);
        String result = si.getKey("hsm.details");
        return result == null ? "No Details" : result;
    }

    public String ac_define_driver_$_2(Args args) throws Exception {
        String hsm = args.argv(0);
        String driver = args.argv(1);
        Class<?> c = Class.forName(driver);
        Class[] classArgs = new Class[]{Args.class, Args.class};
        Object[] objectArgs = new Object[]{this.getArgs(), args, this};
        Constructor<?> con = c.getConstructor(classArgs);
        Object[] values = new Object[3];
        try {
            values[0] = driver;
            values[1] = con.newInstance(objectArgs);
            values[2] = args;
        }
        catch (InvocationTargetException ite) {
            throw (Exception)ite.getTargetException();
        }
        if (!(values[1] instanceof HsmControllable)) {
            throw new IllegalArgumentException("Not a HsmControllable : (" + hsm + ") " + driver);
        }
        this._driverMap.put(hsm, values);
        return hsm + " " + driver + " " + values[1].toString();
    }

    public String ac_ls_driver(Args args) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry e : this._driverMap.entrySet()) {
            String hsm = (String)e.getKey();
            Object[] obj = (Object[])e.getValue();
            sb.append(hsm).append(" ").append(obj[0].toString()).append(" ").append(obj[1].toString()).append("\n");
        }
        return sb.toString();
    }

    private void getBfDetails(StorageInfo storageInfo) throws Exception {
        String hsm = storageInfo.getHsm();
        if (hsm == null || hsm.equals("")) {
            throw new IllegalArgumentException("Hsm not specified");
        }
        Object[] values = (Object[])this._driverMap.get(hsm);
        if (values == null) {
            throw new IllegalArgumentException("Driver not found for hsm=" + hsm);
        }
        HsmControllable hc = (HsmControllable)values[1];
        _log.info("Controller found for " + hsm + " -> " + values[0]);
        hc.getBfDetails(storageInfo);
    }
}

