/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.clients.vsp;

import diskCacheV111.clients.vsp.VspConnection;
import diskCacheV111.clients.vsp.VspDataTransferrable;
import diskCacheV111.clients.vsp.VspIoFinishable;
import diskCacheV111.movers.VspDataOutputStream;
import diskCacheV111.util.VspArgs;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;

public class VspDevice
implements Runnable {
    private final Hashtable _requestHash = new Hashtable();
    private ServerSocket _listen = null;
    private Socket _door = null;
    private BufferedReader _in = null;
    private PrintWriter _out = null;
    private Thread _commandThread = null;
    private Thread _serviceThread = null;
    private boolean _debug = true;
    private String _host = null;
    private int _port = 0;
    private int _sessionId = 1;
    private boolean _online = false;
    private boolean _finished = false;
    private boolean _controlConnectionClosed = false;
    private static final int IDLE = 0;
    private static final int DONE = 1;
    private static final int FAILED = 2;
    private static final int CONNECTED = 4;
    public static final int IOCMD_WRITE = 1;
    public static final int IOCMD_READ = 2;
    public static final int IOCMD_SEEK = 3;
    public static final int IOCMD_CLOSE = 4;
    public static final int IOCMD_INTERRUPT = 5;
    public static final int IOCMD_ACK = 6;
    public static final int IOCMD_FIN = 7;
    public static final int IOCMD_DATA = 8;
    public static final int IOCMD_LOCATE = 9;
    private static final int IOCMD_STATUS = 10;
    private static final int IOCMD_SEEK_AND_READ = 11;
    private static final int IOCMD_SEEK_SET = 0;
    private static final int IOCMD_SEEK_CURRENT = 1;
    private static final int IOCMD_SEEK_END = 2;
    private static final int IO_POSIX = 1;
    private static final int IO_STREAM = 2;

    private synchronized int nextSessionId() {
        return this._sessionId++;
    }

    public void say(String x) {
        if (this._debug) {
            System.out.println(x);
        }
    }

    public void setDebugOutput(boolean debug) {
        this._debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VspDevice(String host, int port, String replyHost) throws UnknownHostException, IOException {
        try {
            this._door = new Socket(host, port);
            this._in = new BufferedReader(new InputStreamReader(this._door.getInputStream()));
            this._out = new PrintWriter(new OutputStreamWriter(this._door.getOutputStream()));
            this._listen = new ServerSocket(0);
            this._host = replyHost;
            this._port = this._listen.getLocalPort();
            this.say("Local : open " + this._host + ":" + this._port);
        }
        catch (IOException e) {
            this._closeAll();
            throw e;
        }
        this._serviceThread = new Thread(this);
        this._serviceThread.start();
        this._commandThread = new Thread(this);
        this._commandThread.start();
        try {
            Hashtable e = this._requestHash;
            synchronized (e) {
                while (!this._online && !this._controlConnectionClosed) {
                    this.say("Create state " + this._online + " " + this._controlConnectionClosed);
                    this._requestHash.wait();
                    this.say("Create state : Woke up");
                }
            }
        }
        catch (InterruptedException ee) {
            // empty catch block
        }
    }

    public void setHostname(String hostname) {
        this._host = hostname;
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this._commandThread) {
            this.commandRun();
        } else if (Thread.currentThread() == this._serviceThread) {
            this.serviceRun();
        }
    }

    private void serviceRun() {
        Socket s = null;
        int sessionId = 0;
        DataInputStream data = null;
        VspRequest request = null;
        while (true) {
            Thread.currentThread();
            if (Thread.interrupted()) break;
            try {
                s = this._listen.accept();
            }
            catch (IOException ioe) {
                this.say("Accept interrupted : " + ioe);
                break;
            }
            this.say("Data connection from : " + s);
            try {
                data = new DataInputStream(s.getInputStream());
                sessionId = data.readInt();
                request = (VspRequest)this._requestHash.get(sessionId);
                if (request == null) {
                    this.say("Unexpected session id from data stream : " + sessionId);
                    continue;
                }
                this.say("Session " + sessionId + " connected");
                request.connectionArrived(data, new DataOutputStream(s.getOutputStream()));
            }
            catch (Exception ie) {
                this.say("Exception for data : " + sessionId + " : " + ie);
                try {
                    s.close();
                }
                catch (Exception xx) {}
            }
        }
        this.say("connection thread terminated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandRun() {
        Hashtable hashtable;
        String line = null;
        VspArgs args = null;
        int sessionId = 0;
        VspRequest request = null;
        this._out.println("0 0 client hello 0 0 0 0");
        this._out.flush();
        while (true) {
            block12: {
                Thread.currentThread();
                if (Thread.interrupted()) break;
                try {
                    line = this._in.readLine();
                    if (line == null) {
                    }
                    break block12;
                }
                catch (IOException ioe) {
                    this.say("commandRun : " + ioe);
                }
                break;
            }
            args = new VspArgs(line);
            sessionId = args.getSessionId();
            this.say("Door : " + (Object)((Object)args));
            if (sessionId == 0) {
                this.masterSession(args);
                continue;
            }
            hashtable = this._requestHash;
            synchronized (hashtable) {
                request = (VspRequest)this._requestHash.get(sessionId);
            }
            if (request == null) {
                this.say("Unexpected session id from command stream : " + sessionId);
                continue;
            }
            request.infoArrived(args);
        }
        hashtable = this._requestHash;
        synchronized (hashtable) {
            this._controlConnectionClosed = true;
            this._requestHash.notifyAll();
        }
        this.say("Command thread terminated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void masterSession(VspArgs args) {
        if (args.getCommand().equals("welcome")) {
            Hashtable hashtable = this._requestHash;
            synchronized (hashtable) {
                this._online = true;
                this.say("Opening master session");
                this._requestHash.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VspConnection open(String pnfsId, String mode) {
        int id = this.nextSessionId();
        VspRequest request = new VspRequest(id, pnfsId, mode);
        Hashtable hashtable = this._requestHash;
        synchronized (hashtable) {
            this._requestHash.put(id, request);
            this._out.println("" + id + " 0 client open " + pnfsId + " " + mode + " " + this._host + " " + this._port);
            this._out.flush();
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Hashtable hashtable = this._requestHash;
        synchronized (hashtable) {
            this._closeAll();
            this._finished = true;
            this._requestHash.notifyAll();
        }
    }

    private void _closeAll() {
        this.say("sending interrupt to command thread");
        this._commandThread.interrupt();
        this.say("sending interrupt to service thread");
        this._serviceThread.interrupt();
        this.say("CloseAll done");
        try {
            if (this._in != null) {
                this._in.close();
            }
        }
        catch (IOException ee) {
            // empty catch block
        }
        if (this._out != null) {
            this._out.close();
        }
        try {
            if (this._door != null) {
                this._door.close();
            }
        }
        catch (IOException ee) {
            // empty catch block
        }
        try {
            if (this._listen != null) {
                this._listen.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.err.println("Usage : ... <host> <port> <replyHost> <pnfsId>");
            System.exit(4);
        }
        String hostname = args[0];
        int port = Integer.parseInt(args[1]);
        String replyHost = args[2];
        String pnfsId = args[3];
        VspDevice vsp2 = new VspDevice(hostname, port, replyHost);
        System.err.println("VspDevice created");
        vsp2.setDebugOutput(true);
        VspConnection c1 = vsp2.open(pnfsId, "r");
        c1.sync();
        c1.setSynchronous(false);
        c1.setIoFinishable(new VspIoFinishable(){

            @Override
            public void ioFinished(VspConnection connection) {
                System.out.println("callback");
            }
        });
        System.out.println("Open synced");
        long start = System.currentTimeMillis();
        long rc = c1.read(0x40000000L, new VspDataTransferrable(){

            @Override
            public void dataArrived(VspConnection vsp2, byte[] buffer, int offset, int size) {
            }

            @Override
            public void dataRequested(VspConnection v, byte[] b, int o, int s) {
            }
        });
        System.out.println("read : " + rc);
        System.out.println("Syncing read");
        c1.sync();
        long diff = System.currentTimeMillis() - start;
        if (diff == 0L) {
            System.out.println("Done : ??? MB/sec");
        } else {
            double rate = (double)c1.getBytesRead() / (double)diff / 1024.0 / 1024.0 * 1000.0;
            System.out.println("Done : " + rate + " MB/sec");
        }
        System.out.println("close");
        c1.close();
        System.err.println("Waiting for sync close");
        c1.sync();
        System.err.println("Sync done");
        vsp2.close();
        System.err.println("Vsp closed");
    }

    private class VspRequest
    implements VspConnection,
    Runnable {
        private int _sessionId = 0;
        private int _state = 0;
        private String _msg = "";
        private final Object _syncLock = new Object();
        private boolean _pending = false;
        private String _pnfsId = null;
        private String _mode = null;
        private byte[] _data = null;
        private int _offset = 0;
        private int _size = 0;
        private long _bytesRead = 0L;
        private int _ioType = 0;
        private long _position = 0L;
        private long _length = 0L;
        private Thread _worker = null;
        private int _ioMode = 2;
        private VspDataTransferrable _transferrable = null;
        private VspDataOutputStream _dataOut = null;
        private DataInputStream _dataIn = null;
        private VspIoFinishable _callBack = null;
        private boolean _writeInThread = false;
        private boolean _isSynchronous = true;
        private String[] _commands = new String[]{"Unkown", "IOCMD_WRITE", "IOCMD_READ", "IOCMD_SEEK", "IOCMD_CLOSE", "IOCMD_INTERRUPT", "IOCMD_ACK", "IOCMD_FIN", "IOCMD_DATA", "IOCMD_LOCATE", "IOCMD_STATUS", "IOCMD_SEEK_AND_READ"};

        public void say(String x) {
            if (VspDevice.this._debug) {
                System.out.println("(" + this._sessionId + ")" + x);
            }
        }

        @Override
        public void setIoFinishable(VspIoFinishable callBack) {
            this._callBack = callBack;
        }

        @Override
        public void setSynchronous(boolean sync) {
            this._isSynchronous = sync;
        }

        @Override
        public void query() throws IOException {
            this.check();
            this._ioType = 9;
            try {
                this._dataOut.writeCmdLocate();
            }
            catch (IOException ee) {
                this.say("Problem in writeCmdLocate : " + ee);
                this.setFailed(ee.toString());
            }
            if (this._isSynchronous) {
                this.sync();
            }
        }

        @Override
        public void seek(long position, int whence) throws IOException {
            this.check();
            this._ioType = 3;
            try {
                this._dataOut.writeCmdSeek(position, whence);
            }
            catch (IOException ee) {
                this.say("Problem in writeCmdSeek : " + ee);
                this.setFailed(ee.toString());
            }
            if (this._isSynchronous) {
                this.sync();
            }
        }

        @Override
        public void write(byte[] data, int offset, int size) throws IOException {
            this.check();
            this._ioType = 1;
            this._data = data;
            this._offset = offset;
            this._size = size;
            try {
                this._dataOut.writeCmdWrite();
            }
            catch (IOException ee) {
                this.say("Problem in doTheWrite : " + ee);
                this.setFailed(ee.toString());
            }
            if (this._isSynchronous) {
                this.sync();
            }
        }

        @Override
        public long read(long size, VspDataTransferrable consumer) throws IOException {
            if (consumer == null) {
                throw new IllegalArgumentException("Consumer must be specified");
            }
            this.check();
            this._transferrable = consumer;
            this._ioType = 2;
            this._ioMode = 2;
            this._data = new byte[65536];
            this._offset = 0;
            this._size = (int)size;
            this._bytesRead = 0L;
            this.say("New read(stream)");
            try {
                this._dataOut.writeCmdRead(size);
            }
            catch (IOException ee) {
                this.say("Problem in doTheRead : " + ee);
                this.setFailed(ee.toString());
            }
            if (this._isSynchronous) {
                this.sync();
                return this._bytesRead;
            }
            return -1L;
        }

        @Override
        public long read(byte[] data, int offset, int size) throws IOException {
            this.check();
            this._ioType = 2;
            this._ioMode = 1;
            this._data = data;
            this._offset = offset;
            this._size = size;
            this._bytesRead = 0L;
            this.say("New read");
            try {
                this._dataOut.writeCmdRead(size);
            }
            catch (IOException ee) {
                this.say("Problem in doTheRead : " + ee);
                this.setFailed(ee.toString());
            }
            if (this._isSynchronous) {
                this.sync();
                return this._bytesRead;
            }
            return -1L;
        }

        @Override
        public long seek_and_read(byte[] data, int offset, long file_offset, int file_whence, int size) throws IOException {
            this.check();
            this._ioType = 11;
            this._ioMode = 1;
            this._data = data;
            this._offset = offset;
            this._size = size;
            this._bytesRead = 0L;
            this.say("New seek and read read");
            try {
                this._dataOut.writeCmdSeekAndRead(file_offset, file_whence, size);
            }
            catch (IOException ee) {
                this.say("Problem in doTheRead : " + ee);
                this.setFailed(ee.toString());
            }
            if (this._isSynchronous) {
                this.sync();
                return this._bytesRead;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sync() throws IOException {
            Object object = this._syncLock;
            synchronized (object) {
                while (this._state == 0 || this._pending) {
                    try {
                        this._syncLock.wait();
                    }
                    catch (InterruptedException ie) {
                        throw new InterruptedIOException("Sync");
                    }
                }
                if (this._state == 4) {
                    return;
                }
                if (this._state == 2) {
                    throw new IOException(this._msg);
                }
                if (this._state == 1) {
                    throw new IOException("Inactive");
                }
            }
        }

        @Override
        public long getPosition() {
            return this._position;
        }

        @Override
        public long getLength() {
            return this._length;
        }

        @Override
        public long getBytesRead() {
            return this._bytesRead;
        }

        private String iocmdToString(int iocmd) {
            if (iocmd <= 0 || iocmd > 9) {
                return "Unkown";
            }
            return this._commands[iocmd];
        }

        private VspRequest(int id, String pnfsId, String rw) {
            this._sessionId = id;
            this._pnfsId = pnfsId;
            this._mode = rw;
        }

        @Override
        public void run() {
            try {
                int chSize = this._dataIn.readInt();
                this.say("Challenge Size is " + chSize);
                this._dataIn.skipBytes(chSize);
                while (!Thread.interrupted()) {
                    int len = 0;
                    try {
                        len = this._dataIn.readInt();
                    }
                    catch (InterruptedIOException iioe) {
                        this.say("connection interrupted");
                        break;
                    }
                    catch (EOFException eofe) {
                        this.say("connection closed");
                        break;
                    }
                    if (len < 4) {
                        throw new Exception("Protocol violation (len)");
                    }
                    int command = this._dataIn.readInt();
                    block4 : switch (command) {
                        case 8: {
                            while (true) {
                                int datalen = this._dataIn.readInt();
                                this.say("data : " + datalen);
                                if (datalen < 0) break block4;
                                if (datalen == 0) continue;
                                this.DATAarrived(datalen, this._dataIn);
                            }
                        }
                        case 6: 
                        case 7: {
                            if (len < 12) {
                                throw new Exception("Protocol violation (len2)");
                            }
                            int iocmd = this._dataIn.readInt();
                            int rc = this._dataIn.readInt();
                            len -= 12;
                            if (rc == 0) {
                                long[] args = new long[len / 8];
                                int i = 0;
                                while (len >= 8) {
                                    args[i] = this._dataIn.readLong();
                                    ++i;
                                    len -= 8;
                                }
                                this.ACK_FINarrived(command, iocmd, args);
                            } else {
                                String str = this._dataIn.readUTF();
                                len -= str.length() + 2;
                                this.setFailed(str);
                            }
                            this._dataIn.skipBytes(len);
                            break;
                        }
                        default: {
                            this.say("Unknown command : " + command);
                            this.say("Arrived : command = " + command + " (len=" + len + ")");
                        }
                    }
                }
            }
            catch (Exception ee) {
                this.say("Run exception : " + ee);
                if (VspDevice.this._debug) {
                    ee.printStackTrace();
                }
                this.setFailed(ee.toString());
            }
            try {
                this._dataIn.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
            try {
                this._dataOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.say("Worker finished");
        }

        private void doTheWriteData() {
            try {
                int out = 0;
                this._dataOut.writeDATA_HEADER();
                do {
                    out = Math.min(4096, this._size);
                    this.say("ACK writeCmdData off=" + this._offset + " out " + out);
                    this._dataOut.writeDATA_BLOCK(this._data, this._offset, out);
                    this._offset += out;
                    this._size -= out;
                } while (this._size > 0);
                this._dataOut.writeDATA_TRAILER();
            }
            catch (IOException ioe) {
                this.setFailed(ioe.toString());
            }
        }

        private void ACK_FINarrived(int command, int iocmd, long[] args) {
            if (command == 6) {
                StringBuffer sb = new StringBuffer();
                sb.append("ack for " + this._commands[iocmd] + " args={");
                for (int i = 0; i < args.length; ++i) {
                    sb.append(args[i] + ",");
                }
                sb.append("}");
                this.say(sb.toString());
                if (iocmd == 1) {
                    if (this._writeInThread) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                VspRequest.this.doTheWriteData();
                            }
                        }).start();
                    } else {
                        this.doTheWriteData();
                    }
                } else if (iocmd == 3) {
                    this.setOk();
                } else if (iocmd == 9) {
                    this._position = args[1];
                    this._length = args[0];
                    this.setOk();
                }
            } else if (command == 7) {
                StringBuffer sb = new StringBuffer();
                sb.append("fin for " + this._commands[iocmd] + " args={");
                for (int i = 0; i < args.length; ++i) {
                    sb.append(args[i] + ",");
                }
                sb.append("}");
                this.say(sb.toString());
                if (iocmd == 1) {
                    this.setOk();
                } else if (iocmd == 2) {
                    this.setOk();
                }
            }
        }

        private void DATAarrived(int len, DataInputStream in) {
            try {
                if (this._ioMode == 2) {
                    this.say("stream data total " + len);
                    int rest = len;
                    while (rest > 0) {
                        int diff = rest > this._data.length ? this._data.length : rest;
                        this.say("stream data p. " + diff);
                        in.readFully(this._data, 0, diff);
                        rest -= diff;
                        this._bytesRead += (long)diff;
                        this._transferrable.dataArrived(this, this._data, 0, diff);
                    }
                } else {
                    this.say("rf " + this._data.length + " " + this._offset + " " + len);
                    in.readFully(this._data, this._offset, len);
                    int rc = len;
                    this._offset += rc;
                    this._size -= rc;
                    this._bytesRead += (long)rc;
                }
            }
            catch (Exception ioe) {
                this.say("erf " + this._data.length + " " + this._offset + " " + len);
                ioe.printStackTrace();
                this.setFailed(ioe.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connectionArrived(DataInputStream in, DataOutputStream out) {
            this.say("Connection arrived for sessionid : " + this._sessionId);
            Object object = this._syncLock;
            synchronized (object) {
                this._state = 4;
                this._pending = false;
                this._dataIn = in;
                this._dataOut = new VspDataOutputStream(out);
                this._worker = new Thread(this);
                this._worker.start();
                this._syncLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void infoArrived(VspArgs args) {
            this.say("Info for " + this._sessionId + " : " + (Object)((Object)args));
            Object object = this._syncLock;
            synchronized (object) {
                if (args.getCommand().equals("failed")) {
                    this.setFailed(args.toString());
                } else {
                    this.setOk();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFailed(String msg) {
            Object object = this._syncLock;
            synchronized (object) {
                this._msg = msg;
                this._pending = false;
                this._state = 2;
                this._syncLock.notifyAll();
                if (this._callBack != null) {
                    this._callBack.ioFinished(this);
                }
                this.say("release (failed)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setOk() {
            Object object = this._syncLock;
            synchronized (object) {
                this._pending = false;
                this._state = 4;
                this._syncLock.notifyAll();
                if (this._callBack != null) {
                    this._callBack.ioFinished(this);
                }
                this.say("release (ok)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void check() throws IOException {
            Object object = this._syncLock;
            synchronized (object) {
                if (VspDevice.this._finished) {
                    throw new IOException("Connection not active");
                }
                if (this._pending) {
                    throw new IOException("IO pending");
                }
                this._pending = true;
            }
        }

        @Override
        public void close() throws IOException {
            this.check();
            this._ioType = 4;
            this._dataOut.writeCmdClose();
        }
    }
}

