/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.cells;

import diskCacheV111.util.HTMLBuilder;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.IoDoorEntry;
import diskCacheV111.vehicles.IoDoorInfo;
import diskCacheV111.vehicles.IoJobInfo;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.services.login.LoginBrokerInfo;
import dmg.cells.services.login.LoginManagerChildrenInfo;
import dmg.util.Args;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferObserverV1
extends CellAdapter
implements Runnable {
    private final Logger _log = LoggerFactory.getLogger(TransferObserverV1.class);
    private final CellNucleus _nucleus;
    private final Args _args;
    private final DoorHandler _doors;
    private final String _loginBroker;
    private long _timeout = 30000L;
    private List<IoEntry> _ioList = null;
    private long _update = 120000L;
    private long _timeUsed = 0L;
    private long _processCounter = 0L;
    private final FieldMap _fieldMap;
    private final Map<String, TableEntry> _tableHash = new HashMap<String, TableEntry>();
    private static String[] __className = new String[]{"cell", "domain", "sequence", "protocol", "owner", "process", "pnfs", "pool", "host", "status", "wait", "state", "submitted", "time", "transferred", "speed", "started"};
    private static String[] __listHeader = new String[]{"Cell", "Domain", "Seq", "Prot", "Owner", "Proc", "PnfsId", "Pool", "Host", "State", "Since", "JobState", "Submitted", "Time", "Trans.&nbsp;(KB)", "Speed&nbsp;(KB/s)", "Started"};
    public String hh_table_help = "";
    public String hh_table_define = "<tableName> <n>[,<m>[,...]] [<tableHeader>]";
    public String hh_table_undefine = "<tableName>";
    public String hh_table_ls = "[<tableName>]";
    public String hh_set_update = "<updateTime/sec>";
    public String hh_go = "[-parallel]";
    public String hh_ls_iolist = "";

    public TransferObserverV1(String name, String args) throws Exception {
        super(name, TransferObserverV1.class.getName(), args, false);
        this._nucleus = this.getNucleus();
        this._args = this.getArgs();
        this._doors = new DoorHandler();
        try {
            if (this._args.argc() < 0) {
                throw new IllegalArgumentException("Usage : ... ");
            }
            String doorList = this._args.getOpt("doors");
            if (doorList != null) {
                for (String s : doorList.split(",")) {
                    this._doors.defineDoor(s);
                }
            }
            String updateString = this._args.getOpt("update");
            try {
                if (updateString != null) {
                    this._update = Long.parseLong(updateString) * 1000L;
                }
            }
            catch (NumberFormatException e) {
                this._log.warn("Illegal value for -update: " + updateString);
            }
            this._loginBroker = this._args.getOpt("loginBroker");
            this._fieldMap = new FieldMap(this._args.getOpt("fieldMap"), this._args);
            this._nucleus.newThread((Runnable)this, "worker").start();
        }
        catch (Exception e) {
            this.start();
            this.kill();
            throw e;
        }
        this.useInterpreter(true);
        this.start();
        this.export();
    }

    public String ac_table_help(Args args) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String header : __listHeader) {
            sb.append(i++).append(" ").append(header).append("\n");
        }
        return sb.toString();
    }

    public synchronized String ac_table_define_$_2_3(Args args) throws NumberFormatException {
        String tableName = args.argv(0);
        String header = args.argc() > 2 ? args.argv(2) : null;
        String[] list = args.argv(1).split(",");
        int[] array = new int[list.length];
        for (int i = 0; i < list.length; ++i) {
            array[i] = Integer.valueOf(list[i]);
        }
        this._tableHash.put(tableName, new TableEntry(tableName, array, header));
        return "";
    }

    public synchronized String ac_table_undefine_$_1(Args args) {
        String tableName = args.argv(0);
        this._tableHash.remove(tableName);
        this._nucleus.getDomainContext().remove(tableName + ".html");
        return "";
    }

    public synchronized String ac_table_ls_$_0_1(Args args) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (args.argc() == 0) {
            for (TableEntry entry : this._tableHash.values()) {
                sb.append(entry.toString()).append("\n");
            }
        } else {
            String tableName = args.argv(0);
            TableEntry entry = this._tableHash.get(tableName);
            if (entry == null) {
                throw new NoSuchElementException("Not found : " + tableName);
            }
            sb.append(entry.toString()).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_set_update_$_1(Args args) {
        long update = Long.parseLong(args.argv(0)) * 1000L;
        if (update < 10000L) {
            throw new IllegalArgumentException("Update time must exceed 10 seconds");
        }
        TransferObserverV1 transferObserverV1 = this;
        synchronized (transferObserverV1) {
            this._update = update;
            this.notifyAll();
        }
        return "Update time set to " + args.argv(0) + " seconds";
    }

    public void getInfo(PrintWriter pw) {
        pw.println("    $Id: TransferObserverV1.java,v 1.18 2007-09-27 15:03:17 behrmann Exp $");
        pw.println("    Update Time : " + this._update / 1000L + " seconds");
        pw.println("        Counter : " + this._processCounter);
        pw.println(" Last Time Used : " + this._timeUsed + " msec's");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                try {
                    ++this._processCounter;
                    long start = System.currentTimeMillis();
                    this.collectDataSequentially();
                    this._timeUsed = System.currentTimeMillis() - start;
                }
                catch (Exception ee) {
                    this._log.warn(ee.toString(), (Throwable)ee);
                }
                TransferObserverV1 ee = this;
                synchronized (ee) {
                    this.wait(this._update);
                }
            }
        }
        catch (InterruptedException e) {
            this._log.info("Data collector interrupted");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_go(Args args) {
        if (args.hasOption("parallel")) {
            this._nucleus.newThread(new Runnable(){

                @Override
                public void run() {
                    TransferObserverV1.this.collectDataSequentially();
                }
            }, "worker").start();
            return "Started";
        }
        TransferObserverV1 transferObserverV1 = this;
        synchronized (transferObserverV1) {
            this.notifyAll();
        }
        return "Process Notified";
    }

    private Object request(String path, Object message) throws Exception {
        CellMessage request = new CellMessage(new CellPath(path), message);
        if ((request = this.sendAndWait(request, this._timeout)) == null) {
            throw new Exception(path + " reply timed out");
        }
        return request.getMessageObject();
    }

    private void getBrokerInfo() {
        if (this._loginBroker != null) {
            ArrayList<LoginBrokerInfo> infoList = new ArrayList<LoginBrokerInfo>();
            for (String loginBroker : this._loginBroker.split(",")) {
                this._log.info("Requesting doorInfo from LoginBroker " + loginBroker);
                try {
                    LoginBrokerInfo[] infos = (LoginBrokerInfo[])this.request(loginBroker, "ls -binary -all");
                    StringBuilder sb = new StringBuilder();
                    sb.append("LoginBroker (" + loginBroker + ") : ");
                    for (LoginBrokerInfo info : infos) {
                        String doorName = info.getCellName() + "@" + info.getDomainName();
                        this._doors.addDoor(doorName);
                        sb.append(doorName).append(",");
                    }
                    this._log.info(sb.toString());
                    infoList.addAll(Arrays.asList(infos));
                }
                catch (Exception e) {
                    this._log.info("Error from sendAndWait : " + e);
                }
            }
            this.updateDoorPage(infoList.toArray(new LoginBrokerInfo[infoList.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectDataSequentially() {
        this._doors.clear();
        this.getBrokerInfo();
        this._log.info("Asking doors for 'doorClientList' (one by one)");
        for (String doorName : this._doors.doors()) {
            this._log.info("Requesting client list from : " + doorName);
            try {
                LoginManagerChildrenInfo info = (LoginManagerChildrenInfo)this.request(doorName, "get children -binary");
                this._log.info(doorName + " reported about " + info.getChildrenCount() + " children");
                this._doors.setDoorInfo(info);
            }
            catch (Exception e) {
                this._doors.undefineDoor(doorName);
                this._log.info("Exception : " + e);
            }
        }
        HashMap<String, IoEntry> ioList = new HashMap<String, IoEntry>();
        HashSet<String> poolHash = new HashSet<String>();
        for (DoorHandler.Entry entry : this._doors.entries()) {
            LoginManagerChildrenInfo info = entry.getChildInfo();
            if (info == null) continue;
            for (String child : info.getChildren()) {
                String childDoor = child + "@" + info.getCellDomainName();
                this._log.info("Requesting client info from : " + childDoor);
                try {
                    IoDoorInfo ioDoorInfo = (IoDoorInfo)this.request(childDoor, "get door info -binary");
                    this._log.info(childDoor + " reply ok");
                    List<IoDoorEntry> ioDoorEntries = ioDoorInfo.getIoDoorEntries();
                    if (ioDoorEntries.size() == 0) continue;
                    for (IoDoorEntry ioDoorEntry : ioDoorEntries) {
                        this._log.info("Adding ioEntry : " + ioDoorEntry);
                        ioList.put(childDoor + "#" + ioDoorEntry.getSerialId(), new IoEntry(ioDoorInfo, ioDoorEntry));
                        String pool = ioDoorEntry.getPool();
                        if (pool == null || pool.length() <= 0 || pool.startsWith("<")) continue;
                        poolHash.add(pool);
                    }
                }
                catch (Exception e) {
                    this._log.info("Exception : " + e);
                }
            }
        }
        this._log.info("Asking pools for io info");
        for (String poolName : poolHash) {
            this._log.info("Asking pool : " + poolName);
            try {
                IoJobInfo[] infos = (IoJobInfo[])this.request(poolName, "mover ls -binary");
                this._log.info(poolName + " reply ok");
                for (IoJobInfo info : infos) {
                    String client = info.getClientName() + "#" + info.getClientId();
                    IoEntry ioEntry = (IoEntry)ioList.get(client);
                    if (ioEntry == null) {
                        this._log.info("No entry found for : " + client);
                        continue;
                    }
                    ioEntry._ioJobInfo = info;
                }
            }
            catch (Exception e) {
                this._log.info("Exception : " + e);
            }
        }
        List<IoEntry> resultList = null;
        TransferObserverV1 transferObserverV1 = this;
        synchronized (transferObserverV1) {
            this._ioList = new ArrayList(new TreeSet(ioList.values()));
            this._nucleus.getDomainContext().put("transfers.list", this._ioList);
            resultList = this._ioList;
        }
        this._nucleus.getDomainContext().put("transfers.html", this.createHtmlTable(resultList));
        this._nucleus.getDomainContext().put("transfers.txt", this.createAsciiTable(resultList));
        this.createDynamicTables(resultList);
    }

    private void updateDoorPage(LoginBrokerInfo[] infos) {
        HTMLBuilder page = new HTMLBuilder(this._nucleus.getDomainContext());
        page.addHeader("/styles/doors.css", "Doors");
        page.beginTable("sortable", "cell", "Cell", "domain", "Domain", "protocol", "Protocol", "version", "Version", "host", "Host", "port", "Port", "load", "Load");
        for (LoginBrokerInfo info : infos) {
            page.beginRow(null, "odd");
            page.td("cell", info.getCellName());
            page.td("domain", info.getDomainName());
            page.td("protocol", info.getProtocolFamily());
            page.td("version", info.getProtocolVersion());
            page.td("host", info.getHost());
            page.td("port", info.getPort());
            page.td("load", (int)(info.getLoad() * 100.0));
            page.endRow();
        }
        page.endTable();
        page.addFooter(this.getClass().getName() + " [$Revision: 1.18 $]");
        page.writeToContext("doors.html");
    }

    private synchronized void createDynamicTables(List<IoEntry> list) {
        for (TableEntry entry : this._tableHash.values()) {
            String tableName = entry.getName();
            int[] array = entry.getFields();
            this._nucleus.getDomainContext().put(tableName + ".html", this.createDynamicTable(list, array));
        }
    }

    private String createDynamicTable(List<IoEntry> ioList, int[] fields) {
        HTMLBuilder page = new HTMLBuilder(this._nucleus.getDomainContext());
        page.addHeader("/styles/transfers.css", "Active Transfers");
        page.beginTable("sortable", new String[0]);
        page.beginTHead();
        for (int field : fields) {
            page.th(__className[field], __listHeader[field]);
        }
        page.endTHead();
        for (IoEntry entry : ioList) {
            List<String> values = this.createFieldList(entry);
            for (int field : fields) {
                if (field >= values.size()) {
                    page.td(__className[field], "");
                    continue;
                }
                page.td(__className[field], values.get(field));
            }
        }
        page.endTable();
        page.addFooter(this.getClass().getName() + " [$Revision: 1.18 $]");
        return page.toString();
    }

    public synchronized String ac_ls_iolist(Args args) {
        if (this._ioList == null) {
            return "";
        }
        return this.createAsciiTable(this._ioList);
    }

    private String createAsciiTable(List<IoEntry> ioList) {
        long now = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        for (IoEntry io : ioList) {
            sb.append(io._ioDoorInfo.getCellName()).append(" ").append(io._ioDoorInfo.getDomainName()).append(" ");
            sb.append(io._ioDoorEntry.getSerialId()).append(" ");
            sb.append(io._ioDoorInfo.getProtocolFamily()).append("-").append(io._ioDoorInfo.getProtocolVersion()).append(" ");
            sb.append(io._ioDoorInfo.getOwner()).append(" ").append(io._ioDoorInfo.getProcess()).append(" ");
            sb.append(io._ioDoorEntry.getPnfsId()).append(" ").append(io._ioDoorEntry.getPool()).append(" ").append(io._ioDoorEntry.getReplyHost()).append(" ").append(io._ioDoorEntry.getStatus()).append(" ").append(now - io._ioDoorEntry.getWaitingSince()).append(" ");
            if (io._ioJobInfo == null) {
                sb.append("No-Mover-Found");
            } else {
                sb.append(io._ioJobInfo.getStatus()).append(" ");
                if (io._ioJobInfo.getStartTime() > 0L) {
                    long transferTime = io._ioJobInfo.getTransferTime();
                    long bytesTransferred = io._ioJobInfo.getBytesTransferred();
                    sb.append(transferTime).append(" ").append(bytesTransferred).append(" ").append(transferTime > 0L ? (double)bytesTransferred / (double)transferTime : 0.0).append(" ");
                    sb.append(now - io._ioJobInfo.getStartTime()).append(" ");
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private List<String> createFieldList(IoEntry io) {
        long now = System.currentTimeMillis();
        ArrayList<String> out = new ArrayList<String>(20);
        PnfsId pnfsid = io._ioDoorEntry.getPnfsId();
        String status = io._ioDoorEntry.getStatus();
        out.add(io._ioDoorInfo.getCellName());
        out.add(io._ioDoorInfo.getDomainName());
        out.add(String.valueOf(io._ioDoorEntry.getSerialId()));
        out.add(io._ioDoorInfo.getProtocolFamily() + "-" + io._ioDoorInfo.getProtocolVersion());
        out.add(this._fieldMap.mapOwner(io._ioDoorInfo.getOwner()));
        out.add(io._ioDoorInfo.getProcess());
        out.add(pnfsid == null ? "" : pnfsid.toString());
        out.add(io._ioDoorEntry.getPool());
        out.add(io._ioDoorEntry.getReplyHost());
        out.add(status == null ? "" : status.replace(" ", "&nbsp;"));
        out.add(this.getTimeString(now - io._ioDoorEntry.getWaitingSince()));
        if (io._ioJobInfo != null) {
            out.add(io._ioJobInfo.getStatus());
            out.add(this.getTimeString(now - io._ioJobInfo.getSubmitTime()));
            if (io._ioJobInfo.getStartTime() > 0L) {
                long transferTime = io._ioJobInfo.getTransferTime();
                long bytesTransferred = io._ioJobInfo.getBytesTransferred();
                out.add(this.getTimeString(transferTime));
                out.add(Long.toString(bytesTransferred / 1024L));
                out.add(transferTime > 0L ? String.valueOf(1000L * bytesTransferred / (1024L * transferTime)) : "-");
                out.add(this.getTimeString(now - io._ioJobInfo.getStartTime()));
            }
        }
        return out;
    }

    private String getTimeString(long msec) {
        int sec = (int)(msec / 1000L);
        int min = sec / 60;
        int hour = min / 60;
        int day = hour / 24;
        String sS = Integer.toString(sec %= 60);
        String mS = Integer.toString(min %= 60);
        String hS = Integer.toString(hour %= 24);
        StringBuilder sb = new StringBuilder();
        if (day > 0) {
            sb.append(day).append(" d ");
        }
        sb.append(hS.length() < 2 ? "0" + hS : hS).append(":");
        sb.append(mS.length() < 2 ? "0" + mS : mS).append(":");
        sb.append(sS.length() < 2 ? "0" + sS : sS);
        return sb.toString();
    }

    private void createHtmlTableRow(HTMLBuilder page, IoEntry io) {
        long now = System.currentTimeMillis();
        page.beginRow(null, "odd");
        page.td("door", io._ioDoorInfo.getCellName());
        page.td("domain", io._ioDoorInfo.getDomainName());
        page.td("sequence", io._ioDoorEntry.getSerialId());
        page.td("protocol", io._ioDoorInfo.getProtocolFamily() + "-" + io._ioDoorInfo.getProtocolVersion());
        String tmp = io._ioDoorInfo.getOwner();
        tmp = tmp.indexOf("known") > -1 ? "?" : this._fieldMap.mapOwner(tmp);
        page.td("owner", tmp);
        tmp = io._ioDoorInfo.getProcess();
        tmp = tmp.indexOf("known") > -1 ? "?" : tmp;
        page.td("process", tmp);
        String poolName = io._ioDoorEntry.getPool();
        if (poolName == null || poolName.equals("<unknown>")) {
            poolName = "N.N.";
        }
        page.td("pnfs", io._ioDoorEntry.getPnfsId());
        page.td("pool", poolName);
        page.td("host", io._ioDoorEntry.getReplyHost());
        String status = io._ioDoorEntry.getStatus();
        page.td("status", status != null ? status.replace(" ", "&nbsp;") : "");
        page.td("wait", this.getTimeString(now - io._ioDoorEntry.getWaitingSince()));
        if (io._ioJobInfo == null) {
            if (poolName.equals("N.N.")) {
                page.td(3, "staging", "Staging");
            } else {
                page.td(3, "missing", "No Mover found");
            }
        } else {
            page.td("state", io._ioJobInfo.getStatus());
            if (io._ioJobInfo.getStartTime() > 0L) {
                long transferTime = io._ioJobInfo.getTransferTime();
                long bytesTransferred = io._ioJobInfo.getBytesTransferred();
                page.td("transferred", bytesTransferred / 1024L);
                page.td("speed", transferTime > 0L ? Long.valueOf(1000L * bytesTransferred / (1024L * transferTime)) : "-");
            } else {
                page.td("transferred", "-");
                page.td("speed", "-");
            }
        }
        page.endRow();
    }

    public String createHtmlTable(List<IoEntry> ioList) {
        HTMLBuilder page = new HTMLBuilder(this._nucleus.getDomainContext());
        page.addHeader("/styles/transfers.css", "Active Transfers");
        page.beginTable("sortable", "door", "Door", "domain", "Domain", "sequence", "Seq", "protocol", "Prot", "owner", "Owner", "process", "Proc", "pnfs", "PnfsId", "pool", "Pool", "host", "Host", "status", "Status", "wait", "Since", "state", "S", "transferred", "Trans.&nbsp;(KB)", "speed", "Speed&nbsp;(KB/s)");
        for (IoEntry io : ioList) {
            this.createHtmlTableRow(page, io);
        }
        page.endTable();
        page.addFooter(this.getClass().getName() + " [$Revision: 1.18 $]");
        return page.toString();
    }

    public String createErrorHtmlTable(List<IoEntry> ioList) {
        HTMLBuilder page = new HTMLBuilder(this._nucleus.getDomainContext());
        page.addHeader("/styles/transfers.css", "Active Transfers");
        page.beginTable("sortable", "door", "Door", "domain", "Domain", "sequence", "Seq", "protocol", "Prot", "owner", "Owner", "process", "Proc", "pnfs", "PnfsId", "pool", "Pool", "host", "Host", "status", "Status", "wait", "Since", "state", "S", "transferred", "Trans.&nbsp;(KB)", "speed", "Speed&nbsp;(KB/s)");
        for (IoEntry io : ioList) {
            if (io._ioJobInfo != null) continue;
            this.createHtmlTableRow(page, io);
        }
        page.endTable();
        page.addFooter(this.getClass().getName() + " [$Revision: 1.18 $]");
        return page.toString();
    }

    private static class IoEntry
    implements Comparable<IoEntry> {
        private final IoDoorInfo _ioDoorInfo;
        private final IoDoorEntry _ioDoorEntry;
        private IoJobInfo _ioJobInfo = null;

        private IoEntry(IoDoorInfo info, IoDoorEntry entry) {
            this._ioDoorInfo = info;
            this._ioDoorEntry = entry;
        }

        @Override
        public int compareTo(IoEntry other) {
            int tmp = this._ioDoorInfo.getDomainName().compareTo(other._ioDoorInfo.getDomainName());
            if (tmp != 0) {
                return tmp;
            }
            tmp = this._ioDoorInfo.getCellName().compareTo(other._ioDoorInfo.getCellName());
            if (tmp != 0) {
                return tmp;
            }
            return Long.valueOf(this._ioDoorEntry.getSerialId()).compareTo(other._ioDoorEntry.getSerialId());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IoEntry)) {
                return false;
            }
            IoEntry other = (IoEntry)obj;
            return this._ioDoorInfo.getDomainName().equals(other._ioDoorInfo.getDomainName()) && this._ioDoorInfo.getCellName().equals(other._ioDoorInfo.getCellName()) && this._ioDoorEntry.getSerialId() == other._ioDoorEntry.getSerialId();
        }

        public int hashCode() {
            return 17;
        }
    }

    private static class TableEntry {
        private String _tableName = null;
        private int[] _fields = null;
        private String _title = null;
        private long _olderThan = 0L;
        private boolean _ifNotYetStarted = false;
        private boolean _ifMoverMissing = false;

        private TableEntry(String tableName, int[] fields) {
            this._tableName = tableName;
            this._fields = fields;
        }

        private TableEntry(String tableName, int[] fields, String title) {
            this._tableName = tableName;
            this._fields = fields;
            this._title = title;
        }

        private int[] getFields() {
            return this._fields;
        }

        private String getName() {
            return this._tableName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._tableName).append(" = ");
            if (this._fields.length > 0) {
                for (int i = 0; i < this._fields.length - 1; ++i) {
                    sb.append(this._fields[i]).append(",");
                }
                sb.append(this._fields[this._fields.length - 1]);
            }
            if (this._title != null) {
                sb.append("  \"").append(this._title).append("\"");
            }
            return sb.toString();
        }

        private boolean ifNotYetStarted() {
            return this._ifNotYetStarted;
        }

        private boolean ifMoverMissing() {
            return this._ifMoverMissing;
        }

        private long getOlderThan() {
            return this._olderThan;
        }
    }

    private static class DoorHandler {
        private final Map<String, Entry> _doors = new HashMap<String, Entry>();

        private DoorHandler() {
        }

        private synchronized Entry defineDoor(String doorName) {
            Entry entry = this._doors.get(doorName);
            if (entry == null) {
                entry = new Entry(doorName, true);
                this._doors.put(doorName, entry);
            }
            return entry;
        }

        private Set<String> doors() {
            return this._doors.keySet();
        }

        private Collection<Entry> entries() {
            return this._doors.values();
        }

        private synchronized Entry undefineDoor(String doorName) {
            Entry entry = this._doors.get(doorName);
            if (entry != null) {
                entry.setFixed(false);
            }
            return entry;
        }

        private synchronized Entry addDoor(String doorName) {
            Entry entry = this._doors.get(doorName);
            if (entry == null) {
                entry = new Entry(doorName, false);
                this._doors.put(doorName, entry);
            }
            return entry;
        }

        private synchronized Entry setDoorInfo(LoginManagerChildrenInfo info) {
            String doorName = info.getCellName() + "@" + info.getCellDomainName();
            Entry entry = this._doors.get(doorName);
            if (entry == null) {
                entry = new Entry(doorName);
                this._doors.put(doorName, entry);
            }
            entry.setChildInfo(info);
            return entry;
        }

        private synchronized void clear() {
            Iterator<Map.Entry<String, Entry>> i = this._doors.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Entry> e = i.next();
                Entry entry = e.getValue();
                if (entry.isFixed()) {
                    entry.setChildInfo(null);
                    continue;
                }
                i.remove();
            }
        }

        private static class Entry {
            private boolean _isFixed = false;
            private String _doorName = null;
            private LoginManagerChildrenInfo _info = null;

            private Entry(String doorName) {
                this(doorName, false);
            }

            private Entry(String doorName, boolean isFixed) {
                this._isFixed = isFixed;
                this._doorName = doorName;
            }

            private LoginManagerChildrenInfo getChildInfo() {
                return this._info;
            }

            private void setChildInfo(LoginManagerChildrenInfo info) {
                this._info = info;
            }

            private boolean isFixed() {
                return this._isFixed;
            }

            private void setFixed(boolean fixed) {
                this._isFixed = fixed;
            }
        }
    }

    private class FieldMap {
        private final Class<?>[] _conArgsClass = new Class[]{Args.class};
        private Class<?> _mapClass = null;
        private Constructor<?> _constructor = null;
        private Object _master = null;
        private Method _mapOwner = null;

        private FieldMap(String className, Args args) {
            if (className == null) {
                TransferObserverV1.this._log.info("FieldMap : 'fieldMap' not defined");
                return;
            }
            Object[] conArgs = new Object[]{args};
            Class[] classArgs = new Class[]{String.class};
            try {
                this._mapClass = Class.forName(className);
                this._constructor = this._mapClass.getConstructor(this._conArgsClass);
                this._master = this._constructor.newInstance(conArgs);
                this._mapOwner = this._mapClass.getMethod("mapOwner", classArgs);
                TransferObserverV1.this.addCommandListener(this._master);
                TransferObserverV1.this._log.info("FieldMap : " + this._mapClass.getName() + " loaded");
            }
            catch (Exception ee) {
                TransferObserverV1.this._log.warn("FieldMap : Creating map class Failed : " + ee);
            }
        }

        private String mapOwner(String owner) {
            Object[] args = new Object[]{owner};
            if (this._mapOwner == null) {
                return owner;
            }
            try {
                return (String)this._mapOwner.invoke(this._master, args);
            }
            catch (Exception ee) {
                TransferObserverV1.this._log.warn("Problem invoking 'mapOwner' : " + ee);
                return owner;
            }
        }
    }
}

