/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.cells;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.GenericStorageInfo;
import diskCacheV111.vehicles.PoolFetchFileMessage;
import diskCacheV111.vehicles.PoolManagerGetReadPoolMessage;
import diskCacheV111.vehicles.PoolManagerGetWritePoolMessage;
import diskCacheV111.vehicles.PoolManagerMessage;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.util.Args;
import dmg.util.CommandSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugCommander
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(DebugCommander.class);
    private final CellNucleus _nucleus = this.getNucleus();
    private final Args _args = this.getArgs();
    public String hh_send_fetch = "<hsm> <pool> <pnfsId> [-path=<poolPath>]";
    public String hh_send_getpool = "[-dest=<destCell>] read|write <storageGroup> <pnfsId>";

    public DebugCommander(String name, String args) {
        super(name, args, true);
    }

    public void messageArrived(CellMessage msg) {
        Object obj = msg.getMessageObject();
        _log.info("DBC : From     : " + msg.getSourcePath());
        _log.info("DBC : Class    : " + obj.getClass().getName());
        _log.info("DBC : toString : " + obj.toString());
    }

    public String ac_send_fetch_$_3(Args args) throws Exception {
        CellPath path = null;
        String hsmName = args.argv(0);
        String poolName = args.argv(1);
        String poolPath = args.getOpt("path");
        path = poolPath == null ? new CellPath(poolName) : new CellPath(poolPath);
        String pnfsid = PnfsId.toCompleteId(args.argv(1));
        this._nucleus.sendMessage(new CellMessage(path, (Object)new PoolFetchFileMessage(poolName, (StorageInfo)new GenericStorageInfo(hsmName, "any"), pnfsid)));
        return "Stay tuned";
    }

    public String ac_send_getpool_$_3(Args args) throws Exception {
        String dest = args.getOpt("dest");
        dest = dest == null ? "PoolManager" : dest;
        String dir = args.argv(0);
        PoolManagerMessage pm = null;
        if (dir.equals("read")) {
            pm = new PoolManagerGetReadPoolMessage(args.argv(1), args.argv(2));
        } else if (dir.equals("write")) {
            pm = new PoolManagerGetWritePoolMessage(args.argv(1), args.argv(2));
        } else {
            throw new CommandSyntaxException("read or write");
        }
        this._nucleus.sendMessage(new CellMessage(new CellPath(dest), (Object)pm));
        return "Done";
    }
}

