/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.admin;

import diskCacheV111.admin.HelpCompletor;
import diskCacheV111.pools.PoolV2Mode;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.SpreadAndWait;
import diskCacheV111.vehicles.DCapProtocolInfo;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PnfsFlagMessage;
import diskCacheV111.vehicles.PnfsGetCacheLocationsMessage;
import diskCacheV111.vehicles.PnfsMapPathMessage;
import diskCacheV111.vehicles.Pool2PoolTransferMsg;
import diskCacheV111.vehicles.PoolLinkInfo;
import diskCacheV111.vehicles.PoolMgrGetPoolByLink;
import diskCacheV111.vehicles.PoolMgrGetPoolLinks;
import diskCacheV111.vehicles.PoolMgrReplicateFileMsg;
import diskCacheV111.vehicles.PoolModifyModeMessage;
import diskCacheV111.vehicles.PoolModifyPersistencyMessage;
import diskCacheV111.vehicles.PoolRemoveFilesMessage;
import diskCacheV111.vehicles.PoolSetStickyMessage;
import diskCacheV111.vehicles.QuotaMgrCheckQuotaMessage;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.SerializationException;
import dmg.util.AclException;
import dmg.util.Args;
import dmg.util.AuthorizedString;
import dmg.util.CommandException;
import dmg.util.CommandExitException;
import dmg.util.CommandInterpreter;
import dmg.util.CommandPanicException;
import dmg.util.CommandSyntaxException;
import dmg.util.CommandThrowableException;
import dmg.util.RequestTimeOutException;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jline.Completor;
import org.dcache.namespace.FileAttribute;
import org.dcache.util.CacheExceptionFactory;
import org.dcache.vehicles.FileAttributes;
import org.dcache.vehicles.PnfsGetFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAdminShell
extends CommandInterpreter
implements Completor {
    private static final Logger _log = LoggerFactory.getLogger(UserAdminShell.class);
    private static final String ADMIN_COMMAND_NOOP = "xyzzy";
    private static final int CD_PROBE_MESSAGE_TIMEOUT_MS = 1000;
    private final CellEndpoint cellEndPoint;
    private String _user = null;
    private String _authUser = null;
    private final CellPath _path = new CellPath("acm");
    private long _timeout = 10000L;
    private boolean _fullException = false;
    private final String _instance;
    private Position _currentPosition = new Position();
    private final boolean _debug = false;
    private Completor _completor;
    public String hh_su = "<userName>";
    public String hh_set_exception = "message|detail";
    public String hh_set_timeout = "<timeout/sec> # command timeout in seconds";
    public String hh_getpoolbylink = "<linkName> [-size=<filesize>] [-service=<serviceCellName]";
    public String hh_quota_query = "<storageClassName>|* [-l] [-service=<serviceCellName>]";
    public String hh_set_sticky = "<pnfsId>|<globalPath> [-target=<target>] [-silent]";
    public String hh_set_unsticky = "<pnfsId>|<globalPath> [-target=<target>] [-silent]";
    public String hh_uncache = "<pnfsId>|<globalPath> [-target=<target>] [-silent]";
    public String fh_repinfoof = "repinfoof <pnfsId> | <globalPath> # lists info the status of a file by pnfsid or by path.\nThe information includes pools on which the file has been stored (info provided by \"cacheinfoof\" in the PnfsManager cell)\nand the repository info of the file (info provided by \"rep ls\" in the pool cell).\n";
    public String hh_repinfoof = "<pnfsId> | <globalPath>";
    public String hh_flags_set = "<pnfsId>|<globalPath> <key> <value>";
    public String hh_flags_remove = "<pnfsId> <key>";
    public String hh_p2p = "<pnfsId> [<sourcePool> <destinationPool>] [-ip=<address]";
    public String ac_modify_poolmode = " a) modify poolmode enable <poolname>[,<poolname>...]\n b) modify poolmode [OPTIONS] disable <poolname>[,<poolname>...] [<code> [<message>]]\n      OPTIONS :\n        -fetch    #  disallows fetch (transfer to client)\n        -stage    #  disallows staging (from HSM)\n        -store    #  disallows store (transfer from client)\n        -p2p-client\n        -rdonly   #  := store,stage,p2p-client\n        -strict   #  := disallows everything\n";
    public String hh_modify_poolmode = "enable|disable <poolname>[,<poolname>...] [<code> [<message>]] [-strict|-stage|-rdonly|-fetch|-store]";
    public String hh_set_deletable = "<pnfsId> # DEBUG for advisory delete (srm)";
    public String hh_flags_ls = "<pnfsId> <key>";
    public String hh_pnfs_map = "<globalPath>";
    public String fh_cd = "  SYNTAX I :\n     cd <cellPath>\n          <cellPath> : <cellName>[@<domainName>]\n     The cd command will send all subsequent commands to the specified cell.\n     Use '..' to get back to local mode\n  SYNTAX II : \n     cd <cellDirectoryPath>\n           <cellDirecotryPath> : /<domainName>[/<cellName>[/<moduleName[...]]]     The cd command will send all subsequent commands to the specified cell resp. module.\n     Use the standard unix directory syntax to navigate though the cell/domain realm.\n     Simple '..' will bring you back to 'SYNTAX I'\n       Special paths :             /*/<cellName>     : use the * directory for wellknown cells.\n            /local            : use the local directory for the local domain\n            /<domain>         : if no cell is given, the system cell is selected\n                                except for the /* director where the topo cell is\n                                chosen, if available\n\n";
    public String hh_cd = "<cellPath> | <cellDirectoryPath> # see 'help cd'";

    public UserAdminShell(String user, CellEndpoint cellEndpoint, Args args) {
        this.cellEndPoint = cellEndpoint;
        this._user = user;
        this._authUser = user;
        String prompt = args.getOpt("dCacheInstance");
        if (prompt == null || !prompt.equals("hide")) {
            if (prompt == null || prompt.length() == 0) {
                try {
                    prompt = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException ee) {
                    prompt = null;
                }
            }
            this._instance = prompt;
        } else {
            this._instance = null;
        }
    }

    public UserAdminShell(String user, final CellNucleus nucleus, final Args args) {
        this(user, new CellEndpoint(){
            private static final long RETRY_PERIOD = 30000L;

            public void sendMessage(CellMessage envelope) throws SerializationException, NoRouteToCellException {
                nucleus.sendMessage(envelope);
            }

            public void sendMessage(CellMessage envelope, CellMessageAnswerable callback, long timeout) throws SerializationException {
                nucleus.sendMessage(envelope, true, true, callback, timeout);
            }

            public CellMessage sendAndWait(CellMessage envelope, long timeout) throws SerializationException, NoRouteToCellException, InterruptedException {
                return nucleus.sendAndWait(envelope, true, true, timeout);
            }

            private long timeUntil(long time) {
                return time - System.currentTimeMillis();
            }

            public CellMessage sendAndWaitToPermanent(CellMessage envelope, long timeout) throws SerializationException, InterruptedException {
                long deadline = System.currentTimeMillis() + timeout;
                while (true) {
                    try {
                        return this.sendAndWait(envelope, this.timeUntil(deadline));
                    }
                    catch (NoRouteToCellException e) {
                        Thread.sleep(Math.min(this.timeUntil(deadline), 30000L));
                        continue;
                    }
                    break;
                }
            }

            public CellInfo getCellInfo() {
                return nucleus.getCellInfo();
            }

            public Map<String, Object> getDomainContext() {
                return nucleus.getDomainContext();
            }

            public Args getArgs() {
                return args;
            }
        }, args);
    }

    protected String getUser() {
        return this._user;
    }

    public void checkPermission(String aclName) throws AclException {
        Object[] request = new Object[]{"request", "<nobody>", "check-permission", this.getUser(), aclName};
        CellMessage reply = null;
        try {
            reply = this.cellEndPoint.sendAndWait(new CellMessage(this._path, (Object)request), this._timeout);
            if (reply == null) {
                throw new AclException("Request timed out (" + this._path + ")");
            }
        }
        catch (Exception ee) {
            throw new AclException("Problem : " + ee.getMessage());
        }
        Object r = reply.getMessageObject();
        if (r == null || !(r instanceof Object[]) || ((Object[])r).length < 6 || !(((Object[])r)[5] instanceof Boolean)) {
            throw new AclException("Protocol violation 4456");
        }
        if (!((Boolean)((Object[])r)[5]).booleanValue()) {
            throw new AclException(this.getUser(), aclName);
        }
    }

    public String getHello() {
        return "\n    dCache Admin (VII) (user=" + this.getUser() + ")\n\n";
    }

    public String getPrompt() {
        if (this._currentPosition.hyperMode) {
            StringBuffer sb = new StringBuffer();
            sb.append("(").append(this.getUser()).append(") ");
            sb.append(this._instance == null ? "/" : "/" + this._instance);
            Iterator it = this._currentPosition.hyperPath.iterator();
            while (it.hasNext()) {
                sb.append("/").append(it.next().toString());
            }
            sb.append(" > ");
            return sb.toString();
        }
        return (this._instance == null ? "" : "[" + this._instance + "] ") + (this._currentPosition.remote == null ? "(local) " : "(" + this._currentPosition.remoteName + ") ") + this.getUser() + " > ";
    }

    public Object ac_logoff(Args args) throws CommandException {
        throw new CommandExitException("Done", 0);
    }

    public String ac_su_$_1(Args args) throws Exception {
        String user = args.argv(0);
        if (user.equals(this._authUser)) {
            this._user = this._authUser;
            return "User changed BACK to " + this._user;
        }
        if (user.equals(this._user)) {
            return "User not changed, still " + this._user;
        }
        try {
            this.checkPermission("system.*.newuser");
        }
        catch (AclException acle) {
            this.checkPermission("system." + user + ".newuser");
        }
        this._user = user;
        return "User changed to " + this._user;
    }

    public String ac_set_exception_$_0_1(Args args) throws CommandException {
        if (args.argc() > 0) {
            if (args.argv(0).equals("message")) {
                this._fullException = false;
            } else if (args.argv(0).equals("detail")) {
                this._fullException = true;
            } else {
                throw new CommandSyntaxException("set exception message|detail");
            }
        }
        return "Exception = " + (this._fullException ? "detail" : "message");
    }

    public String ac_set_timeout_$_0_1(Args args) {
        if (args.argc() > 0) {
            long timeout = (long)Integer.parseInt(args.argv(0)) * 1000L;
            if (timeout < 1000L) {
                throw new IllegalArgumentException("<timeout> >= 1");
            }
            this._timeout = timeout;
        }
        return "Timeout = " + this._timeout / 1000L;
    }

    public String ac_getpoolbylink_$_1(Args args) throws Exception {
        Object result;
        String linkName = args.argv(0);
        String service = args.getOpt("service");
        String sizeString = args.getOpt("size");
        PoolMgrGetPoolByLink msg = new PoolMgrGetPoolByLink(linkName);
        if (sizeString != null) {
            msg.setFilesize(Long.parseLong(sizeString));
        }
        if ((result = this.sendObject(service = service == null ? "PoolManager" : service, (Object)msg)) == null) {
            throw new Exception("QuotaRequest timed out");
        }
        if (result instanceof PoolMgrGetPoolByLink) {
            PoolMgrGetPoolByLink link = (PoolMgrGetPoolByLink)result;
            int rc = link.getReturnCode();
            if (rc != 0) {
                return "Problem " + rc + " <" + link.getErrorObject() + "> reported for link " + linkName;
            }
            return "Pool <" + link.getPoolName() + "> selected for link " + linkName;
        }
        return "Unexpected class " + result.getClass().getName() + " arrived with message " + result.toString();
    }

    public Object ac_quota_query_$_1(Args args) throws Exception {
        String storageClassName = args.argv(0);
        String service = args.getOpt("service");
        service = service == null ? "QuotaManager" : service;
        boolean extended = args.hasOption("l");
        Message msg = null;
        msg = storageClassName.equals("*") ? new PoolMgrGetPoolLinks() : new QuotaMgrCheckQuotaMessage(storageClassName);
        Object result = this.sendObject(service, (Object)msg);
        if (result == null) {
            throw new Exception("QuotaRequest timed out");
        }
        if (result instanceof QuotaMgrCheckQuotaMessage) {
            return result.toString();
        }
        if (result instanceof PoolMgrGetPoolLinks) {
            if (extended) {
                PoolMgrGetPoolLinks info = (PoolMgrGetPoolLinks)result;
                PoolLinkInfo[] links = info.getPoolLinkInfos();
                StringBuffer sb = new StringBuffer();
                if (links == null) {
                    return "Object doesn't contain a Links list";
                }
                for (PoolLinkInfo l : links) {
                    sb.append(" Link ").append(l.getName()).append(" : ").append(l.getAvailableSpaceInBytes()).append("\n");
                    String[] storageGroups = l.getStorageGroups();
                    if (storageGroups == null) continue;
                    for (int sg = 0; sg < storageGroups.length; ++sg) {
                        sb.append("    ").append(storageGroups[sg]).append("\n");
                    }
                }
                return sb.toString();
            }
            return result.toString();
        }
        return "Unexpected class " + result.getClass().getName() + " arrived with message " + result.toString();
    }

    public Object ac_set_sticky_$_1(Args args) throws Exception {
        return this.setSticky(args.argv(0), args.getOpt("target"), true, !args.hasOption("silent") ? new StringBuffer() : null);
    }

    public Object ac_set_unsticky_$_1(Args args) throws Exception {
        return this.setSticky(args.argv(0), args.getOpt("target"), false, !args.hasOption("silent") ? new StringBuffer() : null);
    }

    public Object ac_uncache_$_1(Args args) throws Exception {
        try {
            return this.uncache(args.argv(0), args.getOpt("target"), !args.hasOption("silent") ? new StringBuffer() : null);
        }
        catch (Exception ee) {
            ee.printStackTrace();
            throw ee;
        }
    }

    public String ac_repinfoof_$_1(Args args) throws CacheException, FileNotFoundException, SerializationException, NoRouteToCellException, InterruptedException, RequestTimeOutException {
        StringBuffer sb = new StringBuffer();
        String fileIdentifier = args.argv(0);
        FileAttributes fileAttributes = this.getFileLocations(fileIdentifier);
        PnfsId pnfsId = fileAttributes.getPnfsId();
        if (fileAttributes.getLocations().isEmpty()) {
            return "No file locations found";
        }
        List<CellMessage> replies = this.askPoolsForRepLs(fileAttributes, pnfsId);
        for (CellMessage reply : replies) {
            String replyFromPool = reply.getSourcePath().getCellName();
            sb.append(replyFromPool).append(" : ");
            sb.append(reply.getMessageObject().toString());
        }
        return sb.toString();
    }

    private FileAttributes getFileLocations(String fileIdentifier) throws CacheException, FileNotFoundException, SerializationException, NoRouteToCellException, InterruptedException, RequestTimeOutException {
        PnfsGetFileAttributes msg;
        EnumSet<FileAttribute> request = EnumSet.of(FileAttribute.LOCATIONS, FileAttribute.PNFSID);
        if (PnfsId.isValid(fileIdentifier)) {
            PnfsId pnfsId = new PnfsId(fileIdentifier);
            msg = new PnfsGetFileAttributes(pnfsId, request);
        } else {
            msg = new PnfsGetFileAttributes(fileIdentifier, request);
        }
        PnfsGetFileAttributes replyFileLocations = (PnfsGetFileAttributes)this.sendObject("PnfsManager", (Object)msg);
        if (replyFileLocations == null) {
            throw new CacheException("Request to the PnfsManager timed out");
        }
        if (replyFileLocations.getReturnCode() != 0) {
            throw CacheExceptionFactory.exceptionOf(replyFileLocations);
        }
        return replyFileLocations.getFileAttributes();
    }

    private List<CellMessage> askPoolsForRepLs(FileAttributes fileAttributes, PnfsId pnfsId) {
        SpreadAndWait spreader = new SpreadAndWait(this.cellEndPoint, this._timeout);
        for (String poolName : fileAttributes.getLocations()) {
            CellMessage message = new CellMessage(new CellPath(poolName), (Object)("rep ls " + pnfsId));
            spreader.send(message);
        }
        try {
            spreader.waitForReplies();
        }
        catch (InterruptedException ex) {
            _log.info("InterruptedException while waiting for a reply from pools " + ex);
        }
        return spreader.getReplyList();
    }

    private String setSticky(String destination, String target, boolean mode, StringBuffer sb) throws Exception {
        if (target == null || target.equals("")) {
            target = "*";
        }
        boolean verbose = sb != null;
        PnfsFlagReply reply = this.setPnfsFlag(destination, "s", target, mode);
        PnfsId pnfsId = reply.getPnfsId();
        PnfsGetCacheLocationsMessage pnfsMessage = new PnfsGetCacheLocationsMessage(pnfsId);
        if ((pnfsMessage = (PnfsGetCacheLocationsMessage)this.sendObject("PnfsManager", (Object)pnfsMessage)).getReturnCode() != 0) {
            throw new FileNotFoundException(destination);
        }
        List<String> list = pnfsMessage.getCacheLocations();
        if (verbose) {
            sb.append("Location(s) : ");
            for (String location : list) {
                sb.append(location).append(",");
            }
            sb.append("\n");
        }
        if (target.equals("*")) {
            if (verbose) {
                sb.append("Selection : <all>\n");
            }
        } else if (list.contains(target)) {
            if (verbose) {
                sb.append("Selection : ").append(target).append("\n");
            }
            list = new ArrayList<String>();
            list.add(target);
        } else {
            if (verbose) {
                sb.append("Selection : <nothing>\n");
            }
            return sb == null ? "" : sb.toString();
        }
        PoolSetStickyMessage sticky = null;
        for (String poolName : list) {
            block18: {
                if (verbose) {
                    sb.append(poolName).append(" : ");
                }
                try {
                    sticky = new PoolSetStickyMessage(poolName, pnfsId, mode);
                    sticky = (PoolSetStickyMessage)this.sendObject(poolName, (Object)sticky);
                    if (verbose) {
                        int rc = sticky.getReturnCode();
                        if (rc != 0) {
                            sb.append("[").append(rc).append("] ").append(sticky.getErrorObject().toString());
                        } else {
                            sb.append("ok");
                        }
                    }
                }
                catch (Exception ee) {
                    if (!verbose) break block18;
                    sb.append(ee.getMessage());
                }
            }
            if (!verbose) continue;
            sb.append("\n");
        }
        return sb == null ? "" : sb.toString();
    }

    private String uncache(String destination, String target, StringBuffer sb) throws Exception {
        if (target == null || target.equals("")) {
            target = "*";
        }
        boolean verbose = sb != null;
        PnfsId pnfsId = null;
        if (destination.startsWith("/pnfs")) {
            PnfsMapPathMessage map = new PnfsMapPathMessage(destination);
            if ((map = (PnfsMapPathMessage)this.sendObject("PnfsManager", (Object)map)).getReturnCode() != 0) {
                Object o = map.getErrorObject();
                if (o instanceof Exception) {
                    throw (Exception)o;
                }
                throw new Exception(o.toString());
            }
            pnfsId = map.getPnfsId();
            if (pnfsId == null) {
                throw new FileNotFoundException(destination);
            }
        } else {
            pnfsId = new PnfsId(destination);
        }
        int dbId = pnfsId.getDatabaseId();
        try {
            this.checkPermission("pool.*.uncache");
        }
        catch (AclException ee) {
            this.checkPermission("pool." + dbId + ".uncache");
        }
        PnfsGetCacheLocationsMessage pnfsMessage = new PnfsGetCacheLocationsMessage(pnfsId);
        pnfsMessage = (PnfsGetCacheLocationsMessage)this.sendObject("PnfsManager", (Object)pnfsMessage);
        if (pnfsMessage.getReturnCode() != 0) {
            throw new FileNotFoundException(destination);
        }
        List<String> list = pnfsMessage.getCacheLocations();
        if (verbose) {
            sb.append("Location(s) : ");
            Iterator<String> i = list.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString()).append(",");
            }
            sb.append("\n");
        }
        if (target.equals("*")) {
            if (verbose) {
                sb.append("Selection : <all>\n");
            }
        } else if (list.contains(target)) {
            if (verbose) {
                sb.append("Selection : ").append(target).append("\n");
            }
            list = new ArrayList<String>();
            list.add(target);
        } else {
            if (verbose) {
                sb.append("Selection : <nothing>\n");
            }
            return sb == null ? "" : sb.toString();
        }
        PoolRemoveFilesMessage remove = null;
        Iterator<String> i = list.iterator();
        while (i.hasNext()) {
            block29: {
                String poolName = i.next().toString();
                if (verbose) {
                    sb.append(poolName).append(" : ");
                }
                try {
                    remove = new PoolRemoveFilesMessage(poolName);
                    String[] filelist = new String[]{pnfsId.toString()};
                    remove.setFiles(filelist);
                    remove = (PoolRemoveFilesMessage)this.sendObject(poolName, (Object)remove);
                    if (verbose) {
                        int rc = remove.getReturnCode();
                        if (rc != 0) {
                            Object obj = remove.getErrorObject();
                            if (obj != null && obj instanceof Object[]) {
                                Object o = ((Object[])obj)[0];
                                if (o != null) {
                                    sb.append("[").append(rc).append("] Failed ").append(o.toString());
                                }
                            } else if (obj != null) {
                                sb.append("[").append(rc).append("] Failed ").append(obj.toString());
                            }
                        } else {
                            sb.append("ok");
                        }
                    }
                }
                catch (Exception ee) {
                    if (!verbose) break block29;
                    sb.append(ee.getMessage());
                }
            }
            if (!verbose) continue;
            sb.append("\n");
        }
        return sb == null ? "" : sb.toString();
    }

    public Object ac_flags_set_$_3(Args args) throws Exception {
        String value;
        String key;
        String destination = args.argv(0);
        PnfsFlagMessage result = this.setPnfsFlag(destination, key = args.argv(1), value = args.argv(2), true).getPnfsFlagMessage();
        return result.getReturnCode() == 0 ? "" : result.getErrorObject().toString();
    }

    private PnfsFlagReply setPnfsFlag(String destination, String key, String value, boolean mode) throws Exception {
        PnfsId pnfsId = null;
        if (destination.startsWith("/pnfs")) {
            PnfsMapPathMessage map = new PnfsMapPathMessage(destination);
            if ((map = (PnfsMapPathMessage)this.sendObject("PnfsManager", (Object)map)).getReturnCode() != 0) {
                Object o = map.getErrorObject();
                if (o instanceof Exception) {
                    throw (Exception)o;
                }
                throw new Exception(o.toString());
            }
            pnfsId = map.getPnfsId();
            pnfsId = map.getPnfsId();
            if (pnfsId == null) {
                throw new FileNotFoundException(destination);
            }
        } else {
            pnfsId = new PnfsId(destination);
        }
        int dbId = pnfsId.getDatabaseId();
        try {
            this.checkPermission("pnfs.*.update");
        }
        catch (AclException ee) {
            this.checkPermission("pnfs." + key + "." + dbId + ".update");
        }
        PnfsFlagMessage pfm = new PnfsFlagMessage(pnfsId, key, mode ? PnfsFlagMessage.FlagOperation.SET : PnfsFlagMessage.FlagOperation.REMOVE);
        pfm.setValue(value);
        PnfsFlagMessage result = (PnfsFlagMessage)this.sendObject("PnfsManager", (Object)pfm);
        if (result.getReturnCode() != 0) {
            Object o = result.getErrorObject();
            if (o instanceof Exception) {
                throw (Exception)o;
            }
            throw new Exception(o.toString());
        }
        return new PnfsFlagReply(pnfsId, result);
    }

    public Object ac_flags_remove_$_2(Args args) throws Exception {
        PnfsId pnfsId = null;
        if (args.argv(0).startsWith("/pnfs")) {
            PnfsMapPathMessage map = new PnfsMapPathMessage(args.argv(0));
            if ((map = (PnfsMapPathMessage)this.sendObject("PnfsManager", (Object)map)).getReturnCode() != 0) {
                Object o = map.getErrorObject();
                if (o instanceof Exception) {
                    throw (Exception)o;
                }
                throw new Exception(o.toString());
            }
            pnfsId = map.getPnfsId();
        } else {
            pnfsId = new PnfsId(args.argv(0));
        }
        int dbId = pnfsId.getDatabaseId();
        String key = args.argv(1);
        try {
            this.checkPermission("pnfs.*.update");
        }
        catch (AclException ee) {
            this.checkPermission("pnfs." + key + "." + dbId + ".update");
        }
        PnfsFlagMessage pfm = new PnfsFlagMessage(pnfsId, key, PnfsFlagMessage.FlagOperation.REMOVE);
        PnfsFlagMessage result = (PnfsFlagMessage)this.sendObject("PnfsManager", (Object)pfm);
        if (result.getReturnCode() != 0) {
            Object o = result.getErrorObject();
            if (o instanceof Exception) {
                throw (Exception)o;
            }
            throw new Exception(o.toString());
        }
        return result.getReturnCode() == 0 ? "" : result.getErrorObject().toString();
    }

    public String ac_p2p_$_1_3(Args args) throws Exception {
        if (args.argc() >= 3) {
            String source = args.argv(1);
            String dest = args.argv(2);
            PnfsId pnfsId = new PnfsId(args.argv(0));
            Pool2PoolTransferMsg p2p = new Pool2PoolTransferMsg(source, dest, pnfsId, null);
            this.cellEndPoint.sendMessage(new CellMessage(new CellPath(dest), (Object)p2p));
            return "P2p of " + pnfsId + " initiated from " + source + " to " + dest;
        }
        PnfsId pnfsId = new PnfsId(args.argv(0));
        String ip = args.getOpt("ip");
        PnfsGetFileAttributes fileAttributesMsg = new PnfsGetFileAttributes(pnfsId, PoolMgrReplicateFileMsg.getRequiredAttributes());
        CellMessage msg = new CellMessage(new CellPath("PnfsManager"), (Object)fileAttributesMsg);
        if ((msg = this.cellEndPoint.sendAndWait(msg, 30000L)) == null) {
            throw new Exception("Get storageinfo timed out");
        }
        fileAttributesMsg = (PnfsGetFileAttributes)msg.getMessageObject();
        if (fileAttributesMsg.getReturnCode() != 0) {
            throw new IllegalArgumentException("getFileAttributes returned " + fileAttributesMsg.getReturnCode());
        }
        DCapProtocolInfo pinfo = new DCapProtocolInfo("DCap", 0, 0, "localhost", 0);
        PoolMgrReplicateFileMsg select = new PoolMgrReplicateFileMsg(fileAttributesMsg.getFileAttributes(), pinfo, 0L);
        msg = new CellMessage(new CellPath("PoolManager"), (Object)select);
        String timeoutString = args.getOpt("timeout");
        long timeout = timeoutString != null ? Long.parseLong(timeoutString) * 1000L : 60000L;
        select = (PoolMgrReplicateFileMsg)(msg = this.cellEndPoint.sendAndWait(msg, timeout)).getMessageObject();
        if (select == null) {
            throw new Exception("p2p request timed out");
        }
        if (select.getReturnCode() != 0) {
            throw new Exception("Problem return from 'p2p' : (" + select.getReturnCode() + ") " + select.getErrorObject());
        }
        return "p2p -> " + select.getPoolName();
    }

    public String ac_modify_poolmode_$_2_4(Args args) throws Exception {
        this.checkPermission("*.*.*");
        String enable = args.argv(0);
        String poolList = args.argv(1);
        String message = args.argc() > 3 ? args.argv(3) : null;
        int code = args.argc() > 2 ? Integer.parseInt(args.argv(2)) : 0;
        PoolV2Mode mode = new PoolV2Mode();
        if (enable.equals("disable")) {
            int modeBits = 1;
            if (args.hasOption("strict")) {
                modeBits |= 0x3F;
            }
            if (args.hasOption("stage")) {
                modeBits |= 8;
            }
            if (args.hasOption("fetch")) {
                modeBits |= 2;
            }
            if (args.hasOption("store")) {
                modeBits |= 4;
            }
            if (args.hasOption("p2p-client")) {
                modeBits |= 0x10;
            }
            if (args.hasOption("p2p-server")) {
                modeBits |= 0x20;
            }
            if (args.hasOption("rdonly")) {
                modeBits |= 0x1D;
            }
            mode.setMode(modeBits);
        } else if (!enable.equals("enable")) {
            throw new CommandSyntaxException("Invalid keyword : " + enable);
        }
        StringTokenizer st = new StringTokenizer(poolList, ",");
        PoolModifyModeMessage modify = null;
        StringBuffer sb = new StringBuffer();
        sb.append("Sending new pool mode : ").append(mode).append("\n");
        while (st.hasMoreTokens()) {
            String poolName = st.nextToken();
            modify = new PoolModifyModeMessage(poolName, mode);
            modify.setStatusInfo(code, message);
            sb.append("  ").append(poolName).append(" -> ");
            try {
                modify = (PoolModifyModeMessage)this.sendObject(poolName, (Object)modify);
            }
            catch (Exception ee) {
                sb.append(ee.getMessage()).append("\n");
                continue;
            }
            if (modify.getReturnCode() != 0) {
                sb.append(modify.getErrorObject().toString()).append("\n");
                continue;
            }
            sb.append("OK\n");
        }
        return sb.toString();
    }

    public String ac_set_deletable_$_1(Args args) throws Exception {
        this.checkPermission("*.*.*");
        PnfsId pnfsId = new PnfsId(args.argv(0));
        StringBuffer sb = new StringBuffer();
        PnfsFlagMessage pfm = new PnfsFlagMessage(pnfsId, "d", PnfsFlagMessage.FlagOperation.SET);
        pfm.setValue("true");
        try {
            pfm = (PnfsFlagMessage)this.sendObject("PnfsManager", (Object)pfm);
        }
        catch (Exception ee) {
            sb.append("Attempt to set 'd' flag reported an Exception : " + ee);
            sb.append("\n");
            sb.append("Operation aborted\n");
            return sb.toString();
        }
        if (pfm.getReturnCode() != 0) {
            sb.append("set 'd' flag reported  : " + pfm.getErrorObject());
            return sb.toString();
        }
        sb.append("Setting 'd' succeeded\n");
        PnfsGetCacheLocationsMessage locations = new PnfsGetCacheLocationsMessage(pnfsId);
        try {
            locations = (PnfsGetCacheLocationsMessage)this.sendObject("PnfsManager", (Object)locations);
        }
        catch (Exception ee) {
            sb.append("Attempt to get cache locations reported an Exception : " + ee);
            sb.append("\n");
            sb.append("Operation aborted\n");
            return sb.toString();
        }
        if (locations.getReturnCode() != 0) {
            sb.append("Problem in getting cache location(s) : " + locations.getErrorObject());
            return sb.toString();
        }
        List<String> assumedLocations = locations.getCacheLocations();
        sb.append("Assumed cache locations : ").append(assumedLocations.toString()).append("\n");
        Iterator<String> i = assumedLocations.iterator();
        while (i.hasNext()) {
            String poolName = i.next().toString();
            PoolModifyPersistencyMessage p = new PoolModifyPersistencyMessage(poolName, pnfsId, false);
            try {
                p = (PoolModifyPersistencyMessage)this.sendObject(poolName, (Object)p);
            }
            catch (Exception ee) {
                sb.append("Attempt to contact ").append(poolName).append(" reported an Exception : ").append(ee.toString()).append("\n").append("  Operation continues\n");
                continue;
            }
            if (locations.getReturnCode() != 0) {
                sb.append("Set 'cached' reply from ").append(poolName).append(" : ").append(p.getErrorObject()).append("\n");
                continue;
            }
            sb.append("Set 'cached' OK for ").append(poolName).append("\n");
        }
        return sb.toString();
    }

    public Object ac_flags_ls_$_2(Args args) throws Exception {
        PnfsId pnfsId = null;
        if (args.argv(0).startsWith("/pnfs")) {
            PnfsMapPathMessage map = new PnfsMapPathMessage(args.argv(0));
            if ((map = (PnfsMapPathMessage)this.sendObject("PnfsManager", (Object)map)).getReturnCode() != 0) {
                Object o = map.getErrorObject();
                if (o instanceof Exception) {
                    throw (Exception)o;
                }
                throw new Exception(o.toString());
            }
            pnfsId = map.getPnfsId();
        } else {
            pnfsId = new PnfsId(args.argv(0));
        }
        String key = args.argv(1);
        PnfsFlagMessage pfm = new PnfsFlagMessage(pnfsId, key, PnfsFlagMessage.FlagOperation.GET);
        PnfsFlagMessage result = (PnfsFlagMessage)this.sendObject("PnfsManager", (Object)pfm);
        return result.getReturnCode() == 0 ? key + " -> " + result.getValue() : result.getErrorObject().toString();
    }

    public String ac_pnfs_map_$_1(Args args) throws Exception {
        if (!args.argv(0).startsWith("/pnfs")) {
            throw new IllegalArgumentException("not a global dCache path (/pnfs...)");
        }
        PnfsMapPathMessage map = new PnfsMapPathMessage(args.argv(0));
        if ((map = (PnfsMapPathMessage)this.sendObject("PnfsManager", (Object)map)).getReturnCode() != 0) {
            Object o = map.getErrorObject();
            if (o instanceof Exception) {
                throw (Exception)o;
            }
            throw new Exception(o.toString());
        }
        return map.getPnfsId().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String ac_cd_$_1(Args args) throws Exception {
        String remoteCell = args.argv(0);
        Path path = new Path(remoteCell);
        Position newPosition = null;
        this._completor = null;
        if (path.isDomain()) {
            newPosition = new Position(remoteCell);
        } else if (this._currentPosition.hyperMode) {
            newPosition = new Position(this._currentPosition);
            newPosition.mergePath(path);
        } else if (path.isPath()) {
            if (!path.isAbsolutePath()) throw new IllegalArgumentException("Need absolute path to switch to directory mode");
            newPosition = new Position(this._currentPosition);
            newPosition.mergePath(path);
        } else {
            newPosition = new Position(remoteCell);
        }
        if (newPosition.remoteName != null) {
            this.checkCellExists(newPosition.remote);
            this.checkCdPermission(newPosition.remoteName);
        }
        UserAdminShell userAdminShell = this;
        synchronized (userAdminShell) {
            this._currentPosition = newPosition;
            return "";
        }
    }

    private void checkCdPermission(String remoteName) throws AclException {
        int pos = remoteName.indexOf(45);
        String prefix = null;
        if (pos > 0) {
            prefix = remoteName.substring(0, pos);
        }
        try {
            this.checkPermission("cell.*.execute");
        }
        catch (AclException acle) {
            try {
                this.checkPermission("cell." + remoteName + ".execute");
            }
            catch (AclException acle2) {
                if (prefix == null) {
                    throw acle2;
                }
                try {
                    this.checkPermission("cell." + prefix + "-pools.execute");
                }
                catch (AclException acle3) {
                    throw new AclException(this.getUser(), remoteName);
                }
            }
        }
    }

    private void checkCellExists(CellPath remoteCell) {
        CellMessage checkMsg = new CellMessage(remoteCell, (Object)ADMIN_COMMAND_NOOP);
        try {
            this.cellEndPoint.sendAndWait(checkMsg, 1000L);
        }
        catch (SerializationException e) {
            throw new RuntimeException("Failed to serialise test message", e);
        }
        catch (NoRouteToCellException e) {
            throw new IllegalArgumentException("Cannot cd to this cell as it doesn't exist");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected Object executeLocalCommand(Args args) throws Exception {
        _log.info("Local command " + args);
        try {
            return this.command(args);
        }
        catch (CommandThrowableException cte) {
            throw (Exception)cte.getTargetException();
        }
        catch (CommandPanicException cpe) {
            throw (Exception)cpe.getTargetException();
        }
    }

    public int complete(String buffer, int cursor, List candidates) {
        try {
            if (this._completor == null) {
                Object help = this.executeCommand("help");
                if (help == null) {
                    return -1;
                }
                this._completor = new HelpCompletor(String.valueOf(help));
            }
            return this._completor.complete(buffer, cursor, candidates);
        }
        catch (Exception e) {
            _log.info("Completion failed: " + e.toString());
            return -1;
        }
    }

    public Object executeCommand(String str) throws Exception {
        _log.info("String command (super) " + str);
        if (str.trim().equals("")) {
            return "";
        }
        if (str.equals("..")) {
            this._currentPosition.clearHyperMode();
            this._currentPosition.gotoLocal();
            this._completor = null;
            return "";
        }
        Args args = new Args((CharSequence)str);
        if (this._currentPosition.remote == null) {
            return this.localCommand(args);
        }
        if (this._currentPosition.hyperMode) {
            if (args.argc() == 1 && args.argv(0).equals("cd")) {
                this._currentPosition.gotoLocal();
                return "";
            }
            if (args.argc() > 1 && args.argv(0).equals("cd")) {
                return this.localCommand(args);
            }
            String prefix = this._currentPosition.getPrefix();
            if (prefix.length() > 0) {
                if (args.argc() >= 1 && args.argv(0).equals("help")) {
                    if (args.argc() == 1) {
                        str = "help " + prefix;
                    }
                } else {
                    str = prefix + " " + str;
                }
            }
        }
        return this.sendObject(this._currentPosition.remote, (Object)new AuthorizedString(this._user, str));
    }

    private Object localCommand(Args args) throws Exception {
        Object or = this.executeLocalCommand(args);
        if (or == null) {
            return "";
        }
        String r = or.toString();
        if (r.length() < 1) {
            return "";
        }
        if (r.substring(r.length() - 1).equals("\n")) {
            return r;
        }
        return r + "\n";
    }

    private Object sendObject(String cellPath, Object object) throws SerializationException, NoRouteToCellException, InterruptedException, RequestTimeOutException {
        return this.sendObject(new CellPath(cellPath), object);
    }

    private Object sendObject(CellPath cellPath, Object object) throws SerializationException, NoRouteToCellException, InterruptedException, RequestTimeOutException {
        CellMessage res = this.cellEndPoint.sendAndWait(new CellMessage(cellPath, object), this._timeout);
        if (res == null) {
            throw new RequestTimeOutException(this._timeout, cellPath);
        }
        Object obj = res.getMessageObject();
        if (obj instanceof Throwable && this._fullException) {
            CharArrayWriter ca = new CharArrayWriter();
            ((Throwable)obj).printStackTrace(new PrintWriter(ca));
            return ca.toString();
        }
        return obj;
    }

    protected Object sendCommand(String destination, String command) throws Exception {
        CellPath cellPath = new CellPath(destination);
        CellMessage res = this.cellEndPoint.sendAndWait(new CellMessage(cellPath, (Object)new AuthorizedString(this._user, command)), this._timeout);
        if (res == null) {
            throw new Exception("Request timed out");
        }
        Object obj = res.getMessageObject();
        if (obj instanceof Throwable && this._fullException) {
            CharArrayWriter ca = new CharArrayWriter();
            ((Throwable)obj).printStackTrace(new PrintWriter(ca));
            return ca.toString();
        }
        return obj;
    }

    public Object executeCommand(String destination, Object str) throws Exception {
        _log.info("Object command (" + destination + ") " + str);
        return this.sendCommand(destination, str.toString());
    }

    private class PnfsFlagReply {
        private PnfsId _pnfsId = null;
        private PnfsFlagMessage _message = null;

        public PnfsFlagReply(PnfsId pnfsId, PnfsFlagMessage message) {
            this._pnfsId = pnfsId;
            this._message = message;
        }

        public PnfsId getPnfsId() {
            return this._pnfsId;
        }

        public PnfsFlagMessage getPnfsFlagMessage() {
            return this._message;
        }
    }

    private class Path {
        private String _pathString = null;
        private boolean _isAbsolutePath = false;
        private boolean _isPath = false;
        private boolean _isDomain = false;
        private String[] _path = null;

        private Path(String pathString) throws Exception {
            this._pathString = pathString;
            if (this._pathString.indexOf(64) > -1) {
                this._isDomain = true;
                StringTokenizer st = new StringTokenizer(pathString, "@");
                this._path = new String[2];
                this._path[0] = st.nextToken();
                this._path[1] = st.nextToken();
            } else if (this._pathString.indexOf(47) > -1) {
                this._isPath = true;
                this._isAbsolutePath = this._pathString.startsWith("/");
                StringTokenizer st = new StringTokenizer(this._pathString, "/");
                int count = st.countTokens();
                this._path = new String[count];
                for (int i = 0; i < this._path.length; ++i) {
                    this._path[i] = st.nextToken();
                }
            } else {
                this._path = new String[1];
                this._path[0] = this._pathString;
            }
        }

        private boolean isAbsolutePath() {
            return this._isAbsolutePath;
        }

        private boolean isDomain() {
            return this._isDomain;
        }

        private boolean isPath() {
            return this._isPath;
        }

        private String getItem(int i) {
            return i < 0 || i >= this._path.length ? "" : this._path[i];
        }

        private String[] getPath() {
            return this._path;
        }

        public String toString() {
            return this._pathString;
        }

        public String toLongString() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this._path.length; ++i) {
                sb.append("(").append(i).append(")=").append(this._path[i]).append(";");
            }
            sb.append("isPath=").append(this._isPath).append(";");
            sb.append("isAbsolutePath=").append(this._isAbsolutePath).append(";");
            sb.append("isDomain=").append(this._isDomain).append(";");
            return sb.toString();
        }
    }

    private class Position {
        private CellPath remote = null;
        private String remoteName = null;
        private boolean hyperMode = false;
        private List hyperPath = new ArrayList();
        private String moduleName = null;

        private Position() {
        }

        private Position(Position position) {
            this.remote = position.remote;
            this.remoteName = position.remoteName;
            this.hyperMode = position.hyperMode;
            this.hyperPath = new ArrayList(position.hyperPath);
            this.moduleName = position.moduleName;
        }

        private Position(String removeCell) {
            this.hyperMode = false;
            this.remoteName = removeCell;
            this.remote = this.remoteName == null ? null : new CellPath(this.remoteName);
        }

        private void clearHyperMode() {
            this.hyperMode = false;
            this.remoteName = null;
            this.remote = null;
            this.hyperPath = new ArrayList();
            this.moduleName = null;
        }

        private void gotoLocal() {
            this.remoteName = null;
            this.remote = null;
            this.hyperPath = new ArrayList();
            this.moduleName = null;
        }

        private String getPrefix() {
            if (this.hyperPath == null || this.hyperPath.size() < 3) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            int n = this.hyperPath.size();
            for (int i = 2; i < n; ++i) {
                sb.append(this.hyperPath.get(i).toString()).append(" ");
            }
            return sb.toString();
        }

        private void finish() {
            if (!this.hyperMode) {
                return;
            }
            int size = this.hyperPath.size();
            String domainName = size > 0 ? this.hyperPath.get(0).toString() : null;
            String cellName = size > 1 ? this.hyperPath.get(1).toString() : null;
            String string = this.moduleName = size > 2 ? this.hyperPath.get(2).toString() : null;
            this.remoteName = domainName == null ? null : (cellName == null ? (domainName.equals("*") ? "topo" : "System@" + domainName) : (domainName.equals("*") ? cellName : cellName + "@" + domainName));
            this.remote = this.remoteName == null ? null : new CellPath(this.remoteName);
        }

        private void mergePath(Path path) {
            this.hyperMode = true;
            String[] pathString = path.getPath();
            if (path.isAbsolutePath()) {
                this.hyperPath = new ArrayList();
                int n = pathString.length;
                for (int i = 0; i < n; ++i) {
                    this.hyperPath.add(pathString[i]);
                }
            } else {
                for (String p : pathString) {
                    if (p.equals(".")) continue;
                    if (p.equals("..")) {
                        int currentSize = this.hyperPath.size();
                        if (currentSize == 0) continue;
                        this.hyperPath.remove(currentSize - 1);
                        continue;
                    }
                    this.hyperPath.add(p);
                }
            }
            this.finish();
        }
    }
}

