/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.migration;

import java.util.concurrent.BlockingQueue;
import org.dcache.chimera.migration.AbstractBlockingQueueDecorator;
import org.dcache.chimera.migration.TerminableBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminableBlockingQueueDecorator<E>
extends AbstractBlockingQueueDecorator<E>
implements TerminableBlockingQueue<E> {
    private static Logger _log = LoggerFactory.getLogger(TerminableBlockingQueueDecorator.class);
    private static final int DEFAULT_CONSUMERS_COUNT = 1;
    private final E _sentinel;
    private final int _consumers;
    private boolean _isTerminated;

    public TerminableBlockingQueueDecorator(BlockingQueue<E> queue, E sentinal) {
        this(queue, sentinal, 1);
    }

    public TerminableBlockingQueueDecorator(BlockingQueue<E> queue, E sentinel, int consumers) {
        super(queue);
        this._sentinel = sentinel;
        this._consumers = consumers;
    }

    @Override
    public boolean hasTerminateWith(E item) {
        return this._isTerminated || item == this._sentinel;
    }

    @Override
    public synchronized boolean isTerminated() {
        return this._isTerminated;
    }

    @Override
    public synchronized void terminate() {
        this._isTerminated = true;
        this.populateWithSentinels();
    }

    private void populateWithSentinels() {
        try {
            for (int i = 0; i < this._consumers; ++i) {
                this.addSentinel();
            }
        }
        catch (InterruptedException e) {
            System.out.println("Interrupted while enqueing sentinel items");
        }
    }

    private void addSentinel() throws InterruptedException {
        boolean haveAddedSentinel = false;
        while (!haveAddedSentinel) {
            haveAddedSentinel = this._queue.offer(this._sentinel);
            int removedCount = 0;
            if (haveAddedSentinel) continue;
            while (this.peek() != null && this.peek() != this._sentinel) {
                this.take();
                ++removedCount;
            }
            if (removedCount != 0) continue;
            _log.info("Blocking on TerminableBlockingQueue accepting sentinel");
            this._queue.put(this._sentinel);
            haveAddedSentinel = true;
        }
    }
}

